/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.AggregateComponentsNTA;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Components;
import ast.AST.List;
import ast.AST.ListComponentsNTA;
import ast.AST.Node;
import ast.AST.OptionalComponentNTA;
import ast.AST.Parameter;
import ast.AST.TokenComponent;
import ast.AST.TokenComponentNTA;
import ast.AST.TypeDecl;
import java.io.PrintStream;
import java.util.Iterator;
import jrag.AST.ASTExpression;

public abstract class AttrDecl
extends ASTNode
implements Cloneable {
    ASTExpression bottomValue;
    private String tokenString_Name;
    private String tokenString_Type;
    private boolean tokenboolean_Lazy;
    private String tokenString_FileName;
    private int tokenint_StartLine;
    private int tokenint_EndLine;
    private boolean tokenboolean_Final;
    private boolean tokenboolean_NTA;
    private String tokenString_Comment;
    protected boolean parametersDecl_visited = false;
    protected boolean parameters_visited = false;
    protected boolean interfaceParameters_visited = false;
    protected boolean interfaceParametersDecl_visited = false;
    protected boolean interfaceParametersStart_visited = false;
    protected boolean interfaceParametersContinue_visited = false;
    protected boolean isCircular_visited = false;
    protected boolean hasBottomValue_visited = false;
    protected boolean getBottomValue_visited = false;
    protected boolean root_visited = false;
    protected boolean collDebugString_visited = false;
    protected boolean separateEvaluation_visited = false;
    protected boolean lazyCondition_visited = false;
    protected boolean onePhase_visited = false;
    protected boolean naive_visited = false;
    protected boolean collectingSignature_visited = false;
    protected boolean collectingSignature_computed = false;
    protected String collectingSignature_value;
    protected boolean visitCheckEnabled_visited = false;
    protected boolean declaredNTA_visited = false;
    protected boolean inhDebugString_visited = false;
    protected boolean cycleLimitCheck_visited = false;
    protected boolean name_visited = false;
    protected boolean type_visited = false;
    protected boolean getTypeInSignature_visited = false;
    protected boolean signature_visited = false;
    protected boolean hostClass_visited = false;

    public void flushCache() {
        super.flushCache();
        this.parametersDecl_visited = false;
        this.parameters_visited = false;
        this.interfaceParameters_visited = false;
        this.interfaceParametersDecl_visited = false;
        this.interfaceParametersStart_visited = false;
        this.interfaceParametersContinue_visited = false;
        this.isCircular_visited = false;
        this.hasBottomValue_visited = false;
        this.getBottomValue_visited = false;
        this.root_visited = false;
        this.collDebugString_visited = false;
        this.separateEvaluation_visited = false;
        this.lazyCondition_visited = false;
        this.onePhase_visited = false;
        this.naive_visited = false;
        this.collectingSignature_visited = false;
        this.collectingSignature_computed = false;
        this.collectingSignature_value = null;
        this.visitCheckEnabled_visited = false;
        this.declaredNTA_visited = false;
        this.inhDebugString_visited = false;
        this.cycleLimitCheck_visited = false;
        this.name_visited = false;
        this.type_visited = false;
        this.getTypeInSignature_visited = false;
        this.signature_visited = false;
        this.hostClass_visited = false;
    }

    public Object clone() throws CloneNotSupportedException {
        AttrDecl node = (AttrDecl)super.clone();
        node.parametersDecl_visited = false;
        node.parameters_visited = false;
        node.interfaceParameters_visited = false;
        node.interfaceParametersDecl_visited = false;
        node.interfaceParametersStart_visited = false;
        node.interfaceParametersContinue_visited = false;
        node.isCircular_visited = false;
        node.hasBottomValue_visited = false;
        node.getBottomValue_visited = false;
        node.root_visited = false;
        node.collDebugString_visited = false;
        node.separateEvaluation_visited = false;
        node.lazyCondition_visited = false;
        node.onePhase_visited = false;
        node.naive_visited = false;
        node.collectingSignature_visited = false;
        node.collectingSignature_computed = false;
        node.collectingSignature_value = null;
        node.visitCheckEnabled_visited = false;
        node.declaredNTA_visited = false;
        node.inhDebugString_visited = false;
        node.cycleLimitCheck_visited = false;
        node.name_visited = false;
        node.type_visited = false;
        node.getTypeInSignature_visited = false;
        node.signature_visited = false;
        node.hostClass_visited = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public void setBottomValue(ASTExpression v) {
        this.bottomValue = v;
    }

    public boolean hasAnnotation(String s) {
        return false;
    }

    public String attributeSignature() {
        if (this.getNumParameter() == 0) {
            return this.getName();
        }
        StringBuffer s = new StringBuffer();
        s.append(this.getName());
        int i = 0;
        while (i < this.getNumParameter()) {
            s.append("_" + this.getParameter(i).getTypeInSignature());
            ++i;
        }
        return s.toString();
    }

    public String attributeName() {
        return this.getName();
    }

    public String hostFileComment() {
        String comment = this.getComment().trim();
        if (comment.equals("") || comment.indexOf("/**") == -1) {
            return "    // Declared in " + this.getFileName() + " at line " + this.getStartLine() + "\n";
        }
        int index = comment.indexOf("*/");
        StringBuffer res = new StringBuffer();
        res.append(comment.substring(0, index));
        res.append("\n");
        res.append("    Declared in " + this.getFileName() + " at line " + this.getStartLine() + "\n");
        res.append(comment.substring(index, comment.length()));
        res.append("\n");
        return res.toString();
    }

    public String initLazyMaps() {
        StringBuffer s = new StringBuffer();
        if (ASTNode.lazyMaps) {
            if (this.getNumParameter() != 0 && this.isCircular()) {
                s.append("if(#NAME#_visited == null) #NAME#_visited = " + ASTNode.createDefaultMap + ";\n");
            } else if (this.getNumParameter() != 0 && this.visitCheckEnabled() && ASTNode.rewriteEnabled) {
                s.append("if(#NAME#_visited == null) #NAME#_visited = " + ASTNode.createDefaultMap + ";\n");
            } else if (this.getNumParameter() != 0 && this.visitCheckEnabled()) {
                s.append("if(#NAME#_visited == null) #NAME#_visited = " + ASTNode.createDefaultSet + ";\n");
            }
            if (this.getNumParameter() != 0 && (this.getLazy() || this.isCircular())) {
                s.append("if(#NAME#_values == null) #NAME#_values = " + ASTNode.createDefaultMap + ";\n");
            }
        }
        return s.toString();
    }

    public String visitedDeclarations() {
        if (this.isCircular()) {
            if (this.getNumParameter() == 0) {
                return "    protected int #CLASS#.#NAME#_visited;\n";
            }
            if (ASTNode.lazyMaps) {
                return "    protected java.util.Map #CLASS#.#NAME#_visited;\n";
            }
            return "    protected java.util.Map #CLASS#.#NAME#_visited = " + ASTNode.createDefaultMap + ";\n";
        }
        if (!this.visitCheckEnabled() && !this.isCircular()) {
            return "";
        }
        if (ASTNode.rewriteEnabled) {
            if (this.getNumParameter() == 0) {
                return "    protected int #CLASS#.#NAME#_visited = -1;\n";
            }
            if (ASTNode.lazyMaps) {
                return "    protected java.util.Map #CLASS#.#NAME#_visited;\n";
            }
            return "    protected java.util.Map #CLASS#.#NAME#_visited = " + ASTNode.createDefaultMap + ";\n";
        }
        if (this.getNumParameter() == 0) {
            return "    protected boolean #CLASS#.#NAME#_visited = false;\n";
        }
        if (ASTNode.lazyMaps) {
            return "    protected java.util.Set #CLASS#.#NAME#_visited;\n";
        }
        return "    protected java.util.Set #CLASS#.#NAME#_visited = " + ASTNode.createDefaultSet + ";\n";
    }

    public String visitedException() {
        if (!this.visitCheckEnabled()) {
            return "";
        }
        if (!ASTNode.traceVisitCheck) {
            return "            throw new RuntimeException(\"Circular definition of attr: #METHODNAME# in class: #CLASS#.\");\n";
        }
        return "            System.out.println(\"Circular definition of attr: #METHODNAME# in class: \" + getClass().getName());\n";
    }

    public String resetVisit() {
        if (this.isCircular()) {
            if (this.getNumParameter() == 0) {
                return "        #NAME#_visited = 0;\n";
            }
            return "        #NAME#_visited = " + ASTNode.createDefaultMap + ";\n";
        }
        if (!this.visitCheckEnabled()) {
            return "";
        }
        if (ASTNode.rewriteEnabled) {
            if (this.getNumParameter() == 0) {
                return "        #NAME#_visited = -1;\n";
            }
            return "        #NAME#_visited = " + ASTNode.createDefaultMap + ";\n";
        }
        if (this.getNumParameter() == 0) {
            return "        #NAME#_visited = false;\n";
        }
        return "        #NAME#_visited = " + ASTNode.createDefaultSet + ";\n";
    }

    public String visitedCheck() {
        if (!this.visitCheckEnabled()) {
            return "";
        }
        if (ASTNode.rewriteEnabled) {
            if (this.getNumParameter() == 0) {
                return "        if(#NAME#_visited == state().boundariesCrossed)\n" + this.visitedException();
            }
            return "        if(new Integer(state().boundariesCrossed).equals(#NAME#_visited.get(_parameters)))\n" + this.visitedException();
        }
        if (this.getNumParameter() == 0) {
            return "        if(#NAME#_visited)\n" + this.visitedException();
        }
        return "        if(#NAME#_visited.contains(_parameters))\n" + this.visitedException();
    }

    public String setVisited() {
        if (!this.visitCheckEnabled() && !this.isCircular()) {
            return "";
        }
        if (ASTNode.rewriteEnabled) {
            if (this.getNumParameter() == 0) {
                return "        #NAME#_visited = state().boundariesCrossed;\n";
            }
            return "        #NAME#_visited.put(_parameters, new Integer(state().boundariesCrossed));\n";
        }
        if (this.getNumParameter() == 0) {
            return "        #NAME#_visited = true;\n";
        }
        return "        #NAME#_visited.add(_parameters);\n";
    }

    public String clearVisited() {
        if (!this.visitCheckEnabled() && !this.isCircular()) {
            return "";
        }
        if (ASTNode.rewriteEnabled) {
            if (this.getNumParameter() == 0) {
                return "        #NAME#_visited = -1;\n";
            }
            return "        #NAME#_visited.remove(_parameters);\n";
        }
        if (this.getNumParameter() == 0) {
            return "        #NAME#_visited = false;\n";
        }
        return "        #NAME#_visited.remove(_parameters);\n";
    }

    public String cacheDeclarations() {
        if (!this.getLazy()) {
            return "";
        }
        if (this.getNumParameter() == 0) {
            return "    protected boolean #CLASS#.#NAME#_computed = false;\n    protected #TYPE# #CLASS#.#NAME#_value;\n";
        }
        if (this.declaredNTA()) {
            if (ASTNode.lazyMaps) {
                return "    protected java.util.Map #CLASS#.#NAME#_values;\n    protected List #CLASS#.#NAME#_list;\n";
            }
            return "    protected java.util.Map #CLASS#.#NAME#_values = " + ASTNode.createDefaultMap + ";\n" + "    protected List #CLASS#.#NAME#_list;\n";
        }
        if (ASTNode.lazyMaps) {
            return "    protected java.util.Map #CLASS#.#NAME#_values;\n";
        }
        return "    protected java.util.Map #CLASS#.#NAME#_values = " + ASTNode.createDefaultMap + ";\n";
    }

    public String resetCache() {
        if (!this.getLazy() && !this.isCircular()) {
            return "";
        }
        if (this.getNumParameter() == 0) {
            if (this.isCircular()) {
                if (this.isPrimitive()) {
                    return "        #NAME#_computed = false;\n        #NAME#_initialized = false;\n";
                }
                return "        #NAME#_computed = false;\n        #NAME#_initialized = false;\n        #NAME#_value = null;\n";
            }
            if (this.isPrimitive()) {
                return "        #NAME#_computed = false;\n";
            }
            return "        #NAME#_computed = false;\n        #NAME#_value = null;\n";
        }
        if (this.isCircular()) {
            if (ASTNode.lazyMaps) {
                return "        #NAME#_values = null;\n        #NAME#_computed = " + ASTNode.createDefaultSet + ";\n" + "        #NAME#_initialized = " + ASTNode.createDefaultSet + ";\n";
            }
            return "        #NAME#_values = " + ASTNode.createDefaultMap + ";\n" + "        #NAME#_computed = " + ASTNode.createDefaultSet + ";\n" + "        #NAME#_initialized = " + ASTNode.createDefaultSet + ";\n";
        }
        if (ASTNode.lazyMaps) {
            return "        #NAME#_values = null;\n";
        }
        return "        #NAME#_values = " + ASTNode.createDefaultMap + ";\n";
    }

    public boolean isPrimitive() {
        String type = this.getType();
        return type.equals("int") || type.equals("short") || type.equals("long") || type.equals("float") || type.equals("double") || type.equals("boolean") || type.equals("char");
    }

    public String cacheCheck() {
        if (!this.getLazy() && !this.isCircular()) {
            return "";
        }
        if (this.isNTA() && !(this.findCorrespondingNTA() instanceof TokenComponent)) {
            this.indexNTAchild();
            if (this.getNumParameter() == 0) {
                return "        if(#NAME#_computed)\n            return (" + this.getType() + ")ASTNode.getChild(this, #NAME#ChildPosition());\n";
            }
            return "        if(#NAME#_values.containsKey(_parameters))\n            return (" + this.getType() + ")ASTNode.getChild(this, #NAME#ChildPosition()));\n";
        }
        if (this.getNumParameter() == 0) {
            return "        if(#NAME#_computed)\n            return #NAME#_value;\n";
        }
        if (this.isCircular()) {
            return "        if(#NAME#_computed.contains(_parameters))\n            return " + this.fromReferenceType("#NAME#_values.get(_parameters)", this.getType()) + ";\n";
        }
        return "        if(#NAME#_values.containsKey(_parameters))\n            return " + this.fromReferenceType("#NAME#_values.get(_parameters)", this.getType()) + ";\n";
    }

    public String parameterStructure() {
        if (this.getNumParameter() == 0 || !this.getLazy() && !this.isCircular() && !this.visitCheckEnabled()) {
            return "";
        }
        if (this.getNumParameter() == 1) {
            return "        Object _parameters = " + this.getParameter(0).toReferenceType() + ";\n";
        }
        StringBuffer s = new StringBuffer();
        s.append("        java.util.List _parameters = new java.util.ArrayList(" + this.getNumParameter() + ");\n");
        int i = 0;
        while (i < this.getNumParameter()) {
            s.append("        _parameters.add(" + this.getParameter(i).toReferenceType() + ");\n");
            ++i;
        }
        return s.toString();
    }

    public String cacheInit() {
        if (!this.getLazy()) {
            return "";
        }
        return this.cacheInitRewrite();
    }

    public String cacheInitRewrite() {
        if (!ASTNode.rewriteEnabled) {
            return "";
        }
        return "        int num = state().boundariesCrossed;\n        boolean isFinal = this.is$Final();\n";
    }

    public String callCompute() {
        if (this.getLazy() && this.getNumParameter() == 0) {
            return "        #NAME#_value = #METHODNAME#_compute(#PARM#);\n";
        }
        return "        #TYPE# #NAME#_value = #METHODNAME#_compute(#PARM#);\n";
    }

    public String cacheStoreRewrite() {
        if (!ASTNode.rewriteEnabled || this.getFinal()) {
            return "        if(true)\n";
        }
        return "        if(isFinal && num == state().boundariesCrossed)\n";
    }

    public String cacheStore() {
        if (!this.getLazy()) {
            return "";
        }
        if (this.getNumParameter() == 0) {
            return String.valueOf(this.cacheStoreRewrite()) + "            #NAME#_computed = true;\n";
        }
        return String.valueOf(this.cacheStoreRewrite()) + "            #NAME#_values.put(_parameters, " + this.toReferenceType("#NAME#_value", this.getType()) + ");\n";
    }

    public String returnStmt() {
        if (this.isNTA() && !(this.findCorrespondingNTA() instanceof TokenComponent)) {
            this.indexNTAchild();
            return "        return (" + this.getType() + ")ASTNode.getChild(this, #NAME#ChildPosition());\n";
        }
        return "        return #NAME#_value;\n";
    }

    public String computeMethod() {
        if (!ASTNode.parentInterface) {
            return "";
        }
        return "    private #TYPE# #CLASS#.#METHODNAME#_compute(#PARMDECL#) {\n            ASTNode n = getParent();\n            ASTNode caller = this;\n            ASTNode child = null;\n            while(!(n instanceof Defines_#TYPEINSIGNATURE#_#NAME#) && n != null) {\n                child = caller;\n                caller = n;\n                n = n.getParent();\n            }\n" + this.inhDebugString() + "            return ((Defines_#TYPEINSIGNATURE#_#NAME#)n).Define_#TYPEINSIGNATURE#_#METHODNAME#(#INTERFACEPARM#);\n" + "    }\n\n";
    }

    public String circularComputeCall() {
        return "";
    }

    public String resetCycleInit() {
        return "            state().RESET_CYCLE = true;\n" + this.inhDebugString() + "            " + this.circularComputeCall() + ";\n" + "            state().RESET_CYCLE = false;\n";
    }

    public String resetCycleCheck() {
        if (this.getNumParameter() == 0) {
            return "            if (state().RESET_CYCLE) {\n                #NAME#_computed = false;\n                #NAME#_initialized = false;\n        " + this.returnStmt() + "            }\n";
        }
        return "            if (state().RESET_CYCLE) {\n                #NAME#_computed.remove(_parameters);\n                #NAME#_initialized.remove(_parameters);\n                return " + this.fromReferenceType("#NAME#_values.get(_parameters)", this.getType()) + ";\n" + "            }\n";
    }

    public String cacheCycleInit() {
        if (!ASTNode.cacheCycle) {
            return "";
        }
        return "            state().LAST_CYCLE = true;\n" + this.inhDebugString() + "            " + this.circularComputeCall() + ";\n" + "            state().LAST_CYCLE = false;\n";
    }

    public String cacheCycleCheck() {
        if (!ASTNode.cacheCycle) {
            return "";
        }
        if (this.getNumParameter() == 0) {
            return "            if (state().LAST_CYCLE) {\n                #NAME#_computed = true;\n" + this.inhDebugString() + "                return " + this.circularComputeCall() + ";\n" + "            }\n";
        }
        return "            if (state().LAST_CYCLE) {\n                #NAME#_computed.add(_parameters);\n" + this.inhDebugString() + "                return " + this.circularComputeCall() + ";\n" + "            }\n";
    }

    public String addComponentCheck() {
        if (!ASTNode.componentCheck) {
            return "";
        }
        String string = this.getNumParameter() == 0 ? "null" : "_parameters";
        if (this.getNumParameter() == 0) {
            return "     if(#NAME#_visited && !state().containsEvalEntry(this, \"#NAME#\", null))\n       throw new java.lang.RuntimeException(\"XXX\");\n";
        }
        return "     if(#NAME#_visited.contains(_parameters) && !state().containsEvalEntry(this, \"#NAME#\", _parameters))\n       throw new java.lang.RuntimeException(\"XXX\");\n";
    }

    public String addAddToComponent() {
        if (!ASTNode.componentCheck) {
            return "";
        }
        if (this.getNumParameter() == 0) {
            return "     state().addEvalEntry(this, \"#NAME#\", null);\n";
        }
        return "     state().addEvalEntry(this, \"#NAME#\", _parameters);\n";
    }

    public String addInterruptedCircleDeclaration() {
        if (!ASTNode.componentCheck) {
            return "";
        }
        return "boolean interruptedCircle = false;\n";
    }

    public String addCheckInterruptedCircle() {
        if (!ASTNode.componentCheck) {
            return "";
        }
        return "if(state().IN_CIRCLE) {\n  interruptedCircle = true;\n  state().IN_CIRCLE = false;\n  state().pushEvalStack();\n}\n";
    }

    public String addClearInterruptedCircle() {
        if (!ASTNode.componentCheck) {
            return "";
        }
        return "if(interruptedCircle) {\n  state().IN_CIRCLE = true;\n  state().popEvalStack();\n}\n";
    }

    public String differs(String s1, String s2) {
        if (this.isPrimitive()) {
            return String.valueOf(s1) + "!=" + s2;
        }
        return "(" + s1 + "==null && " + s2 + "!=null)" + " || " + "(" + s1 + "!=null && " + "!" + s1 + ".equals(" + s2 + ")" + ")";
    }

    public boolean isNTA() {
        return false;
    }

    public int indexNTAchild() {
        Components comp = this.findCorrespondingNTA();
        TypeDecl c = this.hostClass();
        while (c != null) {
            int index = 0;
            Iterator iter = c.getComponents();
            while (iter.hasNext()) {
                Components next = (Components)iter.next();
                if (next == comp) {
                    return index;
                }
                if (next instanceof TokenComponent) continue;
                ++index;
            }
            TypeDecl typeDecl = c = c instanceof ASTDecl ? ((ASTDecl)c).superClass() : null;
        }
        return -1;
    }

    public Components findCorrespondingNTA() {
        if (!this.getName().startsWith("get")) {
            return null;
        }
        String attrName = this.getName().substring(3);
        TypeDecl c = this.hostClass();
        while (c != null) {
            Iterator iter = c.getComponents();
            while (iter.hasNext()) {
                Components comp = (Components)iter.next();
                if (comp.name().equals(attrName) && (comp instanceof OptionalComponentNTA || comp instanceof TokenComponentNTA || comp instanceof AggregateComponentsNTA)) {
                    return comp;
                }
                if (attrName.equals(String.valueOf(comp.name()) + "Opt") && comp instanceof OptionalComponentNTA) {
                    return comp;
                }
                if (!attrName.equals(String.valueOf(comp.name()) + "List") || !(comp instanceof ListComponentsNTA)) continue;
                return comp;
            }
            TypeDecl typeDecl = c = c instanceof ASTDecl ? ((ASTDecl)c).superClass() : null;
        }
        return null;
    }

    public String higherOrderAttributeCode() {
        return "";
    }

    public AttrDecl(int i) {
        super(i);
    }

    public AttrDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public AttrDecl() {
        this(0);
        this.setChild(new List(), 0);
    }

    public AttrDecl(List p0, String p1, String p2, boolean p3, String p4, int p5, int p6, boolean p7, boolean p8, String p9) {
        this.setChild(p0, 0);
        this.setName(p1);
        this.setType(p2);
        this.setLazy(p3);
        this.setFileName(p4);
        this.setStartLine(p5);
        this.setEndLine(p6);
        this.setFinal(p7);
        this.setNTA(p8);
        this.setComment(p9);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "AttrDecl" + "\"" + this.getName() + "\"" + "\"" + this.getType() + "\"" + "\"" + this.getLazy() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"" + "\"" + this.getFinal() + "\"" + "\"" + this.getNTA() + "\"" + "\"" + this.getComment() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of AttrDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.getParameterList();
        list.setChild(node, list.getNumChild());
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
    }

    public List getParameterList() {
        return (List)this.getChild(0);
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name;
    }

    public void setType(String value) {
        this.tokenString_Type = value;
    }

    public String getType() {
        return this.tokenString_Type;
    }

    public void setLazy(boolean value) {
        this.tokenboolean_Lazy = value;
    }

    public boolean getLazy() {
        return this.tokenboolean_Lazy;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName;
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public void setFinal(boolean value) {
        this.tokenboolean_Final = value;
    }

    public boolean getFinal() {
        return this.tokenboolean_Final;
    }

    public void setNTA(boolean value) {
        this.tokenboolean_NTA = value;
    }

    public boolean getNTA() {
        return this.tokenboolean_NTA;
    }

    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    public String getComment() {
        return this.tokenString_Comment;
    }

    public abstract String error();

    public String parametersDecl() {
        boolean interruptedCircle = false;
        if (this.parametersDecl_visited) {
            throw new RuntimeException("Circular definition of attr: parametersDecl in class: ");
        }
        this.parametersDecl_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String parametersDecl_value = this.parametersDecl_compute();
        this.parametersDecl_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return parametersDecl_value;
    }

    private String parametersDecl_compute() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.getNumParameter()) {
            Parameter p = this.getParameter(i);
            s.append(String.valueOf(p.getType()) + " " + p.getName());
            if (i < this.getNumParameter() - 1) {
                s.append(", ");
            }
            ++i;
        }
        return s.toString();
    }

    public String parameters() {
        boolean interruptedCircle = false;
        if (this.parameters_visited) {
            throw new RuntimeException("Circular definition of attr: parameters in class: ");
        }
        this.parameters_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String parameters_value = this.parameters_compute();
        this.parameters_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return parameters_value;
    }

    private String parameters_compute() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.getNumParameter()) {
            Parameter p = this.getParameter(i);
            s.append(p.getName());
            if (i < this.getNumParameter() - 1) {
                s.append(", ");
            }
            ++i;
        }
        return s.toString();
    }

    public String interfaceParameters() {
        boolean interruptedCircle = false;
        if (this.interfaceParameters_visited) {
            throw new RuntimeException("Circular definition of attr: interfaceParameters in class: ");
        }
        this.interfaceParameters_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String interfaceParameters_value = this.interfaceParameters_compute();
        this.interfaceParameters_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return interfaceParameters_value;
    }

    private String interfaceParameters_compute() {
        return "caller, child" + (this.parameters().equals("") ? "" : ", " + this.parameters());
    }

    public String interfaceParametersDecl() {
        boolean interruptedCircle = false;
        if (this.interfaceParametersDecl_visited) {
            throw new RuntimeException("Circular definition of attr: interfaceParametersDecl in class: ");
        }
        this.interfaceParametersDecl_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String interfaceParametersDecl_value = this.interfaceParametersDecl_compute();
        this.interfaceParametersDecl_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return interfaceParametersDecl_value;
    }

    private String interfaceParametersDecl_compute() {
        return "ASTNode caller, ASTNode child" + (this.parametersDecl().equals("") ? "" : ", " + this.parametersDecl());
    }

    public String interfaceParametersStart() {
        boolean interruptedCircle = false;
        if (this.interfaceParametersStart_visited) {
            throw new RuntimeException("Circular definition of attr: interfaceParametersStart in class: ");
        }
        this.interfaceParametersStart_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String interfaceParametersStart_value = this.interfaceParametersStart_compute();
        this.interfaceParametersStart_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return interfaceParametersStart_value;
    }

    private String interfaceParametersStart_compute() {
        return "this, null" + (this.parameters().equals("") ? "" : ", " + this.parameters());
    }

    public String interfaceParametersContinue() {
        boolean interruptedCircle = false;
        if (this.interfaceParametersContinue_visited) {
            throw new RuntimeException("Circular definition of attr: interfaceParametersContinue in class: ");
        }
        this.interfaceParametersContinue_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String interfaceParametersContinue_value = this.interfaceParametersContinue_compute();
        this.interfaceParametersContinue_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return interfaceParametersContinue_value;
    }

    private String interfaceParametersContinue_compute() {
        return "this, caller" + (this.parameters().equals("") ? "" : ", " + this.parameters());
    }

    public boolean isCircular() {
        boolean interruptedCircle = false;
        if (this.isCircular_visited) {
            throw new RuntimeException("Circular definition of attr: isCircular in class: ");
        }
        this.isCircular_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean isCircular_value = this.isCircular_compute();
        this.isCircular_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return isCircular_value;
    }

    private boolean isCircular_compute() {
        return this.hasBottomValue();
    }

    public boolean hasBottomValue() {
        boolean interruptedCircle = false;
        if (this.hasBottomValue_visited) {
            throw new RuntimeException("Circular definition of attr: hasBottomValue in class: ");
        }
        this.hasBottomValue_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean hasBottomValue_value = this.hasBottomValue_compute();
        this.hasBottomValue_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return hasBottomValue_value;
    }

    private boolean hasBottomValue_compute() {
        return this.bottomValue != null;
    }

    public ASTExpression getBottomValue() {
        boolean interruptedCircle = false;
        if (this.getBottomValue_visited) {
            throw new RuntimeException("Circular definition of attr: getBottomValue in class: ");
        }
        this.getBottomValue_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        ASTExpression getBottomValue_value = this.getBottomValue_compute();
        this.getBottomValue_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return getBottomValue_value;
    }

    private ASTExpression getBottomValue_compute() {
        return this.bottomValue;
    }

    public TypeDecl root() {
        boolean interruptedCircle = false;
        if (this.root_visited) {
            throw new RuntimeException("Circular definition of attr: root in class: ");
        }
        this.root_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        TypeDecl root_value = this.root_compute();
        this.root_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return root_value;
    }

    private TypeDecl root_compute() {
        return this.hostClass().env().root();
    }

    public String collDebugString() {
        boolean interruptedCircle = false;
        if (this.collDebugString_visited) {
            throw new RuntimeException("Circular definition of attr: collDebugString in class: ");
        }
        this.collDebugString_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String collDebugString_value = this.collDebugString_compute();
        this.collDebugString_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return collDebugString_value;
    }

    private String collDebugString_compute() {
        if (!ASTNode.debugMode) {
            return "";
        }
        return "        if(node == null) throw new RuntimeException(\"Trying to evaluate collection attribute in subtree not attached to main tree\");";
    }

    public boolean separateEvaluation() {
        boolean interruptedCircle = false;
        if (this.separateEvaluation_visited) {
            throw new RuntimeException("Circular definition of attr: separateEvaluation in class: ");
        }
        this.separateEvaluation_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean separateEvaluation_value = this.separateEvaluation_compute();
        this.separateEvaluation_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return separateEvaluation_value;
    }

    private boolean separateEvaluation_compute() {
        return this.hasAnnotation("@SeparateEvaluation") || this.naive();
    }

    public boolean lazyCondition() {
        boolean interruptedCircle = false;
        if (this.lazyCondition_visited) {
            throw new RuntimeException("Circular definition of attr: lazyCondition in class: ");
        }
        this.lazyCondition_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean lazyCondition_value = this.lazyCondition_compute();
        this.lazyCondition_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return lazyCondition_value;
    }

    private boolean lazyCondition_compute() {
        return this.hasAnnotation("@LazyCondition");
    }

    public boolean onePhase() {
        boolean interruptedCircle = false;
        if (this.onePhase_visited) {
            throw new RuntimeException("Circular definition of attr: onePhase in class: ");
        }
        this.onePhase_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean onePhase_value = this.onePhase_compute();
        this.onePhase_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return onePhase_value;
    }

    private boolean onePhase_compute() {
        return this.hasAnnotation("@OnePhase");
    }

    public boolean naive() {
        boolean interruptedCircle = false;
        if (this.naive_visited) {
            throw new RuntimeException("Circular definition of attr: naive in class: ");
        }
        this.naive_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean naive_value = this.naive_compute();
        this.naive_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return naive_value;
    }

    private boolean naive_compute() {
        return this.hasAnnotation("@Naive");
    }

    public String collectingSignature() {
        if (this.collectingSignature_computed) {
            return this.collectingSignature_value;
        }
        boolean interruptedCircle = false;
        if (this.collectingSignature_visited) {
            throw new RuntimeException("Circular definition of attr: collectingSignature in class: ");
        }
        this.collectingSignature_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.collectingSignature_value = this.collectingSignature_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.collectingSignature_computed = true;
        }
        this.collectingSignature_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return this.collectingSignature_value;
    }

    private String collectingSignature_compute() {
        return this.attributeSignature();
    }

    public boolean visitCheckEnabled() {
        boolean interruptedCircle = false;
        if (this.visitCheckEnabled_visited) {
            throw new RuntimeException("Circular definition of attr: visitCheckEnabled in class: ");
        }
        this.visitCheckEnabled_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean visitCheckEnabled_value = this.visitCheckEnabled_compute();
        this.visitCheckEnabled_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return visitCheckEnabled_value;
    }

    private boolean visitCheckEnabled_compute() {
        return ASTNode.visitCheckEnabled;
    }

    public boolean declaredNTA() {
        boolean interruptedCircle = false;
        if (this.declaredNTA_visited) {
            throw new RuntimeException("Circular definition of attr: declaredNTA in class: ");
        }
        this.declaredNTA_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        boolean declaredNTA_value = this.declaredNTA_compute();
        this.declaredNTA_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return declaredNTA_value;
    }

    private boolean declaredNTA_compute() {
        return false;
    }

    public String inhDebugString() {
        boolean interruptedCircle = false;
        if (this.inhDebugString_visited) {
            throw new RuntimeException("Circular definition of attr: inhDebugString in class: ");
        }
        this.inhDebugString_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String inhDebugString_value = this.inhDebugString_compute();
        this.inhDebugString_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return inhDebugString_value;
    }

    private String inhDebugString_compute() {
        if (!ASTNode.debugMode) {
            return "";
        }
        if (ASTNode.parentInterface) {
            return "        if(n == null) throw new RuntimeException(\"Trying to evaluate attribute in subtree not attached to main tree\");";
        }
        return "        if(getParent() == null) throw new RuntimeException(\"Trying to evaluate attribute in subtree not attached to main tree\");";
    }

    public String cycleLimitCheck() {
        boolean interruptedCircle = false;
        if (this.cycleLimitCheck_visited) {
            throw new RuntimeException("Circular definition of attr: cycleLimitCheck in class: ");
        }
        this.cycleLimitCheck_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String cycleLimitCheck_value = this.cycleLimitCheck_compute();
        this.cycleLimitCheck_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return cycleLimitCheck_value;
    }

    private String cycleLimitCheck_compute() {
        return ASTNode.cycleLimit > 0 ? "if(state().CIRCLE_INDEX > " + ASTNode.cycleLimit + ") throw new java.lang.RuntimeException(\"Iteration limit " + ASTNode.cycleLimit + " exceeded\");\n" : "";
    }

    public String name() {
        boolean interruptedCircle = false;
        if (this.name_visited) {
            throw new RuntimeException("Circular definition of attr: name in class: ");
        }
        this.name_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String name_value = this.name_compute();
        this.name_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return name_value;
    }

    private String name_compute() {
        return this.getName();
    }

    public String type() {
        boolean interruptedCircle = false;
        if (this.type_visited) {
            throw new RuntimeException("Circular definition of attr: type in class: ");
        }
        this.type_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String type_value = this.type_compute();
        this.type_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return type_value;
    }

    private String type_compute() {
        return this.getType();
    }

    public String getTypeInSignature() {
        boolean interruptedCircle = false;
        if (this.getTypeInSignature_visited) {
            throw new RuntimeException("Circular definition of attr: getTypeInSignature in class: ");
        }
        this.getTypeInSignature_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String getTypeInSignature_value = this.getTypeInSignature_compute();
        this.getTypeInSignature_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return getTypeInSignature_value;
    }

    private String getTypeInSignature_compute() {
        return AttrDecl.convTypeNameToSignature(this.type());
    }

    public String signature() {
        boolean interruptedCircle = false;
        if (this.signature_visited) {
            throw new RuntimeException("Circular definition of attr: signature in class: ");
        }
        this.signature_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String signature_value = this.signature_compute();
        this.signature_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return signature_value;
    }

    private String signature_compute() {
        if (this.getNumParameter() == 0) {
            return this.getName();
        }
        StringBuffer s = new StringBuffer();
        s.append(this.getName());
        int i = 0;
        while (i < this.getNumParameter()) {
            s.append("_" + this.getParameter(i).getTypeInSignature());
            ++i;
        }
        return s.toString();
    }

    public TypeDecl hostClass() {
        boolean interruptedCircle = false;
        if (this.hostClass_visited) {
            throw new RuntimeException("Circular definition of attr: hostClass in class: ");
        }
        this.hostClass_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        TypeDecl hostClass_value = this.getParent().Define_TypeDecl_hostClass(this, null);
        this.hostClass_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return hostClass_value;
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

