/*
 * Decompiled with CFR 0.152.
 */
package beaver.spec;

import beaver.Symbol;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import beaver.spec.ast.Declaration;
import beaver.spec.ast.GrammarTreeRoot;
import beaver.spec.ast.Rule;
import beaver.spec.ast.TreeWalker;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class GrammarBuilder
extends TreeWalker {
    private Log log;
    private Grammar grammar;
    private HashMap symbols;
    private int n_nonterms;
    private int n_terms;
    private int n_rules;

    private static boolean checkBraces(String code) {
        boolean ovr = false;
        int n = 0;
        int len = code.length();
        int i = 0;
        while (i < len) {
            char c = code.charAt(i);
            if (c == '{') {
                ++n;
            } else if (c == '}') {
                --n;
            }
            if (n < 0) {
                ovr = true;
            }
            ++i;
        }
        return !ovr && n == 0;
    }

    private static String trimCode(String code) {
        if (code != null) {
            int i = code.length();
            while (Character.isWhitespace(code.charAt(--i))) {
            }
            if (code.charAt(i) == '\n' && code.charAt(--i) == '\r') {
                --i;
            }
            code = code.substring(0, i + 1);
        }
        return code;
    }

    public GrammarBuilder(Log log) {
        this.log = log;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void visit(GrammarTreeRoot root) {
        this.grammar = new Grammar();
        this.symbols = new HashMap(89);
        this.symbols.put(this.grammar.error.name, this.grammar.error);
        this.n_nonterms = 1;
        this.n_terms = 1;
        this.n_rules = 0;
        final HashMap tokens = new HashMap(89);
        final ArrayList goals = new ArrayList();
        root.accept(new TreeWalker(){

            public void visit(Declaration.Terminals decl) {
                int i = 0;
                while (i < decl.symbols.length) {
                    String sym_name = (String)decl.symbols[i].value;
                    if (!GrammarBuilder.this.symbols.containsKey(sym_name)) {
                        GrammarBuilder.this.symbols.put(sym_name, new Terminal(sym_name));
                        GrammarBuilder grammarBuilder = GrammarBuilder.this;
                        grammarBuilder.n_terms = grammarBuilder.n_terms + 1;
                        tokens.put(sym_name, decl.symbols[i]);
                    }
                    ++i;
                }
            }

            public void visit(Rule rule) {
                String lhs_sym_name = rule.getLHSSymbolName();
                if (!GrammarBuilder.this.symbols.containsKey(lhs_sym_name)) {
                    GrammarBuilder.this.symbols.put(lhs_sym_name, new NonTerminal(lhs_sym_name));
                    GrammarBuilder grammarBuilder = GrammarBuilder.this;
                    grammarBuilder.n_nonterms = grammarBuilder.n_nonterms + 1;
                } else if (tokens.containsKey(lhs_sym_name)) {
                    GrammarBuilder.this.log.error(rule.lhs_sym, "nonterminal was declared as a terminal");
                    GrammarBuilder.this.symbols.put(lhs_sym_name, new NonTerminal(lhs_sym_name));
                    GrammarBuilder grammarBuilder = GrammarBuilder.this;
                    grammarBuilder.n_nonterms = grammarBuilder.n_nonterms + 1;
                    tokens.remove(lhs_sym_name);
                    GrammarBuilder grammarBuilder2 = GrammarBuilder.this;
                    grammarBuilder2.n_terms = grammarBuilder2.n_terms - 1;
                }
                super.visit(rule);
            }

            public void visit(Rule.Definition rhs) {
                String prec_sym_name = rhs.getPrecedenceSymbolName();
                if (prec_sym_name != null && !GrammarBuilder.this.symbols.containsKey(prec_sym_name)) {
                    Terminal sym = new Terminal(prec_sym_name);
                    sym.id = (short)-1;
                    GrammarBuilder.this.symbols.put(prec_sym_name, sym);
                }
                GrammarBuilder grammarBuilder = GrammarBuilder.this;
                grammarBuilder.n_rules = grammarBuilder.n_rules + 1;
            }
        });
        root.accept(new RuleWalker(){

            public void visit(Rule.Definition.Element rhs_item) {
                String rhs_sym_name = rhs_item.getName();
                GrammarSymbol rhs_sym = (GrammarSymbol)GrammarBuilder.this.symbols.get(rhs_sym_name);
                if (rhs_sym == null) {
                    GrammarBuilder.this.log.error(rhs_item.sym_name, "symbol is neither a terminal nor a nonterminal of the grammar");
                    rhs_sym = new Terminal(rhs_sym_name);
                    GrammarBuilder.this.symbols.put(rhs_sym_name, rhs_sym);
                    rhs_sym.id = (short)-1;
                } else if (rhs_sym instanceof Terminal) {
                    if (rhs_sym.id < 0) {
                        GrammarBuilder.this.log.error(rhs_item.sym_name, "symbol is not declared as a grammar terminal");
                    } else {
                        tokens.remove(rhs_sym_name);
                    }
                }
            }
        });
        Iterator i = tokens.values().iterator();
        while (i.hasNext()) {
            Symbol token = (Symbol)i.next();
            this.log.warning(token, "declared terminal is not used by the grammar");
            this.symbols.remove(token.value);
            --this.n_terms;
        }
        root.accept(new DeclarationWalker(){
            private int precedence = Integer.MAX_VALUE;
            private HashSet imports = new HashSet(23);

            public void visit(GrammarTreeRoot root) {
                this.imports.add("java.util.ArrayList");
                this.imports.add("beaver.*");
                super.visit(root);
                ((GrammarBuilder)GrammarBuilder.this).grammar.imports = ((AbstractCollection)this.imports).toArray(new String[this.imports.size()]);
            }

            public void visit(Declaration.Header decl) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.prolog == null) {
                    char c;
                    String text = (String)decl.code.value;
                    int i = 0;
                    while (Character.isWhitespace(c = text.charAt(i)) || c == '\n') {
                        ++i;
                    }
                    ((GrammarBuilder)GrammarBuilder.this).grammar.prolog = i > 0 ? text.substring(i) : text;
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.prolog = String.valueOf(((GrammarBuilder)GrammarBuilder.this).grammar.prolog) + (String)decl.code.value;
                }
            }

            public void visit(Declaration.PackageName decl) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.package_name != null) {
                    GrammarBuilder.this.log.warning(decl.name, "Parser package has been already defined as \"" + ((GrammarBuilder)GrammarBuilder.this).grammar.package_name + "\", new name ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.package_name = decl.getName();
                }
            }

            public void visit(Declaration.Imports decl) {
                int i = 0;
                while (i < decl.symbols.length) {
                    this.imports.add(decl.symbols[i].value);
                    ++i;
                }
            }

            public void visit(Declaration.ClassName decl) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.class_name != null) {
                    GrammarBuilder.this.log.warning(decl.name, "Parser class name has been already defined as \"" + ((GrammarBuilder)GrammarBuilder.this).grammar.class_name + "\", new name ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.class_name = decl.getName();
                }
            }

            public void visit(Declaration.ClassCode decl) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.class_code != null) {
                    GrammarBuilder.this.log.warning(decl.code, "Embedded parser class code has been already defined, new code ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.class_code = GrammarBuilder.trimCode(this.getCode(decl));
                }
            }

            public void visit(Declaration.ConstructorCode decl) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.init_code != null) {
                    GrammarBuilder.this.log.warning(decl.code, "Parser initialization code has been already defined, new code ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.init_code = GrammarBuilder.trimCode(this.getCode(decl));
                }
            }

            public void visit(Declaration.Goal decl) {
                String sym_name = decl.getName();
                GrammarSymbol sym = (GrammarSymbol)GrammarBuilder.this.symbols.get(sym_name);
                if (sym == null) {
                    GrammarBuilder.this.log.error(decl.name, "Symbol is undefined");
                } else if (sym instanceof Terminal) {
                    GrammarBuilder.this.log.error(decl.name, "Symbol is a terminal");
                } else {
                    goals.add(sym);
                }
            }

            public void visit(Declaration.TypeOf decl) {
                String type = decl.getTypeName();
                int i = 0;
                while (i < decl.symbols.length) {
                    GrammarSymbol sym = (GrammarSymbol)GrammarBuilder.this.symbols.get(decl.symbols[i].value);
                    if (sym == null) {
                        GrammarBuilder.this.log.error(decl.symbols[i], "Symbol is undefined");
                    } else if (sym.type != null) {
                        GrammarBuilder.this.log.error(decl.symbols[i], "Symbol's Java type is already set to \"" + sym.type + "\"");
                    } else {
                        sym.type = type;
                    }
                    ++i;
                }
            }

            public void visit(Declaration.LeftAssoc decl) {
                this.setPrecedence(decl, Terminal.Associativity.LEFT);
            }

            public void visit(Declaration.RightAssoc decl) {
                this.setPrecedence(decl, Terminal.Associativity.RIGHT);
            }

            public void visit(Declaration.NonAssoc decl) {
                this.setPrecedence(decl, Terminal.Associativity.NONE);
            }

            private void setPrecedence(Declaration.SymbolsContainer decl, Terminal.Associativity type) {
                int i = 0;
                while (i < decl.symbols.length) {
                    String sym_name = (String)decl.symbols[i].value;
                    GrammarSymbol sym = (GrammarSymbol)GrammarBuilder.this.symbols.get(sym_name);
                    if (sym == null) {
                        GrammarBuilder.this.log.warning(decl.symbols[i], "Symbol is not used by the grammar");
                    } else if (sym instanceof NonTerminal) {
                        GrammarBuilder.this.log.error(decl.symbols[i], "Symbol is a non-terminal.");
                    } else {
                        ((Terminal)sym).setPrecedence(this.precedence, type);
                    }
                    ++i;
                }
                --this.precedence;
            }

            private String getCode(Declaration.CodeContainer decl) {
                String code = decl.getCode();
                if (!GrammarBuilder.checkBraces(code)) {
                    GrammarBuilder.this.log.warning(decl, "Java code has unbalanced braces");
                }
                return code;
            }
        });
        final ArrayList<Production> rules = new ArrayList<Production>(this.n_rules * 2);
        if (goals.isEmpty()) {
            this.log.warning(root.rules[0].lhs_sym, "Grammar has not declared any goals, will use first declared nonterminal");
            this.grammar.goal_symbol = (NonTerminal)this.symbols.get(root.rules[0].getLHSSymbolName());
        } else if (goals.size() == 1) {
            this.grammar.goal_symbol = (NonTerminal)goals.get(0);
        } else {
            NonTerminal[] alts = goals.toArray(new NonTerminal[goals.size()]);
            this.grammar.goal_symbol = new NonTerminal("$goal");
            this.symbols.put(this.grammar.goal_symbol.name, this.grammar.goal_symbol);
            ++this.n_nonterms;
            rules.add(new Production(rules.size(), this.grammar.goal_symbol, new Production.RHS(alts[0])));
            int i2 = 1;
            while (i2 < alts.length) {
                Terminal term = new Terminal("$" + alts[i2].name);
                this.symbols.put(term.name, term);
                ++this.n_terms;
                rules.add(new Production(rules.size(), this.grammar.goal_symbol, new Production.RHS(term, alts[i2])));
                ++i2;
            }
        }
        root.accept(new RuleWalker(){
            boolean found = false;

            public void visit(GrammarTreeRoot root) {
                super.visit(root);
                if (this.found) {
                    NonTerminal new_goal_sym = new NonTerminal("$goal");
                    new_goal_sym.type = ((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol.type;
                    GrammarBuilder.this.symbols.put(new_goal_sym.name, new_goal_sym);
                    GrammarBuilder grammarBuilder = GrammarBuilder.this;
                    grammarBuilder.n_nonterms = grammarBuilder.n_nonterms + 1;
                    rules.add(new Production(rules.size(), new_goal_sym, new Production.RHS(((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol)));
                    ((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol = new_goal_sym;
                }
            }

            public void visit(Rule.Definition.Element rhs_item) {
                if (!this.found) {
                    this.found = ((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol.name.equals(rhs_item.getName());
                }
            }
        });
        root.accept(new RuleWalker(){
            private NonTerminal lhs_sym;
            private ArrayList rhs_elements = new ArrayList();

            public void visit(Rule rule) {
                this.lhs_sym = (NonTerminal)GrammarBuilder.this.symbols.get(rule.getLHSSymbolName());
                super.visit(rule);
            }

            public void visit(Rule.Definition rhs) {
                this.rhs_elements.clear();
                super.visit(rhs);
                Production rule = new Production(rules.size(), this.lhs_sym, new Production.RHS(this.rhs_elements.toArray(new Production.RHS.Item[this.rhs_elements.size()])), rhs.getPrecedenceSymbolName() == null ? null : (Terminal)GrammarBuilder.this.symbols.get(rhs.getPrecedenceSymbolName()));
                String code = rhs.getReduceActionCode();
                if (code != null) {
                    if (!GrammarBuilder.checkBraces(code)) {
                        GrammarBuilder.this.log.warning(rhs.code, "Java code has unbalanced braces");
                    }
                    rule.code = GrammarBuilder.trimCode(code);
                }
                if (rhs.elements.length > 0) {
                    rule.start_pos = rhs.elements[0].getStart();
                    rule.end_pos = rhs.elements[rhs.elements.length - 1].getEnd();
                }
                rules.add(rule);
            }

            public void visit(Rule.Definition.Element rhs_item) {
                GrammarSymbol rhs_sym = rhs_item.ebnf_sym.value == null ? (GrammarSymbol)GrammarBuilder.this.symbols.get(rhs_item.getName()) : this.getExtendedSymbol(rhs_item);
                this.rhs_elements.add(new Production.RHS.Item(rhs_sym, rhs_item.getAlias()));
            }

            private GrammarSymbol getExtendedSymbol(Rule.Definition.Element rhs_item) {
                switch (rhs_item.getExtUseMark()) {
                    case '?': {
                        return this.getOpt(rhs_item.getName());
                    }
                    case '+': {
                        return this.getLst(rhs_item.getName());
                    }
                    case '*': {
                        return this.getOpt(this.getLst((String)rhs_item.getName()).name);
                    }
                }
                throw new IllegalArgumentException("unrecognized extended symbol notation");
            }

            private NonTerminal getOpt(String sym_name) {
                String opt_sym_name = "opt$" + sym_name;
                NonTerminal opt_sym = (NonTerminal)GrammarBuilder.this.symbols.get(opt_sym_name);
                if (opt_sym == null) {
                    GrammarSymbol item_sym = (GrammarSymbol)GrammarBuilder.this.symbols.get(sym_name);
                    opt_sym = new NonTerminal(opt_sym_name, item_sym.type);
                    GrammarBuilder.this.symbols.put(opt_sym_name, opt_sym);
                    GrammarBuilder grammarBuilder = GrammarBuilder.this;
                    grammarBuilder.n_nonterms = grammarBuilder.n_nonterms + 1;
                    rules.add(new Production(rules.size(), opt_sym, new Production.RHS()));
                    rules.add(new Production(rules.size(), opt_sym, new Production.RHS(item_sym)));
                }
                return opt_sym;
            }

            private NonTerminal getLst(String sym_name) {
                String lst_sym_name = "lst$" + sym_name;
                NonTerminal lst_sym = (NonTerminal)GrammarBuilder.this.symbols.get(lst_sym_name);
                if (lst_sym == null) {
                    GrammarSymbol item_sym = (GrammarSymbol)GrammarBuilder.this.symbols.get(sym_name);
                    lst_sym = new NonTerminal(lst_sym_name, item_sym.type != null ? "+" + item_sym.type : null);
                    GrammarBuilder.this.symbols.put(lst_sym_name, lst_sym);
                    GrammarBuilder grammarBuilder = GrammarBuilder.this;
                    grammarBuilder.n_nonterms = grammarBuilder.n_nonterms + 1;
                    rules.add(new Production(rules.size(), lst_sym, new Production.RHS(item_sym)));
                    rules.add(new Production(rules.size(), lst_sym, new Production.RHS(lst_sym, item_sym)));
                }
                return lst_sym;
            }
        });
        this.grammar.rules = rules.toArray(new Production[rules.size()]);
        this.grammar.nonterminals = this.getNonTerminals();
        this.grammar.terminals = this.getTerminals();
        this.propagateTypes(this.grammar.nonterminals);
        this.writeListsCode(this.grammar.nonterminals);
    }

    private Terminal[] getTerminals() {
        Production[] rules = new Production[this.grammar.rules.length];
        System.arraycopy(this.grammar.rules, 0, rules, 0, rules.length);
        Arrays.sort(rules, Production.NUM_TERM_CMP);
        Terminal[] terms = new Terminal[this.n_terms];
        terms[0] = this.grammar.eof;
        int n = 1;
        int i = 0;
        while (i < rules.length) {
            Production.RHS rhs = rules[i].rhs;
            if (rhs.n_term > 0) {
                int j = 0;
                while (j < rhs.items.length) {
                    GrammarSymbol sym = rhs.items[j].symbol;
                    if (sym instanceof Terminal && sym.id == 0) {
                        Terminal term = (Terminal)sym;
                        term.id = (short)n;
                        terms[n++] = term;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (n < this.n_terms) {
            throw new IllegalStateException("found less terminals than previously counted");
        }
        return terms;
    }

    private NonTerminal[] getNonTerminals() {
        Production[] rules = new Production[this.grammar.rules.length];
        System.arraycopy(this.grammar.rules, 0, rules, 0, rules.length);
        Arrays.sort(rules, Production.NUM_NONTERM_CMP);
        NonTerminal[] nts = new NonTerminal[this.n_nonterms];
        int n = 0;
        int i = 0;
        while (i < rules.length) {
            Production.RHS rhs = rules[i].rhs;
            if (rhs.n_nonterm > 0) {
                int j = 0;
                while (j < rhs.items.length) {
                    GrammarSymbol sym = rhs.items[j].symbol;
                    if (sym instanceof NonTerminal && sym.id == 0) {
                        NonTerminal nt = (NonTerminal)sym;
                        nt.id = (short)(n + this.n_terms);
                        nts[n++] = nt;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.grammar.goal_symbol.id = (short)(n + this.n_terms);
        nts[n++] = this.grammar.goal_symbol;
        if (this.grammar.error.id == 0) {
            this.grammar.error.id = (short)(n + this.n_terms);
            nts[n++] = this.grammar.error;
        }
        if (n < this.n_nonterms) {
            throw new IllegalStateException("found less nonterminals than previously counted");
        }
        return nts;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void propagateTypes(NonTerminal[] nts) {
        boolean more_found;
        do {
            more_found = false;
            int i = 0;
            while (i < nts.length) {
                block16: {
                    Production elem_rule;
                    block18: {
                        block17: {
                            if (nts[i].type != null) break block16;
                            if (nts[i].definitions.size() == 2) break block17;
                            if (nts[i].definitions.size() != 1) break block16;
                            Production rule = nts[i].definitions.start();
                            if (rule.code == null && rule.rhs.size() == 1) {
                                GrammarSymbol item = rule.rhs.start().symbol;
                                if (item.type != null) {
                                    nts[i].type = item.type;
                                    more_found = true;
                                }
                            }
                            break block16;
                        }
                        elem_rule = nts[i].definitions.start();
                        if (elem_rule.rhs.size() == 1) break block18;
                        elem_rule = elem_rule.next_definition;
                        if (elem_rule.rhs.size() != 1) break block16;
                    }
                    if (elem_rule.code == null) {
                        GrammarSymbol elem = elem_rule.rhs.start().symbol;
                        if (elem.type != null) {
                            Production next_rule;
                            Production production = next_rule = elem_rule.next_definition != null ? elem_rule.next_definition : nts[i].definitions.start();
                            if (next_rule.code == null) {
                                if (next_rule.rhs.size() == 0) {
                                    nts[i].type = elem.type;
                                    more_found = true;
                                } else if (next_rule.rhs.size() >= 2 && next_rule.rhs.start().symbol == nts[i] && next_rule.rhs.end().symbol == elem) {
                                    nts[i].type = "+" + elem.type;
                                    more_found = true;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        } while (more_found);
    }

    private void writeListsCode(NonTerminal[] nts) {
        int i = 0;
        while (i < nts.length) {
            block6: {
                Production add_elem_rule;
                GrammarSymbol elem;
                block8: {
                    Production new_list_rule;
                    block7: {
                        if (nts[i].definitions.size() != 2) break block6;
                        new_list_rule = nts[i].definitions.start();
                        if (new_list_rule.rhs.size() == 1) break block7;
                        new_list_rule = new_list_rule.next_definition;
                        if (new_list_rule.rhs.size() != 1) break block6;
                    }
                    if (new_list_rule.code != null) break block6;
                    elem = new_list_rule.rhs.start().symbol;
                    add_elem_rule = nts[i].definitions.start();
                    if (add_elem_rule.rhs.size() >= 2) break block8;
                    add_elem_rule = add_elem_rule.next_definition;
                    if (add_elem_rule.rhs.size() < 2) break block6;
                }
                if (add_elem_rule.code == null && add_elem_rule.rhs.start().symbol == nts[i] && add_elem_rule.rhs.end().symbol == elem) {
                    if (nts[i].type == null) {
                        nts[i].type = "+" + (elem.type != null ? elem.type : "beaver.Symbol");
                    }
                    new_list_rule.code = new StringBuffer(Grammar.EBNF_LIST_TYPE_NAME.length() * 2 + 77).append(Grammar.EBNF_LIST_TYPE_NAME).append(" lst = new ").append(Grammar.EBNF_LIST_TYPE_NAME).append("(); ").append("lst.add(_symbols[offset + 1]").append(elem.type != null ? ".value" : "").append("); ").append("return new Symbol(lst);").toString();
                    add_elem_rule.code = new StringBuffer(Grammar.EBNF_LIST_TYPE_NAME.length() + 88).append("((").append(Grammar.EBNF_LIST_TYPE_NAME).append(") _symbols[offset + 1].value).add(_symbols[offset + ").append(add_elem_rule.rhs.size()).append("]").append(elem.type != null ? ".value" : "").append("); ").append("return _symbols[offset + 1];").toString();
                }
            }
            ++i;
        }
    }

    static class RuleWalker
    extends TreeWalker {
        RuleWalker() {
        }

        public void visit(GrammarTreeRoot node) {
            int i = 0;
            while (i < node.rules.length) {
                node.rules[i].accept(this);
                ++i;
            }
        }
    }

    static class DeclarationWalker
    extends TreeWalker {
        DeclarationWalker() {
        }

        public void visit(GrammarTreeRoot node) {
            int i = 0;
            while (i < node.declarations.length) {
                node.declarations[i].accept(this);
                ++i;
            }
        }
    }
}

