package test.jflex.natlab;
%%
import static test.jflex.natlab.NatlabParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;
%%
%layout natlab

//general header info
%option public "%public"
%option final "%final"
%option class "%class NaiveNatlabScanner"

//required for beaver compatibility
%option extends "%extends Scanner"
%option unicode "%unicode"
%option function "%function nextToken"
%lexthrow "Scanner.Exception"

//for debugging - track line and column
%option line "%line"
%option column "%column"

%option type "%type Symbol"

%component natlab

%start natlab

%declare "private static class PositionRecord {"
%{
  //records the position of a symbol
  private static class PositionRecord {
      int startLine = -1;
      int startCol = -1;
      int endLine = -1;
      int endCol = -1;
  }
%}

%declare "private static class StateRecord {"
%{
  private static class StateRecord {
    int stateNum;
    PositionRecord pos;
    
    StateRecord(int stateNum, PositionRecord pos) {
        this.stateNum = stateNum;
        this.pos = pos;
    }
  }
%}

%declare "private static final java.util.Set<Short> TYPE_PRECEDING_TRANSPOSE = new java.util.HashSet<Short>();"
%{
  private static final java.util.Set<Short> TYPE_PRECEDING_TRANSPOSE = new java.util.HashSet<Short>();
  static {
    //NB: cannot contain DOT
    TYPE_PRECEDING_TRANSPOSE.add(IDENTIFIER);
    TYPE_PRECEDING_TRANSPOSE.add(INT_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(IM_INT_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(FP_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(IM_FP_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(RPAREN);
    TYPE_PRECEDING_TRANSPOSE.add(RSQUARE);
    TYPE_PRECEDING_TRANSPOSE.add(RCURLY);
    TYPE_PRECEDING_TRANSPOSE.add(ARRAYTRANSPOSE);
    TYPE_PRECEDING_TRANSPOSE.add(MTRANSPOSE);
  }
%}

%{
  public void setCommentBuffer(CommentBuffer commentBuffer) {
      state_natlab.inst_natlab.setCommentBuffer(commentBuffer);
  }
%}

%{
  public CommentBuffer getCommentBuffer() {
      return state_natlab.inst_natlab.getCommentBuffer();
  }
%}