package metalexer.jflex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

import test.jflex.metalexer.LayoutParser;
import metalexer.ScannerTestBase;

import beaver.Scanner;

public class LayoutScannerTestBase extends ScannerTestBase {

    protected LayoutScannerTestBase() {
        super(LayoutParser.Terminals.EOF, LayoutParser.Terminals.NAMES);
    }

    /* Construct a scanner that will read from the specified file. */
    protected Scanner getScanner(String filename) throws FileNotFoundException {
        return ReflectionHelper.instantiateScanner("test.jflex.metalexer.LayoutScanner", new BufferedReader(new FileReader(filename)));
    }

    protected short getID(String idString) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return LayoutParser.Terminals.class.getField(idString).getShort(null);
    }
}
