//based on http://jflex.de/manual.html

package test.jflex.metalexer;
import static test.jflex.metalexer.LayoutParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/metalexer/layout.mll [13, 1]
%public
//from test/backend-jflex/in/metalexer/layout.mll [14, 1]
%final
//from test/backend-jflex/in/metalexer/layout.mll [15, 1]
%class LayoutScanner
//from test/backend-jflex/in/metalexer/layout.mll [18, 1]
%extends Scanner
//from test/backend-jflex/in/metalexer/layout.mll [19, 1]
%unicode
//from test/backend-jflex/in/metalexer/layout.mll [20, 1]
%function nextToken
//from test/backend-jflex/in/metalexer/layout.mll [21, 1]
%type Symbol
//from test/backend-jflex/in/metalexer/layout.mll [24, 1]
%line
//from test/backend-jflex/in/metalexer/layout.mll [25, 1]
%column
//from null [27, 1]
%yylexthrow Scanner.Exception

%{
    private final StateClass_layout state_layout = new StateClass_layout();
%}

%{
    private class StateClass_layout {
        private StateClass_layout() {
            metaLexerThread.start();
            
            //from test/backend-jflex/in/metalexer/layout.mll [100, 1]
            embeddingRecordArray[/*local_header_section*/ 0] = new EmbeddingRecord(inst_local_header, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [109, 1]
            embeddingRecordArray[/*inherited_header_section*/ 1] = new EmbeddingRecord(inst_inherited_header, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [118, 1]
            embeddingRecordArray[/*option_section*/ 2] = new EmbeddingRecord(inst_layout_option_section, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [125, 1]
            embeddingRecordArray[/*option_decl*/ 3] = new EmbeddingRecord(inst_decl_region, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [132, 1]
            embeddingRecordArray[/*option_init*/ 4] = new EmbeddingRecord(inst_init_region, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [139, 1]
            embeddingRecordArray[/*option_string_directive*/ 5] = new EmbeddingRecord(inst_string_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [148, 1]
            embeddingRecordArray[/*rule_section*/ 6] = new EmbeddingRecord(inst_layout_rule_section, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [155, 1]
            embeddingRecordArray[/*metapattern_directive*/ 7] = new EmbeddingRecord(inst_metapattern_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [164, 1]
            embeddingRecordArray[/*comments*/ 8] = new EmbeddingRecord(inst_bracket_comment, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [173, 1]
            embeddingRecordArray[/*identifier_directive*/ 9] = new EmbeddingRecord(inst_identifier_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [182, 1]
            embeddingRecordArray[/*string*/ 10] = new EmbeddingRecord(inst_string, PairFilter.EMPTY);
            
            //from test/backend-jflex/in/metalexer/layout.mll [94, 8]
            yybegin(base_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(inst_base, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            startEmbedding(/*local_header_section*/ 0); 
            
            restartAppendBuf();
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[11];
        private final CompClass_base inst_base = new CompClass_base();
        private final CompClass_bracket_comment inst_bracket_comment = new CompClass_bracket_comment();
        private final CompClass_decl_region inst_decl_region = new CompClass_decl_region();
        private final CompClass_identifier_directive inst_identifier_directive = new CompClass_identifier_directive();
        private final CompClass_inherited_header inst_inherited_header = new CompClass_inherited_header();
        private final CompClass_init_region inst_init_region = new CompClass_init_region();
        private final CompClass_layout_option_section inst_layout_option_section = new CompClass_layout_option_section();
        private final CompClass_layout_rule_section inst_layout_rule_section = new CompClass_layout_rule_section();
        private final CompClass_local_header inst_local_header = new CompClass_local_header();
        private final CompClass_metapattern_directive inst_metapattern_directive = new CompClass_metapattern_directive();
        private final CompClass_string inst_string = new CompClass_string();
        private final CompClass_string_directive inst_string_directive = new CompClass_string_directive();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private void append(String text) {
            appendBuf.append(text);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            //System.err.println("yypushback(1)");
            yypushback(1); //to ensure that at least one char is available
            yybegin(EXTRA_RETURN);
        }
        
        private boolean stopped = false;
        
        public void stop() {
            stopped = true;
            pipe.writeFinal('\n');
            boolean joined = false;
            while(!joined) {
                try {
                    metaLexerThread.join();
                    joined = true;
                } catch(InterruptedException e) {}
            }
        }
        
        private final Pipe pipe = new Pipe();
        private final LayoutScanner_Meta metalexer = new LayoutScanner_Meta(pipe);
        private final Thread metaLexerThread = new Thread(new Runnable() {
            public void run() {
                try {
                    metalexer.start();
                } catch(java.io.IOException e) {
                    //unrecoverable
                    e.printStackTrace();
                }
            }}, "MetaLexerThread");
        
        private Integer sendMTok(char mtok) {
            if(stopped) {
                throw new IllegalStateException("No meta-tokens may be sent after stop() has been called.");
            }
            //System.err.println("sendMTok(" + Integer.toHexString(mtok) + ")");
            pipe.write(mtok);
            return metalexer.checkForTransition();
        }
        
        public void processMTok(char mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                //System.err.println("Pair filter caught: " + Integer.toHexString(mtok));
                return; //don't send character if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            Integer nextEmbeddingNum = sendMTok(mtok);
            while(nextEmbeddingNum != null) {
                boolean endOfEmbedding = nextEmbeddingNum < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    startEmbedding(nextEmbeddingNum);
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                nextEmbeddingNum = endOfEmbedding ? sendMTok(currComp.getCharValue()) : null;
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract char getCharValue();
    }
%}

%{
    //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
    private class CompClass_base extends ComponentInnerClass {
        
        public CompClass_base() {
        }
        
        private static final int YYINITIAL = base_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0030';
        }
        
        public Maybe<? extends Symbol> base_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_base.base_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/base.mlc [9, 9]
                error("Unexpected character: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_base.base_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/base.mlc [10, 9]
                return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
    private class CompClass_bracket_comment extends ComponentInnerClass {
        
        public CompClass_bracket_comment() {
        }
        
        private static final int YYINITIAL = bracket_comment_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0032';
        }
        
        public Maybe<? extends Symbol> bracket_comment_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [15, 22]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [16, 23]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [19, 9]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [20, 9]
                error("Unterminated bracket comment");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
    private class CompClass_decl_region extends ComponentInnerClass {
        
        public CompClass_decl_region() {
        }
        
        private static final int YYINITIAL = decl_region_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(DECL_REGION, "%{" + text + "%}", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_layout.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0035';
        }
        
        public Maybe<? extends Symbol> decl_region_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [14, 20]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [19, 9]
                error("Unterminated declaration region");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
    private class CompClass_identifier_directive extends ComponentInnerClass {
        
        public CompClass_identifier_directive() {
        }
        
        private static final int YYINITIAL = identifier_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0037';
        }
        
        public Maybe<? extends Symbol> identifier_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_3()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [20, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [22, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [24, 9]
                error("Unexpected character in identifier list: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_8()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
    private class CompClass_inherited_header extends ComponentInnerClass {
        
        public CompClass_inherited_header() {
        }
        
        private static final int YYINITIAL = inherited_header_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    if(text.startsWith("\r\n")) {
        text = text.substring(2);
    } else if(text.startsWith("\n") || text.startsWith("\r")) {
        text = text.substring(1);
    }
    return Maybe.Just(symbol(INHERITED_HEADER, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_layout.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0039';
        }
        
        public Maybe<? extends Symbol> inherited_header_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_inherited_header.inherited_header_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> inherited_header_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_inherited_header.inherited_header_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/inherited_header.mlc [21, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> inherited_header_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_inherited_header.inherited_header_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/inherited_header.mlc [22, 9]
                error("Unterminated inherited header section.");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
    private class CompClass_init_region extends ComponentInnerClass {
        
        public CompClass_init_region() {
        }
        
        private static final int YYINITIAL = init_region_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(INIT_REGION, "%init{" + text + "%init}", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_layout.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0042';
        }
        
        public Maybe<? extends Symbol> init_region_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [14, 20]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [19, 9]
                error("Unterminated init region");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
    private class CompClass_layout_option_section extends ComponentInnerClass {
        
        public CompClass_layout_option_section() {
        }
        
        private static final int YYINITIAL = layout_option_section_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0044';
        }
        
        public Maybe<? extends Symbol> layout_option_section_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [26, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [27, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [33, 34]
                return Maybe.Just(symbol(HELPER_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [36, 34]
                return Maybe.Just(symbol(LAYOUT_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [37, 33]
                return Maybe.Just(symbol(START_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [38, 37]
                return Maybe.Just(symbol(COMPONENT_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_10() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [41, 35]
                return Maybe.Just(symbol(DECLARE_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_11() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [42, 34]
                return Maybe.Just(symbol(OPTION_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_12() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [43, 37]
                return Maybe.Just(symbol(INITTHROW_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_13() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [44, 36]
                return Maybe.Just(symbol(LEXTHROW_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_14() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [47, 5]
                error("Invalid directive");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_15() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_15()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_16() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_17() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [56, 9]
                error("Unexpected character in option section: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_18() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_18()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
    private class CompClass_layout_rule_section extends ComponentInnerClass {
        
        public CompClass_layout_rule_section() {
        }
        
        private static final int YYINITIAL = layout_rule_section_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u004a';
        }
        
        public Maybe<? extends Symbol> layout_rule_section_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [21, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [22, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [24, 34]
                return Maybe.Just(symbol(START_EMBED_GROUP));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [26, 35]
                return Maybe.Just(symbol(INHERIT_UNEMBED));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [27, 35]
                return Maybe.Just(symbol(INHERIT_REPLACE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [28, 36]
                return Maybe.Just(symbol(INHERIT_UNOPTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [30, 32]
                return Maybe.Just(symbol(EMBEDDING_NAME));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [31, 32]
                return Maybe.Just(symbol(EMBEDDING_HOST));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_10() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [32, 33]
                return Maybe.Just(symbol(EMBEDDING_GUEST));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_11() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [33, 32]
                return Maybe.Just(symbol(EMBEDDING_PAIR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_12() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [35, 33]
                return Maybe.Just(symbol(EMBEDDING_START));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_13() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [36, 31]
                return Maybe.Just(symbol(EMBEDDING_END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_14() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [38, 36]
                return Maybe.Just(symbol(START_INHERIT_GROUP));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_15() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [39, 34]
                return Maybe.Just(symbol(DELETION_DELETE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_16() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_17() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [44, 9]
                error("Unexpected character in rule section: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_18() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_18()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
    private class CompClass_local_header extends ComponentInnerClass {
        
        public CompClass_local_header() {
        }
        
        private static final int YYINITIAL = local_header_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    return Maybe.Just(symbol(LOCAL_HEADER, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_layout.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u004d';
        }
        
        public Maybe<? extends Symbol> local_header_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_local_header.local_header_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> local_header_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_local_header.local_header_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/local_header.mlc [16, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> local_header_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_local_header.local_header_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/local_header.mlc [17, 9]
                error("Unterminated local header section.");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
    private class CompClass_metapattern_directive extends ComponentInnerClass {
        
        public CompClass_metapattern_directive() {
        }
        
        private static final int YYINITIAL = metapattern_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u004f';
        }
        
        public Maybe<? extends Symbol> metapattern_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [19, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [21, 9]
                return Maybe.Just(symbol(MP_ANY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [22, 9]
                return Maybe.Just(symbol(MP_BOF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [23, 9]
                return Maybe.Just(symbol(MP_EOF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [25, 5]
                return Maybe.Just(symbol(MP_LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [26, 5]
                return Maybe.Just(symbol(MP_RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [27, 5]
                return Maybe.Just(symbol(MP_LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_10() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [28, 5]
                return Maybe.Just(symbol(MP_RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_11() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [29, 5]
                return Maybe.Just(symbol(MP_CARET));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_12() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [30, 5]
                return Maybe.Just(symbol(MP_STAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_13() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [31, 5]
                return Maybe.Just(symbol(MP_PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_14() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [32, 5]
                return Maybe.Just(symbol(MP_OPT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_15() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [33, 5]
                return Maybe.Just(symbol(MP_OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_16() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_17() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [37, 20]
                return Maybe.Just(symbol(MP_REGION, yytext().substring(1, yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_18() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [38, 14]
                return Maybe.Just(symbol(MP_SYM, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_19() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [42, 9]
                error("Unexpected character in meta-pattern: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_20() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_20()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
    private class CompClass_string extends ComponentInnerClass {
        
        public CompClass_string() {
        }
        
        private static final int YYINITIAL = string_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(STRING, "\"" + text + "\"", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_layout.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0051';
        }
        
        public Maybe<? extends Symbol> string_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [22, 9]
                /*just end string - %append will handle token*/
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [23, 18]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [24, 11]
                error("Invalid escape sequence: '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [25, 4]
                error("Incomplete escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [26, 18]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [29, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [30, 9]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
    private class CompClass_string_directive extends ComponentInnerClass {
        
        public CompClass_string_directive() {
        }
        
        private static final int YYINITIAL = string_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0053';
        }
        
        public Maybe<? extends Symbol> string_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_3()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string_directive.mlc [18, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string_directive.mlc [21, 9]
                error("Unexpected character in string list: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_8()");
            return Maybe.Nothing();
        }
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
        private final java.util.Set<Character> allOpenChars;
        private final java.util.List<Character> unclosedOpenChars; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Character, java.util.Set<Character>> pairMap, java.util.Set<Character> allOpenChars) {
            this.pairMap = pairMap;
            this.allOpenChars = allOpenChars;
            this.unclosedOpenChars = new java.util.ArrayList<Character>();
        }
        
        public static class Builder {
            private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
            private final java.util.Set<Character> allOpenChars;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Character, java.util.Set<Character>>();
                this.allOpenChars = new java.util.HashSet<Character>();
            }
            
            public Builder add(char open, char close) {
                allOpenChars.add(open);
                java.util.Set<Character> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Character>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenChars);
            }
        }
        
        public boolean test(char ch) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Character> correspondingOpens = pairMap.get(ch);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Character> it = unclosedOpenChars.iterator(); it.hasNext(); ) {
                    char open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenChars.contains(ch)) { //implies opening
                unclosedOpenChars.add(0, ch); //insert at beginning
            }
            return true;
        }
        
        public void reset() {
            unclosedOpenChars.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(ComponentInnerClass comp, PairFilter filter) {
            this.comp = comp;
            this.filter = filter;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    public static class Pipe extends java.io.Reader {
        private final java.util.concurrent.locks.Lock monitorLock = new java.util.concurrent.locks.ReentrantLock();
        private final java.util.Queue<java.util.concurrent.locks.Condition> waitingForFirstRead = new java.util.LinkedList<java.util.concurrent.locks.Condition>();
        private java.util.Map<Thread, java.util.concurrent.locks.Condition> waitingForSecondRead = new java.util.HashMap<Thread, java.util.concurrent.locks.Condition>();
        
        private final java.util.Queue<Character> writeQueue = new java.util.LinkedList<Character>();
        private final java.util.concurrent.locks.Condition notEmpty = monitorLock.newCondition();
        
        private boolean closed = false;
        private boolean eof = false;
        
        public void write(char ch) {
            write(ch, false);
        }
        
        //NB: combine write() with eof() because the last write() will block, making it hard to call eof()
        public void writeFinal(char ch) {
            write(ch, true);
        }
        
        private void write(char ch, boolean isFinal) {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot write after the read end has been closed.");
                }
                if(eof) {
                    throw new IllegalStateException("Cannot write after EOF.");
                }
                if(isFinal) {
                    eof = true;
                }
                writeQueue.add(ch);
                java.util.concurrent.locks.Condition cond = monitorLock.newCondition();
                waitingForFirstRead.add(cond);
                notEmpty.signalAll();
                cond.awaitUninterruptibly();
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        //NB: ignore length and always write 1 byte (unless at EOF)
        public int read(char[] buf, int offset, int length) throws java.io.IOException {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot read after the read end has been closed.");
                }
                boolean freedWriter = freeNextWriter();
                while(!eof && writeQueue.isEmpty()) {
                    notEmpty.awaitUninterruptibly();
                    if(!freedWriter) {
                        freedWriter = freeNextWriter();
                    }
                }
                if(eof && writeQueue.isEmpty()) {
                    //no writers waiting, so none to free
                    return -1;
                }
                waitingForSecondRead.put(Thread.currentThread(), waitingForFirstRead.poll());
                buf[offset] = writeQueue.poll();
                return 1;
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        public void close() throws java.io.IOException {
            monitorLock.lock();
            try {
                closed = true;
                freeAllWriters();
            } finally {
                monitorLock.unlock();
            }
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private boolean freeNextWriter() {
            java.util.concurrent.locks.Condition cond = waitingForSecondRead.get(Thread.currentThread());
            if(cond != null) {
                cond.signal();
                waitingForSecondRead.remove(Thread.currentThread());
                return true;
            }
            return false;
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private void freeAllWriters() {
            for(java.util.concurrent.locks.Condition cond : waitingForSecondRead.values()) {
                cond.signal();
            }
            waitingForSecondRead.clear();
            for(java.util.concurrent.locks.Condition cond : waitingForFirstRead) {
                cond.signal();
            }
            waitingForFirstRead.clear();
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isJust() {
            return !isNothing();
        }
        public abstract boolean isNothing();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isNothing() {
                return false;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isNothing() {
                return true;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

%{
    public void stop() {
        state_layout.stop();
    }
%}

//from null [32, 1]
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
//from null [65, 1]
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}


%xstate EXTRA_RETURN

//from test/backend-jflex/in/metalexer/base.mlc [1, 1]
%state base_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
%state bracket_comment_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
%state decl_region_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
%state identifier_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
%state inherited_header_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
%state init_region_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
%state layout_option_section_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
%state layout_rule_section_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
%state local_header_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
%state metapattern_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/string.mlc [1, 1]
%state string_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
%state string_directive_YYINITIAL_STATE

m_bracket_comment_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/bracket_comment.mlc [11, 1]
m_bracket_comment_CloseBracketComment = "*/" //from test/backend-jflex/in/metalexer/bracket_comment.mlc [12, 1]
m_decl_region_CloseDeclRegion = "%}" //from test/backend-jflex/in/metalexer/decl_region.mlc [11, 1]
m_identifier_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/identifier_directive.mlc [7, 1]
m_identifier_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [8, 1]
m_identifier_directive_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [10, 1]
m_identifier_directive_Digit = [0-9] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [11, 1]
m_identifier_directive_Identifier = {m_identifier_directive_Letter}(((_ | {m_identifier_directive_Letter}) | {m_identifier_directive_Digit}))* //from test/backend-jflex/in/metalexer/identifier_directive.mlc [12, 1]
m_identifier_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_identifier_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_inherited_header_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/inherited_header.mlc [15, 1]
m_init_region_CloseInitRegion = "%init}" //from test/backend-jflex/in/metalexer/init_region.mlc [11, 1]
m_layout_option_section_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/layout_option_section.mlc [7, 1]
m_layout_option_section_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/layout_option_section.mlc [8, 1]
m_layout_option_section_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/layout_option_section.mlc [10, 1]
m_layout_option_section_Digit = [0-9] //from test/backend-jflex/in/metalexer/layout_option_section.mlc [11, 1]
m_layout_option_section_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/layout_option_section.mlc [13, 1]
m_layout_option_section_OpenDeclRegion = "%{" //from test/backend-jflex/in/metalexer/layout_option_section.mlc [15, 1]
m_layout_option_section_OpenInitRegion = "%init{" //from test/backend-jflex/in/metalexer/layout_option_section.mlc [16, 1]
m_layout_option_section_DirectiveLookahead = (!(({m_layout_option_section_Letter} | {m_layout_option_section_Digit}) | _)) //from test/backend-jflex/in/metalexer/layout_option_section.mlc [19, 1]
m_layout_option_section_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_layout_option_section_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_layout_rule_section_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [7, 1]
m_layout_rule_section_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [8, 1]
m_layout_rule_section_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [10, 1]
m_layout_rule_section_Digit = [0-9] //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [11, 1]
m_layout_rule_section_DirectiveLookahead = (!(({m_layout_rule_section_Letter} | {m_layout_rule_section_Digit}) | _)) //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [14, 1]
m_layout_rule_section_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_layout_rule_section_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_local_header_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/local_header.mlc [10, 1]
m_metapattern_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [7, 1]
m_metapattern_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [8, 1]
m_metapattern_directive_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [10, 1]
m_metapattern_directive_Digit = [0-9] //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [11, 1]
m_metapattern_directive_Identifier = {m_metapattern_directive_Letter}(((_ | {m_metapattern_directive_Letter}) | {m_metapattern_directive_Digit}))* //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [12, 1]
m_metapattern_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_metapattern_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_string_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/string.mlc [11, 1]
m_string_Quote = \" //from test/backend-jflex/in/metalexer/string.mlc [13, 1]
m_string_Digit = [0-9] //from test/backend-jflex/in/metalexer/string.mlc [15, 1]
m_string_HexDigit = ({m_string_Digit} | [a-fA-F]) //from test/backend-jflex/in/metalexer/string.mlc [16, 1]
m_string_EscapeSequence = \\(((([nrtfb] | x({m_string_HexDigit}{2})) | u({m_string_HexDigit}{1, 4})) | ([0-3])?([0-7])?[0-7]) | [\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-]) //from test/backend-jflex/in/metalexer/string.mlc [18, 1]
m_string_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/string_directive.mlc [6, 1]
m_string_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/string_directive.mlc [7, 1]
m_string_directive_Quote = \" //from test/backend-jflex/in/metalexer/string_directive.mlc [9, 1]
m_string_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_string_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        //System.err.println("Reconsume char");
        yybegin(state_layout.getPrevState());
        return state_layout.getExtraReturn();
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/base.mlc [9, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_base.base_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/base.mlc [10, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_base.base_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [15, 1]
    {m_bracket_comment_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_layout.processMTok('\u0033'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [16, 1]
    {m_bracket_comment_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_2();
        //System.err.println("processMTok(END_BRACKET_COMMENT)");
        state_layout.processMTok('\u0034'); //END_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [19, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<decl_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/decl_region.mlc [14, 1]
    %{m_decl_region_CloseDeclRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_decl_region.decl_region_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/decl_region.mlc [15, 1]
    {m_decl_region_CloseDeclRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_decl_region.decl_region_action_2();
        //System.err.println("processMTok(END_DECL_REGION)");
        state_layout.processMTok('\u0036'); //END_DECL_REGION
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<decl_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/decl_region.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_decl_region.decl_region_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/decl_region.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_decl_region.decl_region_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_identifier_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_layout.processMTok('\u0033'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [18, 1]
    {m_identifier_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_2();
        //System.err.println("processMTok(END_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0038'); //END_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [19, 1]
    {m_identifier_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [20, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_identifier_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [22, 1]
    {m_identifier_directive_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [24, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [25, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_8();
        //System.err.println("processMTok(END_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0038'); //END_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<inherited_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [18, 1]
    {m_inherited_header_SectionSeparator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_inherited_header.inherited_header_action_1();
        //System.err.println("processMTok(END_INHERITED_HEADER)");
        state_layout.processMTok('\u0041'); //END_INHERITED_HEADER
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<inherited_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_inherited_header.inherited_header_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_inherited_header.inherited_header_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<init_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/init_region.mlc [14, 1]
    %{m_init_region_CloseInitRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_init_region.init_region_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/init_region.mlc [15, 1]
    {m_init_region_CloseInitRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_init_region.init_region_action_2();
        //System.err.println("processMTok(END_INIT_REGION)");
        state_layout.processMTok('\u0043'); //END_INIT_REGION
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<init_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/init_region.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_init_region.init_region_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/init_region.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_init_region.init_region_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_layout_option_section_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_layout.processMTok('\u0033'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [26, 1]
    {m_layout_option_section_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [27, 1]
    {m_layout_option_section_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [29, 1]
    {m_layout_option_section_OpenDeclRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_4();
        //System.err.println("processMTok(START_DECL_REGION)");
        state_layout.processMTok('\u0045'); //START_DECL_REGION
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [30, 1]
    {m_layout_option_section_OpenInitRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_5();
        //System.err.println("processMTok(START_INIT_REGION)");
        state_layout.processMTok('\u0046'); //START_INIT_REGION
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [33, 1]
    "%helper" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [36, 1]
    "%layout" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_7();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [37, 1]
    "%start" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_8();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [38, 1]
    "%component" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_9();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [41, 1]
    "%declare" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_10();
        //System.err.println("processMTok(START_STRING_DIRECTIVE)");
        state_layout.processMTok('\u0048'); //START_STRING_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [42, 1]
    "%option" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_11();
        //System.err.println("processMTok(START_STRING_DIRECTIVE)");
        state_layout.processMTok('\u0048'); //START_STRING_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [43, 1]
    "%initthrow" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_12();
        //System.err.println("processMTok(START_STRING_DIRECTIVE)");
        state_layout.processMTok('\u0048'); //START_STRING_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [44, 1]
    "%lexthrow" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_13();
        //System.err.println("processMTok(START_STRING_DIRECTIVE)");
        state_layout.processMTok('\u0048'); //START_STRING_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [47, 1]
    "%" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [50, 1]
    {m_layout_option_section_SectionSeparator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_15();
        //System.err.println("processMTok(END_OPTION_SECTION)");
        state_layout.processMTok('\u0049'); //END_OPTION_SECTION
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_layout_option_section_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [56, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [57, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_18();
        //System.err.println("processMTok(END_OPTION_SECTION)");
        state_layout.processMTok('\u0049'); //END_OPTION_SECTION
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_layout_rule_section_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_layout.processMTok('\u0033'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [21, 1]
    {m_layout_rule_section_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [22, 1]
    {m_layout_rule_section_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [24, 1]
    "%%embed" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [26, 1]
    "%unembed" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_5();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [27, 1]
    "%replace" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_6();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [28, 1]
    "%unoption" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_7();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [30, 1]
    "%name" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_8();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [31, 1]
    "%host" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_9();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [32, 1]
    "%guest" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_10();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [33, 1]
    "%pair" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_11();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [35, 1]
    "%start" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_12();
        //System.err.println("processMTok(START_METAPATTERN_DIRECTIVE)");
        state_layout.processMTok('\u004b'); //START_METAPATTERN_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [36, 1]
    "%end" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_13();
        //System.err.println("processMTok(START_METAPATTERN_DIRECTIVE)");
        state_layout.processMTok('\u004b'); //START_METAPATTERN_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [38, 1]
    "%%inherit" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_14();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [39, 1]
    "%delete" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_15();
        //System.err.println("processMTok(START_IDENTIFIER_DIRECTIVE)");
        state_layout.processMTok('\u0047'); //START_IDENTIFIER_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_layout_rule_section_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [44, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [45, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_18();
        //System.err.println("processMTok(END_RULE_SECTION)");
        state_layout.processMTok('\u004c'); //END_RULE_SECTION
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<local_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/local_header.mlc [13, 1]
    {m_local_header_SectionSeparator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_local_header.local_header_action_1();
        //System.err.println("processMTok(END_LOCAL_HEADER)");
        state_layout.processMTok('\u004e'); //END_LOCAL_HEADER
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<local_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/local_header.mlc [16, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_local_header.local_header_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/local_header.mlc [17, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_local_header.local_header_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metapattern_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_metapattern_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_layout.processMTok('\u0033'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [18, 1]
    {m_metapattern_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_2();
        //System.err.println("processMTok(END_METAPATTERN_DIRECTIVE)");
        state_layout.processMTok('\u0050'); //END_METAPATTERN_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [19, 1]
    {m_metapattern_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [21, 1]
    "<ANY>" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [22, 1]
    "<BOF>" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [23, 1]
    "<EOF>" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [25, 1]
    "(" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [26, 1]
    ")" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [27, 1]
    "[" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [28, 1]
    "]" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [29, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [30, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [31, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [32, 1]
    "?" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [33, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metapattern_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_metapattern_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [37, 1]
    "%"{m_metapattern_directive_Identifier}"%" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [38, 1]
    {m_metapattern_directive_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metapattern_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [42, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [43, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_20();
        //System.err.println("processMTok(END_METAPATTERN_DIRECTIVE)");
        state_layout.processMTok('\u0050'); //END_METAPATTERN_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string.mlc [22, 1]
    {m_string_Quote} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_1();
        //System.err.println("processMTok(END_STRING)");
        state_layout.processMTok('\u0052'); //END_STRING
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [23, 1]
    {m_string_EscapeSequence} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [24, 1]
    \\[^\r\n] {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [25, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [26, 1]
    {m_string_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string.mlc [29, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [30, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_string_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_layout.processMTok('\u0033'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [15, 1]
    {m_string_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_2();
        //System.err.println("processMTok(END_STRING_DIRECTIVE)");
        state_layout.processMTok('\u0054'); //END_STRING_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [16, 1]
    {m_string_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [17, 1]
    {m_string_directive_Quote} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_4();
        //System.err.println("processMTok(START_STRING)");
        state_layout.processMTok('\u0055'); //START_STRING
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [18, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_string_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string_directive.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_8();
        //System.err.println("processMTok(END_STRING_DIRECTIVE)");
        state_layout.processMTok('\u0054'); //END_STRING_DIRECTIVE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


