package test.jflex.natlab.attributed;
import static test.jflex.natlab.attributed.AttributeParser.Terminals.*;
import test.jflex.natlab.*;
import static test.jflex.natlab.NatlabParser.Terminals.*;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Scanner; //from null [10, 1]
import beaver.Scanner; //from null [10, 1]
import beaver.Scanner; //from null [10, 1]
%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/natlab/attributed_natlab.mll [8, 1]
%class AttributedNatlabScanner
//from test/backend-jflex/in/natlab/attributed_natlab.mll [9, 1]
%function nextToken
//from test/backend-jflex/in/natlab/helper_beaver.mll [9, 1]
%public
//from test/backend-jflex/in/natlab/helper_beaver.mll [10, 1]
%final
//from test/backend-jflex/in/natlab/helper_beaver.mll [13, 1]
%extends Scanner
//from test/backend-jflex/in/natlab/helper_beaver.mll [14, 1]
%unicode
//from test/backend-jflex/in/natlab/helper_beaver.mll [17, 1]
%line
//from test/backend-jflex/in/natlab/helper_beaver.mll [18, 1]
%column
//from test/backend-jflex/in/natlab/helper_beaver.mll [20, 1]
%type Symbol
//from null [22, 1]
%yylexthrow Scanner.Exception

%{
    private final StateClass_attributed_natlab state_attributed_natlab = new StateClass_attributed_natlab();
%}

%{
    private class StateClass_attributed_natlab {
        private StateClass_attributed_natlab() {
            metaLexerThread.start();
            
            //from test/backend-jflex/in/natlab/natlab.mll [55, 1]
            embeddingRecordArray[/*leading_ws*/ 0] = new EmbeddingRecord(inst_leading_ws, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [72, 1]
            embeddingRecordArray[/*class_brackets*/ 1] = new EmbeddingRecord(inst_class_bracketed, new PairFilter.Builder().add(/*START_BRACKETED*/ '\u0039', /*END_BRACKETED*/ '\u0032').build());
            //from test/backend-jflex/in/natlab/natlab.mll [82, 1]
            embeddingRecordArray[/*field_name*/ 2] = new EmbeddingRecord(inst_field_name, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [91, 1]
            embeddingRecordArray[/*transpose*/ 3] = new EmbeddingRecord(inst_transpose, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [100, 1]
            embeddingRecordArray[/*string*/ 4] = new EmbeddingRecord(inst_string, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [109, 1]
            embeddingRecordArray[/*comma_terminator*/ 5] = new EmbeddingRecord(inst_comma_terminator, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [116, 1]
            embeddingRecordArray[/*semicolon_terminator*/ 6] = new EmbeddingRecord(inst_semicolon_terminator, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
            embeddingRecordArray[/*bracket_comment*/ 7] = new EmbeddingRecord(inst_bracket_comment, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
            embeddingRecordArray[/*bracket_help_comment*/ 8] = new EmbeddingRecord(inst_bracket_help_comment, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/attributed_natlab.mll [22, 1]
            embeddingRecordArray[/*class*/ 9] = new EmbeddingRecord(inst_attributed_class, new PairFilter.Builder().add(/*OPEN_END*/ '\u0045', /*END*/ '\u0044').add(/*PROPERTIES*/ '\u0049', /*END*/ '\u0044').add(/*METHODS*/ '\u004a', /*END*/ '\u0044').add(/*EVENTS*/ '\u004b', /*END*/ '\u0044').build());
            //from test/backend-jflex/in/natlab/attributed_natlab.mll [33, 1]
            embeddingRecordArray[/*class_attributes*/ 10] = new EmbeddingRecord(inst_attributes, PairFilter.EMPTY);
            
            //from test/backend-jflex/in/natlab/attributed_natlab.mll [13, 8]
            yybegin(base_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(inst_base, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            startEmbedding(/*leading_ws*/ 0); 
            
            restartAppendBuf();
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[11];
        private final CompClass_attributes inst_attributes = new CompClass_attributes();
        private final CompClass_leading_ws inst_leading_ws = new CompClass_leading_ws();
        private final CompClass_base inst_base = new CompClass_base();
        private final CompClass_attributed_class inst_attributed_class = new CompClass_attributed_class();
        private final CompClass_class_bracketed inst_class_bracketed = new CompClass_class_bracketed();
        private final CompClass_field_name inst_field_name = new CompClass_field_name();
        private final CompClass_comma_terminator inst_comma_terminator = new CompClass_comma_terminator();
        private final CompClass_semicolon_terminator inst_semicolon_terminator = new CompClass_semicolon_terminator();
        private final CompClass_string inst_string = new CompClass_string();
        private final CompClass_transpose inst_transpose = new CompClass_transpose();
        private final CompClass_bracket_comment inst_bracket_comment = new CompClass_bracket_comment();
        private final CompClass_bracket_help_comment inst_bracket_help_comment = new CompClass_bracket_help_comment();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private void append(String text) {
            appendBuf.append(text);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            //System.err.println("yypushback(1)");
            yypushback(1); //to ensure that at least one char is available
            yybegin(EXTRA_RETURN);
        }
        
        private boolean stopped = false;
        
        public void stop() {
            stopped = true;
            pipe.writeFinal('\n');
            boolean joined = false;
            while(!joined) {
                try {
                    metaLexerThread.join();
                    joined = true;
                } catch(InterruptedException e) {}
            }
        }
        
        private final Pipe pipe = new Pipe();
        private final AttributedNatlabScanner_Meta metalexer = new AttributedNatlabScanner_Meta(pipe);
        private final Thread metaLexerThread = new Thread(new Runnable() {
            public void run() {
                try {
                    metalexer.start();
                } catch(java.io.IOException e) {
                    //unrecoverable
                    e.printStackTrace();
                }
            }}, "MetaLexerThread");
        
        private Integer sendMTok(char mtok) {
            if(stopped) {
                throw new IllegalStateException("No meta-tokens may be sent after stop() has been called.");
            }
            //System.err.println("sendMTok(" + Integer.toHexString(mtok) + ")");
            pipe.write(mtok);
            return metalexer.checkForTransition();
        }
        
        public void processMTok(char mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                //System.err.println("Pair filter caught: " + Integer.toHexString(mtok));
                return; //don't send character if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            Integer nextEmbeddingNum = sendMTok(mtok);
            while(nextEmbeddingNum != null) {
                boolean endOfEmbedding = nextEmbeddingNum < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    startEmbedding(nextEmbeddingNum);
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                nextEmbeddingNum = endOfEmbedding ? sendMTok(currComp.getCharValue()) : null;
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract char getCharValue();
    }
%}

%{
    //from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
    private class CompClass_attributes extends ComponentInnerClass {
        
        public CompClass_attributes() {
        }
        
        private static final int YYINITIAL = attributes_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0030';
        }
        
        public Maybe<? extends Symbol> attributes_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [7, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [9, 7]
                return Maybe.Just(symbol(ATTR1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [10, 7]
                return Maybe.Just(symbol(ATTR2));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [12, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [14, 6]
                return Maybe.Just(symbol(VAL1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [15, 6]
                return Maybe.Just(symbol(VAL2));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [17, 5]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
    private class CompClass_leading_ws extends ComponentInnerClass {
        
        public CompClass_leading_ws() {
        }
        
        private static final int YYINITIAL = leading_ws_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0033';
        }
        
        public Maybe<? extends Symbol> leading_ws_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> leading_ws_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> leading_ws_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/leading_ws.mlc [10, 9]
                yypushback(1);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> leading_ws_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_4()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/base.mlc [1, 1]
    private class CompClass_base extends ComponentInnerClass {
        //from null [12, 1]
        //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }

        
        public CompClass_base() {
        }
        
        private static final int YYINITIAL = base_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/base.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/base.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0035';
        }
        
        public Maybe<? extends Symbol> base_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_9() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_10() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 4]
                return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_11() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 4]
                return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_12() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_13() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_14() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_15() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_16() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_17() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_18() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_19() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_20() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_21() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_22() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_23() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_24() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_25() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_26() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_27() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_28() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_29() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_30() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_31() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_32() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_33() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_34() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_35() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_36() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_37() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_38() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_39() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [8, 10]
                return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_40() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [9, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_41() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 6]
                return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_42() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 5]
                return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_43() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 10]
                return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_44() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 4]
                return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_45() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 8]
                return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_46() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 8]
                return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_47() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 5]
                return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_48() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 7]
                return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_49() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_50() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_51() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_52() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_53() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_54() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_55() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_56() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_57() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_58() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_59() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_60() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_61() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_62() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 25]
                commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_63() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_64() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_65() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_66() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_67() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_68() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_69() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_70() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_71() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [14, 9]
                error("Illegal character '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_72() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [15, 9]
                return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
    private class CompClass_attributed_class extends ComponentInnerClass {
        //from null [12, 1]
        //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }

        
        public CompClass_attributed_class() {
        }
        
        private static final int YYINITIAL = attributed_class_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0048';
        }
        
        public Maybe<? extends Symbol> attributed_class_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_9() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_10() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 4]
                return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_11() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 4]
                return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_12() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_13() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_14() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_15() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_16() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_17() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_18() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_19() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_20() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_21() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_22() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_23() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_24() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_25() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_26() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_27() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_28() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_29() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_30() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_31() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_32() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_33() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_34() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_35() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_36() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_37() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_38() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_39() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [11, 10]
                return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_40() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [12, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_41() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 6]
                return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_42() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 5]
                return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_43() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 10]
                return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_44() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 4]
                return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_45() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 8]
                return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_46() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 8]
                return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_47() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 5]
                return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_48() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 7]
                return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_49() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_50() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_51() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_52() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_53() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_54() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_55() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_56() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_57() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_58() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_59() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_60() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributed_class.mlc [9, 12]
                return Maybe.Just(symbol(PROPERTIES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_61() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributed_class.mlc [10, 9]
                return Maybe.Just(symbol(METHODS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_62() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributed_class.mlc [11, 8]
                return Maybe.Just(symbol(EVENTS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_63() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_64() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_65() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 25]
                commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_66() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_67() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_68() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_69() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_70() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_71() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_72() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_73() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_73()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_74() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_74()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [21, 9]
                error("Illegal character in classdef '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_75() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_75()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [22, 9]
                return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
    private class CompClass_class_bracketed extends ComponentInnerClass {
        //from null [12, 1]
        //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }

        
        public CompClass_class_bracketed() {
        }
        
        private static final int YYINITIAL = class_bracketed_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u004c';
        }
        
        public Maybe<? extends Symbol> class_bracketed_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_9() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_10() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 4]
                return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_11() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 4]
                return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_12() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_13() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_14() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_15() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_16() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_17() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_18() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_19() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_20() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_21() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_22() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_23() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_24() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_25() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_26() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_27() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_28() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_29() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_30() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_31() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_32() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_33() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_34() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_35() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_36() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_37() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_38() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_39() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [11, 10]
                return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_40() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [12, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_41() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [14, 12]
                return Maybe.Just(symbol(PROPERTIES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_42() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [15, 9]
                return Maybe.Just(symbol(METHODS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_43() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [16, 8]
                return Maybe.Just(symbol(EVENTS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_44() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 6]
                return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_45() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 5]
                return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_46() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 10]
                return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_47() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 4]
                return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_48() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 8]
                return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_49() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 8]
                return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_50() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 5]
                return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_51() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 7]
                return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_52() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_53() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_54() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_55() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_56() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_57() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_58() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_59() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_60() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_61() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_62() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_63() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_64() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_65() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 25]
                commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_66() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_67() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_68() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_69() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_70() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_71() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_72() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_73() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_73()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_74() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_74()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [21, 9]
                error("Illegal character in classdef '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_75() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_75()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [22, 9]
                error("Unclosed brackets in class");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
    private class CompClass_field_name extends ComponentInnerClass {
        
        public CompClass_field_name() {
        }
        
        private static final int YYINITIAL = field_name_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u004d';
        }
        
        public Maybe<? extends Symbol> field_name_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/field_name.mlc [12, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/field_name.mlc [16, 9]
                yypushback(1);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_7()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
    private class CompClass_comma_terminator extends ComponentInnerClass {
        
        public CompClass_comma_terminator() {
        }
        
        private static final int YYINITIAL = comma_terminator_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u004f';
        }
        
        public Maybe<? extends Symbol> comma_terminator_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [12, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [13, 18]
                return Maybe.Just(symbol(COMMA_LINE_TERMINATOR, null, storedLine + 1, storedCol + 1, yyline + 1, yycolumn + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [18, 9]
                yypushback(1); return Maybe.Just(symbol(COMMA, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [19, 9]
                return Maybe.Just(symbol(COMMA, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
    private class CompClass_semicolon_terminator extends ComponentInnerClass {
        
        public CompClass_semicolon_terminator() {
        }
        
        private static final int YYINITIAL = semicolon_terminator_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0051';
        }
        
        public Maybe<? extends Symbol> semicolon_terminator_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [12, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [13, 18]
                return Maybe.Just(symbol(SEMICOLON_LINE_TERMINATOR, null, storedLine + 1, storedCol + 1, yyline + 1, yycolumn + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [18, 9]
                yypushback(1); return Maybe.Just(symbol(SEMICOLON, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [19, 9]
                return Maybe.Just(symbol(SEMICOLON, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/string.mlc [1, 1]
    private class CompClass_string extends ComponentInnerClass {
        
        public CompClass_string() {
        }
        
        private static final int YYINITIAL = string_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/string.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    return Maybe.Just(symbol(STRING, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_attributed_natlab.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/string.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0053';
        }
        
        public Maybe<? extends Symbol> string_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [13, 6]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [14, 5]
                /*just end string - %append will handle token*/
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [15, 15]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [16, 4]
                error("Invalid escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [17, 18]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [20, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [21, 9]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
    private class CompClass_transpose extends ComponentInnerClass {
        
        public CompClass_transpose() {
        }
        
        private static final int YYINITIAL = transpose_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0055';
        }
        
        public Maybe<? extends Symbol> transpose_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_transpose.transpose_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/transpose.mlc [7, 5]
                return Maybe.Just(symbol(MTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> transpose_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_transpose.transpose_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/transpose.mlc [10, 9]
                yypushback(1);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> transpose_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_transpose.transpose_action_3()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
    private class CompClass_bracket_comment extends ComponentInnerClass {
        
        public CompClass_bracket_comment() {
        }
        
        private static final int YYINITIAL = bracket_comment_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [7, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    commentBuffer.pushComment(symbol(BRACKET_COMMENT, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_attributed_natlab.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0057';
        }
        
        public Maybe<? extends Symbol> bracket_comment_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [14, 22]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [15, 23]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [19, 9]
                error("Unterminated bracket comment");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
    private class CompClass_bracket_help_comment extends ComponentInnerClass {
        
        public CompClass_bracket_help_comment() {
        }
        
        private static final int YYINITIAL = bracket_help_comment_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [7, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(BRACKET_HELP_COMMENT, "%%{" + text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public void append(String text) {
            state_attributed_natlab.append(text);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0059';
        }
        
        public Maybe<? extends Symbol> bracket_help_comment_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [15, 22]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_help_comment_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [16, 23]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_help_comment_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [19, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_help_comment_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [20, 9]
                error("Unterminated bracket help comment");
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
        private final java.util.Set<Character> allOpenChars;
        private final java.util.List<Character> unclosedOpenChars; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Character, java.util.Set<Character>> pairMap, java.util.Set<Character> allOpenChars) {
            this.pairMap = pairMap;
            this.allOpenChars = allOpenChars;
            this.unclosedOpenChars = new java.util.ArrayList<Character>();
        }
        
        public static class Builder {
            private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
            private final java.util.Set<Character> allOpenChars;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Character, java.util.Set<Character>>();
                this.allOpenChars = new java.util.HashSet<Character>();
            }
            
            public Builder add(char open, char close) {
                allOpenChars.add(open);
                java.util.Set<Character> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Character>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenChars);
            }
        }
        
        public boolean test(char ch) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Character> correspondingOpens = pairMap.get(ch);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Character> it = unclosedOpenChars.iterator(); it.hasNext(); ) {
                    char open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenChars.contains(ch)) { //implies opening
                unclosedOpenChars.add(0, ch); //insert at beginning
            }
            return true;
        }
        
        public void reset() {
            unclosedOpenChars.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(ComponentInnerClass comp, PairFilter filter) {
            this.comp = comp;
            this.filter = filter;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    public static class Pipe extends java.io.Reader {
        private final java.util.concurrent.locks.Lock monitorLock = new java.util.concurrent.locks.ReentrantLock();
        private final java.util.Queue<java.util.concurrent.locks.Condition> waitingForFirstRead = new java.util.LinkedList<java.util.concurrent.locks.Condition>();
        private java.util.Map<Thread, java.util.concurrent.locks.Condition> waitingForSecondRead = new java.util.HashMap<Thread, java.util.concurrent.locks.Condition>();
        
        private final java.util.Queue<Character> writeQueue = new java.util.LinkedList<Character>();
        private final java.util.concurrent.locks.Condition notEmpty = monitorLock.newCondition();
        
        private boolean closed = false;
        private boolean eof = false;
        
        public void write(char ch) {
            write(ch, false);
        }
        
        //NB: combine write() with eof() because the last write() will block, making it hard to call eof()
        public void writeFinal(char ch) {
            write(ch, true);
        }
        
        private void write(char ch, boolean isFinal) {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot write after the read end has been closed.");
                }
                if(eof) {
                    throw new IllegalStateException("Cannot write after EOF.");
                }
                if(isFinal) {
                    eof = true;
                }
                writeQueue.add(ch);
                java.util.concurrent.locks.Condition cond = monitorLock.newCondition();
                waitingForFirstRead.add(cond);
                notEmpty.signalAll();
                cond.awaitUninterruptibly();
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        //NB: ignore length and always write 1 byte (unless at EOF)
        public int read(char[] buf, int offset, int length) throws java.io.IOException {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot read after the read end has been closed.");
                }
                boolean freedWriter = freeNextWriter();
                while(!eof && writeQueue.isEmpty()) {
                    notEmpty.awaitUninterruptibly();
                    if(!freedWriter) {
                        freedWriter = freeNextWriter();
                    }
                }
                if(eof && writeQueue.isEmpty()) {
                    //no writers waiting, so none to free
                    return -1;
                }
                waitingForSecondRead.put(Thread.currentThread(), waitingForFirstRead.poll());
                buf[offset] = writeQueue.poll();
                return 1;
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        public void close() throws java.io.IOException {
            monitorLock.lock();
            try {
                closed = true;
                freeAllWriters();
            } finally {
                monitorLock.unlock();
            }
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private boolean freeNextWriter() {
            java.util.concurrent.locks.Condition cond = waitingForSecondRead.get(Thread.currentThread());
            if(cond != null) {
                cond.signal();
                waitingForSecondRead.remove(Thread.currentThread());
                return true;
            }
            return false;
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private void freeAllWriters() {
            for(java.util.concurrent.locks.Condition cond : waitingForSecondRead.values()) {
                cond.signal();
            }
            waitingForSecondRead.clear();
            for(java.util.concurrent.locks.Condition cond : waitingForFirstRead) {
                cond.signal();
            }
            waitingForFirstRead.clear();
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isJust() {
            return !isNothing();
        }
        public abstract boolean isNothing();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isNothing() {
                return false;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isNothing() {
                return true;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

%{
    public void stop() {
        state_attributed_natlab.stop();
    }
%}

//from null [12, 1]
%{//// Comment queue ///////////////////////////////////////////////////////////
  
  //put comments in the buffer rather than returning them
  //NB: must be non-null before scanning starts
  private CommentBuffer commentBuffer = null;
  
  public void setCommentBuffer(CommentBuffer commentBuffer) {
      this.commentBuffer = commentBuffer;
  }
  
  public CommentBuffer getCommentBuffer() {
      return commentBuffer;
  }
%}
//from null [29, 1]
%{//// Position info for commas and semicolons /////////////////////////////////
  
  private int storedLine = -1;
  private int storedCol = -1;
%}
//from null [10, 1]
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
//from null [9, 1]
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}


%xstate EXTRA_RETURN

//from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
%state attributes_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
%state leading_ws_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/base.mlc [1, 1]
%state base_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
%state attributed_class_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
%state class_bracketed_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
%state field_name_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
%state comma_terminator_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
%state semicolon_terminator_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/string.mlc [1, 1]
%state string_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
%state transpose_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
%state bracket_comment_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
%state bracket_help_comment_YYINITIAL_STATE

m_leading_ws_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_leading_ws_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_leading_ws_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_leading_ws_EscapedLineTerminator = {m_leading_ws_Ellipsis}(.)*{m_leading_ws_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_leading_ws_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_leading_ws_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_leading_ws_HexDigit = ({m_leading_ws_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_leading_ws_Identifier = ([_$] | {m_leading_ws_Letter})((([_$] | {m_leading_ws_Letter}) | {m_leading_ws_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_leading_ws_SciExp = [Ee]([+\-])?({m_leading_ws_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_leading_ws_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_leading_ws_IntNumber = ({m_leading_ws_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_leading_ws_FPNumber = (({m_leading_ws_Digit})+(\.)?({m_leading_ws_Digit})* | (\.)?({m_leading_ws_Digit})+)({m_leading_ws_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_leading_ws_HexNumber = 0[xX]({m_leading_ws_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_leading_ws_ImaginaryIntNumber = ({m_leading_ws_Digit})+{m_leading_ws_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_leading_ws_ImaginaryFPNumber = (({m_leading_ws_Digit})+(\.)?({m_leading_ws_Digit})* | (\.)?({m_leading_ws_Digit})+)({m_leading_ws_SciExp})?{m_leading_ws_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_leading_ws_ImaginaryHexNumber = 0[xX]({m_leading_ws_HexDigit})+{m_leading_ws_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_leading_ws_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_leading_ws_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_leading_ws_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_leading_ws_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_leading_ws_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_leading_ws_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_leading_ws_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_base_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_base_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_base_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_base_EscapedLineTerminator = {m_base_Ellipsis}(.)*{m_base_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_base_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_base_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_base_HexDigit = ({m_base_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_base_Identifier = ([_$] | {m_base_Letter})((([_$] | {m_base_Letter}) | {m_base_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_base_SciExp = [Ee]([+\-])?({m_base_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_base_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_base_IntNumber = ({m_base_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_base_FPNumber = (({m_base_Digit})+(\.)?({m_base_Digit})* | (\.)?({m_base_Digit})+)({m_base_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_base_HexNumber = 0[xX]({m_base_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_base_ImaginaryIntNumber = ({m_base_Digit})+{m_base_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_base_ImaginaryFPNumber = (({m_base_Digit})+(\.)?({m_base_Digit})* | (\.)?({m_base_Digit})+)({m_base_SciExp})?{m_base_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_base_ImaginaryHexNumber = 0[xX]({m_base_HexDigit})+{m_base_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_base_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_base_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_base_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_base_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_base_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_base_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_base_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_attributed_class_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_attributed_class_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_attributed_class_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_attributed_class_EscapedLineTerminator = {m_attributed_class_Ellipsis}(.)*{m_attributed_class_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_attributed_class_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_attributed_class_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_attributed_class_HexDigit = ({m_attributed_class_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_attributed_class_Identifier = ([_$] | {m_attributed_class_Letter})((([_$] | {m_attributed_class_Letter}) | {m_attributed_class_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_attributed_class_SciExp = [Ee]([+\-])?({m_attributed_class_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_attributed_class_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_attributed_class_IntNumber = ({m_attributed_class_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_attributed_class_FPNumber = (({m_attributed_class_Digit})+(\.)?({m_attributed_class_Digit})* | (\.)?({m_attributed_class_Digit})+)({m_attributed_class_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_attributed_class_HexNumber = 0[xX]({m_attributed_class_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_attributed_class_ImaginaryIntNumber = ({m_attributed_class_Digit})+{m_attributed_class_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_attributed_class_ImaginaryFPNumber = (({m_attributed_class_Digit})+(\.)?({m_attributed_class_Digit})* | (\.)?({m_attributed_class_Digit})+)({m_attributed_class_SciExp})?{m_attributed_class_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_attributed_class_ImaginaryHexNumber = 0[xX]({m_attributed_class_HexDigit})+{m_attributed_class_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_attributed_class_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_attributed_class_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_attributed_class_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_attributed_class_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_attributed_class_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_attributed_class_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_attributed_class_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_class_bracketed_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_class_bracketed_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_class_bracketed_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_class_bracketed_EscapedLineTerminator = {m_class_bracketed_Ellipsis}(.)*{m_class_bracketed_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_class_bracketed_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_class_bracketed_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_class_bracketed_HexDigit = ({m_class_bracketed_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_class_bracketed_Identifier = ([_$] | {m_class_bracketed_Letter})((([_$] | {m_class_bracketed_Letter}) | {m_class_bracketed_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_class_bracketed_SciExp = [Ee]([+\-])?({m_class_bracketed_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_class_bracketed_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_class_bracketed_IntNumber = ({m_class_bracketed_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_class_bracketed_FPNumber = (({m_class_bracketed_Digit})+(\.)?({m_class_bracketed_Digit})* | (\.)?({m_class_bracketed_Digit})+)({m_class_bracketed_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_class_bracketed_HexNumber = 0[xX]({m_class_bracketed_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_class_bracketed_ImaginaryIntNumber = ({m_class_bracketed_Digit})+{m_class_bracketed_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_class_bracketed_ImaginaryFPNumber = (({m_class_bracketed_Digit})+(\.)?({m_class_bracketed_Digit})* | (\.)?({m_class_bracketed_Digit})+)({m_class_bracketed_SciExp})?{m_class_bracketed_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_class_bracketed_ImaginaryHexNumber = 0[xX]({m_class_bracketed_HexDigit})+{m_class_bracketed_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_class_bracketed_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_class_bracketed_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_class_bracketed_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_class_bracketed_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_class_bracketed_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_class_bracketed_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_class_bracketed_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_field_name_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_field_name_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_field_name_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_field_name_EscapedLineTerminator = {m_field_name_Ellipsis}(.)*{m_field_name_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_field_name_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_field_name_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_field_name_HexDigit = ({m_field_name_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_field_name_Identifier = ([_$] | {m_field_name_Letter})((([_$] | {m_field_name_Letter}) | {m_field_name_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_field_name_SciExp = [Ee]([+\-])?({m_field_name_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_field_name_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_field_name_IntNumber = ({m_field_name_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_field_name_FPNumber = (({m_field_name_Digit})+(\.)?({m_field_name_Digit})* | (\.)?({m_field_name_Digit})+)({m_field_name_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_field_name_HexNumber = 0[xX]({m_field_name_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_field_name_ImaginaryIntNumber = ({m_field_name_Digit})+{m_field_name_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_field_name_ImaginaryFPNumber = (({m_field_name_Digit})+(\.)?({m_field_name_Digit})* | (\.)?({m_field_name_Digit})+)({m_field_name_SciExp})?{m_field_name_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_field_name_ImaginaryHexNumber = 0[xX]({m_field_name_HexDigit})+{m_field_name_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_field_name_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_field_name_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_field_name_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_field_name_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_field_name_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_field_name_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_field_name_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_comma_terminator_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_comma_terminator_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_comma_terminator_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_comma_terminator_EscapedLineTerminator = {m_comma_terminator_Ellipsis}(.)*{m_comma_terminator_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_comma_terminator_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_comma_terminator_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_comma_terminator_HexDigit = ({m_comma_terminator_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_comma_terminator_Identifier = ([_$] | {m_comma_terminator_Letter})((([_$] | {m_comma_terminator_Letter}) | {m_comma_terminator_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_comma_terminator_SciExp = [Ee]([+\-])?({m_comma_terminator_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_comma_terminator_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_comma_terminator_IntNumber = ({m_comma_terminator_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_comma_terminator_FPNumber = (({m_comma_terminator_Digit})+(\.)?({m_comma_terminator_Digit})* | (\.)?({m_comma_terminator_Digit})+)({m_comma_terminator_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_comma_terminator_HexNumber = 0[xX]({m_comma_terminator_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_comma_terminator_ImaginaryIntNumber = ({m_comma_terminator_Digit})+{m_comma_terminator_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_comma_terminator_ImaginaryFPNumber = (({m_comma_terminator_Digit})+(\.)?({m_comma_terminator_Digit})* | (\.)?({m_comma_terminator_Digit})+)({m_comma_terminator_SciExp})?{m_comma_terminator_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_comma_terminator_ImaginaryHexNumber = 0[xX]({m_comma_terminator_HexDigit})+{m_comma_terminator_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_comma_terminator_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_comma_terminator_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_comma_terminator_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_comma_terminator_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_comma_terminator_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_comma_terminator_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_comma_terminator_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_semicolon_terminator_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_semicolon_terminator_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_semicolon_terminator_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_semicolon_terminator_EscapedLineTerminator = {m_semicolon_terminator_Ellipsis}(.)*{m_semicolon_terminator_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_semicolon_terminator_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_semicolon_terminator_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_semicolon_terminator_HexDigit = ({m_semicolon_terminator_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_semicolon_terminator_Identifier = ([_$] | {m_semicolon_terminator_Letter})((([_$] | {m_semicolon_terminator_Letter}) | {m_semicolon_terminator_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_semicolon_terminator_SciExp = [Ee]([+\-])?({m_semicolon_terminator_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_semicolon_terminator_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_semicolon_terminator_IntNumber = ({m_semicolon_terminator_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_semicolon_terminator_FPNumber = (({m_semicolon_terminator_Digit})+(\.)?({m_semicolon_terminator_Digit})* | (\.)?({m_semicolon_terminator_Digit})+)({m_semicolon_terminator_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_semicolon_terminator_HexNumber = 0[xX]({m_semicolon_terminator_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_semicolon_terminator_ImaginaryIntNumber = ({m_semicolon_terminator_Digit})+{m_semicolon_terminator_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_semicolon_terminator_ImaginaryFPNumber = (({m_semicolon_terminator_Digit})+(\.)?({m_semicolon_terminator_Digit})* | (\.)?({m_semicolon_terminator_Digit})+)({m_semicolon_terminator_SciExp})?{m_semicolon_terminator_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_semicolon_terminator_ImaginaryHexNumber = 0[xX]({m_semicolon_terminator_HexDigit})+{m_semicolon_terminator_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_semicolon_terminator_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_semicolon_terminator_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_semicolon_terminator_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_semicolon_terminator_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_semicolon_terminator_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_semicolon_terminator_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_semicolon_terminator_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_string_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_string_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_string_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_string_EscapedLineTerminator = {m_string_Ellipsis}(.)*{m_string_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_string_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_string_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_string_HexDigit = ({m_string_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_string_Identifier = ([_$] | {m_string_Letter})((([_$] | {m_string_Letter}) | {m_string_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_string_SciExp = [Ee]([+\-])?({m_string_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_string_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_string_IntNumber = ({m_string_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_string_FPNumber = (({m_string_Digit})+(\.)?({m_string_Digit})* | (\.)?({m_string_Digit})+)({m_string_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_string_HexNumber = 0[xX]({m_string_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_string_ImaginaryIntNumber = ({m_string_Digit})+{m_string_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_string_ImaginaryFPNumber = (({m_string_Digit})+(\.)?({m_string_Digit})* | (\.)?({m_string_Digit})+)({m_string_SciExp})?{m_string_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_string_ImaginaryHexNumber = 0[xX]({m_string_HexDigit})+{m_string_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_string_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_string_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_string_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_string_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_string_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_string_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_string_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_bracket_comment_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_bracket_comment_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_bracket_comment_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_bracket_comment_EscapedLineTerminator = {m_bracket_comment_Ellipsis}(.)*{m_bracket_comment_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_bracket_comment_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_bracket_comment_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_bracket_comment_HexDigit = ({m_bracket_comment_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_bracket_comment_Identifier = ([_$] | {m_bracket_comment_Letter})((([_$] | {m_bracket_comment_Letter}) | {m_bracket_comment_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_bracket_comment_SciExp = [Ee]([+\-])?({m_bracket_comment_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_bracket_comment_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_bracket_comment_IntNumber = ({m_bracket_comment_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_bracket_comment_FPNumber = (({m_bracket_comment_Digit})+(\.)?({m_bracket_comment_Digit})* | (\.)?({m_bracket_comment_Digit})+)({m_bracket_comment_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_bracket_comment_HexNumber = 0[xX]({m_bracket_comment_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_bracket_comment_ImaginaryIntNumber = ({m_bracket_comment_Digit})+{m_bracket_comment_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_bracket_comment_ImaginaryFPNumber = (({m_bracket_comment_Digit})+(\.)?({m_bracket_comment_Digit})* | (\.)?({m_bracket_comment_Digit})+)({m_bracket_comment_SciExp})?{m_bracket_comment_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_bracket_comment_ImaginaryHexNumber = 0[xX]({m_bracket_comment_HexDigit})+{m_bracket_comment_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_bracket_comment_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_bracket_comment_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_bracket_comment_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_bracket_comment_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_bracket_comment_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_bracket_comment_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_bracket_comment_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_bracket_help_comment_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_bracket_help_comment_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_bracket_help_comment_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_bracket_help_comment_EscapedLineTerminator = {m_bracket_help_comment_Ellipsis}(.)*{m_bracket_help_comment_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_bracket_help_comment_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_bracket_help_comment_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_bracket_help_comment_HexDigit = ({m_bracket_help_comment_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_bracket_help_comment_Identifier = ([_$] | {m_bracket_help_comment_Letter})((([_$] | {m_bracket_help_comment_Letter}) | {m_bracket_help_comment_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_bracket_help_comment_SciExp = [Ee]([+\-])?({m_bracket_help_comment_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_bracket_help_comment_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_bracket_help_comment_IntNumber = ({m_bracket_help_comment_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_bracket_help_comment_FPNumber = (({m_bracket_help_comment_Digit})+(\.)?({m_bracket_help_comment_Digit})* | (\.)?({m_bracket_help_comment_Digit})+)({m_bracket_help_comment_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_bracket_help_comment_HexNumber = 0[xX]({m_bracket_help_comment_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_bracket_help_comment_ImaginaryIntNumber = ({m_bracket_help_comment_Digit})+{m_bracket_help_comment_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_bracket_help_comment_ImaginaryFPNumber = (({m_bracket_help_comment_Digit})+(\.)?({m_bracket_help_comment_Digit})* | (\.)?({m_bracket_help_comment_Digit})+)({m_bracket_help_comment_SciExp})?{m_bracket_help_comment_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_bracket_help_comment_ImaginaryHexNumber = 0[xX]({m_bracket_help_comment_HexDigit})+{m_bracket_help_comment_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_bracket_help_comment_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_bracket_help_comment_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_bracket_help_comment_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_bracket_help_comment_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_bracket_help_comment_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_bracket_help_comment_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_bracket_help_comment_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        //System.err.println("Reconsume char");
        yybegin(state_attributed_natlab.getPrevState());
        return state_attributed_natlab.getExtraReturn();
    }
}

<attributes_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/attributes.mlc [7, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [9, 1]
    attr1 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [10, 1]
    attr2 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [12, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [14, 1]
    val1 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [15, 1]
    val2 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [17, 1]
    ")" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_7();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<leading_ws_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/leading_ws.mlc [6, 1]
    {m_leading_ws_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/leading_ws.mlc [7, 1]
    {m_leading_ws_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<leading_ws_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/leading_ws.mlc [10, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_3();
        //System.err.println("processMTok(END_LEADING_WS)");
        state_attributed_natlab.processMTok('\u0034'); //END_LEADING_WS
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/leading_ws.mlc [11, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_4();
        //System.err.println("processMTok(END_LEADING_WS)");
        state_attributed_natlab.processMTok('\u0034'); //END_LEADING_WS
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_base_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_1();
        //System.err.println("processMTok(START_BRACKET_HELP_COMMENT)");
        state_attributed_natlab.processMTok('\u0036'); //START_BRACKET_HELP_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_base_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_2();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 1]
    {m_base_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [48, 1]
    {m_base_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [51, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_5();
        //System.err.println("processMTok(START_STRING)");
        state_attributed_natlab.processMTok('\u0038'); //START_STRING
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_6();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_7();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_8();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_9();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_10();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 1]
    \} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_11();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_12();
        //System.err.println("processMTok(START_COMMA_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0041'); //START_COMMA_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 1]
    ; {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_13();
        //System.err.println("processMTok(START_SEMICOLON_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0042'); //START_SEMICOLON_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 1]
    : {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 1]
    @ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 1]
    ".*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 1]
    "/" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 1]
    "./" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 1]
    "\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 1]
    ".\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 1]
    ".^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 1]
    ".'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 1]
    "<=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 1]
    ">=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 1]
    "<" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 1]
    ">" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 1]
    "==" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 1]
    "~=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 1]
    "&&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 1]
    "||" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/base.mlc [8, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_39();
        //System.err.println("processMTok(START_CLASS)");
        state_attributed_natlab.processMTok('\u0043'); //START_CLASS
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/base.mlc [9, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_40();
        //System.err.println("processMTok(END)");
        state_attributed_natlab.processMTok('\u0044'); //END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 1]
    case {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_41();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 1]
    for {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_42();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 1]
    function {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_43();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 1]
    if {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_44();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 1]
    parfor {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_45();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 1]
    switch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_46();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 1]
    try {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_47();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 1]
    while {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_48();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 1]
    break {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_49();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 1]
    catch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_50();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 1]
    continue {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_51();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 1]
    else {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 1]
    elseif {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 1]
    global {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 1]
    otherwise {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 1]
    persistent {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 1]
    return {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_59();
        //System.err.println("processMTok(START_FIELD_NAME)");
        state_attributed_natlab.processMTok('\u0046'); //START_FIELD_NAME
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_base_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_60();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_base_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_61();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 1]
    {m_base_EscapedLineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_62();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 1]
    {m_base_IntNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_63();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 1]
    {m_base_FPNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_64();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 1]
    {m_base_HexNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_65();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 1]
    {m_base_ImaginaryIntNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_66();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 1]
    {m_base_ImaginaryFPNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_67();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 1]
    {m_base_ImaginaryHexNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_68();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 1]
    {m_base_ShellCommand} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_69();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 1]
    {m_base_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_70();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/base.mlc [14, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_71();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/base.mlc [15, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<attributed_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_attributed_class_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_1();
        //System.err.println("processMTok(START_BRACKET_HELP_COMMENT)");
        state_attributed_natlab.processMTok('\u0036'); //START_BRACKET_HELP_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_attributed_class_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_2();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 1]
    {m_attributed_class_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [48, 1]
    {m_attributed_class_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [51, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_5();
        //System.err.println("processMTok(START_STRING)");
        state_attributed_natlab.processMTok('\u0038'); //START_STRING
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_6();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_7();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_8();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_9();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_10();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 1]
    \} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_11();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_12();
        //System.err.println("processMTok(START_COMMA_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0041'); //START_COMMA_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 1]
    ; {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_13();
        //System.err.println("processMTok(START_SEMICOLON_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0042'); //START_SEMICOLON_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 1]
    : {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 1]
    @ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 1]
    ".*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 1]
    "/" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 1]
    "./" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 1]
    "\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 1]
    ".\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 1]
    ".^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 1]
    ".'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 1]
    "<=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 1]
    ">=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 1]
    "<" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 1]
    ">" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 1]
    "==" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 1]
    "~=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 1]
    "&&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 1]
    "||" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class.mlc [11, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_39();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class.mlc [12, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_40();
        //System.err.println("processMTok(END)");
        state_attributed_natlab.processMTok('\u0044'); //END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 1]
    case {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_41();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 1]
    for {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_42();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 1]
    function {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_43();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 1]
    if {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_44();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 1]
    parfor {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_45();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 1]
    switch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_46();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 1]
    try {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_47();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 1]
    while {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_48();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 1]
    break {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_49();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 1]
    catch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_50();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 1]
    continue {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_51();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 1]
    else {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 1]
    elseif {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 1]
    global {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 1]
    otherwise {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 1]
    persistent {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 1]
    return {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_59();
        //System.err.println("processMTok(START_FIELD_NAME)");
        state_attributed_natlab.processMTok('\u0046'); //START_FIELD_NAME
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributed_class.mlc [9, 1]
    properties {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_60();
        //System.err.println("processMTok(PROPERTIES)");
        state_attributed_natlab.processMTok('\u0049'); //PROPERTIES
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributed_class.mlc [10, 1]
    methods {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_61();
        //System.err.println("processMTok(METHODS)");
        state_attributed_natlab.processMTok('\u004a'); //METHODS
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributed_class.mlc [11, 1]
    events {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_62();
        //System.err.println("processMTok(EVENTS)");
        state_attributed_natlab.processMTok('\u004b'); //EVENTS
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<attributed_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_attributed_class_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_63();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_attributed_class_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_64();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 1]
    {m_attributed_class_EscapedLineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_65();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 1]
    {m_attributed_class_IntNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_66();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 1]
    {m_attributed_class_FPNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_67();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 1]
    {m_attributed_class_HexNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_68();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 1]
    {m_attributed_class_ImaginaryIntNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_69();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 1]
    {m_attributed_class_ImaginaryFPNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_70();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 1]
    {m_attributed_class_ImaginaryHexNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_71();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 1]
    {m_attributed_class_ShellCommand} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 1]
    {m_attributed_class_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_73();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<attributed_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/class.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_74();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_75();
        //System.err.println("processMTok(END)");
        state_attributed_natlab.processMTok('\u0044'); //END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<class_bracketed_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_class_bracketed_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_1();
        //System.err.println("processMTok(START_BRACKET_HELP_COMMENT)");
        state_attributed_natlab.processMTok('\u0036'); //START_BRACKET_HELP_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_class_bracketed_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_2();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 1]
    {m_class_bracketed_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [48, 1]
    {m_class_bracketed_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [51, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_5();
        //System.err.println("processMTok(START_STRING)");
        state_attributed_natlab.processMTok('\u0038'); //START_STRING
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_6();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_7();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_8();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_9();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_10();
        //System.err.println("processMTok(START_BRACKETED)");
        state_attributed_natlab.processMTok('\u0039'); //START_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 1]
    \} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_11();
        //System.err.println("processMTok(END_BRACKETED)");
        state_attributed_natlab.processMTok('\u0032'); //END_BRACKETED
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_12();
        //System.err.println("processMTok(START_COMMA_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0041'); //START_COMMA_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 1]
    ; {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_13();
        //System.err.println("processMTok(START_SEMICOLON_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0042'); //START_SEMICOLON_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 1]
    : {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 1]
    @ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 1]
    ".*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 1]
    "/" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 1]
    "./" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 1]
    "\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 1]
    ".\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 1]
    ".^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 1]
    ".'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 1]
    "<=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 1]
    ">=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 1]
    "<" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 1]
    ">" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 1]
    "==" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 1]
    "~=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 1]
    "&&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 1]
    "||" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [11, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_39();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [12, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_40();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [14, 1]
    properties {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_41();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [15, 1]
    methods {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_42();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [16, 1]
    events {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_43();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 1]
    case {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_44();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 1]
    for {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_45();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 1]
    function {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_46();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 1]
    if {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_47();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 1]
    parfor {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_48();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 1]
    switch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_49();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 1]
    try {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_50();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 1]
    while {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_51();
        //System.err.println("processMTok(OPEN_END)");
        state_attributed_natlab.processMTok('\u0045'); //OPEN_END
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 1]
    break {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 1]
    catch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 1]
    continue {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 1]
    else {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 1]
    elseif {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 1]
    global {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 1]
    otherwise {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_59();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 1]
    persistent {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_60();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 1]
    return {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_61();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_62();
        //System.err.println("processMTok(START_FIELD_NAME)");
        state_attributed_natlab.processMTok('\u0046'); //START_FIELD_NAME
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<class_bracketed_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_class_bracketed_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_63();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_class_bracketed_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_64();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 1]
    {m_class_bracketed_EscapedLineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_65();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 1]
    {m_class_bracketed_IntNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_66();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 1]
    {m_class_bracketed_FPNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_67();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 1]
    {m_class_bracketed_HexNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_68();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 1]
    {m_class_bracketed_ImaginaryIntNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_69();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 1]
    {m_class_bracketed_ImaginaryFPNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_70();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 1]
    {m_class_bracketed_ImaginaryHexNumber} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_71();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 1]
    {m_class_bracketed_ShellCommand} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 1]
    {m_class_bracketed_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_73();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<class_bracketed_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_74();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_75();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<field_name_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_field_name_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_1();
        //System.err.println("processMTok(START_BRACKET_HELP_COMMENT)");
        state_attributed_natlab.processMTok('\u0036'); //START_BRACKET_HELP_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_field_name_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_2();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<field_name_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_field_name_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_field_name_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/field_name.mlc [12, 1]
    {m_field_name_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_5();
        //System.err.println("processMTok(START_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0047'); //START_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<field_name_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/field_name.mlc [16, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_6();
        //System.err.println("processMTok(END_FIELD_NAME)");
        state_attributed_natlab.processMTok('\u004e'); //END_FIELD_NAME
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/field_name.mlc [17, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_7();
        //System.err.println("processMTok(END_FIELD_NAME)");
        state_attributed_natlab.processMTok('\u004e'); //END_FIELD_NAME
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<comma_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_comma_terminator_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_1();
        //System.err.println("processMTok(START_BRACKET_HELP_COMMENT)");
        state_attributed_natlab.processMTok('\u0036'); //START_BRACKET_HELP_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_comma_terminator_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_2();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [12, 1]
    {m_comma_terminator_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [13, 1]
    {m_comma_terminator_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_4();
        //System.err.println("processMTok(END_COMMA_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0050'); //END_COMMA_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<comma_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_comma_terminator_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_comma_terminator_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<comma_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_7();
        //System.err.println("processMTok(END_COMMA_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0050'); //END_COMMA_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_8();
        //System.err.println("processMTok(END_COMMA_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0050'); //END_COMMA_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<semicolon_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_semicolon_terminator_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_1();
        //System.err.println("processMTok(START_BRACKET_HELP_COMMENT)");
        state_attributed_natlab.processMTok('\u0036'); //START_BRACKET_HELP_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_semicolon_terminator_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_2();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [12, 1]
    {m_semicolon_terminator_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [13, 1]
    {m_semicolon_terminator_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_4();
        //System.err.println("processMTok(END_SEMICOLON_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0052'); //END_SEMICOLON_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<semicolon_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_semicolon_terminator_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_semicolon_terminator_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<semicolon_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_7();
        //System.err.println("processMTok(END_SEMICOLON_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0052'); //END_SEMICOLON_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_8();
        //System.err.println("processMTok(END_SEMICOLON_TERMINATOR)");
        state_attributed_natlab.processMTok('\u0052'); //END_SEMICOLON_TERMINATOR
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/string.mlc [13, 1]
    "''" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [14, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_2();
        //System.err.println("processMTok(END_STRING)");
        state_attributed_natlab.processMTok('\u0054'); //END_STRING
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [15, 1]
    {m_string_ValidEscape} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [16, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [17, 1]
    {m_string_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/string.mlc [20, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [21, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<transpose_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/transpose.mlc [7, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_transpose.transpose_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<transpose_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/transpose.mlc [10, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_transpose.transpose_action_2();
        //System.err.println("processMTok(END_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0056'); //END_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/transpose.mlc [11, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_transpose.transpose_action_3();
        //System.err.println("processMTok(END_TRANSPOSE)");
        state_attributed_natlab.processMTok('\u0056'); //END_TRANSPOSE
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [14, 1]
    {m_bracket_comment_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [15, 1]
    {m_bracket_comment_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_2();
        //System.err.println("processMTok(END_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0058'); //END_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_help_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [15, 1]
    {m_bracket_help_comment_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_1();
        //System.err.println("processMTok(START_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0037'); //START_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [16, 1]
    {m_bracket_help_comment_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_2();
        //System.err.println("processMTok(END_BRACKET_COMMENT)");
        state_attributed_natlab.processMTok('\u0058'); //END_BRACKET_COMMENT
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_help_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [19, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


