package metalexer;

import java.io.PrintWriter;

/** Generates metalexer.*ParserPassTests from the provided list file. */
public abstract class InheritanceFailTestGenerator extends AbstractTestGenerator {
    private final String prefix;

    protected InheritanceFailTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "InheritanceFailTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import java.util.List;");
        testFileWriter.println("import java.util.SortedSet;");
        testFileWriter.println("import java.util.TreeSet;");
        testFileWriter.println();
        testFileWriter.println("import metalexer.ast." + prefix + ";");
        testFileWriter.println();
        testFileWriter.println("public class " + prefix + "InheritanceFailTests extends " + prefix + "ParserFailTestBase {");
        //NB: not a typo - do extend ParserPassTestBase
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("    public void " + methodName + "() throws Exception {");
        testFileWriter.println("        FileLoader loader = new FileLoader(\"test/frontend\");");
        testFileWriter.println("        SortedSet<CompilationError> actualErrors = new TreeSet<CompilationError>();");
        testFileWriter.println("        " + prefix + " node = loader.load" + prefix + "(\"" + testName + "\", actualErrors);");
        testFileWriter.println("        assertTrue(node.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        node = node.processInheritance(loader, actualErrors);");
        testFileWriter.println("        assertTrue(node.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        assertFalse(actualErrors.isEmpty());");
        testFileWriter.println("        List<String> expectedErrors = readErrors(\"" + outFileName + "\");");
        testFileWriter.println("        assertEquals(expectedErrors, actualErrors);");
        testFileWriter.println("    }");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}
