/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.Action;
import beaver.comp.Configuration;
import beaver.spec.GrammarSymbol;
import java.util.HashMap;
import java.util.Map;

class State {
    State next;
    int id;
    Configuration.Set conf_set;
    Action.List actions;
    Action.List terminal_lookahead_actions;
    Action.List nonterminal_lookahead_actions;
    Action default_action;

    State(int n, Configuration.Set set) {
        this.id = n;
        this.conf_set = set;
        this.actions = new Action.List(this);
        this.terminal_lookahead_actions = new Action.List(this);
        this.nonterminal_lookahead_actions = new Action.List(this);
    }

    boolean findLookaheads() {
        boolean bl = false;
        Configuration configuration = this.conf_set.first_conf;
        while (configuration != null) {
            if (!configuration.has_contributed) {
                if (configuration.findLookaheads()) {
                    bl = true;
                }
                configuration.has_contributed = true;
            }
            configuration = configuration.next;
        }
        return bl;
    }

    void splitActions() {
        this.default_action = this.actions.split(this.terminal_lookahead_actions, this.nonterminal_lookahead_actions);
    }

    static class Factory {
        private State last_state;
        private int num_states;
        private Map states = new HashMap(89);
        private Configuration.Set.Factory conf_set_factory;

        Factory(Configuration.Set.Factory factory) {
            this.conf_set_factory = factory;
        }

        State getState(Configuration.Set set) {
            State state = (State)this.states.get(set);
            if (state == null) {
                set.buildClosure();
                state = new State(++this.num_states, set);
                this.states.put(set, state);
                this.last_state = this.last_state == null ? state : (this.last_state.next = state);
                this.buildShiftsFrom(state);
            } else {
                state.conf_set.appendReversePropagation(set);
            }
            return state;
        }

        private void buildShiftsFrom(State state) {
            state.conf_set.resetContributionFlags();
            Configuration configuration = state.conf_set.first_conf;
            while (configuration != null) {
                if (!configuration.has_contributed && !configuration.isDotAfterLastSymbol()) {
                    this.conf_set_factory.reset();
                    GrammarSymbol grammarSymbol = configuration.getSymbolAfterDot();
                    Object object = configuration;
                    while (object != null) {
                        if (!((Configuration)object).has_contributed && !((Configuration)object).isDotAfterLastSymbol() && ((Configuration)object).getSymbolAfterDot() == grammarSymbol) {
                            Configuration configuration2 = this.conf_set_factory.addConfiguration(((Configuration)object).rule, ((Configuration)object).dot + 1);
                            configuration2.addReversePropagation((Configuration)object);
                            ((Configuration)object).has_contributed = true;
                        }
                        object = ((Configuration)object).next;
                    }
                    object = this.getState(this.conf_set_factory.getCore());
                    state.actions.add(new Action.Shift(grammarSymbol, (State)object));
                }
                configuration = configuration.next;
            }
        }
    }
}

