package metalexer.jflex;

import java.util.HashMap;
import java.util.Map;

public class CharacterAssigner {
    private final CharacterGenerator gen;
    private final Map<String, Character> charMap;

    public CharacterAssigner(CharacterGenerator gen) {
        this.gen = gen;
        this.charMap = new HashMap<String, Character>();
    }

    public char assignChar(String name) {
        if(charMap.containsKey(name)) {
            return charMap.get(name);
        }
        char ch = gen.next();
        charMap.put(name, ch);
        return ch;
    }
}
