package metalexer.jflex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

import test.jflex.natlab.CommentBuffer;

import test.jflex.natlab.NatlabParser;
import metalexer.ScannerTestBase;

import beaver.Scanner;

public class NaiveNatlabScannerTestBase extends ScannerTestBase {

    protected NaiveNatlabScannerTestBase() {
        super(NatlabParser.Terminals.EOF, NatlabParser.Terminals.NAMES);
    }

    /* Construct a scanner that will read from the specified file. */
    protected Scanner getScanner(String filename) throws FileNotFoundException {
        return ReflectionHelper.instantiateScanner("test.jflex.natlab.NaiveNatlabScanner", new BufferedReader(new FileReader(filename)), new CommentBuffer());
    }

    protected short getID(String idString) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return NatlabParser.Terminals.class.getField(idString).getShort(null);
    }
}
