package test.jflex.annotations;
import test.jflex.annotations.AnnotationParser.Terminals;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/natlab/annotations.mll [7, 1]
%class AnnotationScanner
//from test/backend-jflex/in/natlab/annotations.mll [8, 1]
%function nextToken
//from test/backend-jflex/in/natlab/helper_beaver.mll [9, 1]
%public
//from test/backend-jflex/in/natlab/helper_beaver.mll [10, 1]
%final
//from test/backend-jflex/in/natlab/helper_beaver.mll [13, 1]
%extends Scanner
//from test/backend-jflex/in/natlab/helper_beaver.mll [14, 1]
%unicode
//from test/backend-jflex/in/natlab/helper_beaver.mll [17, 1]
%line
//from test/backend-jflex/in/natlab/helper_beaver.mll [18, 1]
%column
//from test/backend-jflex/in/natlab/helper_beaver.mll [20, 1]
%type Symbol
//from null [22, 1]
%yylexthrow Scanner.Exception

%{
    private final StateClass_annotations state_annotations = new StateClass_annotations();
%}

%{
    private class StateClass_annotations {
        private StateClass_annotations() {
            metaLexerThread.start();
            
            
            //from test/backend-jflex/in/natlab/annotations.mll [11, 8]
            yybegin(annotations_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(inst_annotations, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            
            restartAppendBuf();
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[0];
        private final CompClass_annotations inst_annotations = new CompClass_annotations();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            //System.err.println("yypushback(1)");
            yypushback(1); //to ensure that at least one char is available
            yybegin(EXTRA_RETURN);
        }
        
        private boolean stopped = false;
        
        public void stop() {
            stopped = true;
            pipe.writeFinal('\n');
            boolean joined = false;
            while(!joined) {
                try {
                    metaLexerThread.join();
                    joined = true;
                } catch(InterruptedException e) {}
            }
        }
        
        private final Pipe pipe = new Pipe();
        private final AnnotationScanner_Meta metalexer = new AnnotationScanner_Meta(pipe);
        private final Thread metaLexerThread = new Thread(new Runnable() {
            public void run() {
                try {
                    metalexer.start();
                } catch(java.io.IOException e) {
                    //unrecoverable
                    e.printStackTrace();
                }
            }}, "MetaLexerThread");
        
        private Integer sendMTok(char mtok) {
            if(stopped) {
                throw new IllegalStateException("No meta-tokens may be sent after stop() has been called.");
            }
            //System.err.println("sendMTok(" + Integer.toHexString(mtok) + ")");
            pipe.write(mtok);
            return metalexer.checkForTransition();
        }
        
        public void processMTok(char mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                //System.err.println("Pair filter caught: " + Integer.toHexString(mtok));
                return; //don't send character if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            Integer nextEmbeddingNum = sendMTok(mtok);
            while(nextEmbeddingNum != null) {
                boolean endOfEmbedding = nextEmbeddingNum < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    startEmbedding(nextEmbeddingNum);
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                nextEmbeddingNum = null;
                if(endOfEmbedding) {
                    char regionChar = currComp.getCharValue();
                    if(getCurrFilter().test(regionChar)) {
                        nextEmbeddingNum = sendMTok(regionChar);
                    } else {
                        //System.err.println("Pair filter caught: " + Integer.toHexString(regionChar));
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract char getCharValue();
    }
%}

%{
    //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
    private class CompClass_annotations extends ComponentInnerClass {
        
        public CompClass_annotations() {
        }
        
        private static final int YYINITIAL = annotations_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0030';
        }
        
        public Maybe<? extends Symbol> annotations_action_1() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [15, 5]
                return Maybe.Just(symbol(Terminals.DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_2() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [17, 5]
                return Maybe.Just(symbol(Terminals.STMT_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_3() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [18, 5]
                return Maybe.Just(symbol(Terminals.ELEMENT_SEPARATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_4() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [20, 5]
                return Maybe.Just(symbol(Terminals.SIZE_OF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_5() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [21, 5]
                return Maybe.Just(symbol(Terminals.EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_6() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [22, 5]
                return Maybe.Just(symbol(Terminals.HAS_TYPE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_7() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [24, 4]
                return Maybe.Just(symbol(Terminals.LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_8() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [25, 4]
                return Maybe.Just(symbol(Terminals.RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_9() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [26, 4]
                return Maybe.Just(symbol(Terminals.LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_10() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [27, 4]
                return Maybe.Just(symbol(Terminals.RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_11() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [28, 4]
                return Maybe.Just(symbol(Terminals.LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_12() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [29, 4]
                return Maybe.Just(symbol(Terminals.RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_13() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [31, 5]
                return Maybe.Just(symbol(Terminals.VARARG_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_14() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [32, 5]
                return Maybe.Just(symbol(Terminals.HANDLE_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_15() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [33, 5]
                return Maybe.Just(symbol(Terminals.TYPE_VAR_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_16() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [35, 6]
                return Maybe.Just(symbol(Terminals.ARROW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_17() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [36, 5]
                return Maybe.Just(symbol(Terminals.UNKNOWN_TYPE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_18() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [38, 5]
                return Maybe.Just(symbol(Terminals.UNION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_19() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [39, 5]
                return Maybe.Just(symbol(Terminals.INTERSECT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_20() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [41, 5]
                return Maybe.Just(symbol(Terminals.IS_SCALAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_21() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [42, 5]
                return Maybe.Just(symbol(Terminals.IS_NOT_SCALAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_22() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [46, 14]
                /* skip */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_23() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [47, 11]
                /* skip */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_24() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [49, 10]
                return Maybe.Just(symbol(Terminals.NUMBER, Integer.parseInt(yytext())));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_25() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [51, 14]
                return Maybe.Just(symbol(Terminals.IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_26() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [55, 9]
                error("Illegal character '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_27() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [56, 9]
                return Maybe.Just(symbol(Terminals.EOF));
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
        private final java.util.Set<Character> allOpenChars;
        private final java.util.List<Character> unclosedOpenChars; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Character, java.util.Set<Character>> pairMap, java.util.Set<Character> allOpenChars) {
            this.pairMap = pairMap;
            this.allOpenChars = allOpenChars;
            this.unclosedOpenChars = new java.util.ArrayList<Character>();
        }
        
        public static class Builder {
            private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
            private final java.util.Set<Character> allOpenChars;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Character, java.util.Set<Character>>();
                this.allOpenChars = new java.util.HashSet<Character>();
            }
            
            public Builder add(char open, char close) {
                allOpenChars.add(open);
                java.util.Set<Character> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Character>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenChars);
            }
        }
        
        public boolean test(char ch) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Character> correspondingOpens = pairMap.get(ch);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Character> it = unclosedOpenChars.iterator(); it.hasNext(); ) {
                    char open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenChars.contains(ch)) { //implies opening
                unclosedOpenChars.add(0, ch); //insert at beginning
            }
            return true;
        }
        
        public void reset() {
            unclosedOpenChars.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(ComponentInnerClass comp, PairFilter filter) {
            this.comp = comp;
            this.filter = filter;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    public static class Pipe extends java.io.Reader {
        private final java.util.concurrent.locks.Lock monitorLock = new java.util.concurrent.locks.ReentrantLock();
        private final java.util.Queue<java.util.concurrent.locks.Condition> waitingForFirstRead = new java.util.LinkedList<java.util.concurrent.locks.Condition>();
        private java.util.Map<Thread, java.util.concurrent.locks.Condition> waitingForSecondRead = new java.util.HashMap<Thread, java.util.concurrent.locks.Condition>();
        
        private final java.util.Queue<Character> writeQueue = new java.util.LinkedList<Character>();
        private final java.util.concurrent.locks.Condition notEmpty = monitorLock.newCondition();
        
        private boolean closed = false;
        private boolean eof = false;
        
        public void write(char ch) {
            write(ch, false);
        }
        
        //NB: combine write() with eof() because the last write() will block, making it hard to call eof()
        public void writeFinal(char ch) {
            write(ch, true);
        }
        
        private void write(char ch, boolean isFinal) {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot write after the read end has been closed.");
                }
                if(eof) {
                    throw new IllegalStateException("Cannot write after EOF.");
                }
                if(isFinal) {
                    eof = true;
                }
                writeQueue.add(ch);
                java.util.concurrent.locks.Condition cond = monitorLock.newCondition();
                waitingForFirstRead.add(cond);
                notEmpty.signalAll();
                cond.awaitUninterruptibly();
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        //NB: ignore length and always write 1 byte (unless at EOF)
        public int read(char[] buf, int offset, int length) throws java.io.IOException {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot read after the read end has been closed.");
                }
                boolean freedWriter = freeNextWriter();
                while(!eof && writeQueue.isEmpty()) {
                    notEmpty.awaitUninterruptibly();
                    if(!freedWriter) {
                        freedWriter = freeNextWriter();
                    }
                }
                if(eof && writeQueue.isEmpty()) {
                    //no writers waiting, so none to free
                    return -1;
                }
                waitingForSecondRead.put(Thread.currentThread(), waitingForFirstRead.poll());
                buf[offset] = writeQueue.poll();
                return 1;
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        public void close() throws java.io.IOException {
            monitorLock.lock();
            try {
                closed = true;
                freeAllWriters();
            } finally {
                monitorLock.unlock();
            }
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private boolean freeNextWriter() {
            java.util.concurrent.locks.Condition cond = waitingForSecondRead.get(Thread.currentThread());
            if(cond != null) {
                cond.signal();
                waitingForSecondRead.remove(Thread.currentThread());
                return true;
            }
            return false;
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private void freeAllWriters() {
            for(java.util.concurrent.locks.Condition cond : waitingForSecondRead.values()) {
                cond.signal();
            }
            waitingForSecondRead.clear();
            for(java.util.concurrent.locks.Condition cond : waitingForFirstRead) {
                cond.signal();
            }
            waitingForFirstRead.clear();
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isJust() {
            return !isNothing();
        }
        public abstract boolean isNothing();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isNothing() {
                return false;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isNothing() {
                return true;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

%{
    public void stop() {
        state_annotations.stop();
    }
%}

//from null [10, 1]
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
//from null [9, 1]
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}


%xstate EXTRA_RETURN

//from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
%state annotations_YYINITIAL_STATE

m_annotations_Whitespace = ([ \t\f\r\n])+ //from test/backend-jflex/in/natlab/annotations.mlc [3, 1]
m_annotations_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/annotations.mlc [5, 1]
m_annotations_Digit = [0-9] //from test/backend-jflex/in/natlab/annotations.mlc [6, 1]
m_annotations_Identifier = ([_$] | {m_annotations_Letter})((([_$] | {m_annotations_Letter}) | {m_annotations_Digit}))* //from test/backend-jflex/in/natlab/annotations.mlc [7, 1]
m_annotations_Number = (0 | [1-9]({m_annotations_Digit})*) //from test/backend-jflex/in/natlab/annotations.mlc [9, 1]
m_annotations_Comment = [/][/](.)* //from test/backend-jflex/in/natlab/annotations.mlc [11, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        //System.err.println("Reconsume char");
        yybegin(state_annotations.getPrevState());
        return state_annotations.getExtraReturn();
    }
}

<annotations_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/annotations.mlc [15, 1]
    "." {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [17, 1]
    ";" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [18, 1]
    "," {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [20, 1]
    "#" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [21, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [22, 1]
    ":" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [24, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [25, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [26, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [27, 1]
    \} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [28, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [29, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [31, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [32, 1]
    "@" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [33, 1]
    "$" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [35, 1]
    "->" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [36, 1]
    "?" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [38, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [39, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [41, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [42, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<annotations_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/annotations.mlc [46, 1]
    {m_annotations_Whitespace} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [47, 1]
    {m_annotations_Comment} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [49, 1]
    {m_annotations_Number} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [51, 1]
    {m_annotations_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<annotations_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/annotations.mlc [55, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [56, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


