package test.jflex.natlab;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
%%
%public
%final
%unicode
%class NatlabScanner_Meta
%function start
%type Object

%{
    java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
    
    void saveStateAndTransition(int newState) {
        stateStack.push(yystate());
        yybegin(newState);
    }
    
    void restoreState() {
        yybegin(stateStack.pop());
    }
%}

%{
    private Integer transition = null;
    
    private void notifyLexer(int transition) {
        //System.err.println("in notifyLexer(" + transition + ")");
        this.transition = transition;
    }
    
    public Integer checkForTransition() {
        Integer tmp = transition;
        transition = null;
        return tmp;
    }
%}

%init{
    //Start in state BASE
    yybegin(BASE);
    
    //Transition through states reachable by pure BOF patterns
    saveStateAndTransition(e_leading_ws); 
%init}

%state BASE
//from test/backend-jflex/in/natlab/natlab.mll [55, 1]
%state e_leading_ws
//from test/backend-jflex/in/natlab/natlab.mll [64, 1]
%state e_class
//from test/backend-jflex/in/natlab/natlab.mll [72, 1]
%state e_class_brackets
//from test/backend-jflex/in/natlab/natlab.mll [82, 1]
%state e_field_name
//from test/backend-jflex/in/natlab/natlab.mll [91, 1]
%state e_transpose
//from test/backend-jflex/in/natlab/natlab.mll [100, 1]
%state e_string
//from test/backend-jflex/in/natlab/natlab.mll [109, 1]
%state e_comma_terminator
//from test/backend-jflex/in/natlab/natlab.mll [116, 1]
%state e_semicolon_terminator
//from test/backend-jflex/in/natlab/natlab.mll [125, 1]
%state e_bracket_comment
//from test/backend-jflex/in/natlab/natlab.mll [132, 1]
%state e_bracket_help_comment

//Meta-tokens
t_END = \u0043 //from test/backend-jflex/in/natlab/natlab.mll [69, 6]
t_END_BRACKETED = \u0038 //from test/backend-jflex/in/natlab/natlab.mll [78, 24]
t_END_BRACKET_COMMENT = \u0054 //from test/backend-jflex/in/natlab/natlab.mll [130, 6]
t_END_COMMA_TERMINATOR = \u004c //from test/backend-jflex/in/natlab/natlab.mll [114, 6]
t_END_FIELD_NAME = \u004a //from test/backend-jflex/in/natlab/natlab.mll [87, 6]
t_END_LEADING_WS = \u0032 //from test/backend-jflex/in/natlab/natlab.mll [60, 6]
t_END_SEMICOLON_TERMINATOR = \u004e //from test/backend-jflex/in/natlab/natlab.mll [121, 6]
t_END_STRING = \u0050 //from test/backend-jflex/in/natlab/natlab.mll [105, 6]
t_END_TRANSPOSE = \u0052 //from test/backend-jflex/in/natlab/natlab.mll [96, 6]
t_OPEN_END = \u0044 //from test/backend-jflex/in/natlab/natlab.mll [70, 7]
t_START_BRACKETED = \u0037 //from test/backend-jflex/in/natlab/natlab.mll [76, 8]
t_START_BRACKET_COMMENT = \u0035 //from test/backend-jflex/in/natlab/natlab.mll [129, 8]
t_START_BRACKET_HELP_COMMENT = \u0034 //from test/backend-jflex/in/natlab/natlab.mll [136, 8]
t_START_CLASS = \u0042 //from test/backend-jflex/in/natlab/natlab.mll [68, 8]
t_START_COMMA_TERMINATOR = \u0039 //from test/backend-jflex/in/natlab/natlab.mll [113, 8]
t_START_FIELD_NAME = \u0045 //from test/backend-jflex/in/natlab/natlab.mll [86, 8]
t_START_SEMICOLON_TERMINATOR = \u0041 //from test/backend-jflex/in/natlab/natlab.mll [120, 8]
t_START_STRING = \u0036 //from test/backend-jflex/in/natlab/natlab.mll [104, 8]
t_START_TRANSPOSE = \u0046 //from test/backend-jflex/in/natlab/natlab.mll [95, 9]

//Regions

%%

//// START PATTERNS ////////////////////////////////////////////////////////////

//no embeddings completed (i.e. now in start component 'base')
<BASE> {
    //start patterns from embeddings with host 'base'
    
    //from test/backend-jflex/in/natlab/natlab.mll [55, 1]
    //start pattern for embedding 'leading_ws'
    /* Omitting empty pattern (handled elsewhere)
    ^ { /*System.err.println("call notifyLexer(leading_ws)");*/ saveStateAndTransition(e_leading_ws); notifyLexer(/*leading_ws*/ 0); }
    */
    
    //from test/backend-jflex/in/natlab/natlab.mll [64, 1]
    //start pattern for embedding 'class'
    {t_START_CLASS} { /*System.err.println("call notifyLexer(class)");*/ saveStateAndTransition(e_class); notifyLexer(/*class*/ 1); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [82, 1]
    //start pattern for embedding 'field_name'
    {t_START_FIELD_NAME} { /*System.err.println("call notifyLexer(field_name)");*/ saveStateAndTransition(e_field_name); notifyLexer(/*field_name*/ 3); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [91, 1]
    //start pattern for embedding 'transpose'
    [\u0046\u0038] { /*System.err.println("call notifyLexer(transpose)");*/ saveStateAndTransition(e_transpose); notifyLexer(/*transpose*/ 4); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [100, 1]
    //start pattern for embedding 'string'
    {t_START_STRING} { /*System.err.println("call notifyLexer(string)");*/ saveStateAndTransition(e_string); notifyLexer(/*string*/ 5); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [109, 1]
    //start pattern for embedding 'comma_terminator'
    {t_START_COMMA_TERMINATOR} { /*System.err.println("call notifyLexer(comma_terminator)");*/ saveStateAndTransition(e_comma_terminator); notifyLexer(/*comma_terminator*/ 6); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [116, 1]
    //start pattern for embedding 'semicolon_terminator'
    {t_START_SEMICOLON_TERMINATOR} { /*System.err.println("call notifyLexer(semicolon_terminator)");*/ saveStateAndTransition(e_semicolon_terminator); notifyLexer(/*semicolon_terminator*/ 7); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
    //start pattern for embedding 'bracket_help_comment'
    {t_START_BRACKET_HELP_COMMENT} { /*System.err.println("call notifyLexer(bracket_help_comment)");*/ saveStateAndTransition(e_bracket_help_comment); notifyLexer(/*bracket_help_comment*/ 9); }
}

//just completed an embedding with guest 'class_bracketed' (i.e. now in component 'class_bracketed')
<e_class_brackets> {
    //start patterns from embeddings with host 'class_bracketed'
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
    //start pattern for embedding 'bracket_help_comment'
    {t_START_BRACKET_HELP_COMMENT} { /*System.err.println("call notifyLexer(bracket_help_comment)");*/ saveStateAndTransition(e_bracket_help_comment); notifyLexer(/*bracket_help_comment*/ 9); }
}

//just completed an embedding with guest 'field_name' (i.e. now in component 'field_name')
<e_field_name> {
    //start patterns from embeddings with host 'field_name'
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
    //start pattern for embedding 'bracket_help_comment'
    {t_START_BRACKET_HELP_COMMENT} { /*System.err.println("call notifyLexer(bracket_help_comment)");*/ saveStateAndTransition(e_bracket_help_comment); notifyLexer(/*bracket_help_comment*/ 9); }
}

//just completed an embedding with guest 'comma_terminator' (i.e. now in component 'comma_terminator')
<e_comma_terminator> {
    //start patterns from embeddings with host 'comma_terminator'
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
    //start pattern for embedding 'bracket_help_comment'
    {t_START_BRACKET_HELP_COMMENT} { /*System.err.println("call notifyLexer(bracket_help_comment)");*/ saveStateAndTransition(e_bracket_help_comment); notifyLexer(/*bracket_help_comment*/ 9); }
}

//just completed an embedding with guest 'class' (i.e. now in component 'class')
<e_class> {
    //start patterns from embeddings with host 'class'
    
    //from test/backend-jflex/in/natlab/natlab.mll [72, 1]
    //start pattern for embedding 'class_brackets'
    {t_START_BRACKETED} { /*System.err.println("call notifyLexer(class_brackets)");*/ saveStateAndTransition(e_class_brackets); notifyLexer(/*class_brackets*/ 2); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [82, 1]
    //start pattern for embedding 'field_name'
    {t_START_FIELD_NAME} { /*System.err.println("call notifyLexer(field_name)");*/ saveStateAndTransition(e_field_name); notifyLexer(/*field_name*/ 3); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [91, 1]
    //start pattern for embedding 'transpose'
    [\u0046\u0038] { /*System.err.println("call notifyLexer(transpose)");*/ saveStateAndTransition(e_transpose); notifyLexer(/*transpose*/ 4); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [100, 1]
    //start pattern for embedding 'string'
    {t_START_STRING} { /*System.err.println("call notifyLexer(string)");*/ saveStateAndTransition(e_string); notifyLexer(/*string*/ 5); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [109, 1]
    //start pattern for embedding 'comma_terminator'
    {t_START_COMMA_TERMINATOR} { /*System.err.println("call notifyLexer(comma_terminator)");*/ saveStateAndTransition(e_comma_terminator); notifyLexer(/*comma_terminator*/ 6); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [116, 1]
    //start pattern for embedding 'semicolon_terminator'
    {t_START_SEMICOLON_TERMINATOR} { /*System.err.println("call notifyLexer(semicolon_terminator)");*/ saveStateAndTransition(e_semicolon_terminator); notifyLexer(/*semicolon_terminator*/ 7); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
    //start pattern for embedding 'bracket_help_comment'
    {t_START_BRACKET_HELP_COMMENT} { /*System.err.println("call notifyLexer(bracket_help_comment)");*/ saveStateAndTransition(e_bracket_help_comment); notifyLexer(/*bracket_help_comment*/ 9); }
}

//just completed an embedding with guest 'bracket_help_comment' (i.e. now in component 'bracket_help_comment')
<e_bracket_help_comment> {
    //start patterns from embeddings with host 'bracket_help_comment'
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
}

//just completed an embedding with guest 'semicolon_terminator' (i.e. now in component 'semicolon_terminator')
<e_semicolon_terminator> {
    //start patterns from embeddings with host 'semicolon_terminator'
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
    
    //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
    //start pattern for embedding 'bracket_help_comment'
    {t_START_BRACKET_HELP_COMMENT} { /*System.err.println("call notifyLexer(bracket_help_comment)");*/ saveStateAndTransition(e_bracket_help_comment); notifyLexer(/*bracket_help_comment*/ 9); }
}

//just completed an embedding with guest 'bracket_comment' (i.e. now in component 'bracket_comment')
<e_bracket_comment> {
    //start patterns from embeddings with host 'bracket_comment'
    
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //start pattern for embedding 'bracket_comment'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(bracket_comment)");*/ saveStateAndTransition(e_bracket_comment); notifyLexer(/*bracket_comment*/ 8); }
}

//// END PATTERNS //////////////////////////////////////////////////////////////

<e_leading_ws> {
    //from test/backend-jflex/in/natlab/natlab.mll [55, 1]
    //end pattern for embedding 'leading_ws'
    {t_END_LEADING_WS} { /*System.err.println("call notifyLexer(restore from leading_ws)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_class> {
    //from test/backend-jflex/in/natlab/natlab.mll [64, 1]
    //end pattern for embedding 'class'
    {t_END} { /*System.err.println("call notifyLexer(restore from class)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_class_brackets> {
    //from test/backend-jflex/in/natlab/natlab.mll [72, 1]
    //end pattern for embedding 'class_brackets'
    {t_END_BRACKETED} { /*System.err.println("call notifyLexer(restore from class_brackets)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_field_name> {
    //from test/backend-jflex/in/natlab/natlab.mll [82, 1]
    //end pattern for embedding 'field_name'
    {t_END_FIELD_NAME} { /*System.err.println("call notifyLexer(restore from field_name)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_transpose> {
    //from test/backend-jflex/in/natlab/natlab.mll [91, 1]
    //end pattern for embedding 'transpose'
    {t_END_TRANSPOSE} { /*System.err.println("call notifyLexer(restore from transpose)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_string> {
    //from test/backend-jflex/in/natlab/natlab.mll [100, 1]
    //end pattern for embedding 'string'
    {t_END_STRING} { /*System.err.println("call notifyLexer(restore from string)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_comma_terminator> {
    //from test/backend-jflex/in/natlab/natlab.mll [109, 1]
    //end pattern for embedding 'comma_terminator'
    {t_END_COMMA_TERMINATOR} { /*System.err.println("call notifyLexer(restore from comma_terminator)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_semicolon_terminator> {
    //from test/backend-jflex/in/natlab/natlab.mll [116, 1]
    //end pattern for embedding 'semicolon_terminator'
    {t_END_SEMICOLON_TERMINATOR} { /*System.err.println("call notifyLexer(restore from semicolon_terminator)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_bracket_comment> {
    //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
    //end pattern for embedding 'bracket_comment'
    {t_END_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(restore from bracket_comment)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_bracket_help_comment> {
    //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
    //end pattern for embedding 'bracket_help_comment'
    {t_END_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(restore from bracket_help_comment)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

//// SHARED CLEAN-UP PATTERNS //////////////////////////////////////////////////

(.|\n) { /*System.err.println("Ignoring '" + Integer.toHexString(yytext().charAt(0)) + "' in state " + yystate());*/ /*consume and ignore*/ }
<<EOF>> { return null; } //break out of infinite loop

