package metalexer.jflex;

import junit.framework.Test;
import junit.framework.TestSuite;

/** Top-level test suite.  Contains all tests. */
public class BackendJFlexTests {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        //$JUnit-BEGIN$
        suite.addTestSuite(StringEscapeTests.class);
        suite.addTestSuite(ReturnWrapTests.class);
        suite.addTestSuite(PackageFindTests.class);
        suite.addTestSuite(StaticFindTests.class);
        suite.addTestSuite(ComponentErrorTests.class);
        suite.addTestSuite(LayoutErrorTests.class);
        if(CompilationTests.JFLEX_HELPER.isJFlexAvailable()) {
            suite.addTestSuite(CompilationTests.class);
            suite.addTestSuite(ComponentMetaScannerTests.class);
            suite.addTestSuite(ComponentScannerTests.class);
            suite.addTestSuite(LayoutScannerTests.class);
            suite.addTestSuite(NatlabScannerTests.class);
            suite.addTestSuite(NaiveNatlabScannerTests.class);
        } else {
            System.err.println("Skipping tests that depend on JFlex");
        }
        //$JUnit-END$
        return suite;
    }
}
