package test.jflex.metalexer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
%%
%public
%final
%unicode
%class ComponentScanner_Meta
%function start
%type Object

%{
    java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
    
    void saveStateAndTransition(int newState) {
        stateStack.push(yystate());
        yybegin(newState);
    }
    
    void restoreState() {
        yybegin(stateStack.pop());
    }
%}

%{
    private Transition transition = null;
    
    private void notifyLexer(int embeddingNum) {
        //System.err.println("in notifyLexer(" + embeddingNum + "," + yytext() + ")");
        this.transition = new Transition(embeddingNum, yytext());
    }
    
    public Transition checkForTransition() {
        Transition tmp = transition;
        transition = null;
        return tmp;
    }
%}

%{
    public static class Transition {
        private final int embeddingNum;
        private final String match;
        
        public Transition(int embeddingNum, String match) {
            this.embeddingNum = embeddingNum;
            this.match = match;
        }
        
        public int getEmbeddingNum() { return embeddingNum; }
        
        public String getMatch() { return match; }
    }
%}

%init{
    //Start in state BASE
    yybegin(BASE);
    
    //Transition through states reachable by pure BOF patterns
    saveStateAndTransition(e_option_section); 
%init}

%state BASE
//from test/backend-jflex/in/metalexer/component.mll [106, 1]
%state e_option_section
//from test/backend-jflex/in/metalexer/component.mll [113, 1]
%state e_option_append
//from test/backend-jflex/in/metalexer/component.mll [120, 1]
%state e_option_decl
//from test/backend-jflex/in/metalexer/component.mll [127, 1]
%state e_option_init
//from test/backend-jflex/in/metalexer/component.mll [134, 1]
%state e_option_string_directive
//from test/backend-jflex/in/metalexer/component.mll [143, 1]
%state e_rule_section
//from test/backend-jflex/in/metalexer/component.mll [150, 1]
%state e_rule_delete_directive
//from test/backend-jflex/in/metalexer/component.mll [157, 1]
%state e_rule_action
//from test/backend-jflex/in/metalexer/component.mll [164, 1]
%state e_rule_metatoken
//from test/backend-jflex/in/metalexer/component.mll [171, 1]
%state e_open_rule_group
//from test/backend-jflex/in/metalexer/component.mll [181, 1]
%state e_comments
//from test/backend-jflex/in/metalexer/component.mll [190, 1]
%state e_string
//from test/backend-jflex/in/metalexer/component.mll [197, 1]
%state e_identifier_directive
//from test/backend-jflex/in/metalexer/component.mll [204, 1]
%state e_macro_invoc
//from test/backend-jflex/in/metalexer/component.mll [211, 1]
%state e_repetition_spec
//from test/backend-jflex/in/metalexer/component.mll [218, 1]
%state e_bracketed_state_list
//from test/backend-jflex/in/metalexer/component.mll [225, 1]
%state e_char_class

//Meta-tokens
t_END_ACTION = \u0032 //from test/backend-jflex/in/metalexer/component.mll [162, 6]
t_END_APPEND_REGION = \u0034 //from test/backend-jflex/in/metalexer/component.mll [118, 6]
t_END_BRACKETED_STATE_LIST = \u0041 //from test/backend-jflex/in/metalexer/component.mll [223, 6]
t_END_BRACKET_COMMENT = \u0038 //from test/backend-jflex/in/metalexer/component.mll [188, 6]
t_END_CHAR_CLASS = \u0043 //from test/backend-jflex/in/metalexer/component.mll [230, 6]
t_END_DECL_REGION = \u0055 //from test/backend-jflex/in/metalexer/component.mll [125, 6]
t_END_DELETE_DIRECTIVE = \u0057 //from test/backend-jflex/in/metalexer/component.mll [155, 6]
t_END_IDENTIFIER_DIRECTIVE = \u0059 //from test/backend-jflex/in/metalexer/component.mll [202, 6]
t_END_INIT_REGION = \u0061 //from test/backend-jflex/in/metalexer/component.mll [132, 6]
t_END_MACRO_INVOC = \u0063 //from test/backend-jflex/in/metalexer/component.mll [209, 6]
t_END_METATOKEN_DECL = \u0065 //from test/backend-jflex/in/metalexer/component.mll [169, 6]
t_END_OPEN_RULE_GROUP = \u0067 //from test/backend-jflex/in/metalexer/component.mll [176, 6]
t_END_OPTION_SECTION = \u004a //from test/backend-jflex/in/metalexer/component.mll [111, 6]
t_END_REPETITION_SPEC = \u0069 //from test/backend-jflex/in/metalexer/component.mll [216, 6]
t_END_RULE_SECTION = \u0053 //from test/backend-jflex/in/metalexer/component.mll [148, 6]
t_END_STRING = \u006d //from test/backend-jflex/in/metalexer/component.mll [195, 6]
t_END_STRING_DIRECTIVE = \u006b //from test/backend-jflex/in/metalexer/component.mll [139, 6]
t_START_ACTION = \u0051 //from test/backend-jflex/in/metalexer/component.mll [161, 8]
t_START_APPEND_REGION = \u0047 //from test/backend-jflex/in/metalexer/component.mll [117, 8]
t_START_BRACKETED_STATE_LIST = \u0050 //from test/backend-jflex/in/metalexer/component.mll [222, 8]
t_START_BRACKET_COMMENT = \u0037 //from test/backend-jflex/in/metalexer/component.mll [187, 8]
t_START_CHAR_CLASS = \u004b //from test/backend-jflex/in/metalexer/component.mll [229, 8]
t_START_DECL_REGION = \u0045 //from test/backend-jflex/in/metalexer/component.mll [124, 8]
t_START_DELETE_DIRECTIVE = \u0052 //from test/backend-jflex/in/metalexer/component.mll [154, 8]
t_START_IDENTIFIER_DIRECTIVE = \u004d //from test/backend-jflex/in/metalexer/component.mll [201, 8]
t_START_INIT_REGION = \u0046 //from test/backend-jflex/in/metalexer/component.mll [131, 8]
t_START_MACRO_INVOC = \u0048 //from test/backend-jflex/in/metalexer/component.mll [208, 8]
t_START_REPETITION_SPEC = \u0049 //from test/backend-jflex/in/metalexer/component.mll [215, 8]
t_START_STRING = \u004c //from test/backend-jflex/in/metalexer/component.mll [194, 8]
t_START_STRING_DIRECTIVE = \u004e //from test/backend-jflex/in/metalexer/component.mll [138, 8]

//Regions
r_action = \u0030 //from test/backend-jflex/in/metalexer/component.mll [168, 8]
r_bracketed_state_list = \u0039 //from test/backend-jflex/in/metalexer/component.mll [175, 8]
r_component_option_section = \u0044 //from test/backend-jflex/in/metalexer/component.mll [147, 8]

%%

//// START PATTERNS ////////////////////////////////////////////////////////////

//no embeddings completed (i.e. now in start component 'base')
<BASE> {
    //start patterns from embeddings with host 'base'
    
    //from test/backend-jflex/in/metalexer/component.mll [106, 1]
    //start pattern for embedding 'option_section'
    /* Omitting empty pattern (handled elsewhere)
    ^ { /*System.err.println("call notifyLexer(option_section)");*/ saveStateAndTransition(e_option_section); notifyLexer(/*option_section*/ 0); }
    */
    
    //from test/backend-jflex/in/metalexer/component.mll [143, 1]
    //start pattern for embedding 'rule_section'
    {r_component_option_section} { /*System.err.println("call notifyLexer(rule_section)");*/ saveStateAndTransition(e_rule_section); notifyLexer(/*rule_section*/ 5); }
}

//just completed an embedding with guest 'metatoken_decl' (i.e. now in component 'metatoken_decl')
<e_rule_metatoken> {
    //start patterns from embeddings with host 'metatoken_decl'
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
}

//just completed an embedding with guest 'bracketed_state_list' (i.e. now in component 'bracketed_state_list')
<e_bracketed_state_list> {
    //start patterns from embeddings with host 'bracketed_state_list'
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
}

//just completed an embedding with guest 'component_rule_section' (i.e. now in component 'component_rule_section')
<e_rule_section> {
    //start patterns from embeddings with host 'component_rule_section'
    
    //from test/backend-jflex/in/metalexer/component.mll [150, 1]
    //start pattern for embedding 'rule_delete_directive'
    {t_START_DELETE_DIRECTIVE} { /*System.err.println("call notifyLexer(rule_delete_directive)");*/ saveStateAndTransition(e_rule_delete_directive); notifyLexer(/*rule_delete_directive*/ 6); }
    
    //from test/backend-jflex/in/metalexer/component.mll [157, 1]
    //start pattern for embedding 'rule_action'
    {t_START_ACTION} { /*System.err.println("call notifyLexer(rule_action)");*/ saveStateAndTransition(e_rule_action); notifyLexer(/*rule_action*/ 7); }
    
    //from test/backend-jflex/in/metalexer/component.mll [164, 1]
    //start pattern for embedding 'rule_metatoken'
    {r_action} { /*System.err.println("call notifyLexer(rule_metatoken)");*/ saveStateAndTransition(e_rule_metatoken); notifyLexer(/*rule_metatoken*/ 8); }
    
    //from test/backend-jflex/in/metalexer/component.mll [171, 1]
    //start pattern for embedding 'open_rule_group'
    {r_bracketed_state_list} { /*System.err.println("call notifyLexer(open_rule_group)");*/ saveStateAndTransition(e_open_rule_group); notifyLexer(/*open_rule_group*/ 9); }
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
    
    //from test/backend-jflex/in/metalexer/component.mll [190, 1]
    //start pattern for embedding 'string'
    {t_START_STRING} { /*System.err.println("call notifyLexer(string)");*/ saveStateAndTransition(e_string); notifyLexer(/*string*/ 11); }
    
    //from test/backend-jflex/in/metalexer/component.mll [197, 1]
    //start pattern for embedding 'identifier_directive'
    {t_START_IDENTIFIER_DIRECTIVE} { /*System.err.println("call notifyLexer(identifier_directive)");*/ saveStateAndTransition(e_identifier_directive); notifyLexer(/*identifier_directive*/ 12); }
    
    //from test/backend-jflex/in/metalexer/component.mll [204, 1]
    //start pattern for embedding 'macro_invoc'
    {t_START_MACRO_INVOC} { /*System.err.println("call notifyLexer(macro_invoc)");*/ saveStateAndTransition(e_macro_invoc); notifyLexer(/*macro_invoc*/ 13); }
    
    //from test/backend-jflex/in/metalexer/component.mll [211, 1]
    //start pattern for embedding 'repetition_spec'
    {t_START_REPETITION_SPEC} { /*System.err.println("call notifyLexer(repetition_spec)");*/ saveStateAndTransition(e_repetition_spec); notifyLexer(/*repetition_spec*/ 14); }
    
    //from test/backend-jflex/in/metalexer/component.mll [218, 1]
    //start pattern for embedding 'bracketed_state_list'
    {t_START_BRACKETED_STATE_LIST} { /*System.err.println("call notifyLexer(bracketed_state_list)");*/ saveStateAndTransition(e_bracketed_state_list); notifyLexer(/*bracketed_state_list*/ 15); }
    
    //from test/backend-jflex/in/metalexer/component.mll [225, 1]
    //start pattern for embedding 'char_class'
    {t_START_CHAR_CLASS} { /*System.err.println("call notifyLexer(char_class)");*/ saveStateAndTransition(e_char_class); notifyLexer(/*char_class*/ 16); }
}

//just completed an embedding with guest 'identifier_directive' (i.e. now in component 'identifier_directive')
<e_identifier_directive> {
    //start patterns from embeddings with host 'identifier_directive'
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
}

//just completed an embedding with guest 'component_option_section' (i.e. now in component 'component_option_section')
<e_option_section> {
    //start patterns from embeddings with host 'component_option_section'
    
    //from test/backend-jflex/in/metalexer/component.mll [113, 1]
    //start pattern for embedding 'option_append'
    {t_START_APPEND_REGION} { /*System.err.println("call notifyLexer(option_append)");*/ saveStateAndTransition(e_option_append); notifyLexer(/*option_append*/ 1); }
    
    //from test/backend-jflex/in/metalexer/component.mll [120, 1]
    //start pattern for embedding 'option_decl'
    {t_START_DECL_REGION} { /*System.err.println("call notifyLexer(option_decl)");*/ saveStateAndTransition(e_option_decl); notifyLexer(/*option_decl*/ 2); }
    
    //from test/backend-jflex/in/metalexer/component.mll [127, 1]
    //start pattern for embedding 'option_init'
    {t_START_INIT_REGION} { /*System.err.println("call notifyLexer(option_init)");*/ saveStateAndTransition(e_option_init); notifyLexer(/*option_init*/ 3); }
    
    //from test/backend-jflex/in/metalexer/component.mll [134, 1]
    //start pattern for embedding 'option_string_directive'
    {t_START_STRING_DIRECTIVE} { /*System.err.println("call notifyLexer(option_string_directive)");*/ saveStateAndTransition(e_option_string_directive); notifyLexer(/*option_string_directive*/ 4); }
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
    
    //from test/backend-jflex/in/metalexer/component.mll [190, 1]
    //start pattern for embedding 'string'
    {t_START_STRING} { /*System.err.println("call notifyLexer(string)");*/ saveStateAndTransition(e_string); notifyLexer(/*string*/ 11); }
    
    //from test/backend-jflex/in/metalexer/component.mll [197, 1]
    //start pattern for embedding 'identifier_directive'
    {t_START_IDENTIFIER_DIRECTIVE} { /*System.err.println("call notifyLexer(identifier_directive)");*/ saveStateAndTransition(e_identifier_directive); notifyLexer(/*identifier_directive*/ 12); }
    
    //from test/backend-jflex/in/metalexer/component.mll [204, 1]
    //start pattern for embedding 'macro_invoc'
    {t_START_MACRO_INVOC} { /*System.err.println("call notifyLexer(macro_invoc)");*/ saveStateAndTransition(e_macro_invoc); notifyLexer(/*macro_invoc*/ 13); }
    
    //from test/backend-jflex/in/metalexer/component.mll [211, 1]
    //start pattern for embedding 'repetition_spec'
    {t_START_REPETITION_SPEC} { /*System.err.println("call notifyLexer(repetition_spec)");*/ saveStateAndTransition(e_repetition_spec); notifyLexer(/*repetition_spec*/ 14); }
    
    //from test/backend-jflex/in/metalexer/component.mll [225, 1]
    //start pattern for embedding 'char_class'
    {t_START_CHAR_CLASS} { /*System.err.println("call notifyLexer(char_class)");*/ saveStateAndTransition(e_char_class); notifyLexer(/*char_class*/ 16); }
}

//just completed an embedding with guest 'string_directive' (i.e. now in component 'string_directive')
<e_option_string_directive> {
    //start patterns from embeddings with host 'string_directive'
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
    
    //from test/backend-jflex/in/metalexer/component.mll [190, 1]
    //start pattern for embedding 'string'
    {t_START_STRING} { /*System.err.println("call notifyLexer(string)");*/ saveStateAndTransition(e_string); notifyLexer(/*string*/ 11); }
}

//just completed an embedding with guest 'bracket_comment' (i.e. now in component 'bracket_comment')
<e_comments> {
    //start patterns from embeddings with host 'bracket_comment'
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
}

//just completed an embedding with guest 'delete_directive' (i.e. now in component 'delete_directive')
<e_rule_delete_directive> {
    //start patterns from embeddings with host 'delete_directive'
    
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 10); }
    
    //from test/backend-jflex/in/metalexer/component.mll [190, 1]
    //start pattern for embedding 'string'
    {t_START_STRING} { /*System.err.println("call notifyLexer(string)");*/ saveStateAndTransition(e_string); notifyLexer(/*string*/ 11); }
    
    //from test/backend-jflex/in/metalexer/component.mll [204, 1]
    //start pattern for embedding 'macro_invoc'
    {t_START_MACRO_INVOC} { /*System.err.println("call notifyLexer(macro_invoc)");*/ saveStateAndTransition(e_macro_invoc); notifyLexer(/*macro_invoc*/ 13); }
    
    //from test/backend-jflex/in/metalexer/component.mll [211, 1]
    //start pattern for embedding 'repetition_spec'
    {t_START_REPETITION_SPEC} { /*System.err.println("call notifyLexer(repetition_spec)");*/ saveStateAndTransition(e_repetition_spec); notifyLexer(/*repetition_spec*/ 14); }
    
    //from test/backend-jflex/in/metalexer/component.mll [218, 1]
    //start pattern for embedding 'bracketed_state_list'
    {t_START_BRACKETED_STATE_LIST} { /*System.err.println("call notifyLexer(bracketed_state_list)");*/ saveStateAndTransition(e_bracketed_state_list); notifyLexer(/*bracketed_state_list*/ 15); }
    
    //from test/backend-jflex/in/metalexer/component.mll [225, 1]
    //start pattern for embedding 'char_class'
    {t_START_CHAR_CLASS} { /*System.err.println("call notifyLexer(char_class)");*/ saveStateAndTransition(e_char_class); notifyLexer(/*char_class*/ 16); }
}

//// END PATTERNS //////////////////////////////////////////////////////////////

<e_option_section> {
    //from test/backend-jflex/in/metalexer/component.mll [106, 1]
    //end pattern for embedding 'option_section'
    {t_END_OPTION_SECTION} { /*System.err.println("call notifyLexer(restore from option_section)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_append> {
    //from test/backend-jflex/in/metalexer/component.mll [113, 1]
    //end pattern for embedding 'option_append'
    {t_END_APPEND_REGION} { /*System.err.println("call notifyLexer(restore from option_append)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_decl> {
    //from test/backend-jflex/in/metalexer/component.mll [120, 1]
    //end pattern for embedding 'option_decl'
    {t_END_DECL_REGION} { /*System.err.println("call notifyLexer(restore from option_decl)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_init> {
    //from test/backend-jflex/in/metalexer/component.mll [127, 1]
    //end pattern for embedding 'option_init'
    {t_END_INIT_REGION} { /*System.err.println("call notifyLexer(restore from option_init)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_string_directive> {
    //from test/backend-jflex/in/metalexer/component.mll [134, 1]
    //end pattern for embedding 'option_string_directive'
    {t_END_STRING_DIRECTIVE} { /*System.err.println("call notifyLexer(restore from option_string_directive)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_rule_section> {
    //from test/backend-jflex/in/metalexer/component.mll [143, 1]
    //end pattern for embedding 'rule_section'
    {t_END_RULE_SECTION} { /*System.err.println("call notifyLexer(restore from rule_section)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_rule_delete_directive> {
    //from test/backend-jflex/in/metalexer/component.mll [150, 1]
    //end pattern for embedding 'rule_delete_directive'
    {t_END_DELETE_DIRECTIVE} { /*System.err.println("call notifyLexer(restore from rule_delete_directive)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_rule_action> {
    //from test/backend-jflex/in/metalexer/component.mll [157, 1]
    //end pattern for embedding 'rule_action'
    {t_END_ACTION} { /*System.err.println("call notifyLexer(restore from rule_action)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_rule_metatoken> {
    //from test/backend-jflex/in/metalexer/component.mll [164, 1]
    //end pattern for embedding 'rule_metatoken'
    {t_END_METATOKEN_DECL} { /*System.err.println("call notifyLexer(restore from rule_metatoken)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_open_rule_group> {
    //from test/backend-jflex/in/metalexer/component.mll [171, 1]
    //end pattern for embedding 'open_rule_group'
    {t_END_OPEN_RULE_GROUP} { /*System.err.println("call notifyLexer(restore from open_rule_group)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_comments> {
    //from test/backend-jflex/in/metalexer/component.mll [181, 1]
    //end pattern for embedding 'comments'
    {t_END_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(restore from comments)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_string> {
    //from test/backend-jflex/in/metalexer/component.mll [190, 1]
    //end pattern for embedding 'string'
    {t_END_STRING} { /*System.err.println("call notifyLexer(restore from string)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_identifier_directive> {
    //from test/backend-jflex/in/metalexer/component.mll [197, 1]
    //end pattern for embedding 'identifier_directive'
    {t_END_IDENTIFIER_DIRECTIVE} { /*System.err.println("call notifyLexer(restore from identifier_directive)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_macro_invoc> {
    //from test/backend-jflex/in/metalexer/component.mll [204, 1]
    //end pattern for embedding 'macro_invoc'
    {t_END_MACRO_INVOC} { /*System.err.println("call notifyLexer(restore from macro_invoc)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_repetition_spec> {
    //from test/backend-jflex/in/metalexer/component.mll [211, 1]
    //end pattern for embedding 'repetition_spec'
    {t_END_REPETITION_SPEC} { /*System.err.println("call notifyLexer(restore from repetition_spec)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_bracketed_state_list> {
    //from test/backend-jflex/in/metalexer/component.mll [218, 1]
    //end pattern for embedding 'bracketed_state_list'
    {t_END_BRACKETED_STATE_LIST} { /*System.err.println("call notifyLexer(restore from bracketed_state_list)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_char_class> {
    //from test/backend-jflex/in/metalexer/component.mll [225, 1]
    //end pattern for embedding 'char_class'
    {t_END_CHAR_CLASS} { /*System.err.println("call notifyLexer(restore from char_class)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

//// SHARED CLEAN-UP PATTERNS //////////////////////////////////////////////////

(.|\n) { /*System.err.println("Ignoring '" + Integer.toHexString(yytext().charAt(0)) + "' in state " + yystate());*/ /*consume and ignore*/ }
<<EOF>> { return null; } //break out of infinite loop

