package test.jflex.metalexer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
%%
%public
%final
%unicode
%class LayoutScanner_Meta
%function start
%type Object

%{
    java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
    
    void saveStateAndTransition(int newState) {
        stateStack.push(yystate());
        yybegin(newState);
    }
    
    void restoreState() {
        yybegin(stateStack.pop());
    }
%}

%{
    private Transition transition = null;
    
    private void notifyLexer(int embeddingNum) {
        //System.err.println("in notifyLexer(" + embeddingNum + "," + yytext() + ")");
        this.transition = new Transition(embeddingNum, yytext());
    }
    
    public Transition checkForTransition() {
        Transition tmp = transition;
        transition = null;
        return tmp;
    }
%}

%{
    public static class Transition {
        private final int embeddingNum;
        private final String match;
        
        public Transition(int embeddingNum, String match) {
            this.embeddingNum = embeddingNum;
            this.match = match;
        }
        
        public int getEmbeddingNum() { return embeddingNum; }
        
        public String getMatch() { return match; }
    }
%}

%init{
    //Start in state BASE
    yybegin(BASE);
    
    //Transition through states reachable by pure BOF patterns
    saveStateAndTransition(e_local_header_section); 
%init}

%state BASE
//from test/backend-jflex/in/metalexer/layout.mll [101, 1]
%state e_local_header_section
//from test/backend-jflex/in/metalexer/layout.mll [110, 1]
%state e_inherited_header_section
//from test/backend-jflex/in/metalexer/layout.mll [119, 1]
%state e_option_section
//from test/backend-jflex/in/metalexer/layout.mll [126, 1]
%state e_option_decl
//from test/backend-jflex/in/metalexer/layout.mll [133, 1]
%state e_option_init
//from test/backend-jflex/in/metalexer/layout.mll [140, 1]
%state e_option_string_directive
//from test/backend-jflex/in/metalexer/layout.mll [149, 1]
%state e_rule_section
//from test/backend-jflex/in/metalexer/layout.mll [156, 1]
%state e_metapattern_directive
//from test/backend-jflex/in/metalexer/layout.mll [163, 1]
%state e_pair_directive
//from test/backend-jflex/in/metalexer/layout.mll [172, 1]
%state e_comments
//from test/backend-jflex/in/metalexer/layout.mll [181, 1]
%state e_identifier_directive
//from test/backend-jflex/in/metalexer/layout.mll [190, 1]
%state e_string

//Meta-tokens
t_END_BRACKET_COMMENT = \u0034 //from test/backend-jflex/in/metalexer/layout.mll [179, 6]
t_END_DECL_REGION = \u0036 //from test/backend-jflex/in/metalexer/layout.mll [131, 6]
t_END_IDENTIFIER_DIRECTIVE = \u0038 //from test/backend-jflex/in/metalexer/layout.mll [186, 6]
t_END_INHERITED_HEADER = \u0041 //from test/backend-jflex/in/metalexer/layout.mll [115, 6]
t_END_INIT_REGION = \u0043 //from test/backend-jflex/in/metalexer/layout.mll [138, 6]
t_END_LOCAL_HEADER = \u004f //from test/backend-jflex/in/metalexer/layout.mll [106, 6]
t_END_METAPATTERN_DIRECTIVE = \u0051 //from test/backend-jflex/in/metalexer/layout.mll [161, 6]
t_END_OPTION_SECTION = \u0049 //from test/backend-jflex/in/metalexer/layout.mll [124, 6]
t_END_PAIR_DIRECTIVE = \u0053 //from test/backend-jflex/in/metalexer/layout.mll [168, 6]
t_END_RULE_SECTION = \u004d //from test/backend-jflex/in/metalexer/layout.mll [154, 6]
t_END_STRING = \u0055 //from test/backend-jflex/in/metalexer/layout.mll [195, 6]
t_END_STRING_DIRECTIVE = \u0057 //from test/backend-jflex/in/metalexer/layout.mll [145, 6]
t_START_BRACKET_COMMENT = \u0033 //from test/backend-jflex/in/metalexer/layout.mll [178, 8]
t_START_DECL_REGION = \u0045 //from test/backend-jflex/in/metalexer/layout.mll [130, 8]
t_START_IDENTIFIER_DIRECTIVE = \u0047 //from test/backend-jflex/in/metalexer/layout.mll [185, 8]
t_START_INIT_REGION = \u0046 //from test/backend-jflex/in/metalexer/layout.mll [137, 8]
t_START_METAPATTERN_DIRECTIVE = \u004c //from test/backend-jflex/in/metalexer/layout.mll [160, 8]
t_START_PAIR_DIRECTIVE = \u004b //from test/backend-jflex/in/metalexer/layout.mll [167, 8]
t_START_STRING = \u0058 //from test/backend-jflex/in/metalexer/layout.mll [194, 8]
t_START_STRING_DIRECTIVE = \u0048 //from test/backend-jflex/in/metalexer/layout.mll [144, 8]

//Regions
r_inherited_header = \u0039 //from test/backend-jflex/in/metalexer/layout.mll [123, 8]
r_layout_option_section = \u0044 //from test/backend-jflex/in/metalexer/layout.mll [153, 8]
r_local_header = \u004e //from test/backend-jflex/in/metalexer/layout.mll [114, 8]

%%

//// START PATTERNS ////////////////////////////////////////////////////////////

//no embeddings completed (i.e. now in start component 'base')
<BASE> {
    //start patterns from embeddings with host 'base'
    
    //from test/backend-jflex/in/metalexer/layout.mll [101, 1]
    //start pattern for embedding 'local_header_section'
    /* Omitting empty pattern (handled elsewhere)
    ^ { /*System.err.println("call notifyLexer(local_header_section)");*/ saveStateAndTransition(e_local_header_section); notifyLexer(/*local_header_section*/ 0); }
    */
    
    //from test/backend-jflex/in/metalexer/layout.mll [110, 1]
    //start pattern for embedding 'inherited_header_section'
    {r_local_header} { /*System.err.println("call notifyLexer(inherited_header_section)");*/ saveStateAndTransition(e_inherited_header_section); notifyLexer(/*inherited_header_section*/ 1); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [119, 1]
    //start pattern for embedding 'option_section'
    {r_inherited_header} { /*System.err.println("call notifyLexer(option_section)");*/ saveStateAndTransition(e_option_section); notifyLexer(/*option_section*/ 2); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [149, 1]
    //start pattern for embedding 'rule_section'
    {r_layout_option_section} { /*System.err.println("call notifyLexer(rule_section)");*/ saveStateAndTransition(e_rule_section); notifyLexer(/*rule_section*/ 6); }
}

//just completed an embedding with guest 'layout_rule_section' (i.e. now in component 'layout_rule_section')
<e_rule_section> {
    //start patterns from embeddings with host 'layout_rule_section'
    
    //from test/backend-jflex/in/metalexer/layout.mll [156, 1]
    //start pattern for embedding 'metapattern_directive'
    {t_START_METAPATTERN_DIRECTIVE} { /*System.err.println("call notifyLexer(metapattern_directive)");*/ saveStateAndTransition(e_metapattern_directive); notifyLexer(/*metapattern_directive*/ 7); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [163, 1]
    //start pattern for embedding 'pair_directive'
    {t_START_PAIR_DIRECTIVE} { /*System.err.println("call notifyLexer(pair_directive)");*/ saveStateAndTransition(e_pair_directive); notifyLexer(/*pair_directive*/ 8); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 9); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [181, 1]
    //start pattern for embedding 'identifier_directive'
    {t_START_IDENTIFIER_DIRECTIVE} { /*System.err.println("call notifyLexer(identifier_directive)");*/ saveStateAndTransition(e_identifier_directive); notifyLexer(/*identifier_directive*/ 10); }
}

//just completed an embedding with guest 'layout_option_section' (i.e. now in component 'layout_option_section')
<e_option_section> {
    //start patterns from embeddings with host 'layout_option_section'
    
    //from test/backend-jflex/in/metalexer/layout.mll [126, 1]
    //start pattern for embedding 'option_decl'
    {t_START_DECL_REGION} { /*System.err.println("call notifyLexer(option_decl)");*/ saveStateAndTransition(e_option_decl); notifyLexer(/*option_decl*/ 3); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [133, 1]
    //start pattern for embedding 'option_init'
    {t_START_INIT_REGION} { /*System.err.println("call notifyLexer(option_init)");*/ saveStateAndTransition(e_option_init); notifyLexer(/*option_init*/ 4); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [140, 1]
    //start pattern for embedding 'option_string_directive'
    {t_START_STRING_DIRECTIVE} { /*System.err.println("call notifyLexer(option_string_directive)");*/ saveStateAndTransition(e_option_string_directive); notifyLexer(/*option_string_directive*/ 5); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 9); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [181, 1]
    //start pattern for embedding 'identifier_directive'
    {t_START_IDENTIFIER_DIRECTIVE} { /*System.err.println("call notifyLexer(identifier_directive)");*/ saveStateAndTransition(e_identifier_directive); notifyLexer(/*identifier_directive*/ 10); }
}

//just completed an embedding with guest 'metapattern_directive' (i.e. now in component 'metapattern_directive')
<e_metapattern_directive> {
    //start patterns from embeddings with host 'metapattern_directive'
    
    //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 9); }
}

//just completed an embedding with guest 'string_directive' (i.e. now in component 'string_directive')
<e_option_string_directive> {
    //start patterns from embeddings with host 'string_directive'
    
    //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 9); }
    
    //from test/backend-jflex/in/metalexer/layout.mll [190, 1]
    //start pattern for embedding 'string'
    {t_START_STRING} { /*System.err.println("call notifyLexer(string)");*/ saveStateAndTransition(e_string); notifyLexer(/*string*/ 11); }
}

//just completed an embedding with guest 'identifier_directive' (i.e. now in component 'identifier_directive')
<e_identifier_directive> {
    //start patterns from embeddings with host 'identifier_directive'
    
    //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 9); }
}

//just completed an embedding with guest 'bracket_comment' (i.e. now in component 'bracket_comment')
<e_comments> {
    //start patterns from embeddings with host 'bracket_comment'
    
    //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
    //start pattern for embedding 'comments'
    {t_START_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(comments)");*/ saveStateAndTransition(e_comments); notifyLexer(/*comments*/ 9); }
}

//// END PATTERNS //////////////////////////////////////////////////////////////

<e_local_header_section> {
    //from test/backend-jflex/in/metalexer/layout.mll [101, 1]
    //end pattern for embedding 'local_header_section'
    {t_END_LOCAL_HEADER} { /*System.err.println("call notifyLexer(restore from local_header_section)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_inherited_header_section> {
    //from test/backend-jflex/in/metalexer/layout.mll [110, 1]
    //end pattern for embedding 'inherited_header_section'
    {t_END_INHERITED_HEADER} { /*System.err.println("call notifyLexer(restore from inherited_header_section)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_section> {
    //from test/backend-jflex/in/metalexer/layout.mll [119, 1]
    //end pattern for embedding 'option_section'
    {t_END_OPTION_SECTION} { /*System.err.println("call notifyLexer(restore from option_section)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_decl> {
    //from test/backend-jflex/in/metalexer/layout.mll [126, 1]
    //end pattern for embedding 'option_decl'
    {t_END_DECL_REGION} { /*System.err.println("call notifyLexer(restore from option_decl)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_init> {
    //from test/backend-jflex/in/metalexer/layout.mll [133, 1]
    //end pattern for embedding 'option_init'
    {t_END_INIT_REGION} { /*System.err.println("call notifyLexer(restore from option_init)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_option_string_directive> {
    //from test/backend-jflex/in/metalexer/layout.mll [140, 1]
    //end pattern for embedding 'option_string_directive'
    {t_END_STRING_DIRECTIVE} { /*System.err.println("call notifyLexer(restore from option_string_directive)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_rule_section> {
    //from test/backend-jflex/in/metalexer/layout.mll [149, 1]
    //end pattern for embedding 'rule_section'
    {t_END_RULE_SECTION} { /*System.err.println("call notifyLexer(restore from rule_section)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_metapattern_directive> {
    //from test/backend-jflex/in/metalexer/layout.mll [156, 1]
    //end pattern for embedding 'metapattern_directive'
    {t_END_METAPATTERN_DIRECTIVE} { /*System.err.println("call notifyLexer(restore from metapattern_directive)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_pair_directive> {
    //from test/backend-jflex/in/metalexer/layout.mll [163, 1]
    //end pattern for embedding 'pair_directive'
    {t_END_PAIR_DIRECTIVE} { /*System.err.println("call notifyLexer(restore from pair_directive)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_comments> {
    //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
    //end pattern for embedding 'comments'
    {t_END_BRACKET_COMMENT} { /*System.err.println("call notifyLexer(restore from comments)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_identifier_directive> {
    //from test/backend-jflex/in/metalexer/layout.mll [181, 1]
    //end pattern for embedding 'identifier_directive'
    {t_END_IDENTIFIER_DIRECTIVE} { /*System.err.println("call notifyLexer(restore from identifier_directive)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

<e_string> {
    //from test/backend-jflex/in/metalexer/layout.mll [190, 1]
    //end pattern for embedding 'string'
    {t_END_STRING} { /*System.err.println("call notifyLexer(restore from string)");*/ restoreState(); notifyLexer(/*restore previous*/ -1); }
}

//// SHARED CLEAN-UP PATTERNS //////////////////////////////////////////////////

(.|\n) { /*System.err.println("Ignoring '" + Integer.toHexString(yytext().charAt(0)) + "' in state " + yystate());*/ /*consume and ignore*/ }
<<EOF>> { return null; } //break out of infinite loop

