package test.jflex.natlab;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
%%
%public
%final
%unicode
%class NaiveNatlabScanner_Meta
%function start
%type Object

%{
    java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
    
    void saveStateAndTransition(int newState) {
        stateStack.push(yystate());
        yybegin(newState);
    }
    
    void restoreState() {
        yybegin(stateStack.pop());
    }
%}

%{
    private Transition transition = null;
    
    private void notifyLexer(int embeddingNum) {
        //System.err.println("in notifyLexer(" + embeddingNum + "," + yytext() + ")");
        this.transition = new Transition(embeddingNum, yytext());
    }
    
    public Transition checkForTransition() {
        Transition tmp = transition;
        transition = null;
        return tmp;
    }
%}

%{
    public static class Transition {
        private final int embeddingNum;
        private final String match;
        
        public Transition(int embeddingNum, String match) {
            this.embeddingNum = embeddingNum;
            this.match = match;
        }
        
        public int getEmbeddingNum() { return embeddingNum; }
        
        public String getMatch() { return match; }
    }
%}

%init{
    //Start in state BASE
    yybegin(BASE);
    
    //Transition through states reachable by pure BOF patterns
%init}

%state BASE

//Meta-tokens

//Regions

%%

//// START PATTERNS ////////////////////////////////////////////////////////////

//// END PATTERNS //////////////////////////////////////////////////////////////

//// SHARED CLEAN-UP PATTERNS //////////////////////////////////////////////////

(.|\n) { /*System.err.println("Ignoring '" + Integer.toHexString(yytext().charAt(0)) + "' in state " + yystate());*/ /*consume and ignore*/ }
<<EOF>> { return null; } //break out of infinite loop

