/* The following code was generated by JFlex 1.4.1 on 2/19/09 5:36 PM */

package test.jflex.annotations;
import test.jflex.annotations.AnnotationParser.Terminals;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Symbol;
import beaver.Scanner;

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 2/19/09 5:36 PM from the specification file
 * <tt>test/backend-jflex/out/natlab/annotations/annotations.flex</tt>
 */
public final class AnnotationScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int annotations_YYINITIAL_STATE = 2;
  public static final int YYINITIAL = 0;
  public static final int EXTRA_RETURN = 1;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\6\1\0\2\1\22\0\1\1\2\0\1\12\1\25"+
    "\1\0\1\32\1\0\1\15\1\16\1\23\1\33\1\11\1\26\1\7"+
    "\1\5\1\4\11\3\1\14\1\10\1\0\1\13\1\27\1\30\1\24"+
    "\32\2\1\21\1\0\1\22\1\0\1\2\1\0\32\2\1\17\1\31"+
    "\1\20\uff82\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\2\1\3\1\4\2\5\1\2\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33";

  private static int [] zzUnpackAction() {
    int [] result = new int[32];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\34\0\70\0\0\0\0\0\124\0\160\0\214"+
    "\0\0\0\250\0\0\0\0\0\0\0\0\0\0\0\0"+
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"+
    "\0\160\0\304\0\0\0\0\0\0\0\0\0\340\0\0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[32];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\34\0\34\4\1\5\1\6\1\7\1\10\1\11\1\12"+
    "\1\6\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\5\1\33\1\34\1\35\1\36\1\0\1\6"+
    "\4\0\1\6\27\0\3\7\20\0\1\7\11\0\2\10"+
    "\34\0\1\37\55\0\1\40\4\0\6\37\1\0\25\37";

  private static int [] zzUnpackTrans() {
    int [] result = new int[252];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\2\0\2\11\3\1\1\11\1\1\16\11\2\1"+
    "\4\11\1\1\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[32];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
    private final StateClass_annotations state_annotations = new StateClass_annotations();
    private class StateClass_annotations {
        private StateClass_annotations() {
            metaLexerThread.start();
            
            
            //from test/backend-jflex/in/natlab/annotations.mll [11, 8]
            yybegin(annotations_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(inst_annotations, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            
            restartAppendBuf();
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[0];
        private final CompClass_annotations inst_annotations = new CompClass_annotations();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                //System.err.println("yypushback(1)");
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private boolean stopped = false;
        
        public void stop() {
            stopped = true;
            pipe.writeFinal('\n');
            boolean joined = false;
            while(!joined) {
                try {
                    metaLexerThread.join();
                    joined = true;
                } catch(InterruptedException e) {}
            }
        }
        
        private final Pipe pipe = new Pipe();
        private final AnnotationScanner_Meta metalexer = new AnnotationScanner_Meta(pipe);
        private final Thread metaLexerThread = new Thread(new Runnable() {
            public void run() {
                try {
                    metalexer.start();
                } catch(java.io.IOException e) {
                    //unrecoverable
                    e.printStackTrace();
                }
            }}, "MetaLexerThread");
        
        private AnnotationScanner_Meta.Transition sendMTok(char mtok) {
            if(stopped) {
                throw new IllegalStateException("No meta-tokens may be sent after stop() has been called.");
            }
            //System.err.println("sendMTok(" + Integer.toHexString(mtok) + ")");
            pipe.write(mtok);
            return metalexer.checkForTransition();
        }
        
        public void processMTok(char mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                //System.err.println("Pair filter caught: " + Integer.toHexString(mtok));
                return; //don't send character if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            AnnotationScanner_Meta.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                next = null;
                if(endOfEmbedding) {
                    char regionChar = currComp.getCharValue();
                    if(getCurrFilter().test(regionChar)) {
                        next = sendMTok(regionChar);
                    } else {
                        //System.err.println("Pair filter caught: " + Integer.toHexString(regionChar));
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract char getCharValue();
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
    private class CompClass_annotations extends ComponentInnerClass {
        
        public CompClass_annotations() {
        }
        
        private static final int YYINITIAL = annotations_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0030';
        }
        
        public Maybe<? extends Symbol> annotations_action_1() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [15, 5]
                return Maybe.Just(symbol(Terminals.DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_2() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [17, 5]
                return Maybe.Just(symbol(Terminals.STMT_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_3() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [18, 5]
                return Maybe.Just(symbol(Terminals.ELEMENT_SEPARATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_4() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [20, 5]
                return Maybe.Just(symbol(Terminals.SIZE_OF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_5() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [21, 5]
                return Maybe.Just(symbol(Terminals.EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_6() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [22, 5]
                return Maybe.Just(symbol(Terminals.HAS_TYPE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_7() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [24, 4]
                return Maybe.Just(symbol(Terminals.LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_8() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [25, 4]
                return Maybe.Just(symbol(Terminals.RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_9() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [26, 4]
                return Maybe.Just(symbol(Terminals.LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_10() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [27, 4]
                return Maybe.Just(symbol(Terminals.RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_11() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [28, 4]
                return Maybe.Just(symbol(Terminals.LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_12() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [29, 4]
                return Maybe.Just(symbol(Terminals.RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_13() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [31, 5]
                return Maybe.Just(symbol(Terminals.VARARG_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_14() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [32, 5]
                return Maybe.Just(symbol(Terminals.HANDLE_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_15() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [33, 5]
                return Maybe.Just(symbol(Terminals.TYPE_VAR_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_16() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [35, 6]
                return Maybe.Just(symbol(Terminals.ARROW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_17() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [36, 5]
                return Maybe.Just(symbol(Terminals.UNKNOWN_TYPE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_18() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [38, 5]
                return Maybe.Just(symbol(Terminals.UNION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_19() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [39, 5]
                return Maybe.Just(symbol(Terminals.INTERSECT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_20() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [41, 5]
                return Maybe.Just(symbol(Terminals.IS_SCALAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_21() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [42, 5]
                return Maybe.Just(symbol(Terminals.IS_NOT_SCALAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_22() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [46, 14]
                /* skip */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_23() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [47, 11]
                /* skip */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_24() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [49, 10]
                return Maybe.Just(symbol(Terminals.NUMBER, Integer.parseInt(yytext())));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_25() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [51, 14]
                return Maybe.Just(symbol(Terminals.IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_26() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [55, 9]
                error("Illegal character '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_27() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [56, 9]
                return Maybe.Just(symbol(Terminals.EOF));
            }
            return Maybe.Nothing();
        }
    }
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
        private final java.util.Set<Character> allOpenChars;
        private final java.util.List<Character> unclosedOpenChars; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Character, java.util.Set<Character>> pairMap, java.util.Set<Character> allOpenChars) {
            this.pairMap = pairMap;
            this.allOpenChars = allOpenChars;
            this.unclosedOpenChars = new java.util.ArrayList<Character>();
        }
        
        public static class Builder {
            private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
            private final java.util.Set<Character> allOpenChars;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Character, java.util.Set<Character>>();
                this.allOpenChars = new java.util.HashSet<Character>();
            }
            
            public Builder add(char open, char close) {
                allOpenChars.add(open);
                java.util.Set<Character> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Character>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenChars);
            }
        }
        
        public boolean test(char ch) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Character> correspondingOpens = pairMap.get(ch);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Character> it = unclosedOpenChars.iterator(); it.hasNext(); ) {
                    char open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenChars.contains(ch)) { //implies opening
                unclosedOpenChars.add(0, ch); //insert at beginning
            }
            return true;
        }
        
        public void clean(String chars) {
            for(char ch : new StringBuffer(chars).reverse().toString().toCharArray()) {
                if(unclosedOpenChars.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenChars.get(0) == ch) {
                    unclosedOpenChars.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenChars.clear();
        }
    }
    public class EmbeddingRecord {
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(ComponentInnerClass comp, PairFilter filter) {
            this.comp = comp;
            this.filter = filter;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
    public static class Pipe extends java.io.Reader {
        private final java.util.concurrent.locks.Lock monitorLock = new java.util.concurrent.locks.ReentrantLock();
        private final java.util.Queue<java.util.concurrent.locks.Condition> waitingForFirstRead = new java.util.LinkedList<java.util.concurrent.locks.Condition>();
        private java.util.Map<Thread, java.util.concurrent.locks.Condition> waitingForSecondRead = new java.util.HashMap<Thread, java.util.concurrent.locks.Condition>();
        
        private final java.util.Queue<Character> writeQueue = new java.util.LinkedList<Character>();
        private final java.util.concurrent.locks.Condition notEmpty = monitorLock.newCondition();
        
        private boolean closed = false;
        private boolean eof = false;
        
        public void write(char ch) {
            write(ch, false);
        }
        
        //NB: combine write() with eof() because the last write() will block, making it hard to call eof()
        public void writeFinal(char ch) {
            write(ch, true);
        }
        
        private void write(char ch, boolean isFinal) {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot write after the read end has been closed.");
                }
                if(eof) {
                    throw new IllegalStateException("Cannot write after EOF.");
                }
                if(isFinal) {
                    eof = true;
                }
                writeQueue.add(ch);
                java.util.concurrent.locks.Condition cond = monitorLock.newCondition();
                waitingForFirstRead.add(cond);
                notEmpty.signalAll();
                cond.awaitUninterruptibly();
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        //NB: ignore length and always write 1 byte (unless at EOF)
        public int read(char[] buf, int offset, int length) throws java.io.IOException {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot read after the read end has been closed.");
                }
                boolean freedWriter = freeNextWriter();
                while(!eof && writeQueue.isEmpty()) {
                    notEmpty.awaitUninterruptibly();
                    if(!freedWriter) {
                        freedWriter = freeNextWriter();
                    }
                }
                if(eof && writeQueue.isEmpty()) {
                    //no writers waiting, so none to free
                    return -1;
                }
                waitingForSecondRead.put(Thread.currentThread(), waitingForFirstRead.poll());
                buf[offset] = writeQueue.poll();
                return 1;
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        public void close() throws java.io.IOException {
            monitorLock.lock();
            try {
                closed = true;
                freeAllWriters();
            } finally {
                monitorLock.unlock();
            }
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private boolean freeNextWriter() {
            java.util.concurrent.locks.Condition cond = waitingForSecondRead.get(Thread.currentThread());
            if(cond != null) {
                cond.signal();
                waitingForSecondRead.remove(Thread.currentThread());
                return true;
            }
            return false;
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private void freeAllWriters() {
            for(java.util.concurrent.locks.Condition cond : waitingForSecondRead.values()) {
                cond.signal();
            }
            waitingForSecondRead.clear();
            for(java.util.concurrent.locks.Condition cond : waitingForFirstRead) {
                cond.signal();
            }
            waitingForFirstRead.clear();
        }
    }
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isJust() {
            return !isNothing();
        }
        public abstract boolean isNothing();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isNothing() {
                return false;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isNothing() {
                return true;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
    public void stop() {
        state_annotations.stop();
    }

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public AnnotationScanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public AnnotationScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 84) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol nextToken() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 21: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 28: break;
        case 12: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 29: break;
        case 27: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 30: break;
        case 26: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 31: break;
        case 7: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 32: break;
        case 1: 
          { //System.err.println("Reconsume char");
        yybegin(state_annotations.getPrevState());
        return state_annotations.getExtraReturn();
          }
        case 33: break;
        case 14: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 34: break;
        case 16: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 35: break;
        case 23: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 36: break;
        case 9: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 37: break;
        case 4: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 38: break;
        case 18: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 39: break;
        case 25: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 40: break;
        case 11: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 41: break;
        case 20: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 42: break;
        case 3: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 43: break;
        case 6: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 44: break;
        case 13: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 45: break;
        case 15: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 46: break;
        case 22: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 47: break;
        case 5: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 48: break;
        case 8: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 49: break;
        case 17: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 50: break;
        case 24: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 51: break;
        case 2: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 52: break;
        case 10: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 53: break;
        case 19: 
          { Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 54: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case annotations_YYINITIAL_STATE: {
              Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 33: break;
            case EXTRA_RETURN: {
              //System.err.println("Reconsume EOF");
        yybegin(state_annotations.getPrevState());
        return state_annotations.getExtraReturn();
            }
            case 34: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
