package annotations;
%%
import static annotations.AnnotationParser.Terminals.*;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

%layout annotations

%start annotations

%component annotations

%option class "%class AnnotationScanner"
%option function "%function nextToken"
%option visibility "%public"
%option final "%final"
%option extends "%extends Scanner"
%option encoding "%unicode"
%option line "%line"
%option col "%column"
%option type "%type Symbol"

%declare "Symbol symbol(short)"
%declare "Symbol symbol(short, Object)"
%declare "Symbol symbol(short, Object, int, int, int, int)"
%declare "void error(String) throws Scanner.Exception"
%declare "void error(String, int) throws Scanner.Exception"

%lexthrow "Scanner.Exception"

%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}

