/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrEq;
import ast.AST.ClassDecl;
import ast.AST.CollDecl;
import ast.AST.CollEq;
import ast.AST.Components;
import ast.AST.IdDecl;
import ast.AST.InhDecl;
import ast.AST.InhEq;
import ast.AST.InterfaceDecl;
import ast.AST.List;
import ast.AST.Node;
import ast.AST.Parameter;
import ast.AST.Rewrite;
import ast.AST.RewriteList;
import ast.AST.SynDecl;
import ast.AST.SynEq;
import ast.AST.TypeDecl;
import jastadd.JastAddCodeGen;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import jrag.AST.ASTCompilationUnit;
import jrag.AST.ASTExpression;
import jrag.AST.SimpleNode;
import jrag.ClassBodyObject;
import jrag.Doc;
import jrag.Unparse;

public class Grammar
extends ASTNode
implements Cloneable {
    public LinkedList compUnits = new LinkedList();
    private boolean collect_contributors_CollDecl_uses = false;
    protected boolean subclassMap_visited = false;
    protected boolean subclassMap_computed = false;
    protected HashMap subclassMap_value;
    protected boolean fatherMap_visited = false;
    protected boolean fatherMap_computed = false;
    protected HashMap fatherMap_value;
    protected boolean astErrors_visited = false;
    protected boolean collectAstErrors_visited = false;
    protected boolean roots_visited = false;
    protected Set lookup_String_visited = new HashSet(4);
    protected boolean root_visited = false;
    protected boolean errors_visited = false;
    protected boolean collectErrors_visited = false;
    protected boolean inhEqMap_visited = false;
    protected boolean inhEqMap_computed = false;
    protected HashMap inhEqMap_value;
    protected boolean rewriteAspects_visited = false;
    protected boolean rewriteAspects_computed = false;
    protected Collection rewriteAspects_value;

    public void flushCache() {
        super.flushCache();
        this.subclassMap_visited = false;
        this.subclassMap_computed = false;
        this.subclassMap_value = null;
        this.fatherMap_visited = false;
        this.fatherMap_computed = false;
        this.fatherMap_value = null;
        this.astErrors_visited = false;
        this.collectAstErrors_visited = false;
        this.roots_visited = false;
        this.lookup_String_visited = new HashSet(4);
        this.root_visited = false;
        this.errors_visited = false;
        this.collectErrors_visited = false;
        this.inhEqMap_visited = false;
        this.inhEqMap_computed = false;
        this.inhEqMap_value = null;
        this.rewriteAspects_visited = false;
        this.rewriteAspects_computed = false;
        this.rewriteAspects_value = null;
        this.collect_contributors_CollDecl_uses = false;
    }

    public Object clone() throws CloneNotSupportedException {
        Grammar node = (Grammar)super.clone();
        node.subclassMap_visited = false;
        node.subclassMap_computed = false;
        node.subclassMap_value = null;
        node.fatherMap_visited = false;
        node.fatherMap_computed = false;
        node.fatherMap_value = null;
        node.astErrors_visited = false;
        node.collectAstErrors_visited = false;
        node.roots_visited = false;
        node.lookup_String_visited = new HashSet(4);
        node.root_visited = false;
        node.errors_visited = false;
        node.collectErrors_visited = false;
        node.inhEqMap_visited = false;
        node.inhEqMap_computed = false;
        node.inhEqMap_value = null;
        node.rewriteAspects_visited = false;
        node.rewriteAspects_computed = false;
        node.rewriteAspects_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            Grammar node = (Grammar)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        Grammar res = (Grammar)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void abstractAncestors() {
        ASTDecl cl = new ASTDecl();
        IdDecl name = new IdDecl();
        name.setID("ASTNode");
        cl.setIdDecl(name);
        cl.setFileName("ASTNode.ast");
        this.addTypeDecl(cl);
        cl = new ASTDecl();
        name = new IdDecl();
        name.setID("List");
        cl.setIdDecl(name);
        cl.setFileName("List.ast");
        this.addTypeDecl(cl);
        cl = new ASTDecl();
        name = new IdDecl();
        name.setID("Opt");
        cl.setIdDecl(name);
        cl.setFileName("Opt.ast");
        this.addTypeDecl(cl);
    }

    public void genReset(PrintWriter stream) {
        stream.println("    public void ASTNode$State.reset() {");
        if (ASTNode.block) {
            stream.print(ASTNode.blockBegin);
        }
        if (ASTNode.circularEnabled) {
            stream.println("        IN_CIRCLE = false;");
            stream.println("        CIRCLE_INDEX = 0;");
            stream.println("        CHANGE = false;");
            if (ASTNode.cacheCycle) {
                stream.println("        LAST_CYCLE = false;");
            }
            if (ASTNode.componentCheck) {
                stream.println("        circularEvalSet = " + ASTNode.createDefaultSet + ";");
                stream.println("        circularEvalStack = new java.util.Stack();");
            }
        }
        if (ASTNode.rewriteEnabled) {
            stream.println("        boundariesCrossed = 0;");
            this.genResetDuringCounters(stream);
            if (ASTNode.rewriteLimit > 0) {
                stream.println("        debugRewrite = " + ASTNode.createDefaultMap + ";\n");
            }
            if (ASTNode.stagedRewrites) {
                stream.println("        rewritePhase = 1;\n");
            }
        }
        if (ASTNode.block) {
            stream.print(ASTNode.blockEnd);
        }
        stream.println("    }");
    }

    public void jjtGenASTNode$State(PrintWriter stream, String parserName, boolean jjtree, boolean rewriteEnabled) {
        stream.println("   static public class ASTNode$State {");
        if (ASTNode.circularEnabled) {
            stream.println("  public boolean IN_CIRCLE = false;");
            stream.println("  public int CIRCLE_INDEX;");
            stream.println("  public boolean CHANGE = false;");
            if (ASTNode.cacheCycle) {
                stream.println("  public boolean LAST_CYCLE = false;");
            }
            stream.println("  public boolean RESET_CYCLE = false;");
            if (ASTNode.componentCheck) {
                stream.println("  public java.util.Set circularEvalSet = " + ASTNode.createDefaultSet + ";");
                stream.println("  public java.util.Stack circularEvalStack = new java.util.Stack();");
                stream.println("  static class CircularEvalEntry {");
                stream.println("  \t ASTNode node;");
                stream.println("  \t String attrName;");
                stream.println("  \t Object parameters;");
                stream.println("  \t public CircularEvalEntry(ASTNode node, String attrName, Object parameters) {");
                stream.println("  \t   this.node = node;");
                stream.println("   \t this.attrName = attrName;");
                stream.println("  \t\t this.parameters = parameters;");
                stream.println("  \t }");
                stream.println("  \t public boolean equals(Object rhs) {");
                stream.println("  \t   CircularEvalEntry s = (CircularEvalEntry) rhs;");
                stream.println("  \t\t if (parameters == null && s.parameters == null)");
                stream.println("  \t\t\t return node == s.node && attrName.equals(s.attrName);");
                stream.println("  \t\t else if (parameters != null && s.parameters != null)");
                stream.println("  \t\t\t return node == s.node && attrName.equals(s.attrName) && parameters.equals(s.parameters);");
                stream.println("  \t\t else");
                stream.println("  \t\t\t return false;");
                stream.println("  \t }");
                stream.println("  \t public int hashCode() {");
                stream.println("  \t\t return node.hashCode();");
                stream.println("  \t }");
                stream.println("  }");
                stream.println("  public void addEvalEntry(ASTNode node, String attrName, Object parameters) {");
                stream.println("    circularEvalSet.add(new CircularEvalEntry(node,attrName,parameters));");
                stream.println("  }");
                stream.println("  public boolean containsEvalEntry(ASTNode node, String attrName, Object parameters) {");
                stream.println("    return circularEvalSet.contains(new CircularEvalEntry(node,attrName,parameters));");
                stream.println("  }");
                stream.println("  static class CircularStackEntry {");
                stream.println("    java.util.Set circularEvalSet;");
                stream.println("  \t boolean changeValue;");
                stream.println("  \t public CircularStackEntry(java.util.Set set, boolean change) {");
                stream.println("  \t\t circularEvalSet = set;");
                stream.println("  \t\t changeValue = change;");
                stream.println("  \t }");
                stream.println("  }");
                stream.println("  public void pushEvalStack() {");
                stream.println("  \t circularEvalStack.push(new CircularStackEntry(circularEvalSet, CHANGE));");
                stream.println("  \t circularEvalSet = " + ASTNode.createDefaultSet + ";");
                stream.println("  \t CHANGE = false;");
                stream.println("  }");
                stream.println("  public void popEvalStack() {");
                stream.println("  \t CircularStackEntry c = (CircularStackEntry) circularEvalStack.pop();");
                stream.println("  \t circularEvalSet = c.circularEvalSet;");
                stream.println("  \t CHANGE = c.changeValue;");
                stream.println("  }");
            }
        }
        if (rewriteEnabled) {
            stream.println("  public static final int REWRITE_CHANGE = 1;");
            stream.println("  public static final int REWRITE_NOCHANGE = 2;");
            stream.println("  public static final int REWRITE_INTERRUPT = 3;");
            if (ASTNode.rewriteLimit > 0) {
                stream.println("  public java.util.HashMap debugRewrite = " + ASTNode.createDefaultMap + ";\n");
            }
            stream.println("  public int boundariesCrossed = 0;\n");
            if (ASTNode.stagedRewrites) {
                stream.println("public int rewritePhase = 1;");
            }
            stream.println("   private int[] stack;");
            stream.println("   private int pos;");
            stream.println("   public ASTNode$State() {");
            stream.println("     stack = new int[64];");
            stream.println("     pos = 0;");
            stream.println("   }");
            stream.println("   private void ensureSize(int size) {");
            stream.println("     if(size < stack.length)");
            stream.println("       return;");
            stream.println("     int[] newStack = new int[stack.length * 2];");
            stream.println("     System.arraycopy(stack, 0, newStack, 0, stack.length);");
            stream.println("     stack = newStack;");
            stream.println("   }");
            stream.println("   public void push(int i) {");
            stream.println("     ensureSize(pos+1);");
            stream.println("     stack[pos++] = i;");
            stream.println("   }");
            stream.println("   public int pop() {");
            stream.println("     return stack[--pos];");
            stream.println("   }");
            stream.println("   public int peek() {");
            stream.println("     return stack[pos-1];");
            stream.println("   }");
        }
        stream.println("  static class IdentityHashSet extends java.util.AbstractSet implements java.util.Set {");
        stream.println("    public IdentityHashSet(int initialCapacity) {");
        stream.println("      map = new java.util.IdentityHashMap(initialCapacity);");
        stream.println("    }");
        stream.println("    private java.util.IdentityHashMap map;");
        stream.println("    private static final Object PRESENT = new Object();");
        stream.println("    public java.util.Iterator iterator() { return map.keySet().iterator(); }");
        stream.println("    public int size() { return map.size(); }");
        stream.println("    public boolean isEmpty() { return map.isEmpty(); }");
        stream.println("    public boolean contains(Object o) { return map.containsKey(o); }");
        stream.println("    public boolean add(Object o) { return map.put(o, PRESENT)==null; }");
        stream.println("    public boolean remove(Object o) { return map.remove(o)==PRESENT; }");
        stream.println("    public void clear() { map.clear(); }");
        stream.println("  }");
        stream.println("  }");
    }

    public TypeDecl findClassDecl(String name, String comment) {
        TypeDecl t;
        if (!(comment = comment.trim()).startsWith("/")) {
            comment = "";
        }
        if ((t = this.lookup(name)) == null) {
            t = new ClassDecl(new IdDecl(name), new List(), new List(), new List(), new List(), new List(), new List(), new List(), "", 0, 0, comment);
            this.addTypeDecl(t);
        }
        return t;
    }

    public TypeDecl findInterfaceDecl(String name, String comment) {
        TypeDecl t;
        if (!(comment = comment.trim()).startsWith("/")) {
            comment = "";
        }
        if ((t = this.lookup(name)) == null) {
            t = new InterfaceDecl(new IdDecl(name), new List(), new List(), new List(), new List(), new List(), new List(), new List(), "", 0, 0, comment);
            this.addTypeDecl(t);
        }
        return t;
    }

    public void addRewriteList(String className, SimpleNode condition, SimpleNode result, String type, String fileName, int startLine, int endLine, String parentName, String childName) {
        TypeDecl c = this.lookup(className);
        if (c != null && c instanceof ASTDecl) {
            RewriteList r = new RewriteList();
            r.setFileName(fileName);
            r.setStartLine(startLine);
            r.setEndLine(endLine);
            r.setCondition(condition);
            r.setResult(result);
            r.setReturnType(type);
            r.setParentName(parentName);
            r.setChildName(childName);
            ((ASTDecl)c).addRewrite(r);
        } else if (c != null) {
            Grammar.error("Can not rewrite to non AST class " + className + " in " + fileName + " at line " + startLine);
        } else {
            Grammar.error("Can not rewrite to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addRewrite(String className, SimpleNode condition, SimpleNode result, String type, String fileName, int startLine, int endLine) {
        TypeDecl c = this.lookup(className);
        if (c != null && c instanceof ASTDecl) {
            Rewrite r = new Rewrite();
            r.setFileName(fileName);
            r.setStartLine(startLine);
            r.setEndLine(endLine);
            r.setCondition(condition);
            r.setResult(result);
            r.setReturnType(type);
            ((ASTDecl)c).addRewrite(r);
        } else if (c != null) {
            Grammar.error("Can not rewrite to non AST class " + className + " in " + fileName + " at line " + startLine);
        } else {
            Grammar.error("Can not rewrite to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addSynDecl(String name, String type, String className, boolean isLazy, String fileName, int startLine, int endLine, List parameterList, ASTExpression bottomValue, boolean isFinal, boolean isNTA, SimpleNode node) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynDecl decl = new SynDecl(parameterList, name, type, isLazy | isNTA, fileName, startLine, endLine, isFinal | isNTA, isNTA, Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            decl.setBottomValue(bottomValue);
            SynDecl synDecl = decl;
            try {
                c.addSynDecl(synDecl);
            }
            finally {
                if (Doc.ajc$if_1(synDecl)) {
                    Doc.aspectOf().ajc$after$jrag_Doc$2$4e588fff(synDecl);
                }
            }
        } else {
            Grammar.error("Can not add synthesized attribute " + type + " " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addSynEq(String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, SimpleNode node, String aspectName) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynEq equ = new SynEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setParameterList(list);
            equ.setComment(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            equ.setAspectName(aspectName);
            c.addSynEq(equ);
        } else {
            Grammar.error("Can not add equation for synthesized attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addInhDecl(String name, String type, String className, boolean isLazy, String fileName, int startLine, int endLine, List parameterList, ASTExpression bottomValue, boolean isFinal, boolean isNTA, SimpleNode node) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            InhDecl decl = new InhDecl(parameterList, name, type, isLazy | isNTA, fileName, startLine, endLine, isFinal | isNTA, isNTA, Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            decl.setBottomValue(bottomValue);
            c.addInhDecl(decl);
        } else {
            Grammar.error("Can not add inherited attribute " + type + " " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, SimpleNode node, String aspectName) {
        this.addInhEq(sonName, name, className, rhs, fileName, startLine, endLine, list, null, node, aspectName);
    }

    public void addInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, Parameter p, SimpleNode node, String aspectName) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            InhEq equ = new InhEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setSonName(sonName);
            equ.setParameterList(list);
            equ.setComment(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            equ.setAspectName(aspectName);
            if (p != null) {
                equ.setIndex(p);
            }
            c.addInhEq(equ);
        } else {
            Grammar.error("Can not add equation for inherited attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addComponents(String className, List componentsList) {
        TypeDecl d = this.lookup(className);
        if (d != null) {
            d.setComponentsList(componentsList);
        }
    }

    public void addCompUnit(ASTCompilationUnit compUnit) {
        this.compUnits.add(compUnit);
    }

    public Iterator getCompUnits() {
        return this.compUnits.iterator();
    }

    public void addClassBodyDecl(SimpleNode n, String className, String fileName, String aspectName) {
        this.addClassBodyDecl(n, className, fileName, "", aspectName);
    }

    public void addClassBodyDecl(SimpleNode n, String className, String fileName, String comments, String aspectName) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            c.classBodyDecls.add(new ClassBodyObject(n, fileName, n.firstToken.beginLine, comments, aspectName));
        } else {
            Grammar.error("Can not add member to unknown class " + className + " in " + fileName + " at line " + n.firstToken.beginLine);
        }
    }

    public void addInterface(SimpleNode nameList, String className, String fileName) {
        if (nameList == null) {
            System.out.println("Panic");
        } else {
            TypeDecl c = this.lookup(className);
            if (c != null) {
                c.implementsList.add(nameList);
            } else {
                int line = nameList.firstToken.beginLine;
                Grammar.error("Can not add interface to unknown class " + className + " in " + fileName + " at line " + line);
            }
        }
    }

    public void extendInterface(SimpleNode nameList, String className, String fileName) {
        if (nameList == null) {
            System.out.println("Panic");
        } else {
            TypeDecl c = this.lookup(className);
            if (c instanceof InterfaceDecl) {
                c.implementsList.add(nameList);
            } else if (c != null) {
                int line = nameList.firstToken.beginLine;
                Grammar.error(String.valueOf(className) + " is not an interface and can therefore not be extended  in " + fileName + " at line " + line);
            } else {
                int line = nameList.firstToken.beginLine;
                Grammar.error("Can not add interface to unknown interface " + className + " in " + fileName + " at line " + line);
            }
        }
    }

    public void processRefinements() {
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            TypeDecl typeDecl = this.getTypeDecl(i);
            typeDecl.processReplacements();
            typeDecl.processRefinedClassBodyDecls();
            typeDecl.processSynEqReplacements();
            typeDecl.processRefinedSynEqs();
            typeDecl.processRefinedInhEqs();
            ++i;
        }
    }

    public void addRefinedSynEq(String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, String aspectName, SimpleNode node, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynEq equ = new SynEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setParameterList(list);
            equ.refinesAspect = aspectName;
            equ.setComment(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            equ.setAspectName(declaredAspect);
            c.refinedSynEqs.add(equ);
        } else {
            Grammar.error("Can not add equation for synthesized attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addReplacedSynEq(String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, String aspectName, String secondAspectName, SimpleNode node, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            SynEq equ = new SynEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setParameterList(list);
            equ.refinesAspect = aspectName;
            equ.replacesAspect = secondAspectName;
            equ.setComment(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            equ.setAspectName(declaredAspect);
            c.replacedSynEqs.add(equ);
        } else {
            Grammar.error("Can not add equation for synthesized attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addRefinedInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, String aspectName, SimpleNode node, String declaredAspect) {
        this.addRefinedInhEq(sonName, name, className, rhs, fileName, startLine, endLine, list, null, aspectName, node, declaredAspect);
    }

    public void addRefinedInhEq(String sonName, String name, String className, SimpleNode rhs, String fileName, int startLine, int endLine, List list, Parameter p, String aspectName, SimpleNode node, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            InhEq equ = new InhEq();
            equ.setName(name);
            equ.setFileName(fileName);
            equ.setStartLine(startLine);
            equ.setEndLine(endLine);
            equ.setRHS(rhs);
            equ.setSonName(sonName);
            equ.setParameterList(list);
            equ.refinesAspect = aspectName;
            equ.setComment(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            equ.setAspectName(declaredAspect);
            if (p != null) {
                equ.setIndex(p);
            }
            c.refinedInhEqs.add(equ);
        } else {
            Grammar.error("Can not add equation for inherited attribute " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addRefinedClassBodyDecl(SimpleNode n, String className, String fileName, String aspectName, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            ClassBodyObject o = new ClassBodyObject(n, fileName, n.firstToken.beginLine, declaredAspect);
            o.refinesAspect = aspectName;
            c.refinedClassBodyDecls.add(o);
        } else {
            Grammar.error("Can not add member to unknown class " + className + " in " + fileName);
        }
    }

    public void addReplacedClassBodyDecl(SimpleNode n, String className, String fileName, String aspectName, String replacedAspect, SimpleNode replacedSignature, String declaredAspect) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            ClassBodyObject o = new ClassBodyObject(n, fileName, n.firstToken.beginLine, declaredAspect);
            o.refinesAspect = aspectName;
            o.replaceAspect = replacedAspect;
            c.replacements.add(o);
        } else {
            Grammar.error("Can not add member to unknown class " + className + " in " + fileName);
        }
    }

    public void weaveCollectionAttributes() {
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            this.getTypeDecl(i).weaveCollectionAttributes();
            ++i;
        }
    }

    public void addCollDecl(String name, String type, String className, String fileName, int startLine, int endLine, ASTExpression startValue, String combOp, boolean isCircular, ArrayList annotations, SimpleNode node, String root) {
        TypeDecl c = this.lookup(className);
        if (c != null) {
            CollDecl decl = new CollDecl();
            decl.setName(name);
            decl.setType(type);
            decl.setLazy(true);
            decl.setFileName(fileName);
            decl.setStartLine(startLine);
            decl.setEndLine(endLine);
            decl.setParameterList(new List());
            decl.setStartValue(startValue);
            decl.setCombOp(combOp);
            decl.setAnnotations(annotations);
            decl.setCircularCollection(isCircular || annotations.contains("@Circular"));
            decl.setComment(Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node));
            decl.setTarget(className);
            decl.root = root;
            c.addCollDecl(decl);
        } else {
            Grammar.error("Can not add collection attribute " + type + " " + name + " to unknown class " + className + " in " + fileName + " at line " + startLine);
        }
    }

    public void addCollEq(String targetName, String targetAttributeName, String attributeType, String reference, List contributionList, String fileName, int startLine, int endLine, boolean refSet, SimpleNode node, String aspectName) {
        TypeDecl c = this.lookup(attributeType);
        if (c != null && c instanceof ASTDecl) {
            CollEq collEq = new CollEq(new List(), targetName, fileName, startLine, endLine, Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_SimpleNode$unparseComment(node), aspectName, contributionList, targetName, targetAttributeName, refSet, reference);
            ((ASTDecl)c).addCollEq(collEq);
        } else {
            Grammar.error("Can not add collection contribution to unknown class " + attributeType + " in " + fileName + " at line " + startLine);
        }
    }

    public void genAGCode(PrintStream s, String aspectName) {
        ASTNode.aspectJ = true;
        s.print(this.genImportsList());
        s.print("aspect " + aspectName + " {\n");
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            this.getTypeDecl(i).genAGCode(s);
            ++i;
        }
        s.print("}\n");
    }

    public String genImportsList() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Iterator iter = this.getCompUnits();
        while (iter.hasNext()) {
            ASTCompilationUnit u = (ASTCompilationUnit)iter.next();
            String[] imports = Unparse.ajc$interMethodDispatch1$jrag_Unparse$jrag_AST_ASTCompilationUnit$getImports(u).split(";");
            int i = 0;
            while (i < imports.length) {
                if (imports[i] != null && !imports[i].equals("")) {
                    set.add(String.valueOf(imports[i]) + ";");
                }
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter2 = set.iterator();
        while (iter2.hasNext()) {
            buf.append(iter2.next());
        }
        buf.append("\n");
        return buf.toString();
    }

    public Iterator inhAttrSet() {
        return this.inhEqMap().keySet().iterator();
    }

    public void genResetDuringCounters(PrintWriter out) {
        Iterator iter = this.rewriteAspects().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String s = "        if(during" + name + " != 0) {\n" + "            System.out.println(\"Warning: resetting during" + name + "\");\n" + "            during" + name + " = 0;\n" + "        }\n";
            out.print(s);
        }
    }

    public void genRewriteOrderChecks(PrintWriter out) {
        Iterator iter = this.rewriteAspects().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String s = "    protected int ASTNode$State.during" + name + " = 0;\n" + "    protected boolean ASTNode.during" + name + "() {\n" + "        if(state().during" + name + " == 0) {\n" + "            return false;\n" + "        }\n" + "        else {\n" + "            state().pop();\n" + "            state().push(ASTNode$State.REWRITE_INTERRUPT);\n" + "            return true;\n" + "        }\n" + "    }\n";
            out.print(s);
        }
    }

    public void createInterfaces(File outputDir, String pack) throws FileNotFoundException {
        if (!ASTNode.parentInterface) {
            return;
        }
        Iterator iter = this.inhEqMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String attrId = (String)entry.getKey();
            AttrEq attr = (AttrEq)((LinkedList)entry.getValue()).get(0);
            String interfaceName = pack.equals("") ? "Defines_" + attrId : String.valueOf(pack.replace('.', File.separatorChar)) + File.separator + "Defines_" + attrId;
            File file = new File(outputDir, String.valueOf(interfaceName) + ".java");
            PrintStream p = new PrintStream(new FileOutputStream(file));
            if (!pack.equals("")) {
                p.println("package " + pack + ";");
                p.println();
            }
            p.print(this.genImportsList());
            String s = "public interface Defines_#TYPEINSIGNATURE#_#NAME# {\n    public #TYPE# Define_#TYPEINSIGNATURE#_#METHODNAME#(#INTERFACEPARMDECL#);\n}\n";
            s = s.replaceAll("#TYPE#", attr.type());
            s = s.replaceAll("#TYPEINSIGNATURE#", attr.getTypeInSignature());
            s = s.replaceAll("#NAME#", attr.attributeSignature());
            s = s.replaceAll("#METHODNAME#", attr.attributeName());
            s = s.replaceAll("#PARMDECL#", attr.parametersDecl());
            s = s.replaceAll("#INTERFACEPARMDECL#", attr.interfaceParametersDecl());
            p.print(s);
        }
    }

    public Grammar(int i) {
        super(i);
        this.is$Final(true);
    }

    public Grammar(Ast p, int i) {
        this(i);
        this.parser = p;
        this.is$Final(true);
    }

    public Grammar() {
        this(0);
        this.setChild(new List(), 0);
        this.is$Final(true);
    }

    public Grammar(List p0) {
        this.setChild(p0, 0);
        this.is$Final(true);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "Grammar");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of Grammar has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof TypeDecl)) {
                    throw new Error("Child number " + k + " in TypeDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of TypeDecl");
                }
                ++k;
            }
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeDeclList(List list) {
        this.setChild(list, 0);
    }

    public int getNumTypeDecl() {
        return this.getTypeDeclList().getNumChild();
    }

    public TypeDecl getTypeDecl(int i) {
        return (TypeDecl)this.getTypeDeclList().getChild(i);
    }

    public void addTypeDecl(TypeDecl node) {
        List list = this.getTypeDeclList();
        list.setChild(node, list.getNumChild());
    }

    public void setTypeDecl(TypeDecl node, int i) {
        List list = this.getTypeDeclList();
        list.setChild(node, i);
    }

    public List getTypeDeclList() {
        return (List)this.getChild(0);
    }

    public List getTypeDeclListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    protected void collect_contributors_CollDecl_uses() {
        if (this.collect_contributors_CollDecl_uses) {
            return;
        }
        super.collect_contributors_CollDecl_uses();
        this.collect_contributors_CollDecl_uses = true;
    }

    public HashMap subclassMap() {
        if (this.subclassMap_computed) {
            return this.subclassMap_value;
        }
        boolean interruptedCircle = false;
        if (this.subclassMap_visited) {
            throw new RuntimeException("Circular definition of attr: subclassMap in class: ");
        }
        this.subclassMap_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.subclassMap_value = this.subclassMap_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.subclassMap_computed = true;
        }
        this.subclassMap_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return this.subclassMap_value;
    }

    private HashMap subclassMap_compute() {
        ASTDecl decl;
        HashMap map = new HashMap();
        int j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl) {
                decl = (ASTDecl)this.getTypeDecl(j);
                map.put(decl, new ArrayList());
            }
            ++j;
        }
        j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl && (decl = (ASTDecl)this.getTypeDecl(j)).superClass() != null) {
                ((ArrayList)map.get(decl.superClass())).add(decl);
            }
            ++j;
        }
        return map;
    }

    public HashMap fatherMap() {
        if (this.fatherMap_computed) {
            return this.fatherMap_value;
        }
        boolean interruptedCircle = false;
        if (this.fatherMap_visited) {
            throw new RuntimeException("Circular definition of attr: fatherMap in class: ");
        }
        this.fatherMap_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.fatherMap_value = this.fatherMap_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.fatherMap_computed = true;
        }
        this.fatherMap_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return this.fatherMap_value;
    }

    private HashMap fatherMap_compute() {
        ASTDecl decl;
        LinkedHashMap map = new LinkedHashMap();
        int j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl) {
                decl = (ASTDecl)this.getTypeDecl(j);
                map.put(decl, new LinkedHashSet());
            }
            ++j;
        }
        j = 0;
        while (j < this.getNumTypeDecl()) {
            if (this.getTypeDecl(j) instanceof ASTDecl) {
                decl = (ASTDecl)this.getTypeDecl(j);
                Iterator iter = decl.getComponents();
                while (iter.hasNext()) {
                    Components c = (Components)iter.next();
                    TypeDecl t = this.lookup(c.type());
                    if (t == null) continue;
                    ((HashSet)((HashMap)map).get(t)).add(decl);
                }
            }
            ++j;
        }
        return map;
    }

    public String astErrors() {
        boolean interruptedCircle = false;
        if (this.astErrors_visited) {
            throw new RuntimeException("Circular definition of attr: astErrors in class: ");
        }
        this.astErrors_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String astErrors_value = this.astErrors_compute();
        this.astErrors_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return astErrors_value;
    }

    private String astErrors_compute() {
        return this.collectAstErrors();
    }

    public String collectAstErrors() {
        boolean interruptedCircle = false;
        if (this.collectAstErrors_visited) {
            throw new RuntimeException("Circular definition of attr: collectAstErrors in class: ");
        }
        this.collectAstErrors_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String collectAstErrors_value = this.collectAstErrors_compute();
        this.collectAstErrors_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return collectAstErrors_value;
    }

    private String collectAstErrors_compute() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            result.append(this.getTypeDecl(i).collectAstErrors());
            ++i;
        }
        ArrayList l = this.roots();
        if (l.isEmpty()) {
            result.append("No root node available\n");
        }
        return result.toString();
    }

    public ArrayList roots() {
        boolean interruptedCircle = false;
        if (this.roots_visited) {
            throw new RuntimeException("Circular definition of attr: roots in class: ");
        }
        this.roots_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        ArrayList roots_value = this.roots_compute();
        this.roots_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return roots_value;
    }

    private ArrayList roots_compute() {
        ArrayList<ASTDecl> l = new ArrayList<ASTDecl>();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            ASTDecl decl;
            if (this.getTypeDecl(i) instanceof ASTDecl && (decl = (ASTDecl)this.getTypeDecl(i)).isRootNode()) {
                l.add(decl);
            }
            ++i;
        }
        return l;
    }

    public TypeDecl lookup(String name) {
        String _parameters = name;
        boolean interruptedCircle = false;
        if (this.lookup_String_visited.contains(_parameters)) {
            throw new RuntimeException("Circular definition of attr: lookup in class: ");
        }
        this.lookup_String_visited.add(_parameters);
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        TypeDecl lookup_String_value = this.lookup_compute(name);
        this.lookup_String_visited.remove(_parameters);
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return lookup_String_value;
    }

    private TypeDecl lookup_compute(String name) {
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            if (this.getTypeDecl(i).name().equals(name)) {
                return this.getTypeDecl(i);
            }
            ++i;
        }
        return null;
    }

    public ASTDecl root() {
        boolean interruptedCircle = false;
        if (this.root_visited) {
            throw new RuntimeException("Circular definition of attr: root in class: ");
        }
        this.root_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        ASTDecl root_value = this.root_compute();
        this.root_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return root_value;
    }

    private ASTDecl root_compute() {
        return (ASTDecl)this.roots().iterator().next();
    }

    public String errors() {
        boolean interruptedCircle = false;
        if (this.errors_visited) {
            throw new RuntimeException("Circular definition of attr: errors in class: ");
        }
        this.errors_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String errors_value = this.errors_compute();
        this.errors_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return errors_value;
    }

    private String errors_compute() {
        return this.collectErrors();
    }

    public String collectErrors() {
        boolean interruptedCircle = false;
        if (this.collectErrors_visited) {
            throw new RuntimeException("Circular definition of attr: collectErrors in class: ");
        }
        this.collectErrors_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String collectErrors_value = this.collectErrors_compute();
        this.collectErrors_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return collectErrors_value;
    }

    private String collectErrors_compute() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            result.append(this.getTypeDecl(i).collectErrors());
            ++i;
        }
        return result.toString();
    }

    public HashMap inhEqMap() {
        if (this.inhEqMap_computed) {
            return this.inhEqMap_value;
        }
        boolean interruptedCircle = false;
        if (this.inhEqMap_visited) {
            throw new RuntimeException("Circular definition of attr: inhEqMap in class: ");
        }
        this.inhEqMap_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.inhEqMap_value = this.inhEqMap_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.inhEqMap_computed = true;
        }
        this.inhEqMap_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return this.inhEqMap_value;
    }

    private HashMap inhEqMap_compute() {
        LinkedHashMap map = new LinkedHashMap();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            if (this.getTypeDecl(i) instanceof ASTDecl) {
                map.putAll(((ASTDecl)this.getTypeDecl(i)).inhEqMap());
            }
            ++i;
        }
        return map;
    }

    public Collection rewriteAspects() {
        if (this.rewriteAspects_computed) {
            return this.rewriteAspects_value;
        }
        boolean interruptedCircle = false;
        if (this.rewriteAspects_visited) {
            throw new RuntimeException("Circular definition of attr: rewriteAspects in class: ");
        }
        this.rewriteAspects_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.rewriteAspects_value = this.rewriteAspects_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.rewriteAspects_computed = true;
        }
        this.rewriteAspects_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return this.rewriteAspects_value;
    }

    private Collection rewriteAspects_compute() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        int i = 0;
        while (i < this.getNumTypeDecl()) {
            if (this.getTypeDecl(i) instanceof ASTDecl) {
                ASTDecl decl = (ASTDecl)this.getTypeDecl(i);
                int j = 0;
                while (j < decl.getNumRewrite()) {
                    Rewrite r = decl.getRewrite(j);
                    set.add(r.aspectName());
                    ++j;
                }
            }
            ++i;
        }
        return set;
    }

    public Collection Define_Collection_findSubclasses(ASTNode caller, ASTNode child, ASTDecl target) {
        if (caller == this.getTypeDeclListNoTransform()) {
            caller.getIndexOfChild(child);
            return (Collection)this.subclassMap().get(target);
        }
        return this.getParent().Define_Collection_findSubclasses(this, caller, target);
    }

    public Collection Define_Collection_findFathers(ASTNode caller, ASTNode child, ASTDecl node) {
        if (caller == this.getTypeDeclListNoTransform()) {
            caller.getIndexOfChild(child);
            LinkedHashSet set = new LinkedHashSet();
            set.addAll((HashSet)this.fatherMap().get(node));
            if (node.superClass() != null) {
                set.addAll(node.superClass().fathers());
            }
            return set;
        }
        return this.getParent().Define_Collection_findFathers(this, caller, node);
    }

    public Grammar Define_Grammar_env(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeDeclListNoTransform()) {
            caller.getIndexOfChild(child);
            return this;
        }
        return this.getParent().Define_Grammar_env(this, caller);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public void jastAddGen(File file, String string, String string2, boolean bl) {
        JastAddCodeGen.ajc$interMethod$jastadd_JastAddCodeGen$ast_AST_Grammar$jastAddGen(this, file, string, string2, bl);
    }

    public void weaveInterfaceIntroductions() {
        JastAddCodeGen.ajc$interMethod$jastadd_JastAddCodeGen$ast_AST_Grammar$weaveInterfaceIntroductions(this);
    }
}

