/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.util;

public class BitSet {
    private int[] bit_bags;
    private boolean has_bits;

    public BitSet(int n) {
        this.bit_bags = new int[n + 31 >> 5];
    }

    public BitSet() {
        this(256);
    }

    public boolean add(int n) {
        boolean bl;
        int n2 = n >> 5;
        this.ensureIndexWithinRange(n2);
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        boolean bl2 = bl = (this.bit_bags[n2] & n4) == 0;
        if (bl) {
            int n5 = n2;
            this.bit_bags[n5] = this.bit_bags[n5] | n4;
            this.has_bits = true;
        }
        return bl;
    }

    public boolean add(BitSet bitSet) {
        boolean bl = false;
        if (bitSet.has_bits) {
            int n = bitSet.bit_bags.length;
            if (n > this.bit_bags.length) {
                this.expandCapacity(n);
            }
            for (int i = 0; i < n; ++i) {
                int n2 = bitSet.bit_bags[i] & ~this.bit_bags[i];
                if (n2 == 0) continue;
                int n3 = i;
                this.bit_bags[n3] = this.bit_bags[n3] | n2;
                bl = true;
                this.has_bits = true;
            }
        }
        return bl;
    }

    public boolean isSet(int n) {
        return this.has_bits && (this.bit_bags[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    public boolean isEmpty() {
        return !this.has_bits;
    }

    public void forEachElementRun(Processor processor) {
        if (this.has_bits) {
            for (int i = 0; i < this.bit_bags.length; ++i) {
                int n = i << 5;
                int n2 = this.bit_bags[i];
                while (n2 != 0) {
                    if ((n2 & 1) == 0) {
                        if ((n2 & 0xFFFF) == 0) {
                            n += 16;
                            n2 >>>= 16;
                        }
                        if ((n2 & 0xFF) == 0) {
                            n += 8;
                            n2 >>>= 8;
                        }
                        if ((n2 & 0xF) == 0) {
                            n += 4;
                            n2 >>>= 4;
                        }
                        if ((n2 & 3) == 0) {
                            n += 2;
                            n2 >>>= 2;
                        }
                        if ((n2 & 1) == 0) {
                            ++n;
                            n2 >>>= 1;
                        }
                    }
                    processor.process(n);
                    n2 >>>= 1;
                    ++n;
                }
            }
        }
    }

    private void ensureIndexWithinRange(int n) {
        if (n >= this.bit_bags.length) {
            if (n > 65535) {
                throw new IllegalArgumentException("huge bit sets (more than 2M bits) are not supported");
            }
            int n2 = n | n >> 1;
            n2 |= n2 >> 2;
            n2 |= n2 >> 4;
            n2 |= n2 >> 8;
            this.expandCapacity(n2 + 1);
        }
    }

    private void expandCapacity(int n) {
        int[] nArray = new int[n];
        System.arraycopy(this.bit_bags, 0, nArray, 0, this.bit_bags.length);
        this.bit_bags = nArray;
    }

    public static abstract class Processor {
        protected abstract void process(int var1);
    }
}

