/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.IdUse;
import ast.AST.NameNode;
import ast.AST.Node;
import ast.AST.Opt;
import java.io.PrintStream;

public class Id
extends ASTNode
implements Cloneable {
    protected boolean name_visited = false;
    protected boolean type_visited = false;

    public void flushCache() {
        super.flushCache();
        this.name_visited = false;
        this.type_visited = false;
    }

    public Object clone() throws CloneNotSupportedException {
        Id node = (Id)super.clone();
        node.name_visited = false;
        node.type_visited = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            Id node = (Id)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        Id res = (Id)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public Id(int i) {
        super(i);
    }

    public Id(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public Id() {
        this(0);
        this.setChild(new Opt(), 0);
        this.setChild(null, 1);
    }

    public Id(Opt p0, IdUse p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "Id");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof Opt)) {
                throw new Error("Child number 0 of Id has the type " + n.getClass().getName() + " which is not an instance of Opt");
            }
            if (((Opt)n).getNumChild() != 0 && !(((Opt)n).getChildNoTransform(0) instanceof NameNode)) {
                throw new Error("Optional NameNode has the type " + ((Opt)n).getChildNoTransform(0).getClass().getName() + " which is not an instance of NameNode");
            }
        }
        if (i == 1 && !(n instanceof IdUse)) {
            throw new Error("Child number 1 of Id has the type " + n.getClass().getName() + " which is not an instance of IdUse");
        }
    }

    public int getNumChild() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setNameNodeOpt(Opt opt) {
        this.setChild(opt, 0);
    }

    public boolean hasNameNode() {
        return this.getNameNodeOpt().getNumChild() != 0;
    }

    public NameNode getNameNode() {
        return (NameNode)this.getNameNodeOpt().getChild(0);
    }

    public void setNameNode(NameNode node) {
        this.getNameNodeOpt().setChild(node, 0);
    }

    public Opt getNameNodeOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt getNameNodeOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    public void setIdUse(IdUse node) {
        this.setChild(node, 1);
    }

    public IdUse getIdUse() {
        return (IdUse)this.getChild(1);
    }

    public IdUse getIdUseNoTransform() {
        return (IdUse)this.getChildNoTransform(1);
    }

    public String name() {
        boolean interruptedCircle = false;
        if (this.name_visited) {
            throw new RuntimeException("Circular definition of attr: name in class: ");
        }
        this.name_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String name_value = this.name_compute();
        this.name_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return name_value;
    }

    private String name_compute() {
        return this.hasNameNode() ? this.getNameNode().name() : this.getIdUse().name();
    }

    public String type() {
        boolean interruptedCircle = false;
        if (this.type_visited) {
            throw new RuntimeException("Circular definition of attr: type in class: ");
        }
        this.type_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String type_value = this.type_compute();
        this.type_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return type_value;
    }

    private String type_compute() {
        return this.getIdUse().name();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

