/* The following code was generated by JFlex 1.4.1 on 1/19/09 1:48 PM */

//TODO-AC: many of the catchall errors are recoverable - either return a bad token which will be discarded or just discard and make a note.
//TODO-AC: meta-pattern macros?
//based on http://jflex.de/manual.html

package metalexer;

import static metalexer.LayoutParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 1/19/09 1:48 PM from the specification file
 * <tt>/Users/amcasey/Research/metalexer/src/frontend/layout.flex</tt>
 */
public final class LayoutScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int INSIDE_INHERITED_HEADER_SECTION = 2;
  public static final int INSIDE_BRACKET_COMMENT = 5;
  public static final int INSIDE_STRING_IDENTIFIER_DIRECTIVE = 9;
  public static final int INSIDE_DECL_REGION = 7;
  public static final int INSIDE_STRING = 6;
  public static final int INSIDE_OPTION_SECTION = 3;
  public static final int INSIDE_LOCAL_HEADER_SECTION = 1;
  public static final int YYINITIAL = 0;
  public static final int INSIDE_META_PATTERN_DIRECTIVE = 10;
  public static final int INSIDE_INIT_REGION = 8;
  public static final int INSIDE_RULE_SECTION = 4;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\22\0\1\3\1\21\1\10"+
    "\1\0\1\21\1\7\2\0\1\60\1\61\1\23\1\65\1\47\1\0"+
    "\1\21\1\22\4\17\4\20\2\5\2\0\1\50\1\0\1\54\1\66"+
    "\1\0\1\51\1\55\3\11\1\57\7\4\1\52\1\56\11\4\1\53"+
    "\1\4\1\62\1\12\1\63\1\64\1\6\1\0\1\35\1\45\1\41"+
    "\1\43\1\32\1\14\1\46\1\31\1\26\2\4\1\33\1\42\1\27"+
    "\1\37\1\34\1\4\1\13\1\40\1\30\1\16\1\4\1\44\1\15"+
    "\1\36\1\4\1\24\1\67\1\25\1\21\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\1\1\3\2\1\3\2\4\1\5\1\3\3\6"+
    "\3\7\2\10\1\11\1\12\2\2\1\13\2\14\1\15"+
    "\1\16\1\13\1\17\1\20\1\21\2\20\1\22\1\20"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\7\0\1\37\1\40\11\0"+
    "\1\41\1\42\3\43\2\2\1\0\1\44\30\0\1\2"+
    "\2\0\1\45\21\0\1\46\3\0\1\2\21\0\1\47"+
    "\1\50\1\46\1\0\1\51\2\0\1\2\2\0\1\52"+
    "\1\53\1\54\5\0\1\55\7\0\1\47\1\0\1\50"+
    "\1\0\1\51\1\0\1\56\1\57\1\60\1\0\1\61"+
    "\1\0\1\62\1\63\1\55\4\0\1\64\3\0\1\56"+
    "\1\0\1\57\2\0\1\61\2\0\1\62\1\0\1\63"+
    "\2\0\1\65\1\0\1\64\1\0\1\66\1\67\2\0"+
    "\1\70\1\0\1\65\1\0\1\71\1\66\1\0\1\67"+
    "\1\0\1\72\1\73\1\70\1\0\1\74\1\71\1\0"+
    "\1\72\1\0\1\73\1\0\1\74\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[243];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\70\0\160\0\250\0\340\0\u0118\0\u0150\0\u0188"+
    "\0\u01c0\0\u01f8\0\u0230\0\u0268\0\u0268\0\u02a0\0\u02d8\0\u0268"+
    "\0\u0310\0\u0268\0\u0348\0\u0380\0\u0268\0\u03b8\0\u0380\0\u0268"+
    "\0\u03f0\0\u0428\0\u0460\0\u0268\0\u0268\0\u0498\0\u04d0\0\u0508"+
    "\0\u0268\0\u0540\0\u0268\0\u0578\0\u0268\0\u0380\0\u0268\0\u0268"+
    "\0\u05b0\0\u05e8\0\u0380\0\u0268\0\u0620\0\u0268\0\u0268\0\u0268"+
    "\0\u0268\0\u0268\0\u0268\0\u0268\0\u0268\0\u0268\0\u0268\0\u0268"+
    "\0\u0268\0\u0658\0\u0690\0\u06c8\0\u0700\0\u0738\0\u0770\0\u07a8"+
    "\0\u07e0\0\u0268\0\u0818\0\u0850\0\u0888\0\u08c0\0\u08f8\0\u0930"+
    "\0\u0968\0\u09a0\0\u09d8\0\u0268\0\u0268\0\u0268\0\u0a10\0\u0a48"+
    "\0\u0a80\0\u0ab8\0\u0af0\0\u0268\0\u0b28\0\u0b60\0\u0b98\0\u0bd0"+
    "\0\u0c08\0\u0c40\0\u0c78\0\u0cb0\0\u0ce8\0\u0d20\0\u0d58\0\u0d90"+
    "\0\u0dc8\0\u0e00\0\u0e38\0\u0e70\0\u0ea8\0\u0ee0\0\u0f18\0\u0f50"+
    "\0\u0f88\0\u0fc0\0\u0ff8\0\u1030\0\u1068\0\u10a0\0\u10d8\0\u0268"+
    "\0\u1110\0\u1148\0\u1180\0\u11b8\0\u11f0\0\u1228\0\u1260\0\u1298"+
    "\0\u12d0\0\u1308\0\u1340\0\u1378\0\u13b0\0\u13e8\0\u1420\0\u1458"+
    "\0\u1490\0\u14c8\0\u1500\0\u1538\0\u1570\0\u15a8\0\u15e0\0\u1618"+
    "\0\u1650\0\u1688\0\u16c0\0\u16f8\0\u1730\0\u1768\0\u17a0\0\u17d8"+
    "\0\u1810\0\u1848\0\u1880\0\u18b8\0\u18f0\0\u1928\0\u1960\0\u1998"+
    "\0\u19d0\0\u1a08\0\u1a08\0\u1a40\0\u1a78\0\u1ab0\0\u1030\0\u1ae8"+
    "\0\u1b20\0\u0268\0\u0268\0\u0268\0\u1b58\0\u1b90\0\u1bc8\0\u1c00"+
    "\0\u1c38\0\u1c70\0\u1ca8\0\u1ce0\0\u1d18\0\u1d50\0\u1d88\0\u1dc0"+
    "\0\u1df8\0\u1e30\0\u1e30\0\u1e68\0\u1e68\0\u1ea0\0\u1ea0\0\u1ed8"+
    "\0\u1f10\0\u0268\0\u1f48\0\u1f80\0\u1fb8\0\u1ff0\0\u2028\0\u2060"+
    "\0\u2060\0\u2098\0\u20d0\0\u2108\0\u2140\0\u2178\0\u21b0\0\u21e8"+
    "\0\u2220\0\u2220\0\u2258\0\u2258\0\u2290\0\u22c8\0\u22c8\0\u2300"+
    "\0\u2338\0\u2338\0\u2370\0\u2370\0\u23a8\0\u23e0\0\u2418\0\u2450"+
    "\0\u2450\0\u2488\0\u24c0\0\u24f8\0\u2530\0\u2568\0\u25a0\0\u25d8"+
    "\0\u25d8\0\u2610\0\u2648\0\u2648\0\u2680\0\u2680\0\u26b8\0\u26f0"+
    "\0\u2728\0\u2728\0\u2760\0\u2798\0\u2798\0\u27d0\0\u27d0\0\u2808"+
    "\0\u2808\0\u2840\0\u2840";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[243];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\70\14\7\15\1\16\67\15\1\17\60\15\1\20\1\21"+
    "\2\22\3\20\1\23\12\20\1\24\45\20\1\25\1\21"+
    "\2\22\3\25\1\26\12\25\1\27\45\25\22\30\1\31"+
    "\1\32\44\30\1\15\1\33\1\34\5\15\1\35\1\15"+
    "\1\36\64\15\1\37\67\15\1\40\60\15\1\41\1\42"+
    "\1\43\1\22\1\44\3\41\1\45\1\44\1\41\4\44"+
    "\3\41\1\46\3\41\21\44\1\47\1\41\3\44\1\41"+
    "\3\44\10\41\1\50\1\42\1\43\1\22\1\51\2\50"+
    "\1\52\1\50\1\51\1\50\4\51\3\50\1\53\1\54"+
    "\2\50\21\51\1\50\1\55\3\51\1\50\3\51\1\56"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\77\0"+
    "\1\66\67\0\1\67\62\0\1\22\74\0\1\70\14\0"+
    "\1\71\1\0\1\72\2\0\1\73\1\0\1\74\3\0"+
    "\1\75\1\76\1\77\1\0\1\100\46\0\1\101\1\102"+
    "\53\0\1\103\3\0\1\104\2\0\1\105\10\0\1\106"+
    "\1\0\1\107\1\110\1\0\1\111\3\0\1\112\5\0"+
    "\1\113\44\0\1\114\66\0\1\115\47\0\1\34\65\0"+
    "\10\116\1\15\1\116\3\15\1\117\1\120\1\121\1\122"+
    "\5\15\1\116\2\15\14\116\1\15\2\116\1\15\3\116"+
    "\1\15\3\116\10\15\7\0\1\123\15\0\1\124\51\0"+
    "\1\125\16\0\1\126\43\0\1\43\71\0\3\44\2\0"+
    "\1\44\1\0\6\44\5\0\21\44\2\0\3\44\1\0"+
    "\3\44\14\0\3\51\2\0\1\51\1\0\6\51\5\0"+
    "\21\51\2\0\3\51\1\0\3\51\14\0\1\127\4\0"+
    "\1\127\1\0\4\127\7\0\21\127\2\0\3\127\1\0"+
    "\3\127\61\0\1\130\3\0\1\131\41\0\1\132\72\0"+
    "\1\133\67\0\1\134\2\0\1\135\66\0\1\136\63\0"+
    "\1\137\76\0\1\140\62\0\1\141\35\0\1\101\2\0"+
    "\65\101\26\0\1\142\3\0\1\143\67\0\1\144\64\0"+
    "\1\145\75\0\1\146\71\0\1\147\57\0\1\150\75\0"+
    "\1\151\62\0\1\152\55\0\1\153\56\0\1\154\3\0"+
    "\1\154\2\0\1\154\2\0\2\154\11\0\1\154\2\0"+
    "\1\154\3\0\1\154\1\0\1\154\1\0\1\154\3\0"+
    "\1\154\3\0\1\154\1\0\1\154\15\0\1\155\3\0"+
    "\1\155\2\0\1\155\2\0\2\155\11\0\1\155\2\0"+
    "\1\155\3\0\1\155\1\0\1\155\1\0\1\155\3\0"+
    "\1\155\3\0\1\155\1\0\1\155\27\0\2\122\66\0"+
    "\2\15\74\0\1\116\70\0\1\156\70\0\1\157\44\0"+
    "\3\127\1\160\1\0\1\127\1\0\6\127\5\0\21\127"+
    "\2\0\3\127\1\0\3\127\62\0\1\161\73\0\1\162"+
    "\37\0\1\163\74\0\1\164\51\0\1\165\110\0\1\166"+
    "\61\0\1\167\74\0\1\170\74\0\1\171\66\0\1\172"+
    "\55\0\1\173\102\0\1\174\61\0\1\175\65\0\1\176"+
    "\4\0\1\177\72\0\1\200\65\0\1\201\72\0\1\202"+
    "\52\0\1\203\76\0\1\204\64\0\1\205\42\0\1\15"+
    "\3\0\1\15\2\0\1\15\2\0\2\15\11\0\1\15"+
    "\2\0\1\15\3\0\1\15\1\0\1\15\1\0\1\15"+
    "\3\0\1\15\3\0\1\15\1\0\1\15\15\0\1\206"+
    "\3\0\1\206\2\0\1\206\2\0\2\206\11\0\1\206"+
    "\2\0\1\206\3\0\1\206\1\0\1\206\1\0\1\206"+
    "\3\0\1\206\3\0\1\206\1\0\1\206\37\0\1\207"+
    "\66\0\1\210\114\0\1\211\73\0\1\212\40\0\1\213"+
    "\73\0\1\214\63\0\1\215\76\0\1\216\56\0\1\217"+
    "\54\0\1\220\110\0\1\221\66\0\1\222\65\0\1\223"+
    "\103\0\1\224\55\0\1\225\76\0\1\226\61\0\1\227"+
    "\65\0\1\230\65\0\1\231\37\0\4\232\3\233\2\232"+
    "\1\233\1\232\6\233\5\232\21\233\2\232\3\233\1\232"+
    "\3\233\10\232\13\0\1\234\67\0\1\235\114\0\1\236"+
    "\34\0\1\237\3\0\1\237\2\0\1\237\2\0\2\237"+
    "\11\0\1\237\2\0\1\237\3\0\1\237\1\0\1\237"+
    "\1\0\1\237\3\0\1\237\3\0\1\237\1\0\1\237"+
    "\36\0\1\240\71\0\1\241\113\0\1\242\67\0\1\243"+
    "\37\0\1\244\3\0\1\245\71\0\1\246\66\0\1\247"+
    "\54\0\1\250\110\0\1\251\60\0\1\252\76\0\1\253"+
    "\65\0\1\254\64\0\1\255\67\0\1\256\72\0\1\257"+
    "\77\0\1\260\52\0\1\261\37\0\4\262\3\263\2\262"+
    "\1\263\1\262\6\263\5\262\21\263\2\262\3\263\1\262"+
    "\3\263\10\262\4\264\3\265\2\264\1\265\1\264\6\265"+
    "\5\264\21\265\2\264\3\265\1\264\3\265\10\264\70\232"+
    "\4\266\3\267\2\266\1\267\1\266\6\267\5\266\21\267"+
    "\2\266\3\267\1\266\3\267\10\266\30\0\1\270\67\0"+
    "\1\271\67\0\1\123\64\0\1\272\73\0\1\273\51\0"+
    "\1\274\67\0\1\275\104\0\1\276\66\0\1\277\40\0"+
    "\4\300\3\301\2\300\1\301\1\300\6\301\5\300\21\301"+
    "\2\300\3\301\1\300\3\301\10\300\27\0\1\302\53\0"+
    "\1\303\67\0\1\304\117\0\1\305\65\0\1\306\60\0"+
    "\1\307\63\0\1\310\41\0\70\262\70\264\70\266\4\311"+
    "\3\312\2\311\1\312\1\311\6\312\5\311\21\312\2\311"+
    "\3\312\1\311\3\312\10\311\4\313\3\314\2\313\1\314"+
    "\1\313\6\314\5\313\21\314\2\313\3\314\1\313\3\314"+
    "\10\313\13\0\1\315\54\0\4\316\3\317\2\316\1\317"+
    "\1\316\6\317\5\316\21\317\2\316\3\317\1\316\3\317"+
    "\10\316\37\0\1\320\30\0\4\321\3\322\2\321\1\322"+
    "\1\321\6\322\5\321\21\322\2\321\3\322\1\321\3\322"+
    "\10\321\4\323\3\324\2\323\1\324\1\323\6\324\5\323"+
    "\21\324\2\323\3\324\1\323\3\324\10\323\70\300\32\0"+
    "\1\325\67\0\1\326\63\0\1\327\41\0\4\330\3\331"+
    "\2\330\1\331\1\330\6\331\5\330\21\331\2\330\3\331"+
    "\1\330\3\331\10\330\32\0\1\332\100\0\1\333\63\0"+
    "\1\334\30\0\70\311\70\313\37\0\1\335\30\0\70\316"+
    "\44\0\1\336\23\0\70\321\70\323\27\0\1\337\40\0"+
    "\4\340\3\341\2\340\1\341\1\340\6\341\5\340\21\341"+
    "\2\340\3\341\1\340\3\341\10\340\30\0\1\342\37\0"+
    "\70\330\4\343\3\344\2\343\1\344\1\343\6\344\5\343"+
    "\21\344\2\343\3\344\1\343\3\344\10\343\4\345\3\346"+
    "\2\345\1\346\1\345\6\346\5\345\21\346\2\345\3\346"+
    "\1\345\3\346\10\345\27\0\1\347\104\0\1\350\23\0"+
    "\4\351\3\352\2\351\1\352\1\351\6\352\5\351\21\352"+
    "\2\351\3\352\1\351\3\352\10\351\30\0\1\353\37\0"+
    "\70\340\4\354\3\355\2\354\1\355\1\354\6\355\5\354"+
    "\21\355\2\354\3\355\1\354\3\355\10\354\70\343\70\345"+
    "\4\356\3\357\2\356\1\357\1\356\6\357\5\356\21\357"+
    "\2\356\3\357\1\356\3\357\10\356\4\360\3\361\2\360"+
    "\1\361\1\360\6\361\5\360\21\361\2\360\3\361\1\360"+
    "\3\361\10\360\70\351\4\362\3\363\2\362\1\363\1\362"+
    "\6\363\5\362\21\363\2\362\3\363\1\362\3\363\10\362"+
    "\70\354\70\356\70\360\70\362";

  private static int [] zzUnpackTrans() {
    int [] result = new int[10360];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\13\0\2\11\2\1\1\11\1\1\1\11\2\1\1\11"+
    "\2\1\1\11\3\1\2\11\3\1\1\11\1\1\1\11"+
    "\1\1\1\11\1\1\2\11\3\1\1\11\1\1\14\11"+
    "\7\0\1\1\1\11\11\0\3\11\4\1\1\0\1\11"+
    "\30\0\1\1\2\0\1\11\21\0\1\7\3\0\1\1"+
    "\21\0\2\7\1\5\1\0\1\7\2\0\1\1\2\0"+
    "\3\11\5\0\1\7\7\0\1\5\1\0\1\5\1\0"+
    "\1\5\1\0\2\7\1\11\1\0\1\7\1\0\2\7"+
    "\1\5\4\0\1\7\3\0\1\5\1\0\1\5\2\0"+
    "\1\5\2\0\1\5\1\0\1\5\2\0\1\7\1\0"+
    "\1\5\1\0\2\7\2\0\1\7\1\0\1\5\1\0"+
    "\1\7\1\5\1\0\1\5\1\0\2\7\1\5\1\0"+
    "\1\7\1\5\1\0\1\5\1\0\1\5\1\0\1\5"+
    "\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[243];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  //// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
  
  //// Position ////////////////////////////////////////////////////////////////
  
  //records the position of a symbol
  private static class PositionRecord {
      int startLine = -1;
      int startCol = -1;
      int endLine = -1;
      int endCol = -1;
  }
  
  //the position of the current symbol
  private PositionRecord pos = new PositionRecord();
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markStartPosition() {
    //correct to one-indexed
    pos.startLine = yyline + 1;
    pos.startCol = yycolumn + 1;
  }
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markEndPosition() {
    //correct to one-indexed
    pos.endLine = yyline + 1;
    pos.endCol = (yycolumn + 1) + yylength() - 1;
  }
  
  //like symbol(type), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type) {
    return symbolFromMarkedPositions(type, null);
  }
  
  //like symbol(type, value), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type, Object value) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.endLine, pos.endCol);
  }
  
  //like symbol(type), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, int length) {
    return symbolFromMarkedStart(type, null, length);
  }
  
  //like symbol(type, value), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, Object value, int length) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.startLine, pos.startCol + length - 1);
  }
  
  //// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
  
  //// State transitions ///////////////////////////////////////////////////////
  
  //stack entry: stack identifier + symbol position
  private static class StateRecord {
    int stateNum;
    PositionRecord pos;
    
    StateRecord(int stateNum, PositionRecord pos) {
        this.stateNum = stateNum;
        this.pos = pos;
    }
  }
  
  //most of our states are used for bracketing
  //this gives us a way to nest bracketing states
  private java.util.Stack<StateRecord> stateStack = new java.util.Stack<StateRecord>();
  
  void saveStateAndTransition(int newState) {
    stateStack.push(new StateRecord(yystate(), pos));
    pos = new PositionRecord();
    yybegin(newState);
  }
  
  void restoreState() {
    StateRecord rec = stateStack.pop();
    yybegin(rec.stateNum);
    pos = rec.pos;
  }
  
  //// Comment nesting /////////////////////////////////////////////////////////
  
  //number of '*/'s or '}'s expected
  private int nestingDepth = 0;
  
  //// Blob accumulation ///////////////////////////////////////////////////////
  
  //for accumulating the contents of a string literal, comment, action, etc
  private StringBuffer blobBuf = new StringBuffer();
  
  //// Other ///////////////////////////////////////////////////////////////////
  
  //for deleting terminal line breaks
  private static String frontChomp(String oldString) {
    if(oldString.startsWith("\r\n")) {
        return oldString.substring(2);
    } else if(oldString.startsWith("\n") || oldString.startsWith("\r")) {
        return oldString.substring(1);
    } else {
        return oldString;
    }
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public LayoutScanner(java.io.Reader in) {
    saveStateAndTransition(INSIDE_LOCAL_HEADER_SECTION);
  blobBuf = new StringBuffer();
  markStartPosition();
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public LayoutScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 154) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol nextToken() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;
    int zzPushbackPosL = zzPushbackPos = -1;
    boolean zzWasPushback;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;

      zzWasPushback = false;

      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            zzPushbackPos = zzPushbackPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            zzPushbackPosL = zzPushbackPos;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 2) == 2 )
            zzPushbackPosL = zzCurrentPosL;

          if ( (zzAttributes & 1) == 1 ) {
            zzWasPushback = (zzAttributes & 4) == 4;
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;
      if (zzWasPushback)
        zzMarkedPos = zzPushbackPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 4: 
          { /* ignore */
          }
        case 61: break;
        case 57: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(START_INHERIT_GROUP);
          }
        case 62: break;
        case 5: 
          { error("Invalid directive");
          }
        case 63: break;
        case 50: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(LAYOUT_DIRECTIVE);
          }
        case 64: break;
        case 52: 
          { return symbol(START_EMBED_GROUP);
          }
        case 65: break;
        case 39: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(EMBEDDING_NAME);
          }
        case 66: break;
        case 46: 
          { saveStateAndTransition(INSIDE_META_PATTERN_DIRECTIVE);
        return symbol(EMBEDDING_START);
          }
        case 67: break;
        case 29: 
          { restoreState();
        saveStateAndTransition(INSIDE_RULE_SECTION);
        //TODO-AC: return symbol(SECTION_SEPARATOR);?
          }
        case 68: break;
        case 51: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(OPTION_DIRECTIVE);
          }
        case 69: break;
        case 15: 
          { return symbol(COMMA);
          }
        case 70: break;
        case 11: 
          { error("Unexpected character in directive option list: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 71: break;
        case 58: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_UNOPTION);
          }
        case 72: break;
        case 6: 
          { error("Unexpected character in rule section: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 73: break;
        case 33: 
          { //blobBuf.append(yytext());
        nestingDepth++;
          }
        case 74: break;
        case 43: 
          { return symbol(MP_BOF);
          }
        case 75: break;
        case 20: 
          { return symbol(MP_RPAREN);
          }
        case 76: break;
        case 27: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(LOCAL_HEADER, blobBuf.toString());
        restoreState();
        
        saveStateAndTransition(INSIDE_INHERITED_HEADER_SECTION);
        blobBuf = new StringBuffer();
        markStartPosition();
        
        return sym;
        //TODO-AC: pushback separator and return it later?
          }
        case 77: break;
        case 17: 
          { return symbol(MP_SYM, yytext());
          }
        case 78: break;
        case 14: 
          { saveStateAndTransition(INSIDE_STRING);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 79: break;
        case 13: 
          { return symbol(IDENTIFIER, yytext());
          }
        case 80: break;
        case 48: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(INIT_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 81: break;
        case 16: 
          { error("Unexpected character in meta-pattern: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 82: break;
        case 28: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(INHERITED_HEADER, frontChomp(blobBuf.toString()));
        restoreState();
        saveStateAndTransition(INSIDE_OPTION_SECTION);
        return sym;
        //TODO-AC: pushback separator and return it later?
          }
        case 83: break;
        case 25: 
          { return symbol(MP_OPT);
          }
        case 84: break;
        case 31: 
          { /* ignore */
        //return symbol(COMMENT, yytext());
          }
        case 85: break;
        case 24: 
          { return symbol(MP_PLUS);
          }
        case 86: break;
        case 35: 
          { blobBuf.append(yytext().substring(1));
          }
        case 87: break;
        case 30: 
          { saveStateAndTransition(INSIDE_DECL_REGION);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 88: break;
        case 22: 
          { return symbol(MP_RSQUARE);
          }
        case 89: break;
        case 32: 
          { saveStateAndTransition(INSIDE_BRACKET_COMMENT);
        //blobBuf = new StringBuffer(yytext());
        //markStartPosition();
        nestingDepth++;
          }
        case 90: break;
        case 44: 
          { saveStateAndTransition(INSIDE_INIT_REGION);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 91: break;
        case 54: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_REPLACE);
          }
        case 92: break;
        case 34: 
          { //blobBuf.append(yytext());
        nestingDepth--;
        if(nestingDepth == 0) {
            //markEndPosition();
            //Symbol sym = symbolFromMarkedPositions(BRACKET_COMMENT, blobBuf.toString());
            restoreState();
            //return sym;
        }
          }
        case 93: break;
        case 1: 
          { error("Unexpected character: " + yytext());
          }
        case 94: break;
        case 3: 
          { error("Unexpected character in option section: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 95: break;
        case 26: 
          { return symbol(MP_OR);
          }
        case 96: break;
        case 2: 
          { blobBuf.append(yytext());
          }
        case 97: break;
        case 47: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(EMBEDDING_GUEST);
          }
        case 98: break;
        case 37: 
          { return symbol(MP_REGION, yytext().substring(1, yylength() - 1));
          }
        case 99: break;
        case 59: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INITTHROW_DIRECTIVE);
          }
        case 100: break;
        case 38: 
          { saveStateAndTransition(INSIDE_META_PATTERN_DIRECTIVE);
        return symbol(EMBEDDING_END);
          }
        case 101: break;
        case 55: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_UNEMBED);
          }
        case 102: break;
        case 18: 
          { return symbol(MP_STAR);
          }
        case 103: break;
        case 53: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(DECLARE_DIRECTIVE);
          }
        case 104: break;
        case 36: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(DECL_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 105: break;
        case 19: 
          { return symbol(MP_LPAREN);
          }
        case 106: break;
        case 9: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(STRING, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 107: break;
        case 56: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(LEXTHROW_DIRECTIVE);
          }
        case 108: break;
        case 45: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(START_DIRECTIVE);
          }
        case 109: break;
        case 23: 
          { return symbol(MP_CARET);
          }
        case 110: break;
        case 60: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(COMPONENT_DIRECTIVE);
          }
        case 111: break;
        case 42: 
          { return symbol(MP_ANY);
          }
        case 112: break;
        case 40: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(EMBEDDING_HOST);
          }
        case 113: break;
        case 7: 
          { //blobBuf.append(yytext());
          }
        case 114: break;
        case 49: 
          { return symbol(HELPER_DIRECTIVE);
          }
        case 115: break;
        case 10: 
          { yybegin(YYINITIAL);
        error("Incomplete escape sequence");
          }
        case 116: break;
        case 8: 
          { yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
          }
        case 117: break;
        case 12: 
          { restoreState(); /* ignore */
          }
        case 118: break;
        case 21: 
          { return symbol(MP_LSQUARE);
          }
        case 119: break;
        case 41: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(EMBEDDING_PAIR);
          }
        case 120: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case INSIDE_INHERITED_HEADER_SECTION: {
              yybegin(YYINITIAL); 
        error("Unterminated inherited header section.");
            }
            case 244: break;
            case INSIDE_BRACKET_COMMENT: {
              yybegin(YYINITIAL);
        //don't finish scanning if there's an unclosed comment
        if(nestingDepth != 0) {
            error(nestingDepth + " levels of comments not closed");
        }
            }
            case 245: break;
            case INSIDE_STRING_IDENTIFIER_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 246: break;
            case INSIDE_DECL_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated declaration region: '" + blobBuf + "'");
            }
            case 247: break;
            case INSIDE_STRING: {
              yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
            }
            case 248: break;
            case INSIDE_OPTION_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 249: break;
            case INSIDE_LOCAL_HEADER_SECTION: {
              yybegin(YYINITIAL); 
        error("Unterminated local header section.");
            }
            case 250: break;
            case YYINITIAL: {
              return symbol(EOF);
            }
            case 251: break;
            case INSIDE_META_PATTERN_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 252: break;
            case INSIDE_INIT_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated init region: '" + blobBuf + "'");
            }
            case 253: break;
            case INSIDE_RULE_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 254: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
