package metalexer;

import metalexer.StringEval;
import junit.framework.TestCase;

public class StringEvalTests extends TestCase {
    public void testUEvals() {
        checkEval("\"\\u1\"", "\u0001");
        checkEval("\"\\u10\"", "\u0010");
        checkEval("\"\\u100\"", "\u0100");
        checkEval("\"\\u1000\"", "\u1000");
    }

    public void testXEvals() {
        checkEval("\"\\x01\"", "\u0001");
    }

    public void testOctalEvals() {
        checkEval("\"\\1\"", "\u0001");
        checkEval("\"\\10\"", "\u0008");
        checkEval("\"\\100\"", "\u0040");
    }

    public void testLineEndingEvals() {
        checkEval("\"\n\"", "\n");
        checkEval("\"\r\"", "\r");
        checkEval("\"\\\n\"", "\n");
        checkEval("\"\\\r\"", "\r");
    }

    public void testTraditionalEvals() {
        //traditional
        checkEval("\"\\n\"", "\n");
        checkEval("\"\\r\"", "\r");
        checkEval("\"\\t\"", "\t");
        checkEval("\"\\f\"", "\f");
        checkEval("\"\\b\"", "\b");
    }

    public void testMetaEvals() {
        checkEval("\"\\\\\"", "\\");
        checkEval("\"\\|\"", "|");
        checkEval("\"\\(\"", "(");
        checkEval("\"\\)\"", ")");
        checkEval("\"\\{\"", "{");
        checkEval("\"\\}\"", "}");
        checkEval("\"\\[\"", "[");
        checkEval("\"\\]\"", "]");
        checkEval("\"\\<\"", "<");
        checkEval("\"\\>\"", ">");
        checkEval("\"\\.\"", ".");
        checkEval("\"\\*\"", "*");
        checkEval("\"\\+\"", "+");
        checkEval("\"\\?\"", "?");
        checkEval("\"\\^\"", "^");
        checkEval("\"\\$\"", "$");
        checkEval("\"\\/\"", "/");
        checkEval("\"\\\"\"", "\"");
        checkEval("\"\\~\"", "~");
        checkEval("\"\\!\"", "!");
        checkEval("\"\\-\"", "-");
    }

    public void testOtherEvals() {
        checkEval("\"\\a\"", "a");
        checkEval("\"\\q\"", "q");
    }

    public void testDoubleEvals() {
        checkEval("\"\\\\u1\"", "\\u1");
        checkEval("\"\\\\1\"", "\\1");
        checkEval("\"\\\\\n\"", "\\\n");
    }

    private static void checkEval(String original, String expected) {
        assertEquals("Evaluating: ", expected, StringEval.evalString(original));
    }
}
