package pi;

%%
//// This file was generated by MetaLexer ////

//from ./ml_bad.mll [13, 1]
%public
//from ./ml_bad.mll [14, 1]
%final
//from ./ml_bad.mll [15, 1]
%class MLBadPiScanner
//from ./ml_bad.mll [16, 1]
%implements PiScanner
//from ./ml_bad.mll [17, 1]
%unicode
//from ./ml_bad.mll [18, 1]
%function getFreqs
//from ./ml_bad.mll [19, 1]
%type int[]

%{
    private final StateClass_ml_bad state_ml_bad = new StateClass_ml_bad();
%}

%{
    private class StateClass_ml_bad {
        private StateClass_ml_bad() {
            metaLexerThread.start();
            
            //from ./ml_bad.mll [27, 1]
            embeddingRecordArray[0] = new EmbeddingRecord("embed", inst_ml_bad2, new PairFilter.Builder().add(/*%ml_bad1%*/ '\u0030', /*%ml_bad2%*/ '\u0033').build());
            
            //from ./ml_bad.mll [8, 8]
            yybegin(ml_bad1_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(null, inst_ml_bad1, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            
            restartAppendBuf();
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[1];
        private final CompClass_ml_bad1 inst_ml_bad1 = new CompClass_ml_bad1();
        private final CompClass_ml_bad2 inst_ml_bad2 = new CompClass_ml_bad2();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private int[] extraReturn = null;
        private int prevState = -1;
        
        public int[] getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(int[] value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private boolean stopped = false;
        
        public void stop() {
            stopped = true;
            pipe.writeFinal('\n');
            boolean joined = false;
            while(!joined) {
                try {
                    metaLexerThread.join();
                    joined = true;
                } catch(InterruptedException e) {}
            }
        }
        
        private final Pipe pipe = new Pipe();
        private final MLBadPiScanner_Meta metalexer = new MLBadPiScanner_Meta(pipe);
        private final Thread metaLexerThread = new Thread(new Runnable() {
            public void run() {
                try {
                    metalexer.start();
                } catch(java.io.IOException e) {
                    //unrecoverable
                    e.printStackTrace();
                }
            }}, "MetaLexerThread");
        
        private MLBadPiScanner_Meta.Transition sendMTok(char mtok) {
            if(stopped) {
                throw new IllegalStateException("No meta-tokens may be sent after stop() has been called.");
            }
            pipe.write(mtok);
            return metalexer.checkForTransition();
        }
        
        public void processMTok(char mtok) {
            if(!getCurrFilter().test(mtok)) {
                return; //don't send character if it gets filtered out
            }
            Maybe<? extends int[]> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MLBadPiScanner_Meta.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                next = null;
                if(endOfEmbedding) {
                    char regionChar = currComp.getCharValue();
                    if(getCurrFilter().test(regionChar)) {
                        next = sendMTok(regionChar);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends int[]> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract char getCharValue();
    }
%}

%{
    //from ./ml_bad1.mlc [1, 1]
    private class CompClass_ml_bad1 extends ComponentInnerClass {
        
        public CompClass_ml_bad1() {
        }
        
        private static final int YYINITIAL = ml_bad1_YYINITIAL_STATE; //from ./ml_bad1.mlc [1, 1]
        
        
        public int getStartState() {
            //from ./ml_bad1.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0030';
        }
        
        public Maybe<? extends int[]> ml_bad1_action_1() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_1()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [5, 3]
                freq[0]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_2() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_2()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [6, 3]
                freq[1]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_3() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_3()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [7, 3]
                freq[2]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_4() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_4()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [8, 3]
                freq[3]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_5() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_5()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [9, 3]
                freq[4]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_6() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_6()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [10, 3]
                freq[5]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_7() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_7()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [11, 3]
                freq[6]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_8() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_8()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [12, 3]
                freq[7]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_9() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_9()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [13, 3]
                freq[8]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_10() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_10()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [14, 3]
                freq[9]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_11() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_11()");
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad1_action_12() {
            //System.err.println("state_ml_bad.inst_ml_bad1.ml_bad1_action_12()");
            if(Object.class != null) {
                //from ./ml_bad1.mlc [20, 9]
                return Maybe.Just(freq);
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from ./ml_bad2.mlc [1, 1]
    private class CompClass_ml_bad2 extends ComponentInnerClass {
        
        public CompClass_ml_bad2() {
        }
        
        private static final int YYINITIAL = ml_bad2_YYINITIAL_STATE; //from ./ml_bad2.mlc [1, 1]
        
        
        public int getStartState() {
            //from ./ml_bad2.mlc [1, 1]
            return YYINITIAL;
        }
        
        public char getCharValue() {
            return '\u0033';
        }
        
        public Maybe<? extends int[]> ml_bad2_action_1() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_1()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [5, 3]
                freq[0]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_2() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_2()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [6, 3]
                freq[1]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_3() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_3()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [7, 3]
                freq[2]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_4() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_4()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [8, 3]
                freq[3]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_5() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_5()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [9, 3]
                freq[4]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_6() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_6()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [10, 3]
                freq[5]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_7() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_7()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [11, 3]
                freq[6]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_8() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_8()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [12, 3]
                freq[7]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_9() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_9()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [13, 3]
                freq[8]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_10() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_10()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [14, 3]
                freq[9]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_11() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_11()");
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_bad2_action_12() {
            //System.err.println("state_ml_bad.inst_ml_bad2.ml_bad2_action_12()");
            if(Object.class != null) {
                //from ./ml_bad2.mlc [20, 9]
                return Maybe.Just(freq);
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
        private final java.util.Set<Character> allOpenChars;
        private final java.util.List<Character> unclosedOpenChars; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Character, java.util.Set<Character>> pairMap, java.util.Set<Character> allOpenChars) {
            this.pairMap = pairMap;
            this.allOpenChars = allOpenChars;
            this.unclosedOpenChars = new java.util.ArrayList<Character>();
        }
        
        public static class Builder {
            private final java.util.Map<Character, java.util.Set<Character>> pairMap; //close -> open
            private final java.util.Set<Character> allOpenChars;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Character, java.util.Set<Character>>();
                this.allOpenChars = new java.util.HashSet<Character>();
            }
            
            public Builder add(char open, char close) {
                allOpenChars.add(open);
                java.util.Set<Character> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Character>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenChars);
            }
        }
        
        public boolean test(char ch) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Character> correspondingOpens = pairMap.get(ch);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Character> it = unclosedOpenChars.iterator(); it.hasNext(); ) {
                    char open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenChars.contains(ch)) { //implies opening
                unclosedOpenChars.add(0, ch); //insert at beginning
            }
            return true;
        }
        
        public void clean(String chars) {
            for(char ch : new StringBuffer(chars).reverse().toString().toCharArray()) {
                if(unclosedOpenChars.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenChars.get(0) == ch) {
                    unclosedOpenChars.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenChars.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    public static class Pipe extends java.io.Reader {
        private final java.util.concurrent.locks.Lock monitorLock = new java.util.concurrent.locks.ReentrantLock();
        private final java.util.Queue<java.util.concurrent.locks.Condition> waitingForFirstRead = new java.util.LinkedList<java.util.concurrent.locks.Condition>();
        private java.util.Map<Thread, java.util.concurrent.locks.Condition> waitingForSecondRead = new java.util.HashMap<Thread, java.util.concurrent.locks.Condition>();
        
        private final java.util.Queue<Character> writeQueue = new java.util.LinkedList<Character>();
        private final java.util.concurrent.locks.Condition notEmpty = monitorLock.newCondition();
        
        private boolean closed = false;
        private boolean eof = false;
        
        public void write(char ch) {
            write(ch, false);
        }
        
        //NB: combine write() with eof() because the last write() will block, making it hard to call eof()
        public void writeFinal(char ch) {
            write(ch, true);
        }
        
        private void write(char ch, boolean isFinal) {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot write after the read end has been closed.");
                }
                if(eof) {
                    throw new IllegalStateException("Cannot write after EOF.");
                }
                if(isFinal) {
                    eof = true;
                }
                writeQueue.add(ch);
                java.util.concurrent.locks.Condition cond = monitorLock.newCondition();
                waitingForFirstRead.add(cond);
                notEmpty.signalAll();
                cond.awaitUninterruptibly();
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        //NB: ignore length and always write 1 byte (unless at EOF)
        public int read(char[] buf, int offset, int length) throws java.io.IOException {
            monitorLock.lock();
            try {
                if(closed) {
                    throw new IllegalStateException("Cannot read after the read end has been closed.");
                }
                boolean freedWriter = freeNextWriter();
                while(!eof && writeQueue.isEmpty()) {
                    notEmpty.awaitUninterruptibly();
                    if(!freedWriter) {
                        freedWriter = freeNextWriter();
                    }
                }
                if(eof && writeQueue.isEmpty()) {
                    //no writers waiting, so none to free
                    return -1;
                }
                waitingForSecondRead.put(Thread.currentThread(), waitingForFirstRead.poll());
                buf[offset] = writeQueue.poll();
                return 1;
            } finally {
                monitorLock.unlock();
            }
        }
        
        @Override
        public void close() throws java.io.IOException {
            monitorLock.lock();
            try {
                closed = true;
                freeAllWriters();
            } finally {
                monitorLock.unlock();
            }
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private boolean freeNextWriter() {
            java.util.concurrent.locks.Condition cond = waitingForSecondRead.get(Thread.currentThread());
            if(cond != null) {
                cond.signal();
                waitingForSecondRead.remove(Thread.currentThread());
                return true;
            }
            return false;
        }
        
        //NB: didn't bother with monitorLock because this method is always called safely
        private void freeAllWriters() {
            for(java.util.concurrent.locks.Condition cond : waitingForSecondRead.values()) {
                cond.signal();
            }
            waitingForSecondRead.clear();
            for(java.util.concurrent.locks.Condition cond : waitingForFirstRead) {
                cond.signal();
            }
            waitingForFirstRead.clear();
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isJust() {
            return !isNothing();
        }
        public abstract boolean isNothing();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isNothing() {
                return false;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isNothing() {
                return true;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

%{
    public void stop() {
        state_ml_bad.stop();
    }
%}

//from null [21, 1]
%{
    private final int[] freq = new int[10];
%}


%xstate EXTRA_RETURN

//from ./ml_bad1.mlc [1, 1]
%state ml_bad1_YYINITIAL_STATE
//from ./ml_bad2.mlc [1, 1]
%state ml_bad2_YYINITIAL_STATE


%%

<EXTRA_RETURN> {
    (. | \n) {
        yybegin(state_ml_bad.getPrevState());
        return state_ml_bad.getExtraReturn();
    }
    
    <<EOF>> {
        yybegin(state_ml_bad.getPrevState());
        return state_ml_bad.getExtraReturn();
    }
}

<ml_bad1_YYINITIAL_STATE> {
    //from ./ml_bad1.mlc [5, 1]
    0 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_1();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [6, 1]
    1 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_2();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [7, 1]
    2 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_3();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [8, 1]
    3 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_4();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [9, 1]
    4 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_5();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [10, 1]
    5 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_6();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [11, 1]
    6 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_7();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [12, 1]
    7 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_8();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [13, 1]
    8 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_9();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [14, 1]
    9 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_10();
        } finally {
            state_ml_bad.processMTok('\u0031'); //START
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<ml_bad1_YYINITIAL_STATE> {
    //from ./ml_bad1.mlc [19, 1]
    (. | \n) {
        Maybe<? extends int[]> maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad1.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends int[]> maybeResult = state_ml_bad.inst_ml_bad1.ml_bad1_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<ml_bad2_YYINITIAL_STATE> {
    //from ./ml_bad2.mlc [5, 1]
    0 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_1();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [6, 1]
    1 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_2();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [7, 1]
    2 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_3();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [8, 1]
    3 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_4();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [9, 1]
    4 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_5();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [10, 1]
    5 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_6();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [11, 1]
    6 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_7();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [12, 1]
    7 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_8();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [13, 1]
    8 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_9();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [14, 1]
    9 {
        Maybe<? extends int[]> maybeResult;
        try {
            maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_10();
        } finally {
            state_ml_bad.processMTok('\u0034'); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<ml_bad2_YYINITIAL_STATE> {
    //from ./ml_bad2.mlc [19, 1]
    (. | \n) {
        Maybe<? extends int[]> maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_bad2.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends int[]> maybeResult = state_ml_bad.inst_ml_bad2.ml_bad2_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


