/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.io;

import beaver.comp.util.IntArray;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class SrcReader
extends Reader {
    public final File file;
    protected char[] txt;
    protected IntArray lines;
    private int ptr;

    public SrcReader(File src_file) throws IOException {
        this.file = src_file;
        FileReader txt_reader = new FileReader(src_file);
        try {
            this.txt = new char[(int)src_file.length()];
            txt_reader.read(this.txt);
        }
        finally {
            ((Reader)txt_reader).close();
        }
        this.lines = new IntArray(this.txt.length / 20 + 20);
        boolean eol = true;
        boolean cr = false;
        int i = 0;
        while (i < this.txt.length) {
            if (eol) {
                this.lines.add(i);
                eol = false;
            }
            switch (this.txt[i]) {
                case '\u000b': 
                case '\f': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    eol = true;
                    cr = false;
                    break;
                }
                case '\r': {
                    if (cr) {
                        eol = true;
                    }
                    cr = true;
                    break;
                }
                case '\n': {
                    if (cr) {
                        cr = false;
                    }
                    eol = true;
                    break;
                }
                default: {
                    if (cr) {
                        eol = true;
                    }
                    cr = false;
                }
            }
            ++i;
        }
    }

    public int read(char[] buf, int off, int len) {
        int copy_max = this.txt.length - this.ptr;
        if (copy_max <= 0) {
            return -1;
        }
        int copy_len = Math.min(copy_max, len);
        if (copy_len > 0) {
            System.arraycopy(this.txt, this.ptr, buf, off, copy_len);
            this.ptr += copy_len;
        }
        return copy_len;
    }

    public void reset() {
        this.ptr = 0;
    }

    public void close() {
    }

    public String getLine(int n) {
        int line_start = this.lines.get(n - 1);
        int line_len = (n == this.lines.size() ? this.txt.length : this.lines.get(n)) - line_start;
        return new String(this.txt, line_start, line_len);
    }
}

