/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.Action;
import beaver.comp.State;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.Terminal;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

class ParsingTables {
    public final State first_state;
    final int n_term;
    short[] actions;
    short[] lookaheads;
    int[] terminal_offsets;
    int[] nonterminal_offsets;
    int last_action_index;
    short[] default_actions;
    boolean compressed;
    static final int UNUSED_OFFSET = Integer.MIN_VALUE;

    ParsingTables(Grammar grammar, State listArray) {
        int n = ParsingTables.countStates((State)listArray);
        this.first_state = listArray;
        this.n_term = grammar.terminals.length;
        this.default_actions = new short[n + 1];
        this.terminal_offsets = new int[n + 1];
        this.nonterminal_offsets = new int[n + 1];
        Arrays.fill(this.terminal_offsets, Integer.MIN_VALUE);
        Arrays.fill(this.nonterminal_offsets, Integer.MIN_VALUE);
        this.actions = new short[16384];
        this.lookaheads = new short[this.actions.length];
        Arrays.fill(this.lookaheads, (short)-1);
        ArrayList<Action.List> arrayList = new ArrayList<Action.List>(n * 2);
        Action.List[] listArray2 = listArray;
        while (listArray2 != null) {
            if (listArray2.default_action != null) {
                this.default_actions[listArray2.id] = listArray2.default_action.getId();
                this.compressed = true;
            }
            if (listArray2.terminal_lookahead_actions.num_actions > 0) {
                arrayList.add(listArray2.terminal_lookahead_actions);
            }
            if (listArray2.nonterminal_lookahead_actions.num_actions > 0) {
                arrayList.add(listArray2.nonterminal_lookahead_actions);
            }
            listArray2 = listArray2.next;
        }
        listArray2 = arrayList.toArray(new Action.List[arrayList.size()]);
        Arrays.sort(listArray2, Action.List.NUM_ACTIONS_CMP);
        this.renumberSymbols(grammar, listArray2);
        int n2 = 0;
        for (int i = 0; i < listArray2.length; ++i) {
            Action.List list = listArray2[i];
            int n3 = this.findOffset(list, n2);
            if (list.first.lookahead instanceof Terminal) {
                if (this.terminal_offsets[list.state.id] != Integer.MIN_VALUE) {
                    throw new IllegalStateException("terminal offset " + list.state.id + " is used");
                }
                this.terminal_offsets[list.state.id] = n3;
            } else {
                if (this.nonterminal_offsets[list.state.id] != Integer.MIN_VALUE) {
                    throw new IllegalStateException("nonterminal offset " + list.state.id + " is used");
                }
                this.nonterminal_offsets[list.state.id] = n3;
            }
            this.last_action_index = Math.max(this.last_action_index, n3 + list.last.lookahead.id);
            n2 = this.advanceStartIndex(n2);
        }
    }

    private void renumberSymbols(Grammar grammar, Action.List[] listArray) {
        int n;
        for (n = 0; n < listArray.length; ++n) {
            Action action = listArray[n].first;
            while (action != null) {
                ++action.lookahead.nrefs;
                action = action.next;
            }
        }
        Arrays.sort(grammar.terminals, 1, grammar.terminals.length, GrammarSymbol.NUMBER_OF_REFERENCES_COMPARATOR);
        Arrays.sort(grammar.nonterminals, GrammarSymbol.NUMBER_OF_REFERENCES_COMPARATOR);
        for (n = 1; n < grammar.terminals.length; ++n) {
            grammar.terminals[n].id = (short)n;
        }
        for (n = 0; n < grammar.nonterminals.length; ++n) {
            grammar.nonterminals[n].id = (short)(n + grammar.terminals.length);
        }
        for (n = 0; n < listArray.length; ++n) {
            listArray[n].sort();
        }
    }

    private int advanceStartIndex(int n) {
        while (n < this.actions.length && this.actions[n] != 0) {
            ++n;
        }
        return n;
    }

    private int findOffset(Action.List list, int n) {
        short s = list.first.lookahead.id;
        short s2 = list.last.lookahead.id;
        int n2 = s2 - s + 1;
        while (true) {
            int n3;
            int n4 = this.actions.length - n2;
            for (n3 = n; n3 <= n4; ++n3) {
                int n5;
                if (this.actions[n3] != 0 || !this.tryInsertActions(list, n5 = n3 - s)) continue;
                this.insertActions(list, n5);
                return n5;
            }
            if (this.actions.length >= 0x100000) {
                throw new IllegalStateException("cannot find place for some actions in parsing tables");
            }
            this.actions = ParsingTables.expand(this.actions);
            n3 = this.lookaheads.length;
            this.lookaheads = ParsingTables.expand(this.lookaheads);
            Arrays.fill(this.lookaheads, n3, this.lookaheads.length, (short)-1);
        }
    }

    private void insertActions(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            int n2 = n + action.lookahead.id;
            if (this.actions[n2] != 0) {
                throw new IllegalStateException("inserting action in occupied slot");
            }
            this.actions[n2] = action.getId();
            action = action.next;
        }
    }

    private boolean tryInsertActions(Action.List list, int n) {
        if (this.canInsertActions(list, n)) {
            this.insertLookaheads(list, n);
            if (list.first.lookahead.id >= this.n_term || !this.hasCollisions()) {
                return true;
            }
            this.removeLookaheads(list, n);
        }
        return false;
    }

    private boolean canInsertActions(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            if (this.actions[n + action.lookahead.id] != 0) {
                return false;
            }
            action = action.next;
        }
        return true;
    }

    private void insertLookaheads(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            int n2 = n + action.lookahead.id;
            if (this.lookaheads[n2] >= 0) {
                throw new IllegalStateException("lookahead collision during initial insert");
            }
            this.lookaheads[n2] = action.lookahead.id;
            action = action.next;
        }
    }

    private void removeLookaheads(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            this.lookaheads[n + action.lookahead.id] = -1;
            action = action.next;
        }
    }

    private boolean hasCollisions() {
        State state = this.first_state;
        while (state != null) {
            int n = this.terminal_offsets[state.id];
            if (n != Integer.MIN_VALUE) {
                Action action = state.terminal_lookahead_actions.first;
                for (int i = 0; i < this.n_term; ++i) {
                    if (action != null && action.lookahead.id == i) {
                        action = action.next;
                        continue;
                    }
                    int n2 = n + i;
                    if (0 > n2 || n2 >= this.lookaheads.length || this.lookaheads[n2] != i) continue;
                    return true;
                }
            }
            state = state.next;
        }
        return false;
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2 = this.last_action_index + 1;
        dataOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.actions[n]);
        }
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.lookaheads[n]);
        }
        n2 = this.terminal_offsets.length;
        dataOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeInt(this.terminal_offsets[n]);
        }
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeInt(this.nonterminal_offsets[n]);
        }
        dataOutputStream.writeInt(this.compressed ? n2 : (n2 = 0));
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.default_actions[n]);
        }
    }

    static int countStates(State state) {
        while (state.next != null) {
            state = state.next;
        }
        return state.id;
    }

    static short[] expand(short[] sArray) {
        short[] sArray2 = new short[sArray.length * 2];
        System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        return sArray2;
    }
}

