package metalexer.jflex;

import java.io.IOException;
import java.io.Reader;

import metalexer.ScannerTestTool;
import test.jflex.natlab.CommentBuffer;
import test.jflex.natlab.NatlabParser;
import beaver.Scanner;

public class NatlabScannerTestTool extends ScannerTestTool {
    private NatlabScannerTestTool() {
        super(NatlabParser.Terminals.EOF, NatlabParser.Terminals.NAMES);
    }

    protected Scanner makeScanner(Reader in) {
        return ReflectionHelper.instantiateScanner("test.jflex.natlab.NatlabScanner", in, new CommentBuffer());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.jflex.NatlabScannerTestTool {basename}");
            System.exit(1);
        }
        try {
            new NatlabScannerTestTool().processFile(args[0]);
            System.exit(0);
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}
