//based on http://jflex.de/manual.html

package test.jflex.metalexer;
import static test.jflex.metalexer.ComponentParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/metalexer/component.mll [13, 1]
%public
//from test/backend-jflex/in/metalexer/component.mll [14, 1]
%final
//from test/backend-jflex/in/metalexer/component.mll [15, 1]
%class ComponentScanner
//from test/backend-jflex/in/metalexer/component.mll [18, 1]
%extends Scanner
//from test/backend-jflex/in/metalexer/component.mll [19, 1]
%unicode
//from test/backend-jflex/in/metalexer/component.mll [20, 1]
%function nextToken
//from test/backend-jflex/in/metalexer/component.mll [21, 1]
%type Symbol
//from test/backend-jflex/in/metalexer/component.mll [24, 1]
%line
//from test/backend-jflex/in/metalexer/component.mll [25, 1]
%column
//from null [27, 1]
%yylexthrow Scanner.Exception

%{
    private final StateClass_component state_component = new StateClass_component();
%}

%{
    private class StateClass_component {
        private StateClass_component() {
            //from test/backend-jflex/in/metalexer/component.mll [106, 1]
            embeddingRecordArray[0] = new EmbeddingRecord("option_section", inst_component_option_section, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [113, 1]
            embeddingRecordArray[1] = new EmbeddingRecord("option_append", inst_append_region, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [120, 1]
            embeddingRecordArray[2] = new EmbeddingRecord("option_decl", inst_decl_region, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [127, 1]
            embeddingRecordArray[3] = new EmbeddingRecord("option_init", inst_init_region, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [134, 1]
            embeddingRecordArray[4] = new EmbeddingRecord("option_string_directive", inst_string_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [143, 1]
            embeddingRecordArray[5] = new EmbeddingRecord("rule_section", inst_component_rule_section, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [150, 1]
            embeddingRecordArray[6] = new EmbeddingRecord("rule_delete_directive", inst_delete_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [157, 1]
            embeddingRecordArray[7] = new EmbeddingRecord("rule_action", inst_action, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [164, 1]
            embeddingRecordArray[8] = new EmbeddingRecord("rule_metatoken", inst_metatoken_decl, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [171, 1]
            embeddingRecordArray[9] = new EmbeddingRecord("open_rule_group", inst_open_rule_group, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [181, 1]
            embeddingRecordArray[10] = new EmbeddingRecord("comments", inst_bracket_comment, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [190, 1]
            embeddingRecordArray[11] = new EmbeddingRecord("string", inst_string, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [197, 1]
            embeddingRecordArray[12] = new EmbeddingRecord("identifier_directive", inst_identifier_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [204, 1]
            embeddingRecordArray[13] = new EmbeddingRecord("macro_invoc", inst_macro_invoc, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [211, 1]
            embeddingRecordArray[14] = new EmbeddingRecord("repetition_spec", inst_repetition_spec, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [218, 1]
            embeddingRecordArray[15] = new EmbeddingRecord("bracketed_state_list", inst_bracketed_state_list, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/component.mll [225, 1]
            embeddingRecordArray[16] = new EmbeddingRecord("char_class", inst_char_class, PairFilter.EMPTY);
            
            //from test/backend-jflex/in/metalexer/component.mll [100, 8]
            yybegin(base_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(null, inst_base, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            startEmbedding(/*option_section*/ 0); 
            
            restartAppendBuf();
            
            //NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.
            sendMTok(/*BOF*/ 0);
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[17];
        private final CompClass_action inst_action = new CompClass_action();
        private final CompClass_append_region inst_append_region = new CompClass_append_region();
        private final CompClass_base inst_base = new CompClass_base();
        private final CompClass_bracket_comment inst_bracket_comment = new CompClass_bracket_comment();
        private final CompClass_bracketed_state_list inst_bracketed_state_list = new CompClass_bracketed_state_list();
        private final CompClass_char_class inst_char_class = new CompClass_char_class();
        private final CompClass_component_option_section inst_component_option_section = new CompClass_component_option_section();
        private final CompClass_component_rule_section inst_component_rule_section = new CompClass_component_rule_section();
        private final CompClass_decl_region inst_decl_region = new CompClass_decl_region();
        private final CompClass_delete_directive inst_delete_directive = new CompClass_delete_directive();
        private final CompClass_identifier_directive inst_identifier_directive = new CompClass_identifier_directive();
        private final CompClass_init_region inst_init_region = new CompClass_init_region();
        private final CompClass_macro_invoc inst_macro_invoc = new CompClass_macro_invoc();
        private final CompClass_metatoken_decl inst_metatoken_decl = new CompClass_metatoken_decl();
        private final CompClass_open_rule_group inst_open_rule_group = new CompClass_open_rule_group();
        private final CompClass_repetition_spec inst_repetition_spec = new CompClass_repetition_spec();
        private final CompClass_string_directive inst_string_directive = new CompClass_string_directive();
        private final CompClass_string inst_string = new CompClass_string();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private final MetaLexerClass_component metalexer_component = new MetaLexerClass_component();
        private MetaLexerClass_component.Transition sendMTok(int mtok) {
            return metalexer_component.processSymbol(mtok);
        }
        
        public void processMTok(int mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                return; //don't send symbol if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MetaLexerClass_component.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                next = null;
                if(endOfEmbedding) {
                    int regionSym = currComp.getSymbolValue();
                    if(getCurrFilter().test(regionSym)) {
                        next = sendMTok(regionSym);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract int getSymbolValue();
    }
%}

%{
    //from test/backend-jflex/in/metalexer/action.mlc [1, 1]
    private class CompClass_action extends ComponentInnerClass {
        
        public CompClass_action() {
        }
        
        private static final int YYINITIAL = action_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/action.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(ACTION, "{:" + text + ":}", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_component.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/action.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 1;
        }
        
        public Maybe<? extends Symbol> action_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_action.action_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/action.mlc [14, 16]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> action_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_action.action_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> action_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_action.action_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/action.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> action_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_action.action_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/action.mlc [19, 9]
                error("Unterminated action");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/append_region.mlc [1, 1]
    private class CompClass_append_region extends ComponentInnerClass {
        
        public CompClass_append_region() {
        }
        
        private static final int YYINITIAL = append_region_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/append_region.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(APPEND_REGION, "%append{" + text + "%append}", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_component.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/append_region.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 2;
        }
        
        public Maybe<? extends Symbol> append_region_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_append_region.append_region_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/append_region.mlc [14, 22]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> append_region_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_append_region.append_region_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> append_region_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_append_region.append_region_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/append_region.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> append_region_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_append_region.append_region_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/append_region.mlc [19, 9]
                error("Unterminated append region");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
    private class CompClass_base extends ComponentInnerClass {
        
        public CompClass_base() {
        }
        
        private static final int YYINITIAL = base_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 3;
        }
        
        public Maybe<? extends Symbol> base_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_base.base_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/base.mlc [9, 9]
                error("Unexpected character: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_base.base_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/base.mlc [10, 9]
                return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
    private class CompClass_bracket_comment extends ComponentInnerClass {
        
        public CompClass_bracket_comment() {
        }
        
        private static final int YYINITIAL = bracket_comment_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 4;
        }
        
        public Maybe<? extends Symbol> bracket_comment_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracket_comment.bracket_comment_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [15, 22]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracket_comment.bracket_comment_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [16, 23]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracket_comment.bracket_comment_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [19, 9]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracket_comment.bracket_comment_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [20, 9]
                error("Unterminated bracket comment");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [1, 1]
    private class CompClass_bracketed_state_list extends ComponentInnerClass {
        
        public CompClass_bracketed_state_list() {
        }
        
        private static final int YYINITIAL = bracketed_state_list_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 5;
        }
        
        public Maybe<? extends Symbol> bracketed_state_list_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_3()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [22, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [23, 21]
                return Maybe.Just(symbol(RANGLE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [25, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_8() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [27, 9]
                error("Unexpected character in state list: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracketed_state_list_action_9() throws Scanner.Exception {
            //System.err.println("state_component.inst_bracketed_state_list.bracketed_state_list_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [28, 9]
                error("Unterminated state list");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/char_class.mlc [1, 1]
    private class CompClass_char_class extends ComponentInnerClass {
        
        public CompClass_char_class() {
        }
        
        private static final int YYINITIAL = char_class_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/char_class.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/char_class.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 6;
        }
        
        public Maybe<? extends Symbol> char_class_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [14, 4]
                return Maybe.Just(symbol(CHAR_CLASS_NEGATE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> char_class_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [15, 4]
                return Maybe.Just(symbol(DASH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> char_class_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [16, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> char_class_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [18, 18]
                return Maybe.Just(symbol(ESCAPE_SEQUENCE, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> char_class_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [19, 10]
                return Maybe.Just(symbol(CHAR_CLASS_CHAR, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> char_class_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [20, 4]
                error("Incomplete escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> char_class_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [25, 9]
                return Maybe.Just(symbol(CHAR_CLASS_CHAR, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> char_class_action_8() throws Scanner.Exception {
            //System.err.println("state_component.inst_char_class.char_class_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/char_class.mlc [26, 9]
                error("Incomplete character class");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [1, 1]
    private class CompClass_component_option_section extends ComponentInnerClass {
        
        public CompClass_component_option_section() {
        }
        
        private static final int YYINITIAL = component_option_section_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/component_option_section.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/component_option_section.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 7;
        }
        
        public Maybe<? extends Symbol> component_option_section_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [41, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [42, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_6()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [48, 39]
                return Maybe.Just(symbol(OPEN_MACRO));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_8() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [49, 44]
                return Maybe.Just(symbol(OPEN_REPETITION_SPEC));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_9() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [52, 20]
                return Maybe.Just(symbol(SECTION_SEPARATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_10() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [19, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_11() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [20, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_12() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [21, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_13() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [22, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_14() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [24, 4]
                return Maybe.Just(symbol(BEGINNING_OF_LINE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_15() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [25, 4]
                return Maybe.Just(symbol(END_OF_LINE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_16() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [27, 4]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_17() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [28, 4]
                return Maybe.Just(symbol(UPTO));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_18() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [30, 4]
                return Maybe.Just(symbol(STAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_19() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [31, 4]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_20() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [32, 4]
                return Maybe.Just(symbol(OPT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_21() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [34, 4]
                return Maybe.Just(symbol(DASH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_22() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [36, 4]
                return Maybe.Just(symbol(SLASH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_23() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [37, 4]
                return Maybe.Just(symbol(ALT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_24() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [39, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_25() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [41, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_26() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [43, 11]
                return Maybe.Just(symbol(ANY_PATTERN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_27() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [44, 11]
                return Maybe.Just(symbol(EOF_PATTERN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_28() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [46, 18]
                return Maybe.Just(symbol(ESCAPE_SEQUENCE, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_29() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [47, 12]
                return Maybe.Just(symbol(NON_META, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_30() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [48, 4]
                error("Incomplete escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_31() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_31()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_32() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [53, 11]
                return Maybe.Just(symbol(NON_META, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_33() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_34() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [56, 55]
                return Maybe.Just(symbol(HELPER_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_35() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [61, 58]
                return Maybe.Just(symbol(COMPONENT_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_36() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [64, 54]
                return Maybe.Just(symbol(STATE_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_37() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [67, 55]
                return Maybe.Just(symbol(XSTATE_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_38() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [70, 54]
                return Maybe.Just(symbol(START_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_39() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [75, 55]
                return Maybe.Just(symbol(EXTERN_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_40() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [78, 55]
                return Maybe.Just(symbol(IMPORT_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_41() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [81, 58]
                return Maybe.Just(symbol(INITTHROW_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_42() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [84, 57]
                return Maybe.Just(symbol(LEXTHROW_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_43() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [89, 26]
                error("Invalid directive");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_44() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [93, 35]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_45() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_option_section.mlc [99, 9]
                error("Unexpected character in option section: " + yytext() );
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_option_section_action_46() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_option_section.component_option_section_action_46()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [1, 1]
    private class CompClass_component_rule_section extends ComponentInnerClass {
        
        public CompClass_component_rule_section() {
        }
        
        private static final int YYINITIAL = component_rule_section_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/component_rule_section.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/component_rule_section.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 8;
        }
        
        public Maybe<? extends Symbol> component_rule_section_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [41, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [42, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [44, 20]
                return Maybe.Just(symbol(LANGLE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [46, 18]
                return Maybe.Just(symbol(GROUP_SEPARATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [47, 27]
                return Maybe.Just(symbol(INHERIT_SECTION_SEPARATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [49, 39]
                return Maybe.Just(symbol(OPEN_MACRO));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_8() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [53, 44]
                return Maybe.Just(symbol(OPEN_REPETITION_SPEC));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_9() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_9()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_10() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [60, 21]
                return Maybe.Just(symbol(CLOSE_RULE_GROUP));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_11() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [19, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_12() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [20, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_13() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [21, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_14() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [22, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_15() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [24, 4]
                return Maybe.Just(symbol(BEGINNING_OF_LINE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_16() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [25, 4]
                return Maybe.Just(symbol(END_OF_LINE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_17() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [27, 4]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_18() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [28, 4]
                return Maybe.Just(symbol(UPTO));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_19() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [30, 4]
                return Maybe.Just(symbol(STAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_20() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [31, 4]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_21() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [32, 4]
                return Maybe.Just(symbol(OPT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_22() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [34, 4]
                return Maybe.Just(symbol(DASH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_23() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [36, 4]
                return Maybe.Just(symbol(SLASH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_24() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [37, 4]
                return Maybe.Just(symbol(ALT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_25() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [39, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_26() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [41, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_27() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [43, 11]
                return Maybe.Just(symbol(ANY_PATTERN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_28() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [44, 11]
                return Maybe.Just(symbol(EOF_PATTERN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_29() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [46, 18]
                return Maybe.Just(symbol(ESCAPE_SEQUENCE, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_30() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [47, 12]
                return Maybe.Just(symbol(NON_META, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_31() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [48, 4]
                error("Incomplete escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_32() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_32()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_33() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [53, 11]
                return Maybe.Just(symbol(NON_META, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_34() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_35() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [65, 52]
                return Maybe.Just(symbol(DELETE_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_36() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/component_rule_section.mlc [72, 9]
                error("Unexpected character in rule section: " + yytext() );
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> component_rule_section_action_37() throws Scanner.Exception {
            //System.err.println("state_component.inst_component_rule_section.component_rule_section_action_37()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
    private class CompClass_decl_region extends ComponentInnerClass {
        
        public CompClass_decl_region() {
        }
        
        private static final int YYINITIAL = decl_region_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(DECL_REGION, "%{" + text + "%}", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_component.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 9;
        }
        
        public Maybe<? extends Symbol> decl_region_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_decl_region.decl_region_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [14, 20]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_decl_region.decl_region_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_decl_region.decl_region_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_decl_region.decl_region_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [19, 9]
                error("Unterminated declaration region");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/delete_directive.mlc [1, 1]
    private class CompClass_delete_directive extends ComponentInnerClass {
        
        public CompClass_delete_directive() {
        }
        
        private static final int YYINITIAL = delete_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/delete_directive.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/delete_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 10;
        }
        
        public Maybe<? extends Symbol> delete_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/delete_directive.mlc [29, 18]
                return Maybe.Just(symbol(DELETE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/delete_directive.mlc [30, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/delete_directive.mlc [32, 20]
                return Maybe.Just(symbol(LANGLE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/delete_directive.mlc [34, 39]
                return Maybe.Just(symbol(OPEN_MACRO));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/delete_directive.mlc [38, 44]
                return Maybe.Just(symbol(OPEN_REPETITION_SPEC));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [19, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [20, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_9() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [21, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_10() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [22, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_11() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [24, 4]
                return Maybe.Just(symbol(BEGINNING_OF_LINE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_12() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [25, 4]
                return Maybe.Just(symbol(END_OF_LINE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_13() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [27, 4]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_14() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [28, 4]
                return Maybe.Just(symbol(UPTO));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_15() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [30, 4]
                return Maybe.Just(symbol(STAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_16() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [31, 4]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_17() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [32, 4]
                return Maybe.Just(symbol(OPT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_18() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [34, 4]
                return Maybe.Just(symbol(DASH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_19() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [36, 4]
                return Maybe.Just(symbol(SLASH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_20() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [37, 4]
                return Maybe.Just(symbol(ALT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_21() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [39, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_22() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [41, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_23() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [43, 11]
                return Maybe.Just(symbol(ANY_PATTERN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_24() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [44, 11]
                return Maybe.Just(symbol(EOF_PATTERN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_25() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [46, 18]
                return Maybe.Just(symbol(ESCAPE_SEQUENCE, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_26() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [47, 12]
                return Maybe.Just(symbol(NON_META, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_27() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [48, 4]
                error("Incomplete escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_28() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_28()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_29() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_regex.mlc [53, 11]
                return Maybe.Just(symbol(NON_META, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_30() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> delete_directive_action_31() throws Scanner.Exception {
            //System.err.println("state_component.inst_delete_directive.delete_directive_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/delete_directive.mlc [45, 9]
                return Maybe.Just(symbol(DELETE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
    private class CompClass_identifier_directive extends ComponentInnerClass {
        
        public CompClass_identifier_directive() {
        }
        
        private static final int YYINITIAL = identifier_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 11;
        }
        
        public Maybe<? extends Symbol> identifier_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_3()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [21, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [23, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [24, 23]
                return Maybe.Just(symbol(QUALIFIED_IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [26, 9]
                error("Unexpected character in identifier list: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_9() throws Scanner.Exception {
            //System.err.println("state_component.inst_identifier_directive.identifier_directive_action_9()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
    private class CompClass_init_region extends ComponentInnerClass {
        
        public CompClass_init_region() {
        }
        
        private static final int YYINITIAL = init_region_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(INIT_REGION, "%init{" + text + "%init}", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_component.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 12;
        }
        
        public Maybe<? extends Symbol> init_region_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_init_region.init_region_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [14, 20]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_init_region.init_region_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_init_region.init_region_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_init_region.init_region_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [19, 9]
                error("Unterminated init region");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [1, 1]
    private class CompClass_macro_invoc extends ComponentInnerClass {
        
        public CompClass_macro_invoc() {
        }
        
        private static final int YYINITIAL = macro_invoc_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/macro_invoc.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/macro_invoc.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 13;
        }
        
        public Maybe<? extends Symbol> macro_invoc_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_macro_invoc.macro_invoc_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> macro_invoc_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_macro_invoc.macro_invoc_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> macro_invoc_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_macro_invoc.macro_invoc_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/macro_invoc.mlc [20, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> macro_invoc_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_macro_invoc.macro_invoc_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/macro_invoc.mlc [21, 21]
                return Maybe.Just(symbol(CLOSE_MACRO));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> macro_invoc_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_macro_invoc.macro_invoc_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/macro_invoc.mlc [23, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> macro_invoc_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_macro_invoc.macro_invoc_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/macro_invoc.mlc [25, 9]
                error("Unexpected character in macro invocation: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> macro_invoc_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_macro_invoc.macro_invoc_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/macro_invoc.mlc [26, 9]
                error("Unterminated macro invocation");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [1, 1]
    private class CompClass_metatoken_decl extends ComponentInnerClass {
        
        public CompClass_metatoken_decl() {
        }
        
        private static final int YYINITIAL = metatoken_decl_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 14;
        }
        
        public Maybe<? extends Symbol> metatoken_decl_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_metatoken_decl.metatoken_decl_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metatoken_decl_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_metatoken_decl.metatoken_decl_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metatoken_decl_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_metatoken_decl.metatoken_decl_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [19, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metatoken_decl_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_metatoken_decl.metatoken_decl_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metatoken_decl_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_metatoken_decl.metatoken_decl_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [22, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metatoken_decl_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_metatoken_decl.metatoken_decl_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [24, 9]
                error("Unexpected character in meta token specification: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metatoken_decl_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_metatoken_decl.metatoken_decl_action_7()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/open_rule_group.mlc [1, 1]
    private class CompClass_open_rule_group extends ComponentInnerClass {
        
        public CompClass_open_rule_group() {
        }
        
        private static final int YYINITIAL = open_rule_group_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/open_rule_group.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/open_rule_group.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 15;
        }
        
        public Maybe<? extends Symbol> open_rule_group_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_open_rule_group.open_rule_group_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/open_rule_group.mlc [12, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> open_rule_group_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_open_rule_group.open_rule_group_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/open_rule_group.mlc [13, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> open_rule_group_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_open_rule_group.open_rule_group_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/open_rule_group.mlc [15, 20]
                return Maybe.Just(symbol(OPEN_RULE_GROUP));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> open_rule_group_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_open_rule_group.open_rule_group_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/open_rule_group.mlc [18, 9]
                error("Expecting '{', found: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> open_rule_group_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_open_rule_group.open_rule_group_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/open_rule_group.mlc [19, 9]
                error("No group associated with state list");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [1, 1]
    private class CompClass_repetition_spec extends ComponentInnerClass {
        
        public CompClass_repetition_spec() {
        }
        
        private static final int YYINITIAL = repetition_spec_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/repetition_spec.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/repetition_spec.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 16;
        }
        
        public Maybe<? extends Symbol> repetition_spec_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_repetition_spec.repetition_spec_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> repetition_spec_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_repetition_spec.repetition_spec_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> repetition_spec_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_repetition_spec.repetition_spec_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/repetition_spec.mlc [19, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> repetition_spec_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_repetition_spec.repetition_spec_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/repetition_spec.mlc [20, 21]
                return Maybe.Just(symbol(CLOSE_REPETITION_SPEC));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> repetition_spec_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_repetition_spec.repetition_spec_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/repetition_spec.mlc [22, 10]
                return Maybe.Just(symbol(NUMBER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> repetition_spec_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_repetition_spec.repetition_spec_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/repetition_spec.mlc [24, 9]
                error("Unexpected character in repetition specification: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> repetition_spec_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_repetition_spec.repetition_spec_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/repetition_spec.mlc [25, 9]
                error("Unterminated repetition specification");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
    private class CompClass_string_directive extends ComponentInnerClass {
        
        public CompClass_string_directive() {
        }
        
        private static final int YYINITIAL = string_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 17;
        }
        
        public Maybe<? extends Symbol> string_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_3()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string_directive.mlc [18, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string_directive.mlc [21, 9]
                error("Unexpected character in string list: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_component.inst_string_directive.string_directive_action_8()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
    private class CompClass_string extends ComponentInnerClass {
        
        public CompClass_string() {
        }
        
        private static final int YYINITIAL = string_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(STRING, "\"" + text + "\"", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_component.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 18;
        }
        
        public Maybe<? extends Symbol> string_action_1() throws Scanner.Exception {
            //System.err.println("state_component.inst_string.string_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [22, 9]
                /*just end string - %append will handle token*/
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_2() throws Scanner.Exception {
            //System.err.println("state_component.inst_string.string_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [23, 18]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_3() throws Scanner.Exception {
            //System.err.println("state_component.inst_string.string_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [24, 11]
                error("Invalid escape sequence: '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_4() throws Scanner.Exception {
            //System.err.println("state_component.inst_string.string_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [25, 4]
                error("Incomplete escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_5() throws Scanner.Exception {
            //System.err.println("state_component.inst_string.string_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [26, 18]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_6() throws Scanner.Exception {
            //System.err.println("state_component.inst_string.string_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [29, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_7() throws Scanner.Exception {
            //System.err.println("state_component.inst_string.string_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [30, 9]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    public static class MetaLexerClass_component {
        
        //// Symbols ////
        // <BOF>
        // %action%
        // %append_region%
        // %base%
        // %bracket_comment%
        // %bracketed_state_list%
        // %char_class%
        // %component_option_section%
        // %component_rule_section%
        // %decl_region%
        // %delete_directive%
        // %identifier_directive%
        // %init_region%
        // %macro_invoc%
        // %metatoken_decl%
        // %open_rule_group%
        // %repetition_spec%
        // %string_directive%
        // %string%
        // END_ACTION
        // END_APPEND_REGION
        // START_BRACKET_COMMENT
        // END_BRACKET_COMMENT
        // END_BRACKETED_STATE_LIST
        // END_CHAR_CLASS
        // START_DECL_REGION
        // START_INIT_REGION
        // START_APPEND_REGION
        // START_MACRO_INVOC
        // START_REPETITION_SPEC
        // END_OPTION_SECTION
        // START_CHAR_CLASS
        // START_STRING
        // START_IDENTIFIER_DIRECTIVE
        // START_STRING_DIRECTIVE
        // START_BRACKETED_STATE_LIST
        // START_ACTION
        // START_DELETE_DIRECTIVE
        // END_RULE_SECTION
        // END_DECL_REGION
        // END_DELETE_DIRECTIVE
        // END_IDENTIFIER_DIRECTIVE
        // END_INIT_REGION
        // END_MACRO_INVOC
        // END_METATOKEN_DECL
        // END_OPEN_RULE_GROUP
        // END_REPETITION_SPEC
        // END_STRING_DIRECTIVE
        // END_STRING
        
        private static final Integer[][] trans_BASE = new Integer[][] {
            {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_BASE = new Integer[] {null,0,};
        
        private static final Integer[][] trans_string = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,},
        };
        private static final Integer[] act_string = new Integer[] {null,27,};
        
        private static final Integer[][] trans_rule_delete_directive = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,2,3,0,4,5,0,0,6,0,0,0,0,7,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_rule_delete_directive = new Integer[] {null,1,8,9,11,6,10,22,};
        
        private static final Integer[][] trans_repetition_spec = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,},
        };
        private static final Integer[] act_repetition_spec = new Integer[] {null,30,};
        
        private static final Integer[][] trans_open_rule_group = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,},
        };
        private static final Integer[] act_open_rule_group = new Integer[] {null,25,};
        
        private static final Integer[][] trans_option_decl = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_option_decl = new Integer[] {null,18,};
        
        private static final Integer[][] trans_char_class = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_char_class = new Integer[] {null,32,};
        
        private static final Integer[][] trans_option_section = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,3,4,5,6,7,8,9,10,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_option_section = new Integer[] {null,1,13,14,12,8,9,16,11,6,7,15,};
        
        private static final Integer[][] trans_rule_action = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_rule_action = new Integer[] {null,23,};
        
        private static final Integer[][] trans_option_string_directive = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,},
        };
        private static final Integer[] act_option_string_directive = new Integer[] {null,1,6,20,};
        
        private static final Integer[][] trans_identifier_directive = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_identifier_directive = new Integer[] {null,1,28,};
        
        private static final Integer[][] trans_rule_metatoken = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,},
        };
        private static final Integer[] act_rule_metatoken = new Integer[] {null,1,24,};
        
        private static final Integer[][] trans_option_init = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,},
        };
        private static final Integer[] act_option_init = new Integer[] {null,19,};
        
        private static final Integer[][] trans_bracketed_state_list = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_bracketed_state_list = new Integer[] {null,1,31,};
        
        private static final Integer[][] trans_macro_invoc = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,},
        };
        private static final Integer[] act_macro_invoc = new Integer[] {null,29,};
        
        private static final Integer[][] trans_option_append = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_option_append = new Integer[] {null,17,};
        
        private static final Integer[][] trans_rule_section = new Integer[][] {
            {0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,4,5,0,6,7,8,0,9,10,11,12,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_rule_section = new Integer[] {null,4,5,1,8,9,11,6,7,10,3,2,21,};
        
        private static final Integer[][] trans_comments = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_comments = new Integer[] {null,1,26,};
        
        private static final Integer[][][] transitionTables = new Integer[][][] {
            trans_option_section,
            trans_option_append,
            trans_option_decl,
            trans_option_init,
            trans_option_string_directive,
            trans_rule_section,
            trans_rule_delete_directive,
            trans_rule_action,
            trans_rule_metatoken,
            trans_open_rule_group,
            trans_comments,
            trans_string,
            trans_identifier_directive,
            trans_macro_invoc,
            trans_repetition_spec,
            trans_bracketed_state_list,
            trans_char_class,
        };
        
        private static final Integer[][] actionTables = new Integer[][] {
            act_option_section,
            act_option_append,
            act_option_decl,
            act_option_init,
            act_option_string_directive,
            act_rule_section,
            act_rule_delete_directive,
            act_rule_action,
            act_rule_metatoken,
            act_open_rule_group,
            act_comments,
            act_string,
            act_identifier_directive,
            act_macro_invoc,
            act_repetition_spec,
            act_bracketed_state_list,
            act_char_class,
        };
        
        private static final Integer[][] rev_trans_option_append = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_append = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_option_decl = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_decl = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_option_init = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_init = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_option_string_directive = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_string_directive = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_rule_section = new Integer[][] {
            {1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_rule_section = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_rule_delete_directive = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_rule_delete_directive = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_rule_action = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_rule_action = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_rule_metatoken = new Integer[][] {
            {1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_rule_metatoken = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_open_rule_group = new Integer[][] {
            {1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_open_rule_group = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_comments = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_comments = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_string = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_string = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_identifier_directive = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_identifier_directive = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_macro_invoc = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_macro_invoc = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_repetition_spec = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_repetition_spec = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_bracketed_state_list = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_bracketed_state_list = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_char_class = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_char_class = new Integer[] {null,null,1,};
        
        private static final Integer[][][] reverseTransitionTables = new Integer[][][] {
            rev_trans_rule_section,
            rev_trans_comments,
            rev_trans_rule_delete_directive,
            rev_trans_rule_action,
            rev_trans_rule_metatoken,
            rev_trans_open_rule_group,
            rev_trans_string,
            rev_trans_identifier_directive,
            rev_trans_macro_invoc,
            rev_trans_repetition_spec,
            rev_trans_bracketed_state_list,
            rev_trans_char_class,
            rev_trans_option_append,
            rev_trans_option_decl,
            rev_trans_option_init,
            rev_trans_option_string_directive,
        };
        
        private static final Integer[][] reverseActionTables = new Integer[][] {
            rev_act_rule_section,
            rev_act_comments,
            rev_act_rule_delete_directive,
            rev_act_rule_action,
            rev_act_rule_metatoken,
            rev_act_open_rule_group,
            rev_act_string,
            rev_act_identifier_directive,
            rev_act_macro_invoc,
            rev_act_repetition_spec,
            rev_act_bracketed_state_list,
            rev_act_char_class,
            rev_act_option_append,
            rev_act_option_decl,
            rev_act_option_init,
            rev_act_option_string_directive,
        };
        
        private static final int[] actionMap = new int[] {5,10,6,7,8,9,11,12,13,14,15,16,1,2,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,};
        
        private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
        
        private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();
        private int currentState = 0;
        private Integer[][] currentTransitionTable = trans_BASE;
        private Integer[] currentActionTable = act_BASE;
        
        public MetaLexerClass_component() {
            //Transition through states reachable by pure BOF patterns
            switchDFAs(/*option_section*/ 0); 
        }
        
        public Transition processSymbol(int sym) {
            currentMatch.add(sym);
            currentState = currentTransitionTable[currentState][sym];
            Integer mpatNum = currentActionTable[currentState];
            if(mpatNum == null) {
                return null;
            }
            int action = actionMap[mpatNum];
            Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));
            switchDFAs(action);
            return transition;
        }
        
        private void switchDFAs(int action) {
            currentState = 0;
            currentMatch.clear();
            
            int nextEmbedding;
            if(action < 0) {
                stateStack.pop();
                nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();
            } else {
                stateStack.push(action);
                nextEmbedding = action;
            }
            
            if(nextEmbedding < 0) {
                currentTransitionTable = trans_BASE;
                currentActionTable = act_BASE;
            } else {
                currentTransitionTable = transitionTables[nextEmbedding];
                currentActionTable = actionTables[nextEmbedding];
            }
        }
        
        private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {
            if(mpatNum >= reverseTransitionTables.length) {
                //don't need to clean end pattern matches - they aren't looked at
                return new java.util.ArrayList<Integer>(rawMatch);
            }
            
            java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();
            Integer[][] transitions = reverseTransitionTables[mpatNum];
            Integer[] actions = reverseActionTables[mpatNum];
            int dfaState = 0;
            for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {
                int sym = rawMatch.get(i);
                cleanMatch.add(sym);
                dfaState = transitions[dfaState][sym];
            }
            java.util.Collections.reverse(cleanMatch);
            return cleanMatch;
        }
        
        public static class Transition {
            private final int embeddingNum;
            private final java.util.List<Integer> match;
            
            public Transition(int embeddingNum, java.util.List<Integer> match) {
                this.embeddingNum = embeddingNum;
                this.match = new java.util.ArrayList<Integer>(match);
            }
            
            public int getEmbeddingNum() { return embeddingNum; }
            
            public java.util.List<Integer> getMatch() { return match; }
        }
        
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
        private final java.util.Set<Integer> allOpenSymbols;
        private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {
            this.pairMap = pairMap;
            this.allOpenSymbols = allOpenSymbols;
            this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();
        }
        
        public static class Builder {
            private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
            private final java.util.Set<Integer> allOpenSymbols;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();
                this.allOpenSymbols = new java.util.HashSet<Integer>();
            }
            
            public Builder add(int open, int close) {
                allOpenSymbols.add(open);
                java.util.Set<Integer> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Integer>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenSymbols);
            }
        }
        
        public boolean test(int sym) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Integer> correspondingOpens = pairMap.get(sym);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {
                    int open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenSymbols.contains(sym)) { //implies opening
                unclosedOpenSymbols.add(0, sym); //insert at beginning
            }
            return true;
        }
        
        public void clean(java.util.List<Integer> match) {
            java.util.Collections.reverse(match);
            for(int sym : match) {
                if(unclosedOpenSymbols.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenSymbols.get(0) == sym) {
                    unclosedOpenSymbols.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenSymbols.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isNothing() {
            return !isJust();
        }
        public abstract boolean isJust();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isJust() {
                return true;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isJust() {
                return false;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

//from null [32, 1]
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
//from null [65, 1]
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}


%xstate EXTRA_RETURN

//from test/backend-jflex/in/metalexer/action.mlc [1, 1]
%state action_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/append_region.mlc [1, 1]
%state append_region_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/base.mlc [1, 1]
%state base_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
%state bracket_comment_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [1, 1]
%state bracketed_state_list_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/char_class.mlc [1, 1]
%state char_class_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/component_option_section.mlc [1, 1]
%state component_option_section_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/component_rule_section.mlc [1, 1]
%state component_rule_section_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
%state decl_region_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/delete_directive.mlc [1, 1]
%state delete_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
%state identifier_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
%state init_region_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/macro_invoc.mlc [1, 1]
%state macro_invoc_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/metatoken_decl.mlc [1, 1]
%state metatoken_decl_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/open_rule_group.mlc [1, 1]
%state open_rule_group_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/repetition_spec.mlc [1, 1]
%state repetition_spec_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
%state string_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/string.mlc [1, 1]
%state string_YYINITIAL_STATE

m_action_CloseAction = ":}" //from test/backend-jflex/in/metalexer/action.mlc [11, 1]
m_append_region_CloseAppendRegion = "%append}" //from test/backend-jflex/in/metalexer/append_region.mlc [11, 1]
m_bracket_comment_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/bracket_comment.mlc [11, 1]
m_bracket_comment_CloseBracketComment = "*/" //from test/backend-jflex/in/metalexer/bracket_comment.mlc [12, 1]
m_bracketed_state_list_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [7, 1]
m_bracketed_state_list_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [8, 1]
m_bracketed_state_list_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [10, 1]
m_bracketed_state_list_Digit = [0-9] //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [11, 1]
m_bracketed_state_list_Identifier = {m_bracketed_state_list_Letter}(((_ | {m_bracketed_state_list_Letter}) | {m_bracketed_state_list_Digit}))* //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [12, 1]
m_bracketed_state_list_CloseAngleBracket = \> //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [14, 1]
m_bracketed_state_list_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_bracketed_state_list_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_char_class_Digit = [0-9] //from test/backend-jflex/in/metalexer/char_class.mlc [7, 1]
m_char_class_HexDigit = ({m_char_class_Digit} | [a-fA-F]) //from test/backend-jflex/in/metalexer/char_class.mlc [8, 1]
m_char_class_EscapeSequence = \\(((([nrtfb] | x({m_char_class_HexDigit}{2})) | u({m_char_class_HexDigit}{1, 4})) | ([0-3])?([0-7])?[0-7]) | [\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-]) //from test/backend-jflex/in/metalexer/char_class.mlc [10, 1]
m_component_option_section_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/component_option_section.mlc [7, 1]
m_component_option_section_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/component_option_section.mlc [8, 1]
m_component_option_section_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/component_option_section.mlc [10, 1]
m_component_option_section_Digit = [0-9] //from test/backend-jflex/in/metalexer/component_option_section.mlc [11, 1]
m_component_option_section_Identifier = {m_component_option_section_Letter}(((_ | {m_component_option_section_Letter}) | {m_component_option_section_Digit}))* //from test/backend-jflex/in/metalexer/component_option_section.mlc [12, 1]
m_component_option_section_Number = (0 | [1-9]({m_component_option_section_Digit})*) //from test/backend-jflex/in/metalexer/component_option_section.mlc [13, 1]
m_component_option_section_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/component_option_section.mlc [15, 1]
m_component_option_section_OpenDeclRegion = "%{" //from test/backend-jflex/in/metalexer/component_option_section.mlc [17, 1]
m_component_option_section_OpenInitRegion = "%init{" //from test/backend-jflex/in/metalexer/component_option_section.mlc [20, 1]
m_component_option_section_OpenAppendRegion = "%append{" //from test/backend-jflex/in/metalexer/component_option_section.mlc [23, 1]
m_component_option_section_OpenCurlyBracket = \{ //from test/backend-jflex/in/metalexer/component_option_section.mlc [26, 1]
m_component_option_section_CloseCurlyBracket = \} //from test/backend-jflex/in/metalexer/component_option_section.mlc [27, 1]
m_component_option_section_DirectiveLookahead = (!(({m_component_option_section_Letter} | {m_component_option_section_Digit}) | _)) //from test/backend-jflex/in/metalexer/component_option_section.mlc [30, 1]
m_component_option_section_MacroLookahead = ({m_component_option_section_OtherWhiteSpace})*{m_component_option_section_Identifier}({m_component_option_section_OtherWhiteSpace})*{m_component_option_section_CloseCurlyBracket} //from test/backend-jflex/in/metalexer/component_option_section.mlc [33, 1]
m_component_option_section_RepetitionLookahead = ({m_component_option_section_OtherWhiteSpace})*{m_component_option_section_Number}(({m_component_option_section_OtherWhiteSpace})*","({m_component_option_section_OtherWhiteSpace})*{m_component_option_section_Number})?({m_component_option_section_OtherWhiteSpace})*{m_component_option_section_CloseCurlyBracket} //from test/backend-jflex/in/metalexer/component_option_section.mlc [34, 1]
m_component_option_section_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_component_option_section_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_component_option_section_HexDigit = ({m_component_option_section_Digit} | [a-fA-F]) //from test/backend-jflex/in/metalexer/abstract_regex.mlc [9, 1]
m_component_option_section_EscapeSequence = \\(((([nrtfb] | x({m_component_option_section_HexDigit}{2})) | u({m_component_option_section_HexDigit}{1, 4})) | ([0-3])?([0-7])?[0-7]) | [\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-]) //from test/backend-jflex/in/metalexer/abstract_regex.mlc [11, 1]
m_component_option_section_Quote = \" //from test/backend-jflex/in/metalexer/abstract_regex.mlc [13, 1]
m_component_option_section_NonMeta = [^\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-] //from test/backend-jflex/in/metalexer/abstract_regex.mlc [15, 1]
m_component_rule_section_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/component_rule_section.mlc [7, 1]
m_component_rule_section_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/component_rule_section.mlc [8, 1]
m_component_rule_section_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/component_rule_section.mlc [10, 1]
m_component_rule_section_Digit = [0-9] //from test/backend-jflex/in/metalexer/component_rule_section.mlc [11, 1]
m_component_rule_section_Identifier = {m_component_rule_section_Letter}(((_ | {m_component_rule_section_Letter}) | {m_component_rule_section_Digit}))* //from test/backend-jflex/in/metalexer/component_rule_section.mlc [12, 1]
m_component_rule_section_Number = (0 | [1-9]({m_component_rule_section_Digit})*) //from test/backend-jflex/in/metalexer/component_rule_section.mlc [13, 1]
m_component_rule_section_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/component_rule_section.mlc [15, 1]
m_component_rule_section_GroupSeparator = "%:" //from test/backend-jflex/in/metalexer/component_rule_section.mlc [16, 1]
m_component_rule_section_Quote = \" //from test/backend-jflex/in/metalexer/component_rule_section.mlc [18, 1]
m_component_rule_section_OpenAction = "{:" //from test/backend-jflex/in/metalexer/component_rule_section.mlc [20, 1]
m_component_rule_section_OpenCurlyBracket = \{ //from test/backend-jflex/in/metalexer/component_rule_section.mlc [23, 1]
m_component_rule_section_CloseCurlyBracket = \} //from test/backend-jflex/in/metalexer/component_rule_section.mlc [24, 1]
m_component_rule_section_OpenAngleBracket = \< //from test/backend-jflex/in/metalexer/component_rule_section.mlc [26, 1]
m_component_rule_section_MacroLookahead = ({m_component_rule_section_OtherWhiteSpace})*{m_component_rule_section_Identifier}({m_component_rule_section_OtherWhiteSpace})*{m_component_rule_section_CloseCurlyBracket} //from test/backend-jflex/in/metalexer/component_rule_section.mlc [30, 1]
m_component_rule_section_RepetitionLookahead = ({m_component_rule_section_OtherWhiteSpace})*{m_component_rule_section_Number}(({m_component_rule_section_OtherWhiteSpace})*","({m_component_rule_section_OtherWhiteSpace})*{m_component_rule_section_Number})?({m_component_rule_section_OtherWhiteSpace})*{m_component_rule_section_CloseCurlyBracket} //from test/backend-jflex/in/metalexer/component_rule_section.mlc [31, 1]
m_component_rule_section_DeleteLookahead = (({m_component_rule_section_LineTerminator} | {m_component_rule_section_OtherWhiteSpace}))+\< //from test/backend-jflex/in/metalexer/component_rule_section.mlc [34, 1]
m_component_rule_section_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_component_rule_section_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_component_rule_section_HexDigit = ({m_component_rule_section_Digit} | [a-fA-F]) //from test/backend-jflex/in/metalexer/abstract_regex.mlc [9, 1]
m_component_rule_section_EscapeSequence = \\(((([nrtfb] | x({m_component_rule_section_HexDigit}{2})) | u({m_component_rule_section_HexDigit}{1, 4})) | ([0-3])?([0-7])?[0-7]) | [\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-]) //from test/backend-jflex/in/metalexer/abstract_regex.mlc [11, 1]
m_component_rule_section_NonMeta = [^\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-] //from test/backend-jflex/in/metalexer/abstract_regex.mlc [15, 1]
m_decl_region_CloseDeclRegion = "%}" //from test/backend-jflex/in/metalexer/decl_region.mlc [11, 1]
m_delete_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/delete_directive.mlc [7, 1]
m_delete_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/delete_directive.mlc [8, 1]
m_delete_directive_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/delete_directive.mlc [10, 1]
m_delete_directive_Digit = [0-9] //from test/backend-jflex/in/metalexer/delete_directive.mlc [11, 1]
m_delete_directive_Identifier = {m_delete_directive_Letter}(((_ | {m_delete_directive_Letter}) | {m_delete_directive_Digit}))* //from test/backend-jflex/in/metalexer/delete_directive.mlc [12, 1]
m_delete_directive_Number = (0 | [1-9]({m_delete_directive_Digit})*) //from test/backend-jflex/in/metalexer/delete_directive.mlc [13, 1]
m_delete_directive_OpenCurlyBracket = \{ //from test/backend-jflex/in/metalexer/delete_directive.mlc [15, 1]
m_delete_directive_CloseCurlyBracket = \} //from test/backend-jflex/in/metalexer/delete_directive.mlc [16, 1]
m_delete_directive_OpenAngleBracket = \< //from test/backend-jflex/in/metalexer/delete_directive.mlc [18, 1]
m_delete_directive_MacroLookahead = ({m_delete_directive_OtherWhiteSpace})*{m_delete_directive_Identifier}({m_delete_directive_OtherWhiteSpace})*{m_delete_directive_CloseCurlyBracket} //from test/backend-jflex/in/metalexer/delete_directive.mlc [22, 1]
m_delete_directive_RepetitionLookahead = ({m_delete_directive_OtherWhiteSpace})*{m_delete_directive_Number}(({m_delete_directive_OtherWhiteSpace})*","({m_delete_directive_OtherWhiteSpace})*{m_delete_directive_Number})?({m_delete_directive_OtherWhiteSpace})*{m_delete_directive_CloseCurlyBracket} //from test/backend-jflex/in/metalexer/delete_directive.mlc [23, 1]
m_delete_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_delete_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_delete_directive_HexDigit = ({m_delete_directive_Digit} | [a-fA-F]) //from test/backend-jflex/in/metalexer/abstract_regex.mlc [9, 1]
m_delete_directive_EscapeSequence = \\(((([nrtfb] | x({m_delete_directive_HexDigit}{2})) | u({m_delete_directive_HexDigit}{1, 4})) | ([0-3])?([0-7])?[0-7]) | [\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-]) //from test/backend-jflex/in/metalexer/abstract_regex.mlc [11, 1]
m_delete_directive_Quote = \" //from test/backend-jflex/in/metalexer/abstract_regex.mlc [13, 1]
m_delete_directive_NonMeta = [^\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-] //from test/backend-jflex/in/metalexer/abstract_regex.mlc [15, 1]
m_identifier_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/identifier_directive.mlc [7, 1]
m_identifier_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [8, 1]
m_identifier_directive_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [10, 1]
m_identifier_directive_Digit = [0-9] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [11, 1]
m_identifier_directive_Identifier = {m_identifier_directive_Letter}(((_ | {m_identifier_directive_Letter}) | {m_identifier_directive_Digit}))* //from test/backend-jflex/in/metalexer/identifier_directive.mlc [12, 1]
m_identifier_directive_QualifiedIdentifier = {m_identifier_directive_Identifier}(\.{m_identifier_directive_Identifier})+ //from test/backend-jflex/in/metalexer/identifier_directive.mlc [13, 1]
m_identifier_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_identifier_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_init_region_CloseInitRegion = "%init}" //from test/backend-jflex/in/metalexer/init_region.mlc [11, 1]
m_macro_invoc_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/macro_invoc.mlc [7, 1]
m_macro_invoc_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/macro_invoc.mlc [8, 1]
m_macro_invoc_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/macro_invoc.mlc [10, 1]
m_macro_invoc_Digit = [0-9] //from test/backend-jflex/in/metalexer/macro_invoc.mlc [11, 1]
m_macro_invoc_Identifier = {m_macro_invoc_Letter}(((_ | {m_macro_invoc_Letter}) | {m_macro_invoc_Digit}))* //from test/backend-jflex/in/metalexer/macro_invoc.mlc [12, 1]
m_macro_invoc_CloseCurlyBracket = \} //from test/backend-jflex/in/metalexer/macro_invoc.mlc [14, 1]
m_metatoken_decl_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [6, 1]
m_metatoken_decl_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [7, 1]
m_metatoken_decl_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [9, 1]
m_metatoken_decl_Digit = [0-9] //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [10, 1]
m_metatoken_decl_Identifier = {m_metatoken_decl_Letter}(((_ | {m_metatoken_decl_Letter}) | {m_metatoken_decl_Digit}))* //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [11, 1]
m_metatoken_decl_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_metatoken_decl_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_open_rule_group_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/open_rule_group.mlc [6, 1]
m_open_rule_group_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/open_rule_group.mlc [7, 1]
m_open_rule_group_OpenCurlyBracket = \{ //from test/backend-jflex/in/metalexer/open_rule_group.mlc [8, 1]
m_repetition_spec_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/repetition_spec.mlc [7, 1]
m_repetition_spec_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/repetition_spec.mlc [8, 1]
m_repetition_spec_Digit = [0-9] //from test/backend-jflex/in/metalexer/repetition_spec.mlc [10, 1]
m_repetition_spec_Number = (0 | [1-9]({m_repetition_spec_Digit})*) //from test/backend-jflex/in/metalexer/repetition_spec.mlc [11, 1]
m_repetition_spec_CloseCurlyBracket = \} //from test/backend-jflex/in/metalexer/repetition_spec.mlc [13, 1]
m_string_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/string_directive.mlc [6, 1]
m_string_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/string_directive.mlc [7, 1]
m_string_directive_Quote = \" //from test/backend-jflex/in/metalexer/string_directive.mlc [9, 1]
m_string_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_string_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_string_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/string.mlc [11, 1]
m_string_Quote = \" //from test/backend-jflex/in/metalexer/string.mlc [13, 1]
m_string_Digit = [0-9] //from test/backend-jflex/in/metalexer/string.mlc [15, 1]
m_string_HexDigit = ({m_string_Digit} | [a-fA-F]) //from test/backend-jflex/in/metalexer/string.mlc [16, 1]
m_string_EscapeSequence = \\(((([nrtfb] | x({m_string_HexDigit}{2})) | u({m_string_HexDigit}{1, 4})) | ([0-3])?([0-7])?[0-7]) | [\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-]) //from test/backend-jflex/in/metalexer/string.mlc [18, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        yybegin(state_component.getPrevState());
        return state_component.getExtraReturn();
    }
    
    <<EOF>> {
        yybegin(state_component.getPrevState());
        return state_component.getExtraReturn();
    }
}

<action_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/action.mlc [14, 1]
    %{m_action_CloseAction} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_action.action_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/action.mlc [15, 1]
    {m_action_CloseAction} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_action.action_action_2();
        } finally {
            state_component.processMTok(19); //END_ACTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<action_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/action.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_action.action_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/action.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_action.action_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<append_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/append_region.mlc [14, 1]
    %{m_append_region_CloseAppendRegion} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_append_region.append_region_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/append_region.mlc [15, 1]
    {m_append_region_CloseAppendRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_append_region.append_region_action_2();
        } finally {
            state_component.processMTok(20); //END_APPEND_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<append_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/append_region.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_append_region.append_region_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/append_region.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_append_region.append_region_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/base.mlc [9, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_base.base_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/base.mlc [10, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_base.base_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [15, 1]
    {m_bracket_comment_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_bracket_comment.bracket_comment_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [16, 1]
    {m_bracket_comment_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_bracket_comment.bracket_comment_action_2();
        } finally {
            state_component.processMTok(22); //END_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [19, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracket_comment.bracket_comment_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracket_comment.bracket_comment_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracketed_state_list_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_bracketed_state_list_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [20, 1]
    {m_bracketed_state_list_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [21, 1]
    {m_bracketed_state_list_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [22, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [23, 1]
    {m_bracketed_state_list_CloseAngleBracket} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_5();
        } finally {
            state_component.processMTok(23); //END_BRACKETED_STATE_LIST
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracketed_state_list_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_bracketed_state_list_Comment} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [25, 1]
    {m_bracketed_state_list_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracketed_state_list_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [27, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracketed_state_list.mlc [28, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_bracketed_state_list.bracketed_state_list_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<char_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/char_class.mlc [14, 1]
    \^ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_char_class.char_class_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/char_class.mlc [15, 1]
    \- {
        Maybe<? extends Symbol> maybeResult = state_component.inst_char_class.char_class_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/char_class.mlc [16, 1]
    \] {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_char_class.char_class_action_3();
        } finally {
            state_component.processMTok(24); //END_CHAR_CLASS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/char_class.mlc [18, 1]
    {m_char_class_EscapeSequence} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_char_class.char_class_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/char_class.mlc [19, 1]
    \\(. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_char_class.char_class_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/char_class.mlc [20, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_char_class.char_class_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<char_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/char_class.mlc [25, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_char_class.char_class_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/char_class.mlc [26, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_char_class.char_class_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<component_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_component_option_section_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [41, 1]
    {m_component_option_section_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [42, 1]
    {m_component_option_section_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [44, 1]
    {m_component_option_section_OpenDeclRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_4();
        } finally {
            state_component.processMTok(25); //START_DECL_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [45, 1]
    {m_component_option_section_OpenInitRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_5();
        } finally {
            state_component.processMTok(26); //START_INIT_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [46, 1]
    {m_component_option_section_OpenAppendRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_6();
        } finally {
            state_component.processMTok(27); //START_APPEND_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [48, 1]
    {m_component_option_section_OpenCurlyBracket} / {m_component_option_section_MacroLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_7();
        } finally {
            state_component.processMTok(28); //START_MACRO_INVOC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [49, 1]
    {m_component_option_section_OpenCurlyBracket} / {m_component_option_section_RepetitionLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_8();
        } finally {
            state_component.processMTok(29); //START_REPETITION_SPEC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [52, 1]
    {m_component_option_section_SectionSeparator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_9();
        } finally {
            state_component.processMTok(30); //END_OPTION_SECTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [19, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [20, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [21, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_12();
        } finally {
            state_component.processMTok(31); //START_CHAR_CLASS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [22, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [24, 1]
    \^ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [25, 1]
    \$ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [27, 1]
    \! {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [28, 1]
    \~ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [30, 1]
    \* {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [31, 1]
    \+ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [32, 1]
    \? {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [34, 1]
    \- {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [36, 1]
    \/ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [37, 1]
    \| {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [39, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [41, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [43, 1]
    "<<ANY>>" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [44, 1]
    "<<EOF>>" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [46, 1]
    {m_component_option_section_EscapeSequence} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [47, 1]
    \\(. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [48, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [50, 1]
    {m_component_option_section_Quote} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_31();
        } finally {
            state_component.processMTok(32); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [53, 1]
    {m_component_option_section_NonMeta} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<component_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_component_option_section_Comment} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [56, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%helper" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [61, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%component" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_35();
        } finally {
            state_component.processMTok(33); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [64, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%state" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_36();
        } finally {
            state_component.processMTok(33); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [67, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%xstate" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_37();
        } finally {
            state_component.processMTok(33); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [70, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%start" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_38();
        } finally {
            state_component.processMTok(33); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [75, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%extern" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_39();
        } finally {
            state_component.processMTok(34); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [78, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%import" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_40();
        } finally {
            state_component.processMTok(34); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [81, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%initthrow" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_41();
        } finally {
            state_component.processMTok(34); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [84, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%lexthrow" / {m_component_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_42();
        } finally {
            state_component.processMTok(34); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [89, 1]
    ^({m_component_option_section_OtherWhiteSpace})*"%" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_43();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [93, 1]
    ^({m_component_option_section_OtherWhiteSpace})*{m_component_option_section_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_44();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<component_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [99, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_option_section.component_option_section_action_45();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_option_section.mlc [100, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_option_section.component_option_section_action_46();
        } finally {
            state_component.processMTok(30); //END_OPTION_SECTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<component_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_component_rule_section_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [41, 1]
    {m_component_rule_section_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [42, 1]
    {m_component_rule_section_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [44, 1]
    {m_component_rule_section_OpenAngleBracket} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_4();
        } finally {
            state_component.processMTok(35); //START_BRACKETED_STATE_LIST
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [46, 1]
    {m_component_rule_section_GroupSeparator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [47, 1]
    {m_component_rule_section_SectionSeparator}inherit {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_6();
        } finally {
            state_component.processMTok(33); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [49, 1]
    {m_component_rule_section_OpenCurlyBracket} / {m_component_rule_section_MacroLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_7();
        } finally {
            state_component.processMTok(28); //START_MACRO_INVOC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [53, 1]
    {m_component_rule_section_OpenCurlyBracket} / {m_component_rule_section_RepetitionLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_8();
        } finally {
            state_component.processMTok(29); //START_REPETITION_SPEC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [57, 1]
    {m_component_rule_section_OpenAction} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_9();
        } finally {
            state_component.processMTok(36); //START_ACTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [60, 1]
    {m_component_rule_section_CloseCurlyBracket} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [19, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [20, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [21, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_13();
        } finally {
            state_component.processMTok(31); //START_CHAR_CLASS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [22, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [24, 1]
    \^ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [25, 1]
    \$ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [27, 1]
    \! {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [28, 1]
    \~ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [30, 1]
    \* {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [31, 1]
    \+ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [32, 1]
    \? {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [34, 1]
    \- {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [36, 1]
    \/ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [37, 1]
    \| {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [39, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [41, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [43, 1]
    "<<ANY>>" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [44, 1]
    "<<EOF>>" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [46, 1]
    {m_component_rule_section_EscapeSequence} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [47, 1]
    \\(. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [48, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [50, 1]
    {m_component_rule_section_Quote} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_32();
        } finally {
            state_component.processMTok(32); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [53, 1]
    {m_component_rule_section_NonMeta} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<component_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_component_rule_section_Comment} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [65, 1]
    ^({m_component_rule_section_OtherWhiteSpace})*"%delete" / {m_component_rule_section_DeleteLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_35();
        } finally {
            state_component.processMTok(37); //START_DELETE_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<component_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [72, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_component_rule_section.component_rule_section_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/component_rule_section.mlc [73, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_component_rule_section.component_rule_section_action_37();
        } finally {
            state_component.processMTok(38); //END_RULE_SECTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<decl_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/decl_region.mlc [14, 1]
    %{m_decl_region_CloseDeclRegion} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_decl_region.decl_region_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/decl_region.mlc [15, 1]
    {m_decl_region_CloseDeclRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_decl_region.decl_region_action_2();
        } finally {
            state_component.processMTok(39); //END_DECL_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<decl_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/decl_region.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_decl_region.decl_region_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/decl_region.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_decl_region.decl_region_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<delete_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_delete_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/delete_directive.mlc [29, 1]
    {m_delete_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_2();
        } finally {
            state_component.processMTok(40); //END_DELETE_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/delete_directive.mlc [30, 1]
    {m_delete_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/delete_directive.mlc [32, 1]
    {m_delete_directive_OpenAngleBracket} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_4();
        } finally {
            state_component.processMTok(35); //START_BRACKETED_STATE_LIST
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/delete_directive.mlc [34, 1]
    {m_delete_directive_OpenCurlyBracket} / {m_delete_directive_MacroLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_5();
        } finally {
            state_component.processMTok(28); //START_MACRO_INVOC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/delete_directive.mlc [38, 1]
    {m_delete_directive_OpenCurlyBracket} / {m_delete_directive_RepetitionLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_6();
        } finally {
            state_component.processMTok(29); //START_REPETITION_SPEC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [19, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [20, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [21, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_9();
        } finally {
            state_component.processMTok(31); //START_CHAR_CLASS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [22, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [24, 1]
    \^ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [25, 1]
    \$ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [27, 1]
    \! {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [28, 1]
    \~ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [30, 1]
    \* {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [31, 1]
    \+ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [32, 1]
    \? {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [34, 1]
    \- {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [36, 1]
    \/ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [37, 1]
    \| {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [39, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [41, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [43, 1]
    "<<ANY>>" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [44, 1]
    "<<EOF>>" {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [46, 1]
    {m_delete_directive_EscapeSequence} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [47, 1]
    \\(. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [48, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [50, 1]
    {m_delete_directive_Quote} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_28();
        } finally {
            state_component.processMTok(32); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/abstract_regex.mlc [53, 1]
    {m_delete_directive_NonMeta} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<delete_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_delete_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_delete_directive.delete_directive_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<delete_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/delete_directive.mlc [45, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_delete_directive.delete_directive_action_31();
        } finally {
            state_component.processMTok(40); //END_DELETE_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_identifier_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_identifier_directive.identifier_directive_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [19, 1]
    {m_identifier_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_identifier_directive.identifier_directive_action_2();
        } finally {
            state_component.processMTok(41); //END_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [20, 1]
    {m_identifier_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_identifier_directive.identifier_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [21, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_component.inst_identifier_directive.identifier_directive_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_identifier_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_identifier_directive.identifier_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [23, 1]
    {m_identifier_directive_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_identifier_directive.identifier_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [24, 1]
    {m_identifier_directive_QualifiedIdentifier} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_identifier_directive.identifier_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [26, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_identifier_directive.identifier_directive_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [27, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_identifier_directive.identifier_directive_action_9();
        } finally {
            state_component.processMTok(41); //END_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<init_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/init_region.mlc [14, 1]
    %{m_init_region_CloseInitRegion} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_init_region.init_region_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/init_region.mlc [15, 1]
    {m_init_region_CloseInitRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_init_region.init_region_action_2();
        } finally {
            state_component.processMTok(42); //END_INIT_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<init_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/init_region.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_init_region.init_region_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/init_region.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_init_region.init_region_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<macro_invoc_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [18, 1]
    {m_macro_invoc_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_macro_invoc.macro_invoc_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [19, 1]
    {m_macro_invoc_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_macro_invoc.macro_invoc_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [20, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_component.inst_macro_invoc.macro_invoc_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [21, 1]
    {m_macro_invoc_CloseCurlyBracket} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_macro_invoc.macro_invoc_action_4();
        } finally {
            state_component.processMTok(43); //END_MACRO_INVOC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<macro_invoc_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [23, 1]
    {m_macro_invoc_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_macro_invoc.macro_invoc_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<macro_invoc_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [25, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_macro_invoc.macro_invoc_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/macro_invoc.mlc [26, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_macro_invoc.macro_invoc_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metatoken_decl_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_metatoken_decl_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_metatoken_decl.metatoken_decl_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [18, 1]
    {m_metatoken_decl_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_metatoken_decl.metatoken_decl_action_2();
        } finally {
            state_component.processMTok(44); //END_METATOKEN_DECL
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [19, 1]
    {m_metatoken_decl_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_metatoken_decl.metatoken_decl_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metatoken_decl_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_metatoken_decl_Comment} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_metatoken_decl.metatoken_decl_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [22, 1]
    {m_metatoken_decl_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_metatoken_decl.metatoken_decl_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metatoken_decl_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [24, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_metatoken_decl.metatoken_decl_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metatoken_decl.mlc [25, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_metatoken_decl.metatoken_decl_action_7();
        } finally {
            state_component.processMTok(44); //END_METATOKEN_DECL
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<open_rule_group_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/open_rule_group.mlc [12, 1]
    {m_open_rule_group_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_open_rule_group.open_rule_group_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/open_rule_group.mlc [13, 1]
    {m_open_rule_group_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_open_rule_group.open_rule_group_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/open_rule_group.mlc [15, 1]
    {m_open_rule_group_OpenCurlyBracket} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_open_rule_group.open_rule_group_action_3();
        } finally {
            state_component.processMTok(45); //END_OPEN_RULE_GROUP
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<open_rule_group_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/open_rule_group.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_open_rule_group.open_rule_group_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/open_rule_group.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_open_rule_group.open_rule_group_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<repetition_spec_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [17, 1]
    {m_repetition_spec_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_repetition_spec.repetition_spec_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [18, 1]
    {m_repetition_spec_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_repetition_spec.repetition_spec_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [19, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_component.inst_repetition_spec.repetition_spec_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [20, 1]
    {m_repetition_spec_CloseCurlyBracket} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_repetition_spec.repetition_spec_action_4();
        } finally {
            state_component.processMTok(46); //END_REPETITION_SPEC
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<repetition_spec_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [22, 1]
    {m_repetition_spec_Number} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_repetition_spec.repetition_spec_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<repetition_spec_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [24, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_repetition_spec.repetition_spec_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/repetition_spec.mlc [25, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_repetition_spec.repetition_spec_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_string_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_string_directive.string_directive_action_1();
        } finally {
            state_component.processMTok(21); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [15, 1]
    {m_string_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_string_directive.string_directive_action_2();
        } finally {
            state_component.processMTok(47); //END_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [16, 1]
    {m_string_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string_directive.string_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [17, 1]
    {m_string_directive_Quote} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_string_directive.string_directive_action_4();
        } finally {
            state_component.processMTok(32); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [18, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string_directive.string_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_string_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string_directive.string_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string_directive.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string_directive.string_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_string_directive.string_directive_action_8();
        } finally {
            state_component.processMTok(47); //END_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string.mlc [22, 1]
    {m_string_Quote} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_component.inst_string.string_action_1();
        } finally {
            state_component.processMTok(48); //END_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [23, 1]
    {m_string_EscapeSequence} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string.string_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [24, 1]
    \\[^\r\n] {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string.string_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [25, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string.string_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [26, 1]
    {m_string_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string.string_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string.mlc [29, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string.string_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [30, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_component.inst_string.string_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


