package test.jflex.natlab; //TWEAK: package

import static test.jflex.natlab.NatlabParser.Terminals.*; //TWEAK: package

import beaver.Symbol;
import beaver.Scanner;

%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/natlab-naive/natlab.mll [18, 1]
%public
//from test/backend-jflex/in/natlab-naive/natlab.mll [19, 1]
%final
//from test/backend-jflex/in/natlab-naive/natlab.mll [20, 1]
%class NaiveNatlabScanner
//from test/backend-jflex/in/natlab-naive/natlab.mll [21, 1]
%extends Scanner
//from test/backend-jflex/in/natlab-naive/natlab.mll [22, 1]
%unicode
//from test/backend-jflex/in/natlab-naive/natlab.mll [23, 1]
%function nextToken
//from test/backend-jflex/in/natlab-naive/natlab.mll [24, 1]
%type Symbol
//from test/backend-jflex/in/natlab-naive/natlab.mll [25, 1]
%line
//from test/backend-jflex/in/natlab-naive/natlab.mll [26, 1]
%column
//from null [28, 1]
%yylexthrow Scanner.Exception

%{
    private final StateClass_natlab state_natlab = new StateClass_natlab();
%}

%{
    private class StateClass_natlab {
        private StateClass_natlab() {
            
            //from test/backend-jflex/in/natlab-naive/natlab.mll [14, 8]
            yybegin(natlab_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(null, inst_natlab, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            
            restartAppendBuf();
            
            //NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.
            sendMTok(/*BOF*/ 0);
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[0];
        private final CompClass_natlab inst_natlab = new CompClass_natlab();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private final MetaLexerClass_natlab metalexer_natlab = new MetaLexerClass_natlab();
        private MetaLexerClass_natlab.Transition sendMTok(int mtok) {
            return metalexer_natlab.processSymbol(mtok);
        }
        
        public void processMTok(int mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                return; //don't send symbol if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MetaLexerClass_natlab.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                next = null;
                if(endOfEmbedding) {
                    int regionSym = currComp.getSymbolValue();
                    if(getCurrFilter().test(regionSym)) {
                        next = sendMTok(regionSym);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract int getSymbolValue();
    }
%}

%{
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [1, 1]
    private class CompClass_natlab extends ComponentInnerClass {
        
        public CompClass_natlab() {
        }
        
        private static final int COMMA_TERMINATOR = natlab_COMMA_TERMINATOR_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [3, 9]
        private static final int SEMICOLON_TERMINATOR = natlab_SEMICOLON_TERMINATOR_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [4, 9]
        private static final int COMMENT_NESTING = natlab_COMMENT_NESTING_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [5, 9]
        private static final int INSIDE_STRING = natlab_INSIDE_STRING_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [6, 9]
        private static final int HELP_COMMENT_NESTING = natlab_HELP_COMMENT_NESTING_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [7, 9]
        private static final int YYINITIAL = natlab_YYINITIAL_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [1, 1]
        private static final int FIELD_NAME = natlab_FIELD_NAME_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [9, 8]
        private static final int CONSUME_LEADING_WHITESPACE = natlab_CONSUME_LEADING_WHITESPACE_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [10, 9]
        private static final int CLASS = natlab_CLASS_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [11, 8]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab-naive/natlab.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 1;
        }
        
        public Maybe<? extends Symbol> natlab_action_1() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [40, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_2() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [41, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_3() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [45, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_4() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [46, 19]
                transposeNext = false; /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_5() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [47, 5]
                //NB: cannot be a string if we're expecting a transpose - even if string is a longer match
    if(transposeNext) {
        return Maybe.Just(symbol(MTRANSPOSE));
    } else {
        saveStateAndTransition(INSIDE_STRING);
        strBuf = new StringBuffer();
        markStartPosition();
    }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_6() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [58, 6]
                strBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_7() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [59, 5]
                markEndPosition();
        Symbol sym = symbolFromMarkedPositions(STRING, strBuf.toString());
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_8() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [63, 15]
                strBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_9() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [64, 4]
                error("Invalid escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_10() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [65, 18]
                yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + strBuf + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_11() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [67, 3]
                strBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_12() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [71, 26]
                transposeNext = false; 
    saveStateAndTransition(HELP_COMMENT_NESTING);
    markStartPosition();
    bracketCommentNestingDepth++;
    bracketCommentBuf = new StringBuffer(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_13() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [76, 22]
                transposeNext = false; 
    saveStateAndTransition(COMMENT_NESTING);
    markStartPosition();
    bracketCommentNestingDepth++;
    bracketCommentBuf = new StringBuffer(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_14() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [84, 3]
                bracketCommentBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_15() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [85, 22]
                bracketCommentNestingDepth++; bracketCommentBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_16() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [89, 23]
                bracketCommentNestingDepth--;
        bracketCommentBuf.append(yytext());
        if(bracketCommentNestingDepth == 0) {
            markEndPosition();
            Symbol sym = symbolFromMarkedPositions(BRACKET_COMMENT, bracketCommentBuf.toString());
            restoreState();
            commentBuffer.pushComment(sym);
        }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_17() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [100, 23]
                bracketCommentNestingDepth--;
        bracketCommentBuf.append(yytext());
        if(bracketCommentNestingDepth == 0) {
            markEndPosition();
            Symbol sym = symbolFromMarkedPositions(BRACKET_HELP_COMMENT, bracketCommentBuf.toString());
            restoreState();
            return Maybe.Just(sym);
        }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_18() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [111, 4]
                bracketNestingDepth++; return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_19() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [112, 4]
                bracketNestingDepth--; return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_20() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [113, 4]
                bracketNestingDepth++; return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_21() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [114, 4]
                bracketNestingDepth--; return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_22() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [115, 4]
                bracketNestingDepth++; return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_23() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [116, 4]
                bracketNestingDepth--; return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_24() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [117, 3]
                transposeNext = false; saveStateAndTransition(COMMA_TERMINATOR); markStartPosition();
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_25() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [118, 3]
                transposeNext = false; saveStateAndTransition(SEMICOLON_TERMINATOR); markStartPosition();
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_26() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [122, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_27() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [123, 22]
                saveStateAndTransition(COMMENT_NESTING);
        markStartPosition();
        bracketCommentNestingDepth++;
        bracketCommentBuf = new StringBuffer(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_28() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [130, 18]
                markEndPosition();
        Symbol sym = symbolFromMarkedPositions(COMMA_LINE_TERMINATOR);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_29() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [137, 18]
                markEndPosition();
        Symbol sym = symbolFromMarkedPositions(SEMICOLON_LINE_TERMINATOR);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_30() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [144, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_31() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [145, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_32() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [146, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_33() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [147, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_34() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [148, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_35() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [149, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_36() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [150, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_37() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [151, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_38() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [152, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_39() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [153, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_40() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [154, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_41() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [155, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_42() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [156, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_43() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [157, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_44() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [158, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_45() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [159, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_46() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [160, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_47() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [161, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_48() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [162, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_49() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [163, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_50() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [164, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_51() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [165, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_52() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [166, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_53() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [167, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_54() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [168, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_55() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [172, 10]
                numEndsExpected++; 
        saveStateAndTransition(CLASS);
        return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_56() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [175, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_57() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [179, 10]
                numEndsExpected++; return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_58() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [180, 5]
                if(bracketNestingDepth == 0) {
            numEndsExpected--;
            if(numEndsExpected == 0) {
                restoreState();
            }
        }
        return Maybe.Just(symbol(END)); //NB: just return normal END token
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_59() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [187, 12]
                numEndsExpected++; return Maybe.Just(symbol(PROPERTIES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_60() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [188, 9]
                numEndsExpected++; return Maybe.Just(symbol(METHODS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_61() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [189, 8]
                numEndsExpected++; return Maybe.Just(symbol(EVENTS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_62() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [193, 6]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_63() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [194, 5]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_64() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [195, 10]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_65() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [196, 4]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_66() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [197, 8]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_67() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [198, 8]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_68() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [199, 5]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_69() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [200, 7]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_70() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [201, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_71() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [202, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_72() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [203, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_73() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_73()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [204, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_74() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_74()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [205, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_75() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_75()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [206, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_76() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_76()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [207, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_77() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_77()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [208, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_78() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_78()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [209, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_79() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_79()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [210, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_80() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_80()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [211, 4]
                //NB: have to change the state AFTER calling symbol
            Symbol result = symbol(DOT);
            saveStateAndTransition(FIELD_NAME);
            return Maybe.Just(result);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_81() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_81()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [218, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_82() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_82()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [224, 14]
                String fullText = yytext();
    String annotation = fullText.substring(2, fullText.length() - 2); //drop (* *)
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol;
    //TODO-AC: this is what LengthScanner is for, but we don't want the dependency
    //  since this is a temporary change
    for(int i = 1; i < fullText.length(); i++) {
        char prevChar = fullText.charAt(i - 1);
        if((prevChar == '\n') || (prevChar == '\r' && fullText.charAt(i) != '\n')) {
            endLine++;
            endCol = 1;
        } else {
            endCol++;
        }
    }
    return Maybe.Just(symbol(ANNOTATION, annotation, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_83() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_83()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [242, 25]
                transposeNext = false;
    commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_84() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_84()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [244, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_85() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_85()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [245, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_86() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_86()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [246, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_87() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_87()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [247, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_88() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_88()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [248, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_89() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_89()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [249, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_90() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_90()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [250, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_91() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_91()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [251, 11]
                transposeNext = false; commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_92() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_92()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [255, 9]
                bracketCommentBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_93() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_93()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [259, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_94() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_94()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [263, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_95() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_95()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [267, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_96() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_96()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [271, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_97() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_97()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [277, 9]
                yypushback(1); yybegin(YYINITIAL);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_98() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_98()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [281, 9]
                yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + strBuf + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_99() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_99()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [286, 9]
                yybegin(YYINITIAL);
        //don't finish scanning if there's an unclosed comment
        if(bracketCommentNestingDepth != 0) {
            error(bracketCommentNestingDepth + " levels of comments not closed");
        }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_100() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_100()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [294, 9]
                yypushback(1); //TWEAK: was . (=> moved as well)
        Symbol sym = symbolFromMarkedStart(COMMA, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_101() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_101()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [298, 9]
                Symbol sym = symbolFromMarkedStart(COMMA, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_102() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_102()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [304, 9]
                yypushback(1); //TWEAK: was . (=> moved as well)
        Symbol sym = symbolFromMarkedStart(SEMICOLON, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_103() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_103()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [308, 9]
                Symbol sym = symbolFromMarkedStart(SEMICOLON, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_104() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_104()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [314, 9]
                error("Illegal character '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_105() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_105()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [318, 9]
                //don't need to check that we're in the initial state, because the
    //  xstates handle EOF and the non-xstates are acceptable when ending
    //don't need to check numEndsExpected since that's only used for changing
    //  states - the parser actually checks the bracketing
    return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    public static class MetaLexerClass_natlab {
        
        //// Symbols ////
        // <BOF>
        // %natlab%
        
        private static final Integer[][] trans_BASE = new Integer[][] {
            {0,0,},
        };
        private static final Integer[] act_BASE = new Integer[] {null,};
        
        private static final Integer[][][] transitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] actionTables = new Integer[][] {
        };
        
        
        private static final Integer[][][] reverseTransitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] reverseActionTables = new Integer[][] {
        };
        
        private static final int[] actionMap = new int[] {};
        
        private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
        
        private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();
        private int currentState = 0;
        private Integer[][] currentTransitionTable = trans_BASE;
        private Integer[] currentActionTable = act_BASE;
        
        public MetaLexerClass_natlab() {
            //Transition through states reachable by pure BOF patterns
        }
        
        public Transition processSymbol(int sym) {
            currentMatch.add(sym);
            currentState = currentTransitionTable[currentState][sym];
            Integer mpatNum = currentActionTable[currentState];
            if(mpatNum == null) {
                return null;
            }
            int action = actionMap[mpatNum];
            Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));
            switchDFAs(action);
            return transition;
        }
        
        private void switchDFAs(int action) {
            currentState = 0;
            currentMatch.clear();
            
            int nextEmbedding;
            if(action < 0) {
                stateStack.pop();
                nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();
            } else {
                stateStack.push(action);
                nextEmbedding = action;
            }
            
            if(nextEmbedding < 0) {
                currentTransitionTable = trans_BASE;
                currentActionTable = act_BASE;
            } else {
                currentTransitionTable = transitionTables[nextEmbedding];
                currentActionTable = actionTables[nextEmbedding];
            }
        }
        
        private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {
            if(mpatNum >= reverseTransitionTables.length) {
                //don't need to clean end pattern matches - they aren't looked at
                return new java.util.ArrayList<Integer>(rawMatch);
            }
            
            java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();
            Integer[][] transitions = reverseTransitionTables[mpatNum];
            Integer[] actions = reverseActionTables[mpatNum];
            int dfaState = 0;
            for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {
                int sym = rawMatch.get(i);
                cleanMatch.add(sym);
                dfaState = transitions[dfaState][sym];
            }
            java.util.Collections.reverse(cleanMatch);
            return cleanMatch;
        }
        
        public static class Transition {
            private final int embeddingNum;
            private final java.util.List<Integer> match;
            
            public Transition(int embeddingNum, java.util.List<Integer> match) {
                this.embeddingNum = embeddingNum;
                this.match = new java.util.ArrayList<Integer>(match);
            }
            
            public int getEmbeddingNum() { return embeddingNum; }
            
            public java.util.List<Integer> getMatch() { return match; }
        }
        
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
        private final java.util.Set<Integer> allOpenSymbols;
        private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {
            this.pairMap = pairMap;
            this.allOpenSymbols = allOpenSymbols;
            this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();
        }
        
        public static class Builder {
            private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
            private final java.util.Set<Integer> allOpenSymbols;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();
                this.allOpenSymbols = new java.util.HashSet<Integer>();
            }
            
            public Builder add(int open, int close) {
                allOpenSymbols.add(open);
                java.util.Set<Integer> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Integer>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenSymbols);
            }
        }
        
        public boolean test(int sym) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Integer> correspondingOpens = pairMap.get(sym);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {
                    int open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenSymbols.contains(sym)) { //implies opening
                unclosedOpenSymbols.add(0, sym); //insert at beginning
            }
            return true;
        }
        
        public void clean(java.util.List<Integer> match) {
            java.util.Collections.reverse(match);
            for(int sym : match) {
                if(unclosedOpenSymbols.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenSymbols.get(0) == sym) {
                    unclosedOpenSymbols.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenSymbols.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isNothing() {
            return !isJust();
        }
        public abstract boolean isJust();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isJust() {
                return true;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isJust() {
                return false;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

//from null [30, 1]
%{
  //// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    //if we return anything while in state FIELD_NAME, then restore state
    //i.e. only the first token after the dot is parsed specially
    if(yystate() == natlab_FIELD_NAME_STATE) { //HACK: mangled name
        restoreState();
    }
    //if we saw something that forces the next single-quote to mean MTRANSPOSE, then set transposeNext
    transposeNext = TYPE_PRECEDING_TRANSPOSE.contains(type);
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
  
  //// Position ////////////////////////////////////////////////////////////////
  
  //records the position of a symbol
  private static class PositionRecord {
      int startLine = -1;
      int startCol = -1;
      int endLine = -1;
      int endCol = -1;
  }
  
  //the position of the current symbol
  private PositionRecord pos = new PositionRecord();
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markStartPosition() {
    //correct to one-indexed
    pos.startLine = yyline + 1;
    pos.startCol = yycolumn + 1;
  }
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markEndPosition() {
    //correct to one-indexed
    pos.endLine = yyline + 1;
    pos.endCol = (yycolumn + 1) + yylength() - 1;
  }
  
  //like symbol(type), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type) {
    return symbolFromMarkedPositions(type, null);
  }
  
  //like symbol(type, value), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type, Object value) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.endLine, pos.endCol);
  }
  
  //like symbol(type), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, int length) {
    return symbolFromMarkedStart(type, null, length);
  }
  
  //like symbol(type, value), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, Object value, int length) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.startLine, pos.startCol + length - 1);
  }
  
  //// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
  
  //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  //// Bracket nesting /////////////////////////////////////////////////////////
  
  //purely to avoid decrementing numEndsExpected for end in exprs
  
  private int bracketNestingDepth = 0;
  
  //// Comment nesting /////////////////////////////////////////////////////////
  
  //number of '%%}'s expected
  private int bracketCommentNestingDepth = 0;
  //bracket comment string consumed so far
  private StringBuffer bracketCommentBuf = null;
  
  //// Comment queue ///////////////////////////////////////////////////////////
  
  //put comments in the buffer rather than returning them
  //NB: must be non-null before scanning starts
  private CommentBuffer commentBuffer = null;
  
  public void setCommentBuffer(CommentBuffer commentBuffer) {
      this.commentBuffer = commentBuffer;
  }
  
  public CommentBuffer getCommentBuffer() {
      return commentBuffer;
  }
  
  //// State transitions ///////////////////////////////////////////////////////
  
  //stack entry: stack identifier + symbol position
  private static class StateRecord {
    int stateNum;
    PositionRecord pos;
    
    StateRecord(int stateNum, PositionRecord pos) {
        this.stateNum = stateNum;
        this.pos = pos;
    }
  }
  
  //most of our states are used for bracketing
  //this gives us a way to nest bracketing states
  private java.util.Stack<StateRecord> stateStack = new java.util.Stack<StateRecord>();
  
  void saveStateAndTransition(int newState) {
    stateStack.push(new StateRecord(yystate(), pos));
    pos = new PositionRecord();
    yybegin(newState);
  }
  
  void restoreState() {
    StateRecord rec = stateStack.pop();
    yybegin(rec.stateNum);
    pos = rec.pos;
  }
  
  //// End-bracketing //////////////////////////////////////////////////////////
  
  //Number of end keywords expected before we leave the CLASS state
  //NB: NOT USED TO VERIFY STRUCTURE (that happens in the parser)
  int numEndsExpected = 0;
  
  //Increment the number of 'end's expected if we are in the CLASS state
  void maybeIncrNumEndsExpected() {
    if(yystate() == natlab_CLASS_STATE) { //HACK: mangled name
        numEndsExpected++;
    }
  }
  
  //// Transpose ///////////////////////////////////////////////////////////////
  
  //if any of these symbols is seen, then an immediately following single-quote
  //will be interpreted as MTRANSPOSE
  //if any other symbol is seen, then a single-quote will be interpreted as the
  //beginning of a string literal
  private static final java.util.Set<Short> TYPE_PRECEDING_TRANSPOSE = new java.util.HashSet<Short>();
  static {
    //NB: cannot contain DOT
    TYPE_PRECEDING_TRANSPOSE.add(IDENTIFIER);
    TYPE_PRECEDING_TRANSPOSE.add(INT_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(IM_INT_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(FP_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(IM_FP_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(RPAREN);
    TYPE_PRECEDING_TRANSPOSE.add(RSQUARE);
    TYPE_PRECEDING_TRANSPOSE.add(RCURLY);
    TYPE_PRECEDING_TRANSPOSE.add(ARRAYTRANSPOSE);
    TYPE_PRECEDING_TRANSPOSE.add(MTRANSPOSE);
  }
  
  private boolean transposeNext = false;
  
  //// String literals /////////////////////////////////////////////////////////
  
  //for accumulating the contents of a string literal
  private StringBuffer strBuf = new StringBuffer();
%}

//from null [264, 1]
%init{
  yybegin(natlab_CONSUME_LEADING_WHITESPACE_STATE); //HACK: mangled name
%init}

%xstate EXTRA_RETURN

//from test/backend-jflex/in/natlab-naive/natlab.mlc [3, 9]
%xstate natlab_COMMA_TERMINATOR_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [4, 9]
%xstate natlab_SEMICOLON_TERMINATOR_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [5, 9]
%xstate natlab_COMMENT_NESTING_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [6, 9]
%xstate natlab_INSIDE_STRING_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [7, 9]
%xstate natlab_HELP_COMMENT_NESTING_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [1, 1]
%state natlab_YYINITIAL_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [9, 8]
%state natlab_FIELD_NAME_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [10, 9]
%xstate natlab_CONSUME_LEADING_WHITESPACE_STATE
//from test/backend-jflex/in/natlab-naive/natlab.mlc [11, 8]
%state natlab_CLASS_STATE

m_natlab_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab-naive/natlab.mlc [13, 1]
m_natlab_HexDigit = ({m_natlab_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab-naive/natlab.mlc [14, 1]
m_natlab_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab-naive/natlab.mlc [15, 1]
m_natlab_ImaginaryHexNumber = 0[xX]({m_natlab_HexDigit})+{m_natlab_Imaginary} //from test/backend-jflex/in/natlab-naive/natlab.mlc [16, 1]
m_natlab_HexNumber = 0[xX]({m_natlab_HexDigit})+ //from test/backend-jflex/in/natlab-naive/natlab.mlc [17, 1]
m_natlab_ShellCommand = [\!](.)* //from test/backend-jflex/in/natlab-naive/natlab.mlc [18, 1]
m_natlab_FPNumber = (({m_natlab_Digit})+(\.)?({m_natlab_Digit})* | (\.)?({m_natlab_Digit})+)({m_natlab_SciExp})? //from test/backend-jflex/in/natlab-naive/natlab.mlc [19, 1]
m_natlab_SciExp = [Ee]([\+\-])?({m_natlab_Digit})+ //from test/backend-jflex/in/natlab-naive/natlab.mlc [20, 1]
m_natlab_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab-naive/natlab.mlc [21, 1]
m_natlab_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab-naive/natlab.mlc [22, 1]
m_natlab_EscapedLineTerminator = {m_natlab_Ellipsis}(.)*{m_natlab_LineTerminator} //from test/backend-jflex/in/natlab-naive/natlab.mlc [23, 1]
m_natlab_Identifier = ([_\$] | {m_natlab_Letter})((([_\$] | {m_natlab_Letter}) | {m_natlab_Digit}))* //from test/backend-jflex/in/natlab-naive/natlab.mlc [24, 1]
m_natlab_IntNumber = ({m_natlab_Digit})+ //from test/backend-jflex/in/natlab-naive/natlab.mlc [25, 1]
m_natlab_Comment = (% | %[^%\{\r\n](.)*) //from test/backend-jflex/in/natlab-naive/natlab.mlc [26, 1]
m_natlab_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab-naive/natlab.mlc [27, 1]
m_natlab_Annotation = "(*"(([^\*] | [\*][^\)]))*"*)" //from test/backend-jflex/in/natlab-naive/natlab.mlc [28, 1]
m_natlab_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab-naive/natlab.mlc [29, 1]
m_natlab_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab-naive/natlab.mlc [30, 1]
m_natlab_ImaginaryFPNumber = (({m_natlab_Digit})+(\.)?({m_natlab_Digit})* | (\.)?({m_natlab_Digit})+)({m_natlab_SciExp})?{m_natlab_Imaginary} //from test/backend-jflex/in/natlab-naive/natlab.mlc [31, 1]
m_natlab_Digit = [0-9] //from test/backend-jflex/in/natlab-naive/natlab.mlc [32, 1]
m_natlab_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab-naive/natlab.mlc [33, 1]
m_natlab_CloseBracketComment = %\} //from test/backend-jflex/in/natlab-naive/natlab.mlc [34, 1]
m_natlab_ImaginaryIntNumber = ({m_natlab_Digit})+{m_natlab_Imaginary} //from test/backend-jflex/in/natlab-naive/natlab.mlc [35, 1]
m_natlab_HelpComment = (%% | %%[^\{\r\n](.)*) //from test/backend-jflex/in/natlab-naive/natlab.mlc [36, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        yybegin(state_natlab.getPrevState());
        return state_natlab.getExtraReturn();
    }
    
    <<EOF>> {
        yybegin(state_natlab.getPrevState());
        return state_natlab.getExtraReturn();
    }
}

<natlab_CONSUME_LEADING_WHITESPACE_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [40, 1]
    {m_natlab_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [41, 1]
    {m_natlab_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [45, 1]
    {m_natlab_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [46, 1]
    {m_natlab_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [47, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_INSIDE_STRING_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [58, 1]
    "''" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [59, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [63, 1]
    {m_natlab_ValidEscape} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [64, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [65, 1]
    {m_natlab_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [67, 1]
    . {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [71, 1]
    {m_natlab_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [76, 1]
    {m_natlab_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_HELP_COMMENT_NESTING_STATE, natlab_COMMENT_NESTING_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [84, 1]
    % {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [85, 1]
    {m_natlab_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_COMMENT_NESTING_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [89, 1]
    {m_natlab_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_HELP_COMMENT_NESTING_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [100, 1]
    {m_natlab_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [111, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [112, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [113, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [114, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [115, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [116, 1]
    \} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [117, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [118, 1]
    ; {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_SEMICOLON_TERMINATOR_STATE, natlab_COMMA_TERMINATOR_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [122, 1]
    {m_natlab_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [123, 1]
    {m_natlab_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_COMMA_TERMINATOR_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [130, 1]
    {m_natlab_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_SEMICOLON_TERMINATOR_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [137, 1]
    {m_natlab_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [144, 1]
    : {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [145, 1]
    @ {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [146, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [147, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [148, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [149, 1]
    ".*" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [150, 1]
    "/" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [151, 1]
    "./" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [152, 1]
    "\\" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [153, 1]
    ".\\" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_39();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [154, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_40();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [155, 1]
    ".^" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_41();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [156, 1]
    ".'" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_42();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [157, 1]
    "<=" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_43();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [158, 1]
    ">=" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_44();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [159, 1]
    "<" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_45();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [160, 1]
    ">" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_46();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [161, 1]
    "==" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_47();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [162, 1]
    "~=" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_48();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [163, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_49();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [164, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_50();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [165, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_51();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [166, 1]
    "&&" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [167, 1]
    "||" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [168, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [172, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [175, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [179, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [180, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [187, 1]
    properties {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_59();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [188, 1]
    methods {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_60();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [189, 1]
    events {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_61();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_CLASS_STATE, natlab_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [193, 1]
    case {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_62();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [194, 1]
    for {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_63();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [195, 1]
    function {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_64();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [196, 1]
    if {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_65();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [197, 1]
    parfor {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_66();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [198, 1]
    switch {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_67();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [199, 1]
    try {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_68();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [200, 1]
    while {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_69();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [201, 1]
    break {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_70();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [202, 1]
    catch {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_71();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [203, 1]
    continue {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [204, 1]
    else {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_73();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [205, 1]
    elseif {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_74();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [206, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_75();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [207, 1]
    global {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_76();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [208, 1]
    otherwise {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_77();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [209, 1]
    persistent {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_78();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [210, 1]
    return {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_79();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [211, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_80();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_FIELD_NAME_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [218, 1]
    \. {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_81();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [224, 1]
    {m_natlab_Annotation} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_82();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [242, 1]
    {m_natlab_EscapedLineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_83();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [244, 1]
    {m_natlab_IntNumber} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_84();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [245, 1]
    {m_natlab_FPNumber} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_85();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [246, 1]
    {m_natlab_HexNumber} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_86();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [247, 1]
    {m_natlab_ImaginaryIntNumber} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_87();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [248, 1]
    {m_natlab_ImaginaryFPNumber} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_88();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [249, 1]
    {m_natlab_ImaginaryHexNumber} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_89();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [250, 1]
    {m_natlab_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_90();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [251, 1]
    {m_natlab_Comment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_91();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_HELP_COMMENT_NESTING_STATE, natlab_COMMENT_NESTING_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [255, 1]
    ([^%])+ {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_92();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [259, 1]
    {m_natlab_ShellCommand} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_93();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_SEMICOLON_TERMINATOR_STATE, natlab_COMMA_TERMINATOR_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [263, 1]
    {m_natlab_Comment} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_94();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_CLASS_STATE, natlab_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [267, 1]
    {m_natlab_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_95();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_FIELD_NAME_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [271, 1]
    {m_natlab_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_96();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_CONSUME_LEADING_WHITESPACE_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [277, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_97();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_INSIDE_STRING_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [281, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_98();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_HELP_COMMENT_NESTING_STATE, natlab_COMMENT_NESTING_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [286, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_99();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_COMMA_TERMINATOR_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [294, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_100();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [298, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_101();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_SEMICOLON_TERMINATOR_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [304, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_102();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [308, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_103();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [314, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_104();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<natlab_COMMA_TERMINATOR_STATE, natlab_SEMICOLON_TERMINATOR_STATE, natlab_COMMENT_NESTING_STATE, natlab_INSIDE_STRING_STATE, natlab_HELP_COMMENT_NESTING_STATE, natlab_YYINITIAL_STATE, natlab_FIELD_NAME_STATE, natlab_CONSUME_LEADING_WHITESPACE_STATE, natlab_CLASS_STATE> {
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [318, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_105();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


