/* The following code was generated by JFlex 1.4.1 on 5/14/09 7:38 PM */

package test.jflex.natlab; //TWEAK: package

import static test.jflex.natlab.NatlabParser.Terminals.*; //TWEAK: package

import beaver.Symbol;
import beaver.Scanner;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 5/14/09 7:38 PM from the specification file
 * <tt>test/backend-jflex/out/natlab-naive/natlab/natlab.flex</tt>
 */
public final class NaiveNatlabScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int natlab_INSIDE_STRING_STATE = 5;
  public static final int natlab_HELP_COMMENT_NESTING_STATE = 6;
  public static final int natlab_SEMICOLON_TERMINATOR_STATE = 3;
  public static final int EXTRA_RETURN = 1;
  public static final int natlab_FIELD_NAME_STATE = 8;
  public static final int natlab_COMMENT_NESTING_STATE = 4;
  public static final int YYINITIAL = 0;
  public static final int natlab_YYINITIAL_STATE = 7;
  public static final int natlab_CONSUME_LEADING_WHITESPACE_STATE = 9;
  public static final int natlab_COMMA_TERMINATOR_STATE = 2;
  public static final int natlab_CLASS_STATE = 10;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\7\1\0\1\1\1\21\22\0\1\1\1\6\1\14"+
    "\1\0\1\16\1\17\1\46\1\30\1\22\1\24\1\23\1\37\1\33"+
    "\1\11\1\3\1\40\1\4\11\25\1\35\1\34\1\42\1\43\1\44"+
    "\1\0\1\36\4\2\1\10\1\2\2\16\2\12\15\16\1\5\2\16"+
    "\1\31\1\13\1\32\1\41\1\16\1\0\1\52\1\15\1\50\1\54"+
    "\1\55\1\56\1\73\1\65\1\63\1\12\1\72\1\51\1\64\1\57"+
    "\1\62\1\60\1\16\1\61\1\53\1\26\1\67\1\66\1\70\1\5"+
    "\1\71\1\16\1\20\1\47\1\27\1\45\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\1\1\1\2\1\3\1\4\1\5\1\4\1\6"+
    "\2\7\1\10\1\11\1\12\1\13\1\14\1\13\1\15"+
    "\1\11\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\20\1\27\1\30\1\24\1\31\1\32"+
    "\1\33\1\22\1\20\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\12\20\1\55\1\56\1\57"+
    "\1\60\2\61\4\20\1\5\1\62\1\63\1\64\1\65"+
    "\1\66\1\67\1\0\1\70\1\71\1\72\1\73\1\74"+
    "\1\75\2\0\1\76\1\20\1\27\1\77\1\100\1\0"+
    "\1\20\1\101\1\102\1\103\1\104\1\105\1\106\14\20"+
    "\1\107\7\20\1\0\1\110\1\111\1\70\1\0\1\20"+
    "\1\77\1\112\1\0\1\113\6\20\1\114\1\115\10\20"+
    "\1\116\3\20\2\117\1\120\1\20\1\121\2\20\1\122"+
    "\2\20\1\123\13\20\1\124\1\20\1\125\10\20\1\126"+
    "\7\20\1\127\1\130\1\20\1\131\1\20\1\132\1\20"+
    "\1\133\1\20\1\134\11\20\1\135\1\136\1\137\1\140"+
    "\2\20\1\141\2\20\1\142\1\20\1\143\1\144";

  private static int [] zzUnpackAction() {
    int [] result = new int[235];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\74\0\170\0\264\0\360\0\u012c\0\u0168\0\u01a4"+
    "\0\u01e0\0\u021c\0\u0258\0\0\0\0\0\0\0\0\0\u0294"+
    "\0\u02d0\0\0\0\0\0\u030c\0\u0348\0\u0384\0\0\0\0"+
    "\0\u03c0\0\u03fc\0\u0438\0\u0474\0\0\0\0\0\u04b0\0\u04ec"+
    "\0\u0528\0\u0564\0\0\0\0\0\0\0\u05a0\0\u05dc\0\0"+
    "\0\u0618\0\u0654\0\0\0\0\0\u0690\0\u06cc\0\0\0\0"+
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"+
    "\0\0\0\u0708\0\u0744\0\u0780\0\u07bc\0\u07f8\0\u0834\0\u0870"+
    "\0\u08ac\0\u08e8\0\u0924\0\u0960\0\u099c\0\u09d8\0\u0a14\0\u0a50"+
    "\0\u0a8c\0\u0ac8\0\u04ec\0\0\0\0\0\0\0\u0b04\0\u0b40"+
    "\0\u0b7c\0\u0bb8\0\u0bf4\0\u0c30\0\0\0\0\0\0\0\0"+
    "\0\0\0\0\0\u0c6c\0\u0ca8\0\0\0\0\0\0\0\0"+
    "\0\0\0\u0ce4\0\u0d20\0\0\0\u0d5c\0\u0d98\0\u0dd4\0\0"+
    "\0\u0e10\0\u0e4c\0\0\0\0\0\0\0\0\0\0\0\0"+
    "\0\u0e88\0\u0ec4\0\u0f00\0\u0f3c\0\u0f78\0\u0fb4\0\u0ff0\0\u102c"+
    "\0\u1068\0\u10a4\0\u10e0\0\u111c\0\u04b0\0\u1158\0\u1194\0\u11d0"+
    "\0\u120c\0\u1248\0\u1284\0\u12c0\0\u12fc\0\0\0\u1338\0\u1374"+
    "\0\u13b0\0\u13ec\0\u1428\0\0\0\u1464\0\u04b0\0\u14a0\0\u14dc"+
    "\0\u1518\0\u1554\0\u1590\0\u15cc\0\u04b0\0\u04b0\0\u1608\0\u1644"+
    "\0\u1680\0\u16bc\0\u16f8\0\u1734\0\u1770\0\u17ac\0\u04b0\0\u17e8"+
    "\0\u1824\0\u1860\0\0\0\u12fc\0\0\0\u189c\0\0\0\u18d8"+
    "\0\u1914\0\u04b0\0\u1950\0\u198c\0\u19c8\0\u1a04\0\u1a40\0\u1a7c"+
    "\0\u1ab8\0\u1af4\0\u1b30\0\u1b6c\0\u1ba8\0\u1be4\0\u1c20\0\u1c5c"+
    "\0\u04b0\0\u1c98\0\u04b0\0\u1cd4\0\u1d10\0\u1d4c\0\u1d88\0\u1dc4"+
    "\0\u1e00\0\u1e3c\0\u1e78\0\u04b0\0\u1eb4\0\u1ef0\0\u1f2c\0\u1f68"+
    "\0\u1fa4\0\u1fe0\0\u201c\0\u04b0\0\u04b0\0\u2058\0\u04b0\0\u2094"+
    "\0\u04b0\0\u20d0\0\u04b0\0\u210c\0\u04b0\0\u2148\0\u2184\0\u21c0"+
    "\0\u21fc\0\u2238\0\u2274\0\u22b0\0\u22ec\0\u2328\0\u04b0\0\u04b0"+
    "\0\u04b0\0\u04b0\0\u2364\0\u23a0\0\u04b0\0\u23dc\0\u2418\0\u04b0"+
    "\0\u2454\0\u04b0\0\u04b0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[235];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\74\0\74\14\1\15\1\16\5\15\1\17\7\15\1\20"+
    "\1\15\1\21\52\15\1\22\1\16\5\22\1\23\7\22"+
    "\1\20\1\22\1\24\52\22\17\25\1\26\54\25\7\27"+
    "\1\30\3\27\1\31\5\27\1\32\6\27\1\33\43\27"+
    "\17\25\1\34\54\25\1\35\1\36\1\37\1\40\1\41"+
    "\1\37\1\42\1\43\1\37\1\44\1\37\1\45\1\35"+
    "\1\46\1\37\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\73\1\74"+
    "\1\75\1\76\1\77\1\100\2\37\1\101\1\37\1\102"+
    "\1\103\1\37\1\104\1\105\1\106\1\107\4\37\1\110"+
    "\2\37\1\111\1\35\1\36\1\112\1\113\1\41\1\112"+
    "\1\42\1\43\1\112\1\44\1\112\1\45\1\35\2\112"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\112"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\24\112\1\114\1\115\5\114\1\116\11\114\1\117"+
    "\52\114\1\35\1\36\1\37\1\40\1\41\1\37\1\42"+
    "\1\43\1\37\1\44\1\37\1\45\1\35\1\46\1\37"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\120\2\37\1\101\1\37\1\121\1\103\1\37"+
    "\1\122\1\105\1\106\1\107\1\123\3\37\1\110\2\37"+
    "\1\111\7\124\1\0\7\124\1\0\1\125\1\0\52\124"+
    "\7\0\1\17\73\0\1\23\64\0\17\25\1\0\54\25"+
    "\20\0\1\126\6\0\1\127\57\0\3\130\10\0\1\130"+
    "\27\0\2\130\1\0\1\130\21\0\1\30\114\0\1\131"+
    "\63\0\1\126\6\0\1\132\46\0\1\37\1\0\2\37"+
    "\2\0\1\37\1\0\1\37\2\0\2\37\6\0\2\37"+
    "\21\0\24\37\3\0\1\133\1\134\6\0\1\135\7\0"+
    "\1\136\1\0\1\134\2\0\1\137\7\0\1\140\1\141"+
    "\35\0\1\134\1\55\1\142\2\0\1\143\1\0\1\144"+
    "\12\0\1\55\27\0\1\143\5\0\1\144\10\0\7\42"+
    "\1\0\64\42\2\0\1\37\1\0\2\37\2\0\1\37"+
    "\1\0\1\37\2\0\2\37\6\0\2\37\21\0\11\37"+
    "\1\145\12\37\7\146\1\0\7\146\1\147\1\150\1\0"+
    "\52\146\7\0\1\43\107\0\1\151\53\0\1\134\1\55"+
    "\3\0\1\143\1\0\1\144\12\0\1\55\27\0\1\143"+
    "\5\0\1\144\12\0\1\37\1\0\2\37\2\0\1\37"+
    "\1\0\1\37\2\0\2\37\6\0\2\37\21\0\11\37"+
    "\1\152\12\37\43\0\1\153\73\0\1\154\73\0\1\155"+
    "\73\0\1\156\76\0\1\157\74\0\1\160\26\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\1\37\1\161\1\162\7\37\1\163"+
    "\11\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\20\37\1\164"+
    "\3\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\1\37\1\165"+
    "\5\37\1\166\14\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\12\37\1\167\4\37\1\170\4\37\2\0\1\37\1\0"+
    "\2\37\2\0\1\37\1\0\1\37\2\0\2\37\6\0"+
    "\2\37\21\0\2\37\1\171\2\37\1\172\16\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\5\37\1\173\16\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\1\37\1\174\21\0\24\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\6\37\1\175\15\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\15\37\1\176\6\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\1\37\1\177\22\37\2\0\1\112"+
    "\1\0\2\112\2\0\1\112\1\0\1\112\2\0\2\112"+
    "\6\0\2\112\21\0\24\112\7\0\1\116\66\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\1\37\1\200\1\162\7\37\1\163"+
    "\11\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\1\37\1\165"+
    "\5\37\1\201\6\37\1\202\5\37\2\0\1\37\1\0"+
    "\2\37\2\0\1\37\1\0\1\37\2\0\2\37\6\0"+
    "\2\37\21\0\2\37\1\171\2\37\1\172\3\37\1\203"+
    "\12\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\5\37\1\204"+
    "\16\37\7\124\1\0\64\124\3\0\1\205\74\0\1\134"+
    "\3\0\1\143\1\0\1\206\12\0\1\134\27\0\1\143"+
    "\5\0\1\206\12\0\1\207\1\0\1\207\3\0\1\207"+
    "\4\0\1\207\7\0\1\207\22\0\1\207\1\0\1\207"+
    "\1\0\3\207\21\0\1\210\4\0\1\211\13\0\1\210"+
    "\11\0\1\211\36\0\1\37\1\0\2\37\2\0\1\37"+
    "\1\0\1\37\2\0\2\37\6\0\2\37\21\0\5\37"+
    "\1\212\16\37\7\146\1\0\64\146\7\213\1\0\10\213"+
    "\1\214\1\0\52\213\23\151\1\215\50\151\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\21\37\1\216\2\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\2\37\1\217\21\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\1\37\1\220\21\0\3\37\1\221\20\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\7\37\1\222\14\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\13\37\1\223\10\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\3\37\1\224\20\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\4\37\1\225\17\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\11\37\1\226\12\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\7\37\1\227\14\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\11\37\1\230\12\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\11\37\1\231\12\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\1\37\1\232\21\0\24\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\15\37\1\233\6\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\13\37\1\234\10\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\12\37\1\235\11\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\2\37\1\236\21\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\4\37\1\237\17\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\5\37\1\240\16\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\12\37\1\241\11\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\1\37\1\242\21\0\24\37\7\205\1\243\11\205"+
    "\1\244\52\205\2\0\1\207\1\0\1\207\3\0\1\207"+
    "\1\0\1\245\2\0\1\207\7\0\1\207\22\0\1\207"+
    "\1\0\1\207\1\0\3\207\4\0\1\245\14\0\1\210"+
    "\5\0\1\206\12\0\1\210\35\0\1\206\14\0\1\210"+
    "\20\0\1\210\50\0\1\37\1\0\2\37\2\0\1\37"+
    "\1\0\1\37\2\0\2\37\6\0\2\37\21\0\2\37"+
    "\1\246\21\37\7\213\1\0\64\213\24\151\1\247\47\151"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\3\37\1\250\20\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\1\251\23\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\5\37\1\252\16\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\1\37\1\253\21\0\24\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\1\37\1\254\21\0\24\37\2\0\1\37\1\0"+
    "\2\37\2\0\1\37\1\0\1\37\2\0\2\37\6\0"+
    "\2\37\21\0\5\37\1\255\16\37\2\0\1\37\1\0"+
    "\2\37\2\0\1\37\1\0\1\37\2\0\2\37\6\0"+
    "\2\37\21\0\1\256\23\37\2\0\1\37\1\0\2\37"+
    "\2\0\1\37\1\0\1\37\2\0\2\37\6\0\2\37"+
    "\21\0\6\37\1\257\15\37\2\0\1\37\1\0\2\37"+
    "\2\0\1\37\1\0\1\37\2\0\2\37\6\0\2\37"+
    "\21\0\3\37\1\260\20\37\2\0\1\37\1\0\2\37"+
    "\2\0\1\37\1\0\1\37\2\0\2\37\6\0\2\37"+
    "\21\0\17\37\1\261\4\37\2\0\1\37\1\0\2\37"+
    "\2\0\1\37\1\0\1\37\2\0\2\37\6\0\2\37"+
    "\21\0\5\37\1\262\16\37\2\0\1\37\1\0\2\37"+
    "\2\0\1\37\1\0\1\37\2\0\2\37\6\0\2\37"+
    "\21\0\1\37\1\263\22\37\2\0\1\37\1\0\2\37"+
    "\2\0\1\37\1\0\1\37\2\0\1\264\1\37\6\0"+
    "\2\37\21\0\24\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\3\37\1\265\20\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\7\37\1\266\14\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\10\37\1\267\13\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\15\37\1\270\6\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\22\37\1\271\1\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\3\37\1\272\20\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\15\37\1\273\6\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\13\37\1\274\10\37\2\0\1\37\1\0\2\37\2\0"+
    "\1\37\1\0\1\37\2\0\2\37\6\0\2\37\21\0"+
    "\1\275\23\37\2\0\1\37\1\0\2\37\2\0\1\37"+
    "\1\0\1\37\2\0\2\37\6\0\2\37\21\0\13\37"+
    "\1\276\10\37\2\0\1\37\1\0\2\37\2\0\1\37"+
    "\1\0\1\37\2\0\2\37\6\0\1\37\1\277\21\0"+
    "\24\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\12\37\1\300"+
    "\11\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\13\37\1\301"+
    "\10\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\11\37\1\302"+
    "\12\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\11\37\1\303"+
    "\12\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\5\37\1\304"+
    "\16\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\2\37\1\305"+
    "\21\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\2\37\21\0\3\37\1\306"+
    "\20\37\2\0\1\37\1\0\2\37\2\0\1\37\1\0"+
    "\1\37\2\0\2\37\6\0\1\37\1\307\21\0\24\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\5\37\1\310\16\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\12\37\1\311\11\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\4\37\1\312\17\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\7\37\1\313\14\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\15\37\1\314\6\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\6\37\1\315\15\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\13\37\1\316\10\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\11\37\1\317\12\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\3\37\1\320\20\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\7\37\1\321\14\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\20\37\1\322\3\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\1\37\1\323\22\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\4\37\1\324\17\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\3\37\1\325\20\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\11\37\1\326\12\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\4\37\1\327\17\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\5\37\1\330\16\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\17\37\1\331\4\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\2\37\21\0\12\37\1\332\11\37"+
    "\2\0\1\37\1\0\2\37\2\0\1\37\1\0\1\37"+
    "\2\0\2\37\6\0\1\37\1\333\21\0\24\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\13\37\1\334\10\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\2\37\21\0\5\37\1\335\16\37\2\0"+
    "\1\37\1\0\2\37\2\0\1\37\1\0\1\37\2\0"+
    "\2\37\6\0\1\37\1\336\21\0\24\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\3\37\1\337\20\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\6\37\1\340\15\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\5\37\1\341\16\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\7\37\1\342\14\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\5\37\1\343\16\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\3\37\1\344\20\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\6\37\1\345\15\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\13\37\1\346\10\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\7\37\1\347\14\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\5\37\1\350\16\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\2\37\21\0\5\37\1\351\16\37\2\0\1\37"+
    "\1\0\2\37\2\0\1\37\1\0\1\37\2\0\2\37"+
    "\6\0\1\37\1\352\21\0\24\37\2\0\1\37\1\0"+
    "\2\37\2\0\1\37\1\0\1\37\2\0\2\37\6\0"+
    "\2\37\21\0\3\37\1\353\20\37";

  private static int [] zzUnpackTrans() {
    int [] result = new int[9360];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\12\0\4\11\2\1\2\11\3\1\2\11\4\1"+
    "\2\11\4\1\3\11\2\1\1\11\2\1\2\11\2\1"+
    "\13\11\22\1\3\11\6\1\6\11\1\0\1\1\5\11"+
    "\2\0\1\11\3\1\1\11\1\0\1\1\6\11\24\1"+
    "\1\0\1\11\2\1\1\0\2\1\1\11\1\0\25\1"+
    "\1\11\1\1\1\11\1\1\1\11\104\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[235];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
    private final StateClass_natlab state_natlab = new StateClass_natlab();
    private class StateClass_natlab {
        private StateClass_natlab() {
            
            //from test/backend-jflex/in/natlab-naive/natlab.mll [14, 8]
            yybegin(natlab_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(null, inst_natlab, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            
            restartAppendBuf();
            
            //NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.
            sendMTok(/*BOF*/ 0);
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[0];
        private final CompClass_natlab inst_natlab = new CompClass_natlab();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private final MetaLexerClass_natlab metalexer_natlab = new MetaLexerClass_natlab();
        private MetaLexerClass_natlab.Transition sendMTok(int mtok) {
            return metalexer_natlab.processSymbol(mtok);
        }
        
        public void processMTok(int mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                return; //don't send symbol if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MetaLexerClass_natlab.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                next = null;
                if(endOfEmbedding) {
                    int regionSym = currComp.getSymbolValue();
                    if(getCurrFilter().test(regionSym)) {
                        next = sendMTok(regionSym);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract int getSymbolValue();
    }
    //from test/backend-jflex/in/natlab-naive/natlab.mlc [1, 1]
    private class CompClass_natlab extends ComponentInnerClass {
        
        public CompClass_natlab() {
        }
        
        private static final int COMMA_TERMINATOR = natlab_COMMA_TERMINATOR_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [3, 9]
        private static final int SEMICOLON_TERMINATOR = natlab_SEMICOLON_TERMINATOR_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [4, 9]
        private static final int COMMENT_NESTING = natlab_COMMENT_NESTING_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [5, 9]
        private static final int INSIDE_STRING = natlab_INSIDE_STRING_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [6, 9]
        private static final int HELP_COMMENT_NESTING = natlab_HELP_COMMENT_NESTING_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [7, 9]
        private static final int YYINITIAL = natlab_YYINITIAL_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [1, 1]
        private static final int FIELD_NAME = natlab_FIELD_NAME_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [9, 8]
        private static final int CONSUME_LEADING_WHITESPACE = natlab_CONSUME_LEADING_WHITESPACE_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [10, 9]
        private static final int CLASS = natlab_CLASS_STATE; //from test/backend-jflex/in/natlab-naive/natlab.mlc [11, 8]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab-naive/natlab.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 1;
        }
        
        public Maybe<? extends Symbol> natlab_action_1() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [40, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_2() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [41, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_3() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [45, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_4() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [46, 19]
                transposeNext = false; /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_5() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [47, 5]
                //NB: cannot be a string if we're expecting a transpose - even if string is a longer match
    if(transposeNext) {
        return Maybe.Just(symbol(MTRANSPOSE));
    } else {
        saveStateAndTransition(INSIDE_STRING);
        strBuf = new StringBuffer();
        markStartPosition();
    }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_6() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [58, 6]
                strBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_7() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [59, 5]
                markEndPosition();
        Symbol sym = symbolFromMarkedPositions(STRING, strBuf.toString());
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_8() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [63, 15]
                strBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_9() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [64, 4]
                error("Invalid escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_10() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [65, 18]
                yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + strBuf + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_11() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [67, 3]
                strBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_12() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [71, 26]
                transposeNext = false; 
    saveStateAndTransition(HELP_COMMENT_NESTING);
    markStartPosition();
    bracketCommentNestingDepth++;
    bracketCommentBuf = new StringBuffer(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_13() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [76, 22]
                transposeNext = false; 
    saveStateAndTransition(COMMENT_NESTING);
    markStartPosition();
    bracketCommentNestingDepth++;
    bracketCommentBuf = new StringBuffer(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_14() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [84, 3]
                bracketCommentBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_15() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [85, 22]
                bracketCommentNestingDepth++; bracketCommentBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_16() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [89, 23]
                bracketCommentNestingDepth--;
        bracketCommentBuf.append(yytext());
        if(bracketCommentNestingDepth == 0) {
            markEndPosition();
            Symbol sym = symbolFromMarkedPositions(BRACKET_COMMENT, bracketCommentBuf.toString());
            restoreState();
            commentBuffer.pushComment(sym);
        }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_17() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [100, 23]
                bracketCommentNestingDepth--;
        bracketCommentBuf.append(yytext());
        if(bracketCommentNestingDepth == 0) {
            markEndPosition();
            Symbol sym = symbolFromMarkedPositions(BRACKET_HELP_COMMENT, bracketCommentBuf.toString());
            restoreState();
            return Maybe.Just(sym);
        }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_18() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [111, 4]
                bracketNestingDepth++; return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_19() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [112, 4]
                bracketNestingDepth--; return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_20() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [113, 4]
                bracketNestingDepth++; return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_21() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [114, 4]
                bracketNestingDepth--; return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_22() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [115, 4]
                bracketNestingDepth++; return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_23() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [116, 4]
                bracketNestingDepth--; return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_24() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [117, 3]
                transposeNext = false; saveStateAndTransition(COMMA_TERMINATOR); markStartPosition();
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_25() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [118, 3]
                transposeNext = false; saveStateAndTransition(SEMICOLON_TERMINATOR); markStartPosition();
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_26() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [122, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_27() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [123, 22]
                saveStateAndTransition(COMMENT_NESTING);
        markStartPosition();
        bracketCommentNestingDepth++;
        bracketCommentBuf = new StringBuffer(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_28() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [130, 18]
                markEndPosition();
        Symbol sym = symbolFromMarkedPositions(COMMA_LINE_TERMINATOR);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_29() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [137, 18]
                markEndPosition();
        Symbol sym = symbolFromMarkedPositions(SEMICOLON_LINE_TERMINATOR);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_30() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [144, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_31() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [145, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_32() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [146, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_33() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [147, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_34() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [148, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_35() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [149, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_36() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [150, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_37() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [151, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_38() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [152, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_39() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [153, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_40() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [154, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_41() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [155, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_42() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [156, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_43() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [157, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_44() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [158, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_45() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [159, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_46() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [160, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_47() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [161, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_48() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [162, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_49() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [163, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_50() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [164, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_51() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [165, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_52() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [166, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_53() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [167, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_54() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [168, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_55() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [172, 10]
                numEndsExpected++; 
        saveStateAndTransition(CLASS);
        return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_56() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [175, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_57() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [179, 10]
                numEndsExpected++; return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_58() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [180, 5]
                if(bracketNestingDepth == 0) {
            numEndsExpected--;
            if(numEndsExpected == 0) {
                restoreState();
            }
        }
        return Maybe.Just(symbol(END)); //NB: just return normal END token
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_59() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [187, 12]
                numEndsExpected++; return Maybe.Just(symbol(PROPERTIES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_60() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [188, 9]
                numEndsExpected++; return Maybe.Just(symbol(METHODS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_61() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [189, 8]
                numEndsExpected++; return Maybe.Just(symbol(EVENTS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_62() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [193, 6]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_63() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [194, 5]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_64() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [195, 10]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_65() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [196, 4]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_66() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [197, 8]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_67() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [198, 8]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_68() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [199, 5]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_69() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [200, 7]
                maybeIncrNumEndsExpected(); return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_70() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [201, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_71() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [202, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_72() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [203, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_73() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_73()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [204, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_74() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_74()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [205, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_75() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_75()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [206, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_76() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_76()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [207, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_77() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_77()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [208, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_78() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_78()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [209, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_79() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_79()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [210, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_80() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_80()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [211, 4]
                //NB: have to change the state AFTER calling symbol
            Symbol result = symbol(DOT);
            saveStateAndTransition(FIELD_NAME);
            return Maybe.Just(result);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_81() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_81()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [218, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_82() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_82()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [224, 14]
                String fullText = yytext();
    String annotation = fullText.substring(2, fullText.length() - 2); //drop (* *)
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol;
    //TODO-AC: this is what LengthScanner is for, but we don't want the dependency
    //  since this is a temporary change
    for(int i = 1; i < fullText.length(); i++) {
        char prevChar = fullText.charAt(i - 1);
        if((prevChar == '\n') || (prevChar == '\r' && fullText.charAt(i) != '\n')) {
            endLine++;
            endCol = 1;
        } else {
            endCol++;
        }
    }
    return Maybe.Just(symbol(ANNOTATION, annotation, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_83() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_83()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [242, 25]
                transposeNext = false;
    commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_84() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_84()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [244, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_85() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_85()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [245, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_86() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_86()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [246, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_87() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_87()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [247, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_88() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_88()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [248, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_89() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_89()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [249, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_90() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_90()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [250, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_91() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_91()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [251, 11]
                transposeNext = false; commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_92() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_92()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [255, 9]
                bracketCommentBuf.append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_93() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_93()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [259, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_94() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_94()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [263, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_95() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_95()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [267, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_96() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_96()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [271, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_97() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_97()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [277, 9]
                yypushback(1); yybegin(YYINITIAL);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_98() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_98()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [281, 9]
                yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + strBuf + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_99() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_99()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [286, 9]
                yybegin(YYINITIAL);
        //don't finish scanning if there's an unclosed comment
        if(bracketCommentNestingDepth != 0) {
            error(bracketCommentNestingDepth + " levels of comments not closed");
        }
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_100() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_100()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [294, 9]
                yypushback(1); //TWEAK: was . (=> moved as well)
        Symbol sym = symbolFromMarkedStart(COMMA, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_101() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_101()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [298, 9]
                Symbol sym = symbolFromMarkedStart(COMMA, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_102() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_102()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [304, 9]
                yypushback(1); //TWEAK: was . (=> moved as well)
        Symbol sym = symbolFromMarkedStart(SEMICOLON, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_103() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_103()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [308, 9]
                Symbol sym = symbolFromMarkedStart(SEMICOLON, 1);
        restoreState();
        return Maybe.Just(sym);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_104() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_104()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [314, 9]
                error("Illegal character '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> natlab_action_105() throws Scanner.Exception {
            //System.err.println("state_natlab.inst_natlab.natlab_action_105()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab-naive/natlab.mlc [318, 9]
                //don't need to check that we're in the initial state, because the
    //  xstates handle EOF and the non-xstates are acceptable when ending
    //don't need to check numEndsExpected since that's only used for changing
    //  states - the parser actually checks the bracketing
    return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
    public static class MetaLexerClass_natlab {
        
        //// Symbols ////
        // <BOF>
        // %natlab%
        
        private static final Integer[][] trans_BASE = new Integer[][] {
            {0,0,},
        };
        private static final Integer[] act_BASE = new Integer[] {null,};
        
        private static final Integer[][][] transitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] actionTables = new Integer[][] {
        };
        
        
        private static final Integer[][][] reverseTransitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] reverseActionTables = new Integer[][] {
        };
        
        private static final int[] actionMap = new int[] {};
        
        private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
        
        private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();
        private int currentState = 0;
        private Integer[][] currentTransitionTable = trans_BASE;
        private Integer[] currentActionTable = act_BASE;
        
        public MetaLexerClass_natlab() {
            //Transition through states reachable by pure BOF patterns
        }
        
        public Transition processSymbol(int sym) {
            currentMatch.add(sym);
            currentState = currentTransitionTable[currentState][sym];
            Integer mpatNum = currentActionTable[currentState];
            if(mpatNum == null) {
                return null;
            }
            int action = actionMap[mpatNum];
            Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));
            switchDFAs(action);
            return transition;
        }
        
        private void switchDFAs(int action) {
            currentState = 0;
            currentMatch.clear();
            
            int nextEmbedding;
            if(action < 0) {
                stateStack.pop();
                nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();
            } else {
                stateStack.push(action);
                nextEmbedding = action;
            }
            
            if(nextEmbedding < 0) {
                currentTransitionTable = trans_BASE;
                currentActionTable = act_BASE;
            } else {
                currentTransitionTable = transitionTables[nextEmbedding];
                currentActionTable = actionTables[nextEmbedding];
            }
        }
        
        private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {
            if(mpatNum >= reverseTransitionTables.length) {
                //don't need to clean end pattern matches - they aren't looked at
                return new java.util.ArrayList<Integer>(rawMatch);
            }
            
            java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();
            Integer[][] transitions = reverseTransitionTables[mpatNum];
            Integer[] actions = reverseActionTables[mpatNum];
            int dfaState = 0;
            for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {
                int sym = rawMatch.get(i);
                cleanMatch.add(sym);
                dfaState = transitions[dfaState][sym];
            }
            java.util.Collections.reverse(cleanMatch);
            return cleanMatch;
        }
        
        public static class Transition {
            private final int embeddingNum;
            private final java.util.List<Integer> match;
            
            public Transition(int embeddingNum, java.util.List<Integer> match) {
                this.embeddingNum = embeddingNum;
                this.match = new java.util.ArrayList<Integer>(match);
            }
            
            public int getEmbeddingNum() { return embeddingNum; }
            
            public java.util.List<Integer> getMatch() { return match; }
        }
        
    }
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
        private final java.util.Set<Integer> allOpenSymbols;
        private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {
            this.pairMap = pairMap;
            this.allOpenSymbols = allOpenSymbols;
            this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();
        }
        
        public static class Builder {
            private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
            private final java.util.Set<Integer> allOpenSymbols;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();
                this.allOpenSymbols = new java.util.HashSet<Integer>();
            }
            
            public Builder add(int open, int close) {
                allOpenSymbols.add(open);
                java.util.Set<Integer> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Integer>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenSymbols);
            }
        }
        
        public boolean test(int sym) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Integer> correspondingOpens = pairMap.get(sym);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {
                    int open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenSymbols.contains(sym)) { //implies opening
                unclosedOpenSymbols.add(0, sym); //insert at beginning
            }
            return true;
        }
        
        public void clean(java.util.List<Integer> match) {
            java.util.Collections.reverse(match);
            for(int sym : match) {
                if(unclosedOpenSymbols.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenSymbols.get(0) == sym) {
                    unclosedOpenSymbols.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenSymbols.clear();
        }
    }
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isNothing() {
            return !isJust();
        }
        public abstract boolean isJust();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isJust() {
                return true;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isJust() {
                return false;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
  //// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    //if we return anything while in state FIELD_NAME, then restore state
    //i.e. only the first token after the dot is parsed specially
    if(yystate() == natlab_FIELD_NAME_STATE) { //HACK: mangled name
        restoreState();
    }
    //if we saw something that forces the next single-quote to mean MTRANSPOSE, then set transposeNext
    transposeNext = TYPE_PRECEDING_TRANSPOSE.contains(type);
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
  
  //// Position ////////////////////////////////////////////////////////////////
  
  //records the position of a symbol
  private static class PositionRecord {
      int startLine = -1;
      int startCol = -1;
      int endLine = -1;
      int endCol = -1;
  }
  
  //the position of the current symbol
  private PositionRecord pos = new PositionRecord();
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markStartPosition() {
    //correct to one-indexed
    pos.startLine = yyline + 1;
    pos.startCol = yycolumn + 1;
  }
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markEndPosition() {
    //correct to one-indexed
    pos.endLine = yyline + 1;
    pos.endCol = (yycolumn + 1) + yylength() - 1;
  }
  
  //like symbol(type), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type) {
    return symbolFromMarkedPositions(type, null);
  }
  
  //like symbol(type, value), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type, Object value) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.endLine, pos.endCol);
  }
  
  //like symbol(type), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, int length) {
    return symbolFromMarkedStart(type, null, length);
  }
  
  //like symbol(type, value), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, Object value, int length) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.startLine, pos.startCol + length - 1);
  }
  
  //// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
  
  //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  //// Bracket nesting /////////////////////////////////////////////////////////
  
  //purely to avoid decrementing numEndsExpected for end in exprs
  
  private int bracketNestingDepth = 0;
  
  //// Comment nesting /////////////////////////////////////////////////////////
  
  //number of '%%}'s expected
  private int bracketCommentNestingDepth = 0;
  //bracket comment string consumed so far
  private StringBuffer bracketCommentBuf = null;
  
  //// Comment queue ///////////////////////////////////////////////////////////
  
  //put comments in the buffer rather than returning them
  //NB: must be non-null before scanning starts
  private CommentBuffer commentBuffer = null;
  
  public void setCommentBuffer(CommentBuffer commentBuffer) {
      this.commentBuffer = commentBuffer;
  }
  
  public CommentBuffer getCommentBuffer() {
      return commentBuffer;
  }
  
  //// State transitions ///////////////////////////////////////////////////////
  
  //stack entry: stack identifier + symbol position
  private static class StateRecord {
    int stateNum;
    PositionRecord pos;
    
    StateRecord(int stateNum, PositionRecord pos) {
        this.stateNum = stateNum;
        this.pos = pos;
    }
  }
  
  //most of our states are used for bracketing
  //this gives us a way to nest bracketing states
  private java.util.Stack<StateRecord> stateStack = new java.util.Stack<StateRecord>();
  
  void saveStateAndTransition(int newState) {
    stateStack.push(new StateRecord(yystate(), pos));
    pos = new PositionRecord();
    yybegin(newState);
  }
  
  void restoreState() {
    StateRecord rec = stateStack.pop();
    yybegin(rec.stateNum);
    pos = rec.pos;
  }
  
  //// End-bracketing //////////////////////////////////////////////////////////
  
  //Number of end keywords expected before we leave the CLASS state
  //NB: NOT USED TO VERIFY STRUCTURE (that happens in the parser)
  int numEndsExpected = 0;
  
  //Increment the number of 'end's expected if we are in the CLASS state
  void maybeIncrNumEndsExpected() {
    if(yystate() == natlab_CLASS_STATE) { //HACK: mangled name
        numEndsExpected++;
    }
  }
  
  //// Transpose ///////////////////////////////////////////////////////////////
  
  //if any of these symbols is seen, then an immediately following single-quote
  //will be interpreted as MTRANSPOSE
  //if any other symbol is seen, then a single-quote will be interpreted as the
  //beginning of a string literal
  private static final java.util.Set<Short> TYPE_PRECEDING_TRANSPOSE = new java.util.HashSet<Short>();
  static {
    //NB: cannot contain DOT
    TYPE_PRECEDING_TRANSPOSE.add(IDENTIFIER);
    TYPE_PRECEDING_TRANSPOSE.add(INT_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(IM_INT_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(FP_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(IM_FP_NUMBER);
    TYPE_PRECEDING_TRANSPOSE.add(RPAREN);
    TYPE_PRECEDING_TRANSPOSE.add(RSQUARE);
    TYPE_PRECEDING_TRANSPOSE.add(RCURLY);
    TYPE_PRECEDING_TRANSPOSE.add(ARRAYTRANSPOSE);
    TYPE_PRECEDING_TRANSPOSE.add(MTRANSPOSE);
  }
  
  private boolean transposeNext = false;
  
  //// String literals /////////////////////////////////////////////////////////
  
  //for accumulating the contents of a string literal
  private StringBuffer strBuf = new StringBuffer();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public NaiveNatlabScanner(java.io.Reader in) {
    yybegin(natlab_CONSUME_LEADING_WHITESPACE_STATE); //HACK: mangled name
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public NaiveNatlabScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 154) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol nextToken() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 29: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 101: break;
        case 3: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 102: break;
        case 63: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_90();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 103: break;
        case 91: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_76();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 104: break;
        case 69: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 105: break;
        case 80: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_89();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 106: break;
        case 22: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 107: break;
        case 71: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_65();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 108: break;
        case 9: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 109: break;
        case 54: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 110: break;
        case 38: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_40();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 111: break;
        case 23: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_91();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 112: break;
        case 98: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_77();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 113: break;
        case 70: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 114: break;
        case 57: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_39();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 115: break;
        case 89: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_66();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 116: break;
        case 51: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 117: break;
        case 13: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 118: break;
        case 8: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_92();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 119: break;
        case 61: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_41();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 120: break;
        case 99: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_78();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 121: break;
        case 50: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 122: break;
        case 40: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 123: break;
        case 87: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_67();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 124: break;
        case 52: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 125: break;
        case 17: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_80();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 126: break;
        case 53: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 127: break;
        case 19: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_93();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 128: break;
        case 59: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_42();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 129: break;
        case 90: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_79();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 130: break;
        case 4: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 131: break;
        case 94: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 132: break;
        case 2: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_100();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 133: break;
        case 75: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_68();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 134: break;
        case 55: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 135: break;
        case 46: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_81();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 136: break;
        case 34: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 137: break;
        case 12: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 138: break;
        case 5: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_94();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 139: break;
        case 65: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_43();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 140: break;
        case 84: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_70();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 141: break;
        case 7: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 142: break;
        case 76: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 143: break;
        case 86: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_69();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 144: break;
        case 25: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 145: break;
        case 81: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_82();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 146: break;
        case 35: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 147: break;
        case 16: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_95();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 148: break;
        case 67: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_44();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 149: break;
        case 85: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_71();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 150: break;
        case 30: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 151: break;
        case 97: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 152: break;
        case 6: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_102();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 153: break;
        case 27: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 154: break;
        case 79: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_83();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 155: break;
        case 36: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 156: break;
        case 45: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_96();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 157: break;
        case 39: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_45();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 158: break;
        case 95: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 159: break;
        case 31: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 160: break;
        case 78: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 161: break;
        case 18: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_84();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 162: break;
        case 21: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 163: break;
        case 93: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_60();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 164: break;
        case 47: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_97();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 165: break;
        case 41: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_46();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 166: break;
        case 49: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 167: break;
        case 24: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 168: break;
        case 100: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_59();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 169: break;
        case 14: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_104();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 170: break;
        case 56: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_85();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 171: break;
        case 26: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 172: break;
        case 92: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_61();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 173: break;
        case 11: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 174: break;
        case 66: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_47();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 175: break;
        case 48: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 176: break;
        case 28: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 177: break;
        case 83: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_73();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 178: break;
        case 73: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_86();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 179: break;
        case 58: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 180: break;
        case 82: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_62();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 181: break;
        case 10: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 182: break;
        case 68: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_48();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 183: break;
        case 20: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 184: break;
        case 32: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 185: break;
        case 88: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_74();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 186: break;
        case 1: 
          { yybegin(state_natlab.getPrevState());
        return state_natlab.getExtraReturn();
          }
        case 187: break;
        case 44: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_50();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 188: break;
        case 62: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_87();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 189: break;
        case 37: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 190: break;
        case 77: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_63();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 191: break;
        case 74: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 192: break;
        case 43: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_49();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 193: break;
        case 15: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 194: break;
        case 33: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 195: break;
        case 42: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_51();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 196: break;
        case 72: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_88();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 197: break;
        case 60: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 198: break;
        case 96: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_64();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 199: break;
        case 64: 
          { Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
          }
        case 200: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case natlab_INSIDE_STRING_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_98();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 236: break;
            case natlab_HELP_COMMENT_NESTING_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_99();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 237: break;
            case natlab_SEMICOLON_TERMINATOR_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_103();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 238: break;
            case EXTRA_RETURN: {
              yybegin(state_natlab.getPrevState());
        return state_natlab.getExtraReturn();
            }
            case 239: break;
            case natlab_FIELD_NAME_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_105();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 240: break;
            case natlab_COMMENT_NESTING_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_99();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 241: break;
            case natlab_YYINITIAL_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_105();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 242: break;
            case natlab_CONSUME_LEADING_WHITESPACE_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_105();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 243: break;
            case natlab_COMMA_TERMINATOR_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_101();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 244: break;
            case natlab_CLASS_STATE: {
              Maybe<? extends Symbol> maybeResult = state_natlab.inst_natlab.natlab_action_105();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
            }
            case 245: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
