package test.jflex.annotations;
import test.jflex.annotations.AnnotationParser.Terminals;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/natlab/annotations.mll [7, 1]
%class AnnotationScanner
//from test/backend-jflex/in/natlab/annotations.mll [8, 1]
%function nextToken
//from test/backend-jflex/in/natlab/helper_beaver.mll [9, 1]
%public
//from test/backend-jflex/in/natlab/helper_beaver.mll [10, 1]
%final
//from test/backend-jflex/in/natlab/helper_beaver.mll [13, 1]
%extends Scanner
//from test/backend-jflex/in/natlab/helper_beaver.mll [14, 1]
%unicode
//from test/backend-jflex/in/natlab/helper_beaver.mll [17, 1]
%line
//from test/backend-jflex/in/natlab/helper_beaver.mll [18, 1]
%column
//from test/backend-jflex/in/natlab/helper_beaver.mll [20, 1]
%type Symbol
//from null [22, 1]
%yylexthrow Scanner.Exception

%{
    private final StateClass_annotations state_annotations = new StateClass_annotations();
%}

%{
    private class StateClass_annotations {
        private StateClass_annotations() {
            
            //from test/backend-jflex/in/natlab/annotations.mll [11, 8]
            yybegin(annotations_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(null, inst_annotations, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            
            restartAppendBuf();
            
            //NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.
            sendMTok(/*BOF*/ 0);
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[0];
        private final CompClass_annotations inst_annotations = new CompClass_annotations();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private final MetaLexerClass_annotations metalexer_annotations = new MetaLexerClass_annotations();
        private MetaLexerClass_annotations.Transition sendMTok(int mtok) {
            return metalexer_annotations.processSymbol(mtok);
        }
        
        public void processMTok(int mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                return; //don't send symbol if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MetaLexerClass_annotations.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                next = null;
                if(endOfEmbedding) {
                    int regionSym = currComp.getSymbolValue();
                    if(getCurrFilter().test(regionSym)) {
                        next = sendMTok(regionSym);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract int getSymbolValue();
    }
%}

%{
    //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
    private class CompClass_annotations extends ComponentInnerClass {
        
        public CompClass_annotations() {
        }
        
        private static final int YYINITIAL = annotations_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 1;
        }
        
        public Maybe<? extends Symbol> annotations_action_1() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [15, 5]
                return Maybe.Just(symbol(Terminals.DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_2() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [17, 5]
                return Maybe.Just(symbol(Terminals.STMT_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_3() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [18, 5]
                return Maybe.Just(symbol(Terminals.ELEMENT_SEPARATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_4() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [20, 5]
                return Maybe.Just(symbol(Terminals.SIZE_OF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_5() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [21, 5]
                return Maybe.Just(symbol(Terminals.EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_6() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [22, 5]
                return Maybe.Just(symbol(Terminals.HAS_TYPE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_7() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [24, 4]
                return Maybe.Just(symbol(Terminals.LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_8() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [25, 4]
                return Maybe.Just(symbol(Terminals.RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_9() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [26, 4]
                return Maybe.Just(symbol(Terminals.LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_10() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [27, 4]
                return Maybe.Just(symbol(Terminals.RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_11() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [28, 4]
                return Maybe.Just(symbol(Terminals.LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_12() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [29, 4]
                return Maybe.Just(symbol(Terminals.RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_13() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [31, 5]
                return Maybe.Just(symbol(Terminals.VARARG_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_14() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [32, 5]
                return Maybe.Just(symbol(Terminals.HANDLE_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_15() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [33, 5]
                return Maybe.Just(symbol(Terminals.TYPE_VAR_MODIFIER));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_16() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [35, 6]
                return Maybe.Just(symbol(Terminals.ARROW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_17() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [36, 5]
                return Maybe.Just(symbol(Terminals.UNKNOWN_TYPE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_18() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [38, 5]
                return Maybe.Just(symbol(Terminals.UNION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_19() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [39, 5]
                return Maybe.Just(symbol(Terminals.INTERSECT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_20() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [41, 5]
                return Maybe.Just(symbol(Terminals.IS_SCALAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_21() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [42, 5]
                return Maybe.Just(symbol(Terminals.IS_NOT_SCALAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_22() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [46, 14]
                /* skip */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_23() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [47, 11]
                /* skip */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_24() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [49, 10]
                return Maybe.Just(symbol(Terminals.NUMBER, Integer.parseInt(yytext())));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_25() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [51, 14]
                return Maybe.Just(symbol(Terminals.IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_26() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [55, 9]
                error("Illegal character '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> annotations_action_27() throws Scanner.Exception {
            //System.err.println("state_annotations.inst_annotations.annotations_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/annotations.mlc [56, 9]
                return Maybe.Just(symbol(Terminals.EOF));
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    public static class MetaLexerClass_annotations {
        
        //// Symbols ////
        // <BOF>
        // %annotations%
        
        private static final Integer[][] trans_BASE = new Integer[][] {
            {0,0,},
        };
        private static final Integer[] act_BASE = new Integer[] {null,};
        
        private static final Integer[][][] transitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] actionTables = new Integer[][] {
        };
        
        
        private static final Integer[][][] reverseTransitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] reverseActionTables = new Integer[][] {
        };
        
        private static final int[] actionMap = new int[] {};
        
        private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
        
        private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();
        private int currentState = 0;
        private Integer[][] currentTransitionTable = trans_BASE;
        private Integer[] currentActionTable = act_BASE;
        
        public MetaLexerClass_annotations() {
            //Transition through states reachable by pure BOF patterns
        }
        
        public Transition processSymbol(int sym) {
            currentMatch.add(sym);
            currentState = currentTransitionTable[currentState][sym];
            Integer mpatNum = currentActionTable[currentState];
            if(mpatNum == null) {
                return null;
            }
            int action = actionMap[mpatNum];
            Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));
            switchDFAs(action);
            return transition;
        }
        
        private void switchDFAs(int action) {
            currentState = 0;
            currentMatch.clear();
            
            int nextEmbedding;
            if(action < 0) {
                stateStack.pop();
                nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();
            } else {
                stateStack.push(action);
                nextEmbedding = action;
            }
            
            if(nextEmbedding < 0) {
                currentTransitionTable = trans_BASE;
                currentActionTable = act_BASE;
            } else {
                currentTransitionTable = transitionTables[nextEmbedding];
                currentActionTable = actionTables[nextEmbedding];
            }
        }
        
        private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {
            if(mpatNum >= reverseTransitionTables.length) {
                //don't need to clean end pattern matches - they aren't looked at
                return new java.util.ArrayList<Integer>(rawMatch);
            }
            
            java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();
            Integer[][] transitions = reverseTransitionTables[mpatNum];
            Integer[] actions = reverseActionTables[mpatNum];
            int dfaState = 0;
            for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {
                int sym = rawMatch.get(i);
                cleanMatch.add(sym);
                dfaState = transitions[dfaState][sym];
            }
            java.util.Collections.reverse(cleanMatch);
            return cleanMatch;
        }
        
        public static class Transition {
            private final int embeddingNum;
            private final java.util.List<Integer> match;
            
            public Transition(int embeddingNum, java.util.List<Integer> match) {
                this.embeddingNum = embeddingNum;
                this.match = new java.util.ArrayList<Integer>(match);
            }
            
            public int getEmbeddingNum() { return embeddingNum; }
            
            public java.util.List<Integer> getMatch() { return match; }
        }
        
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
        private final java.util.Set<Integer> allOpenSymbols;
        private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {
            this.pairMap = pairMap;
            this.allOpenSymbols = allOpenSymbols;
            this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();
        }
        
        public static class Builder {
            private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
            private final java.util.Set<Integer> allOpenSymbols;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();
                this.allOpenSymbols = new java.util.HashSet<Integer>();
            }
            
            public Builder add(int open, int close) {
                allOpenSymbols.add(open);
                java.util.Set<Integer> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Integer>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenSymbols);
            }
        }
        
        public boolean test(int sym) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Integer> correspondingOpens = pairMap.get(sym);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {
                    int open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenSymbols.contains(sym)) { //implies opening
                unclosedOpenSymbols.add(0, sym); //insert at beginning
            }
            return true;
        }
        
        public void clean(java.util.List<Integer> match) {
            java.util.Collections.reverse(match);
            for(int sym : match) {
                if(unclosedOpenSymbols.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenSymbols.get(0) == sym) {
                    unclosedOpenSymbols.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenSymbols.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isNothing() {
            return !isJust();
        }
        public abstract boolean isJust();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isJust() {
                return true;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isJust() {
                return false;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

//from null [10, 1]
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
//from null [9, 1]
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}


%xstate EXTRA_RETURN

//from test/backend-jflex/in/natlab/annotations.mlc [1, 1]
%state annotations_YYINITIAL_STATE

m_annotations_Whitespace = ([ \t\f\r\n])+ //from test/backend-jflex/in/natlab/annotations.mlc [3, 1]
m_annotations_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/annotations.mlc [5, 1]
m_annotations_Digit = [0-9] //from test/backend-jflex/in/natlab/annotations.mlc [6, 1]
m_annotations_Identifier = ([_$] | {m_annotations_Letter})((([_$] | {m_annotations_Letter}) | {m_annotations_Digit}))* //from test/backend-jflex/in/natlab/annotations.mlc [7, 1]
m_annotations_Number = (0 | [1-9]({m_annotations_Digit})*) //from test/backend-jflex/in/natlab/annotations.mlc [9, 1]
m_annotations_Comment = [/][/](.)* //from test/backend-jflex/in/natlab/annotations.mlc [11, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        yybegin(state_annotations.getPrevState());
        return state_annotations.getExtraReturn();
    }
    
    <<EOF>> {
        yybegin(state_annotations.getPrevState());
        return state_annotations.getExtraReturn();
    }
}

<annotations_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/annotations.mlc [15, 1]
    "." {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [17, 1]
    ";" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [18, 1]
    "," {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [20, 1]
    "#" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [21, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [22, 1]
    ":" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [24, 1]
    \( {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [25, 1]
    \) {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [26, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [27, 1]
    \} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [28, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [29, 1]
    \] {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [31, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [32, 1]
    "@" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [33, 1]
    "$" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [35, 1]
    "->" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [36, 1]
    "?" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [38, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [39, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [41, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [42, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<annotations_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/annotations.mlc [46, 1]
    {m_annotations_Whitespace} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [47, 1]
    {m_annotations_Comment} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [49, 1]
    {m_annotations_Number} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [51, 1]
    {m_annotations_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<annotations_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/annotations.mlc [55, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/annotations.mlc [56, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_annotations.inst_annotations.annotations_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


