package machine;

import java.util.BitSet;

public class Test {
    public static void main(String[] args) {
        test2();
    }

    private static void test1() {
        BitSet[][] transitions = new BitSet[13][4];
        for(int i = 0; i < 13; i++) {
            for(int j = 0; j < 4; j++) {
                transitions[i][j] = new BitSet(13);
            }
        }
        transitions[0][0].set(0);
        transitions[0][1].set(0);
        transitions[0][2].set(0);
        transitions[0][3].set(0);
        
        transitions[1][0].set(2);
        transitions[2][1].set(3);
        transitions[3][1].set(4);
        transitions[4][2].set(5);
        transitions[5][3].set(6);
        
        transitions[7][1].set(8);
        transitions[8][1].set(9);
        
        transitions[10][1].set(11);
        transitions[11][2].set(12);
        
        BitSet[] epsilons = new BitSet[13];
        for(int i = 0; i < 13; i++) {
            epsilons[i] = new BitSet(13);
        }
        epsilons[0].set(1);
        epsilons[0].set(7);
        epsilons[0].set(10);

        Integer[] actions = new Integer[13];
        actions[6] = 1;
        actions[9] = 2;
        actions[12] = 3;
        
        ENFA enfa = new ENFA(transitions, epsilons, actions);
        enfa.dump();
        
        NFA nfa = enfa.convertToNFA();
        nfa.dump();
        
        DFA dfa = nfa.convertToDFA();
        dfa.dump();
        
        DFA min = dfa.minimize();
        min.dump();
    }
    
    private static void test2() {
        BitSet[][] transitions = new BitSet[3][4];
        for(int i = 0; i < 3; i++) {
            for(int j = 0; j < 4; j++) {
                transitions[i][j] = new BitSet(3);
            }
        }
        transitions[0][0].set(0);
        transitions[0][1].set(0);
        transitions[0][2].set(0);
        transitions[0][3].set(0);
        
        transitions[1][0].set(2);
        
        BitSet[] epsilons = new BitSet[13];
        for(int i = 0; i < 13; i++) {
            epsilons[i] = new BitSet(13);
        }
        epsilons[0].set(1);

        Integer[] actions = new Integer[3];
        actions[2] = 1;
        
        ENFA enfa = new ENFA(transitions, epsilons, actions);
        enfa.dump();
        
        NFA nfa = enfa.convertToNFA();
        nfa.dump();
        
        DFA dfa = nfa.convertToDFA();
        dfa.dump();
        
        DFA min = dfa.minimize();
        min.dump();
    }

}
