package pi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
%%
%public
%final
%unicode
%class MLNBadPiScanner_Meta
%function start
%type Object

%{
    java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
    
    void saveStateAndTransition(int newState) {
        stateStack.push(yystate());
        yybegin(newState);
    }
    
    void restoreState() {
        yybegin(stateStack.pop());
    }
%}

%{
    private Transition transition = null;
    
    private void notifyLexer(int embeddingNum) {
        this.transition = new Transition(embeddingNum, yytext());
    }
    
    public Transition checkForTransition() {
        Transition tmp = transition;
        transition = null;
        return tmp;
    }
%}

%{
    public static class Transition {
        private final int embeddingNum;
        private final String match;
        
        public Transition(int embeddingNum, String match) {
            this.embeddingNum = embeddingNum;
            this.match = match;
        }
        
        public int getEmbeddingNum() { return embeddingNum; }
        
        public String getMatch() { return match; }
    }
%}

%init{
    //Start in state BASE
    yybegin(BASE);
    
    //Transition through states reachable by pure BOF patterns
%init}

%state BASE
//from ./mln_bad.mll [27, 1]
%state e_embed

//Meta-tokens
t_END = \u0034 //from ./mln_bad.mll [32, 6]
t_START = \u0031 //from ./mln_bad.mll [31, 8]

//Regions

%%

//// START PATTERNS ////////////////////////////////////////////////////////////

//no embeddings completed (i.e. now in start component 'ml_bad1')
<BASE> {
    //start patterns from embeddings with host 'ml_bad1'
    
    //from ./mln_bad.mll [27, 1]
    //start pattern for embedding 'embed'
    {t_START} { saveStateAndTransition(e_embed); notifyLexer(/*embed*/ 0); }
}

//// END PATTERNS //////////////////////////////////////////////////////////////

<e_embed> {
    //from ./mln_bad.mll [27, 1]
    //end pattern for embedding 'embed'
    {t_END} { restoreState(); notifyLexer(/*restore previous*/ -1); }
}

//// SHARED CLEAN-UP PATTERNS //////////////////////////////////////////////////

(.|\n) { /*consume and ignore*/ }
<<EOF>> { return null; } //break out of infinite loop

