package pi;

%%
//// This file was generated by MetaLexer ////

//from ./mln_good.mll [12, 1]
%public
//from ./mln_good.mll [13, 1]
%final
//from ./mln_good.mll [14, 1]
%class MLNGoodPiScanner
//from ./mln_good.mll [15, 1]
%implements PiScanner
//from ./mln_good.mll [16, 1]
%unicode
//from ./mln_good.mll [17, 1]
%function getFreqs
//from ./mln_good.mll [18, 1]
%type int[]

%{
    private final StateClass_mln_good state_mln_good = new StateClass_mln_good();
%}

%{
    private class StateClass_mln_good {
        private StateClass_mln_good() {
            
            //from ./mln_good.mll [8, 8]
            yybegin(ml_good_YYINITIAL_STATE);
            
            embeddingStack.add(new EmbeddingRecord(null, inst_ml_good, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            
            restartAppendBuf();
            
            //NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.
            sendMTok(/*BOF*/ 0);
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[0];
        private final CompClass_ml_good inst_ml_good = new CompClass_ml_good();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private int[] extraReturn = null;
        private int prevState = -1;
        
        public int[] getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(int[] value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private final MetaLexerClass_mln_good metalexer_mln_good = new MetaLexerClass_mln_good();
        private MetaLexerClass_mln_good.Transition sendMTok(int mtok) {
            return metalexer_mln_good.processSymbol(mtok);
        }
        
        public void processMTok(int mtok) {
            if(!getCurrFilter().test(mtok)) {
                return; //don't send symbol if it gets filtered out
            }
            Maybe<? extends int[]> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MetaLexerClass_mln_good.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                next = null;
                if(endOfEmbedding) {
                    int regionSym = currComp.getSymbolValue();
                    if(getCurrFilter().test(regionSym)) {
                        next = sendMTok(regionSym);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public Maybe<? extends int[]> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract int getSymbolValue();
    }
%}

%{
    //from ./ml_good.mlc [1, 1]
    private class CompClass_ml_good extends ComponentInnerClass {
        
        public CompClass_ml_good() {
        }
        
        private static final int YYINITIAL = ml_good_YYINITIAL_STATE; //from ./ml_good.mlc [1, 1]
        
        
        public int getStartState() {
            //from ./ml_good.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 1;
        }
        
        public Maybe<? extends int[]> ml_good_action_1() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_1()");
            if(Object.class != null) {
                //from ./ml_good.mlc [5, 3]
                freq[0]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_2() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_2()");
            if(Object.class != null) {
                //from ./ml_good.mlc [6, 3]
                freq[1]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_3() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_3()");
            if(Object.class != null) {
                //from ./ml_good.mlc [7, 3]
                freq[2]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_4() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_4()");
            if(Object.class != null) {
                //from ./ml_good.mlc [8, 3]
                freq[3]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_5() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_5()");
            if(Object.class != null) {
                //from ./ml_good.mlc [9, 3]
                freq[4]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_6() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_6()");
            if(Object.class != null) {
                //from ./ml_good.mlc [10, 3]
                freq[5]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_7() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_7()");
            if(Object.class != null) {
                //from ./ml_good.mlc [11, 3]
                freq[6]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_8() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_8()");
            if(Object.class != null) {
                //from ./ml_good.mlc [12, 3]
                freq[7]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_9() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_9()");
            if(Object.class != null) {
                //from ./ml_good.mlc [13, 3]
                freq[8]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_10() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_10()");
            if(Object.class != null) {
                //from ./ml_good.mlc [14, 3]
                freq[9]++;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_11() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_11()");
            return Maybe.Nothing();
        }
        public Maybe<? extends int[]> ml_good_action_12() {
            //System.err.println("state_mln_good.inst_ml_good.ml_good_action_12()");
            if(Object.class != null) {
                //from ./ml_good.mlc [20, 9]
                return Maybe.Just(freq);
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    public static class MetaLexerClass_mln_good {
        
        //// Symbols ////
        // <BOF>
        // %ml_good%
        
        private static final Integer[][] trans_BASE = new Integer[][] {
            {0,0,},
        };
        private static final Integer[] act_BASE = new Integer[] {null,};
        
        private static final Integer[][][] transitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] actionTables = new Integer[][] {
        };
        
        
        private static final Integer[][][] reverseTransitionTables = new Integer[][][] {
        };
        
        private static final Integer[][] reverseActionTables = new Integer[][] {
        };
        
        private static final int[] actionMap = new int[] {};
        
        private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
        
        private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();
        private int currentState = 0;
        private Integer[][] currentTransitionTable = trans_BASE;
        private Integer[] currentActionTable = act_BASE;
        
        public MetaLexerClass_mln_good() {
            //Transition through states reachable by pure BOF patterns
        }
        
        public Transition processSymbol(int sym) {
            System.err.println("Processing symbol " + sym);
            currentMatch.add(sym);
            currentState = currentTransitionTable[currentState][sym];
            Integer mpatNum = currentActionTable[currentState];
            if(mpatNum == null) {
                return null;
            }
            int action = actionMap[mpatNum];
            Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));
            switchDFAs(action);
            return transition;
        }
        
        private void switchDFAs(int action) {
            currentState = 0;
            currentMatch.clear();
            
            int nextEmbedding;
            if(action < 0) {
                stateStack.pop();
                nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();
            } else {
                stateStack.push(action);
                nextEmbedding = action;
            }
            
            System.err.println("Switching to DFA " + nextEmbedding);
            if(nextEmbedding < 0) {
                currentTransitionTable = trans_BASE;
                currentActionTable = act_BASE;
            } else {
                currentTransitionTable = transitionTables[nextEmbedding];
                currentActionTable = actionTables[nextEmbedding];
            }
        }
        
        private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {
            if(mpatNum >= reverseTransitionTables.length) {
                //don't need to clean end pattern matches - they aren't looked at
                return new java.util.ArrayList<Integer>(rawMatch);
            }
            
            java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();
            Integer[][] transitions = reverseTransitionTables[mpatNum];
            Integer[] actions = reverseActionTables[mpatNum];
            int dfaState = 0;
            for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {
                int sym = rawMatch.get(i);
                cleanMatch.add(sym);
                dfaState = transitions[dfaState][sym];
            }
            java.util.Collections.reverse(cleanMatch);
            return cleanMatch;
        }
        
        public static class Transition {
            private final int embeddingNum;
            private final java.util.List<Integer> match;
            
            public Transition(int embeddingNum, java.util.List<Integer> match) {
                this.embeddingNum = embeddingNum;
                this.match = new java.util.ArrayList<Integer>(match);
            }
            
            public int getEmbeddingNum() { return embeddingNum; }
            
            public java.util.List<Integer> getMatch() { return match; }
        }
        
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
        private final java.util.Set<Integer> allOpenSymbols;
        private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {
            this.pairMap = pairMap;
            this.allOpenSymbols = allOpenSymbols;
            this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();
        }
        
        public static class Builder {
            private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
            private final java.util.Set<Integer> allOpenSymbols;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();
                this.allOpenSymbols = new java.util.HashSet<Integer>();
            }
            
            public Builder add(int open, int close) {
                allOpenSymbols.add(open);
                java.util.Set<Integer> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Integer>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenSymbols);
            }
        }
        
        public boolean test(int sym) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Integer> correspondingOpens = pairMap.get(sym);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {
                    int open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenSymbols.contains(sym)) { //implies opening
                unclosedOpenSymbols.add(0, sym); //insert at beginning
            }
            return true;
        }
        
        public void clean(java.util.List<Integer> match) {
            java.util.Collections.reverse(match);
            for(int sym : match) {
                if(unclosedOpenSymbols.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenSymbols.get(0) == sym) {
                    unclosedOpenSymbols.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenSymbols.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isNothing() {
            return !isJust();
        }
        public abstract boolean isJust();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isJust() {
                return true;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isJust() {
                return false;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

//from null [20, 1]
%{
    private final int[] freq = new int[10];
%}
//from null [24, 1]
%{
    public void stop() {}
%}


%xstate EXTRA_RETURN

//from ./ml_good.mlc [1, 1]
%state ml_good_YYINITIAL_STATE


%%

<EXTRA_RETURN> {
    (. | \n) {
        yybegin(state_mln_good.getPrevState());
        return state_mln_good.getExtraReturn();
    }
    
    <<EOF>> {
        yybegin(state_mln_good.getPrevState());
        return state_mln_good.getExtraReturn();
    }
}

<ml_good_YYINITIAL_STATE> {
    //from ./ml_good.mlc [5, 1]
    0 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [6, 1]
    1 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [7, 1]
    2 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [8, 1]
    3 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [9, 1]
    4 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [10, 1]
    5 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [11, 1]
    6 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [12, 1]
    7 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [13, 1]
    8 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [14, 1]
    9 {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<ml_good_YYINITIAL_STATE> {
    //from ./ml_good.mlc [19, 1]
    (. | \n) {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from ./ml_good.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends int[]> maybeResult = state_mln_good.inst_ml_good.ml_good_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


