//TODO-AC: combine with ReturnWrap?

package metalexer.jflex;

import java.io.IOException;
import java.io.StringReader;

%%

//general header info
%public
%final
%class PackageFind

%unicode
%function findPackage
%type String

%{
    private StringBuffer packageBuf = new StringBuffer();
%}

%{
    public static String findPackage(String header) {
        StringReader reader = new StringReader(header);
        PackageFind scanner = new PackageFind(reader);
        String result = null;
        try {
            result = scanner.findPackage();
            reader.close();
        } catch(IOException e) {
            //can't happen since StringReader
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return (result.length() > 0) ? result : null;
    }
%}

%{
    private int depth = 0;
    private boolean lookingForSemi = false;
%}

Any = . | \n

StartSLC = "//"
EndSLC = \r | \n | \r\n

StartMLC = "/*"
EndMLC = "*/"

StartString = \"
EndString = \"

WhiteSpace = [ \n\r\t\f]

%xstate SINGLE_LINE_COMMENT
%xstate MULTI_LINE_COMMENT
%xstate STRING

%%

{StartSLC} { yybegin(SINGLE_LINE_COMMENT); }

//NB: don't check for return stmts in comments
<SINGLE_LINE_COMMENT> {
    {EndSLC} { yybegin(YYINITIAL); }
    {Any} { }
    <<EOF>> { return packageBuf.toString(); }
}

{StartMLC} { yybegin(MULTI_LINE_COMMENT); depth++; }

//NB: don't check for return stmts in comments
<MULTI_LINE_COMMENT> {
    {StartMLC} { depth++; }
    {EndMLC} { depth--; if(depth == 0) { yybegin(YYINITIAL); } }
    {Any} { }
    <<EOF>> { return packageBuf.toString(); }
}

{StartString} { yybegin(STRING); }

//NB: don't check for return stmts in strings
<STRING> {
    \\\" { }
    {EndString} { yybegin(YYINITIAL); }
    {Any} { }
    <<EOF>> { return packageBuf.toString(); }
}

"package" {WhiteSpace} { packageBuf = new StringBuffer(); lookingForSemi = true; }
"package" / ({StartSLC} | {StartMLC}) { packageBuf = new StringBuffer(); lookingForSemi = true; }

";" { lookingForSemi = false; }

{WhiteSpace} { /* skip */ }

{Any} {
    if(lookingForSemi) {
        packageBuf.append(yytext());
    }
}

<<EOF>> { return packageBuf.toString(); }
