package metalexer.jflex;

import java.io.IOException;
import java.io.StringReader;

%%

//general header info
%public
%final
%class StringEscape

%unicode
%function process
%type String

%{
    private StringBuffer buf = new StringBuffer();
%}

%{
    //replace escape sequences and non-printing characters with the corresponding JFlex escape sequences
    public static String escapeString(String original) {
        StringReader reader = new StringReader(original);
        StringEscape scanner = new StringEscape(reader);
        String result = null;
        try {
            result = scanner.process();
            reader.close();
        } catch(IOException e) {
            //can't happen since StringReader
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }
%}

HexDigit = [0-9A-Fa-f]

%%

//hex codes have to be fixed length in JFlex strings
\\u{HexDigit}{1} { buf.append("\\u" + "000" + yytext().substring(2)); }
\\u{HexDigit}{2} { buf.append("\\u" + "00" + yytext().substring(2)); }
\\u{HexDigit}{3} { buf.append("\\u" + "0" + yytext().substring(2)); }
\\u{HexDigit}{4} { buf.append(yytext()); }

//nothing to do for "\\x" escapes
\\x{HexDigit}{2} { buf.append(yytext()); }

//octal codes have to bed fixed length in JFlex strings
\\[0-7] { buf.append("\\" + "00" + yytext().substring(1)); }
\\[0-7][0-7] { buf.append("\\" + "0" + yytext().substring(1)); }
\\[0-3][0-7][0-7] { buf.append(yytext()); }

//line ending characters should be escaped in JFlex strings
\\? \n { buf.append("\\n"); }
\\? \r { buf.append("\\r"); }

//nothing to do for other escapes
\\? (. | \n) { buf.append(yytext()); }

<<EOF>> { return buf.toString(); }