//based on http://jflex.de/manual.html

package test.jflex.metalexer;
import static test.jflex.metalexer.LayoutParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/metalexer/layout.mll [13, 1]
%public
//from test/backend-jflex/in/metalexer/layout.mll [14, 1]
%final
//from test/backend-jflex/in/metalexer/layout.mll [15, 1]
%class LayoutScanner
//from test/backend-jflex/in/metalexer/layout.mll [18, 1]
%extends Scanner
//from test/backend-jflex/in/metalexer/layout.mll [19, 1]
%unicode
//from test/backend-jflex/in/metalexer/layout.mll [20, 1]
%function nextToken
//from test/backend-jflex/in/metalexer/layout.mll [21, 1]
%type Symbol
//from test/backend-jflex/in/metalexer/layout.mll [24, 1]
%line
//from test/backend-jflex/in/metalexer/layout.mll [25, 1]
%column
//from null [27, 1]
%yylexthrow Scanner.Exception

//from null [32, 1]
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
//from null [65, 1]
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}


%{
    private final StateClass_layout state_layout = new StateClass_layout();
%}

%{
    private class StateClass_layout {
        private StateClass_layout() {
            //from test/backend-jflex/in/metalexer/layout.mll [101, 1]
            embeddingRecordArray[0] = new EmbeddingRecord("local_header_section", inst_local_header, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [110, 1]
            embeddingRecordArray[1] = new EmbeddingRecord("inherited_header_section", inst_inherited_header, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [119, 1]
            embeddingRecordArray[2] = new EmbeddingRecord("option_section", inst_layout_option_section, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [126, 1]
            embeddingRecordArray[3] = new EmbeddingRecord("option_decl", inst_decl_region, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [133, 1]
            embeddingRecordArray[4] = new EmbeddingRecord("option_init", inst_init_region, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [140, 1]
            embeddingRecordArray[5] = new EmbeddingRecord("option_string_directive", inst_string_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [149, 1]
            embeddingRecordArray[6] = new EmbeddingRecord("rule_section", inst_layout_rule_section, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [156, 1]
            embeddingRecordArray[7] = new EmbeddingRecord("metapattern_directive", inst_metapattern_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [163, 1]
            embeddingRecordArray[8] = new EmbeddingRecord("pair_directive", inst_pair_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [172, 1]
            embeddingRecordArray[9] = new EmbeddingRecord("comments", inst_bracket_comment, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [181, 1]
            embeddingRecordArray[10] = new EmbeddingRecord("identifier_directive", inst_identifier_directive, PairFilter.EMPTY);
            //from test/backend-jflex/in/metalexer/layout.mll [190, 1]
            embeddingRecordArray[11] = new EmbeddingRecord("string", inst_string, PairFilter.EMPTY);
            
            //from test/backend-jflex/in/metalexer/layout.mll [95, 8]
            yybegin(base_YYINITIAL_STATE);
            
            embeddingStack.push(new EmbeddingRecord(null, inst_base, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            startEmbedding(/*local_header_section*/ 0); 
            
            restartAppendBuf();
            restartDelimBuf(false);
            
            //NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.
            sendMTok(/*BOF*/ 0);
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[12];
        private final CompClass_base inst_base = new CompClass_base();
        private final CompClass_bracket_comment inst_bracket_comment = new CompClass_bracket_comment();
        private final CompClass_decl_region inst_decl_region = new CompClass_decl_region();
        private final CompClass_identifier_directive inst_identifier_directive = new CompClass_identifier_directive();
        private final CompClass_inherited_header inst_inherited_header = new CompClass_inherited_header();
        private final CompClass_init_region inst_init_region = new CompClass_init_region();
        private final CompClass_layout_option_section inst_layout_option_section = new CompClass_layout_option_section();
        private final CompClass_layout_rule_section inst_layout_rule_section = new CompClass_layout_rule_section();
        private final CompClass_local_header inst_local_header = new CompClass_local_header();
        private final CompClass_metapattern_directive inst_metapattern_directive = new CompClass_metapattern_directive();
        private final CompClass_pair_directive inst_pair_directive = new CompClass_pair_directive();
        private final CompClass_string inst_string = new CompClass_string();
        private final CompClass_string_directive inst_string_directive = new CompClass_string_directive();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int delimStartLine = -1;
        private int delimStartCol = -1;
        private StringBuffer delimBuf = null;
        
        private void restartDelimBuf(boolean copyToAppendBuf) {
            if(copyToAppendBuf && delimBuf.length() > 0) {
                startLine = delimStartLine;
                startCol = delimStartCol;
                appendBuf.append(delimBuf);
            }
            delimStartLine = -1;
            delimStartCol = -1;
            delimBuf = new StringBuffer();
        }
        private <T> void appendToStartDelim(T t) {
            if(delimStartLine < 0) {
                delimStartLine = yyline + 1;
                delimStartCol = yycolumn + 1;
            }
            delimBuf.append(t);
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private final MetaLexerClass_layout metalexer_layout = new MetaLexerClass_layout();
        private MetaLexerClass_layout.Transition sendMTok(int mtok) {
            return metalexer_layout.processSymbol(mtok);
        }
        
        public void processMTok(int mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                return; //don't send symbol if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MetaLexerClass_layout.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                restartDelimBuf(nextComp.expectsStartDelim());
                
                next = null;
                if(endOfEmbedding) {
                    int regionSym = currComp.getSymbolValue();
                    if(getCurrFilter().test(regionSym)) {
                        next = sendMTok(regionSym);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public boolean expectsStartDelim() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract int getSymbolValue();
    }
%}

%{
    //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
    private class CompClass_base extends ComponentInnerClass {
        
        public CompClass_base() {
        }
        
        private static final int YYINITIAL = base_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/base.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 1;
        }
        
        public Maybe<? extends Symbol> base_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_base.base_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/base.mlc [9, 9]
                error("Unexpected character: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_base.base_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/base.mlc [10, 9]
                return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
    private class CompClass_bracket_comment extends ComponentInnerClass {
        
        public CompClass_bracket_comment() {
        }
        
        private static final int YYINITIAL = bracket_comment_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 2;
        }
        
        public Maybe<? extends Symbol> bracket_comment_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [15, 22]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [16, 23]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [19, 9]
                //append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_bracket_comment.bracket_comment_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/bracket_comment.mlc [20, 9]
                error("Unterminated bracket comment");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
    private class CompClass_decl_region extends ComponentInnerClass {
        
        public CompClass_decl_region() {
        }
        
        private static final int YYINITIAL = decl_region_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(DECL_REGION, "%{" + text + "%}", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_layout.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 3;
        }
        
        public Maybe<? extends Symbol> decl_region_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [14, 20]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> decl_region_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_decl_region.decl_region_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/decl_region.mlc [19, 9]
                error("Unterminated declaration region");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
    private class CompClass_identifier_directive extends ComponentInnerClass {
        
        public CompClass_identifier_directive() {
        }
        
        private static final int YYINITIAL = identifier_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 4;
        }
        
        public Maybe<? extends Symbol> identifier_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_3()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [21, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [23, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [24, 23]
                return Maybe.Just(symbol(QUALIFIED_IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/identifier_directive.mlc [26, 9]
                error("Unexpected character in identifier list: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> identifier_directive_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_identifier_directive.identifier_directive_action_9()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
    private class CompClass_inherited_header extends ComponentInnerClass {
        
        public CompClass_inherited_header() {
        }
        
        private static final int YYINITIAL = inherited_header_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    if(text.startsWith("\r\n")) {
        text = text.substring(2);
    } else if(text.startsWith("\n") || text.startsWith("\r")) {
        text = text.substring(1);
    }
    return Maybe.Just(symbol(INHERITED_HEADER, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_layout.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 5;
        }
        
        public Maybe<? extends Symbol> inherited_header_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_inherited_header.inherited_header_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> inherited_header_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_inherited_header.inherited_header_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/inherited_header.mlc [21, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> inherited_header_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_inherited_header.inherited_header_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/inherited_header.mlc [22, 9]
                error("Unterminated inherited header section.");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
    private class CompClass_init_region extends ComponentInnerClass {
        
        public CompClass_init_region() {
        }
        
        private static final int YYINITIAL = init_region_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public boolean expectsStartDelim() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    return Maybe.Just(symbol(INIT_REGION, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_layout.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 6;
        }
        
        public Maybe<? extends Symbol> init_region_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [13, 20]
                append(yytext().substring(1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [14, 19]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [17, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> init_region_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_init_region.init_region_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/init_region.mlc [18, 9]
                error("Unterminated init region");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
    private class CompClass_layout_option_section extends ComponentInnerClass {
        
        public CompClass_layout_option_section() {
        }
        
        private static final int YYINITIAL = layout_option_section_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 7;
        }
        
        public Maybe<? extends Symbol> layout_option_section_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [26, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [27, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [30, 18]
                appendToStartDelim(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [33, 34]
                return Maybe.Just(symbol(HELPER_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [36, 34]
                return Maybe.Just(symbol(LAYOUT_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [37, 33]
                return Maybe.Just(symbol(START_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [38, 37]
                return Maybe.Just(symbol(COMPONENT_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_10() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [41, 35]
                return Maybe.Just(symbol(DECLARE_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_11() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [42, 34]
                return Maybe.Just(symbol(OPTION_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_12() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [43, 37]
                return Maybe.Just(symbol(INITTHROW_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_13() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [44, 36]
                return Maybe.Just(symbol(LEXTHROW_DIRECTIVE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_14() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [47, 5]
                error("Invalid directive");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_15() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_15()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_16() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_17() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_option_section.mlc [56, 9]
                error("Unexpected character in option section: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_option_section_action_18() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_option_section.layout_option_section_action_18()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
    private class CompClass_layout_rule_section extends ComponentInnerClass {
        
        public CompClass_layout_rule_section() {
        }
        
        private static final int YYINITIAL = layout_rule_section_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 8;
        }
        
        public Maybe<? extends Symbol> layout_rule_section_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [21, 18]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [22, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [24, 34]
                return Maybe.Just(symbol(START_EMBED_GROUP));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [26, 35]
                return Maybe.Just(symbol(INHERIT_UNEMBED));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [27, 35]
                return Maybe.Just(symbol(INHERIT_REPLACE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [28, 36]
                return Maybe.Just(symbol(INHERIT_UNOPTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [30, 32]
                return Maybe.Just(symbol(EMBEDDING_NAME));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [31, 32]
                return Maybe.Just(symbol(EMBEDDING_HOST));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_10() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [32, 33]
                return Maybe.Just(symbol(EMBEDDING_GUEST));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_11() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [33, 32]
                return Maybe.Just(symbol(EMBEDDING_PAIR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_12() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [35, 33]
                return Maybe.Just(symbol(EMBEDDING_START));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_13() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [36, 31]
                return Maybe.Just(symbol(EMBEDDING_END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_14() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [38, 36]
                return Maybe.Just(symbol(START_INHERIT_GROUP));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_15() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [39, 34]
                return Maybe.Just(symbol(DELETION_DELETE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_16() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_17() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [44, 9]
                error("Unexpected character in rule section: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> layout_rule_section_action_18() throws Scanner.Exception {
            //System.err.println("state_layout.inst_layout_rule_section.layout_rule_section_action_18()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
    private class CompClass_local_header extends ComponentInnerClass {
        
        public CompClass_local_header() {
        }
        
        private static final int YYINITIAL = local_header_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    return Maybe.Just(symbol(LOCAL_HEADER, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_layout.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 9;
        }
        
        public Maybe<? extends Symbol> local_header_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_local_header.local_header_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> local_header_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_local_header.local_header_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/local_header.mlc [16, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> local_header_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_local_header.local_header_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/local_header.mlc [17, 9]
                error("Unterminated local header section.");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
    private class CompClass_metapattern_directive extends ComponentInnerClass {
        
        public CompClass_metapattern_directive() {
        }
        
        private static final int YYINITIAL = metapattern_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 10;
        }
        
        public Maybe<? extends Symbol> metapattern_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [20, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [22, 9]
                return Maybe.Just(symbol(MP_ANY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [23, 9]
                return Maybe.Just(symbol(MP_BOF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [24, 9]
                return Maybe.Just(symbol(MP_EOF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [26, 5]
                return Maybe.Just(symbol(MP_LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [27, 5]
                return Maybe.Just(symbol(MP_RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [28, 5]
                return Maybe.Just(symbol(MP_LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_10() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [29, 5]
                return Maybe.Just(symbol(MP_RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_11() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [30, 5]
                return Maybe.Just(symbol(MP_CARET));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_12() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [31, 5]
                return Maybe.Just(symbol(MP_STAR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_13() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [32, 5]
                return Maybe.Just(symbol(MP_PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_14() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [33, 5]
                return Maybe.Just(symbol(MP_OPT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_15() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [34, 5]
                return Maybe.Just(symbol(MP_OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_16() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_17() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [38, 20]
                return Maybe.Just(symbol(MP_REGION, yytext().substring(1, yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_18() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [39, 29]
                return Maybe.Just(symbol(MP_REGION, yytext().substring(1, yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_19() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [40, 14]
                return Maybe.Just(symbol(MP_SYM, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_20() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [44, 9]
                error("Unexpected character in meta-pattern: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> metapattern_directive_action_21() throws Scanner.Exception {
            //System.err.println("state_layout.inst_metapattern_directive.metapattern_directive_action_21()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [1, 1]
    private class CompClass_pair_directive extends ComponentInnerClass {
        
        public CompClass_pair_directive() {
        }
        
        private static final int YYINITIAL = pair_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/pair_directive.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/pair_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 11;
        }
        
        public Maybe<? extends Symbol> pair_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/pair_directive.mlc [20, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/pair_directive.mlc [22, 5]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/pair_directive.mlc [26, 20]
                return Maybe.Just(symbol(MP_REGION, yytext().substring(1, yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/pair_directive.mlc [27, 29]
                return Maybe.Just(symbol(MP_REGION, yytext().substring(1, yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/pair_directive.mlc [28, 14]
                return Maybe.Just(symbol(MP_SYM, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_9() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/pair_directive.mlc [32, 9]
                error("Unexpected character in pair item: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> pair_directive_action_10() throws Scanner.Exception {
            //System.err.println("state_layout.inst_pair_directive.pair_directive_action_10()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
    private class CompClass_string extends ComponentInnerClass {
        
        public CompClass_string() {
        }
        
        private static final int YYINITIAL = string_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(STRING, "\"" + text + "\"", startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_layout.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/string.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 12;
        }
        
        public Maybe<? extends Symbol> string_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [22, 9]
                /*just end string - %append will handle token*/
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [23, 18]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [24, 11]
                error("Invalid escape sequence: '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [25, 4]
                error("Incomplete escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [26, 18]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [29, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string.string_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string.mlc [30, 9]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
    private class CompClass_string_directive extends ComponentInnerClass {
        
        public CompClass_string_directive() {
        }
        
        private static final int YYINITIAL = string_directive_YYINITIAL_STATE; //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_layout.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 13;
        }
        
        public Maybe<? extends Symbol> string_directive_action_1() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_2() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_3() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_3()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_4() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_5() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string_directive.mlc [18, 3]
                return Maybe.Just(symbol(COMMA));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_6() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 11]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_7() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/metalexer/string_directive.mlc [21, 9]
                error("Unexpected character in string list: " + yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_directive_action_8() throws Scanner.Exception {
            //System.err.println("state_layout.inst_string_directive.string_directive_action_8()");
            return Maybe.Nothing();
        }
    }
%}

%{
    public static class MetaLexerClass_layout {
        
        //// Symbols ////
        // <BOF>
        // %base%
        // %bracket_comment%
        // %decl_region%
        // %identifier_directive%
        // %inherited_header%
        // %init_region%
        // %layout_option_section%
        // %layout_rule_section%
        // %local_header%
        // %metapattern_directive%
        // %pair_directive%
        // %string%
        // %string_directive%
        // START_BRACKET_COMMENT
        // END_BRACKET_COMMENT
        // END_DECL_REGION
        // END_IDENTIFIER_DIRECTIVE
        // END_INHERITED_HEADER
        // END_INIT_REGION
        // START_DECL_REGION
        // START_INIT_REGION
        // START_IDENTIFIER_DIRECTIVE
        // START_STRING_DIRECTIVE
        // END_OPTION_SECTION
        // START_PAIR_DIRECTIVE
        // START_METAPATTERN_DIRECTIVE
        // END_RULE_SECTION
        // END_LOCAL_HEADER
        // END_METAPATTERN_DIRECTIVE
        // END_PAIR_DIRECTIVE
        // END_STRING
        // END_STRING_DIRECTIVE
        // START_STRING
        
        private static final Integer[][] trans_BASE = new Integer[][] {
            {0,0,0,0,0,1,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_BASE = new Integer[] {null,1,2,0,};
        
        private static final Integer[][] trans_pair_directive = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,},
        };
        private static final Integer[] act_pair_directive = new Integer[] {null,19,};
        
        private static final Integer[][] trans_rule_section = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,3,4,5,0,0,0,0,0,0,},
        };
        private static final Integer[] act_rule_section = new Integer[] {null,5,6,4,3,17,};
        
        private static final Integer[][] trans_local_header_section = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,},
        };
        private static final Integer[] act_local_header_section = new Integer[] {null,11,};
        
        private static final Integer[][] trans_identifier_directive = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_identifier_directive = new Integer[] {null,5,21,};
        
        private static final Integer[][] trans_option_init = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_option_init = new Integer[] {null,15,};
        
        private static final Integer[][] trans_comments = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_comments = new Integer[] {null,5,20,};
        
        private static final Integer[][] trans_inherited_header_section = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_inherited_header_section = new Integer[] {null,12,};
        
        private static final Integer[][] trans_metapattern_directive = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,},
        };
        private static final Integer[] act_metapattern_directive = new Integer[] {null,5,18,};
        
        private static final Integer[][] trans_option_decl = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_option_decl = new Integer[] {null,14,};
        
        private static final Integer[][] trans_option_string_directive = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,},
        };
        private static final Integer[] act_option_string_directive = new Integer[] {null,5,16,10,};
        
        private static final Integer[][] trans_option_section = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,2,3,4,5,6,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_option_section = new Integer[] {null,5,7,8,6,9,13,};
        
        private static final Integer[][] trans_string = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,},
        };
        private static final Integer[] act_string = new Integer[] {null,22,};
        
        private static final Integer[][][] transitionTables = new Integer[][][] {
            trans_local_header_section,
            trans_inherited_header_section,
            trans_option_section,
            trans_option_decl,
            trans_option_init,
            trans_option_string_directive,
            trans_rule_section,
            trans_metapattern_directive,
            trans_pair_directive,
            trans_comments,
            trans_identifier_directive,
            trans_string,
        };
        
        private static final Integer[][] actionTables = new Integer[][] {
            act_local_header_section,
            act_inherited_header_section,
            act_option_section,
            act_option_decl,
            act_option_init,
            act_option_string_directive,
            act_rule_section,
            act_metapattern_directive,
            act_pair_directive,
            act_comments,
            act_identifier_directive,
            act_string,
        };
        
        private static final Integer[][] rev_trans_inherited_header_section = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_inherited_header_section = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_option_section = new Integer[][] {
            {1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_section = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_option_decl = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_decl = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_option_init = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_init = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_option_string_directive = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_option_string_directive = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_rule_section = new Integer[][] {
            {1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_rule_section = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_metapattern_directive = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_metapattern_directive = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_pair_directive = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_pair_directive = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_comments = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_comments = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_identifier_directive = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_identifier_directive = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_string = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_string = new Integer[] {null,null,1,};
        
        private static final Integer[][][] reverseTransitionTables = new Integer[][][] {
            rev_trans_inherited_header_section,
            rev_trans_option_section,
            rev_trans_rule_section,
            rev_trans_metapattern_directive,
            rev_trans_pair_directive,
            rev_trans_comments,
            rev_trans_identifier_directive,
            rev_trans_option_decl,
            rev_trans_option_init,
            rev_trans_option_string_directive,
            rev_trans_string,
        };
        
        private static final Integer[][] reverseActionTables = new Integer[][] {
            rev_act_inherited_header_section,
            rev_act_option_section,
            rev_act_rule_section,
            rev_act_metapattern_directive,
            rev_act_pair_directive,
            rev_act_comments,
            rev_act_identifier_directive,
            rev_act_option_decl,
            rev_act_option_init,
            rev_act_option_string_directive,
            rev_act_string,
        };
        
        private static final int[] actionMap = new int[] {1,2,6,7,8,9,10,3,4,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,};
        
        private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
        
        private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();
        private int currentState = 0;
        private Integer[][] currentTransitionTable = trans_BASE;
        private Integer[] currentActionTable = act_BASE;
        
        public MetaLexerClass_layout() {
            //Transition through states reachable by pure BOF patterns
            switchDFAs(/*local_header_section*/ 0); 
        }
        
        public Transition processSymbol(int sym) {
            currentMatch.add(sym);
            currentState = currentTransitionTable[currentState][sym];
            Integer mpatNum = currentActionTable[currentState];
            if(mpatNum == null) {
                return null;
            }
            int action = actionMap[mpatNum];
            Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));
            switchDFAs(action);
            return transition;
        }
        
        private void switchDFAs(int action) {
            currentState = 0;
            currentMatch.clear();
            
            int nextEmbedding;
            if(action < 0) {
                stateStack.pop();
                nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();
            } else {
                stateStack.push(action);
                nextEmbedding = action;
            }
            
            if(nextEmbedding < 0) {
                currentTransitionTable = trans_BASE;
                currentActionTable = act_BASE;
            } else {
                currentTransitionTable = transitionTables[nextEmbedding];
                currentActionTable = actionTables[nextEmbedding];
            }
        }
        
        private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {
            if(mpatNum >= reverseTransitionTables.length) {
                //don't need to clean end pattern matches - they aren't looked at
                return new java.util.ArrayList<Integer>(rawMatch);
            }
            
            java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();
            Integer[][] transitions = reverseTransitionTables[mpatNum];
            Integer[] actions = reverseActionTables[mpatNum];
            int dfaState = 0;
            for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {
                int sym = rawMatch.get(i);
                cleanMatch.add(sym);
                dfaState = transitions[dfaState][sym];
            }
            java.util.Collections.reverse(cleanMatch);
            return cleanMatch;
        }
        
        public static class Transition {
            private final int embeddingNum;
            private final java.util.List<Integer> match;
            
            public Transition(int embeddingNum, java.util.List<Integer> match) {
                this.embeddingNum = embeddingNum;
                this.match = new java.util.ArrayList<Integer>(match);
            }
            
            public int getEmbeddingNum() { return embeddingNum; }
            
            public java.util.List<Integer> getMatch() { return match; }
        }
        
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
        private final java.util.Set<Integer> allOpenSymbols;
        private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {
            this.pairMap = pairMap;
            this.allOpenSymbols = allOpenSymbols;
            this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();
        }
        
        public static class Builder {
            private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
            private final java.util.Set<Integer> allOpenSymbols;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();
                this.allOpenSymbols = new java.util.HashSet<Integer>();
            }
            
            public Builder add(int open, int close) {
                allOpenSymbols.add(open);
                java.util.Set<Integer> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Integer>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenSymbols);
            }
        }
        
        public boolean test(int sym) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Integer> correspondingOpens = pairMap.get(sym);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {
                    int open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenSymbols.contains(sym)) { //implies opening
                unclosedOpenSymbols.add(0, sym); //insert at beginning
            }
            return true;
        }
        
        public void clean(java.util.List<Integer> match) {
            java.util.Collections.reverse(match);
            for(int sym : match) {
                if(unclosedOpenSymbols.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenSymbols.get(0) == sym) {
                    unclosedOpenSymbols.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenSymbols.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isNothing() {
            return !isJust();
        }
        public abstract boolean isJust();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isJust() {
                return true;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isJust() {
                return false;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

%xstate EXTRA_RETURN

//from test/backend-jflex/in/metalexer/base.mlc [1, 1]
%state base_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/bracket_comment.mlc [1, 1]
%state bracket_comment_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/decl_region.mlc [1, 1]
%state decl_region_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/identifier_directive.mlc [1, 1]
%state identifier_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/inherited_header.mlc [1, 1]
%state inherited_header_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/init_region.mlc [1, 1]
%state init_region_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/layout_option_section.mlc [1, 1]
%state layout_option_section_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/layout_rule_section.mlc [1, 1]
%state layout_rule_section_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/local_header.mlc [1, 1]
%state local_header_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/metapattern_directive.mlc [1, 1]
%state metapattern_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/pair_directive.mlc [1, 1]
%state pair_directive_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/string.mlc [1, 1]
%state string_YYINITIAL_STATE
//from test/backend-jflex/in/metalexer/string_directive.mlc [1, 1]
%state string_directive_YYINITIAL_STATE

m_bracket_comment_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/bracket_comment.mlc [11, 1]
m_bracket_comment_CloseBracketComment = "*/" //from test/backend-jflex/in/metalexer/bracket_comment.mlc [12, 1]
m_decl_region_CloseDeclRegion = "%}" //from test/backend-jflex/in/metalexer/decl_region.mlc [11, 1]
m_identifier_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/identifier_directive.mlc [7, 1]
m_identifier_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [8, 1]
m_identifier_directive_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [10, 1]
m_identifier_directive_Digit = [0-9] //from test/backend-jflex/in/metalexer/identifier_directive.mlc [11, 1]
m_identifier_directive_Identifier = {m_identifier_directive_Letter}(((_ | {m_identifier_directive_Letter}) | {m_identifier_directive_Digit}))* //from test/backend-jflex/in/metalexer/identifier_directive.mlc [12, 1]
m_identifier_directive_QualifiedIdentifier = {m_identifier_directive_Identifier}(\.{m_identifier_directive_Identifier})+ //from test/backend-jflex/in/metalexer/identifier_directive.mlc [13, 1]
m_identifier_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_identifier_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_inherited_header_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/inherited_header.mlc [15, 1]
m_init_region_CloseInitRegion = "%init}" //from test/backend-jflex/in/metalexer/init_region.mlc [10, 1]
m_layout_option_section_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/layout_option_section.mlc [7, 1]
m_layout_option_section_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/layout_option_section.mlc [8, 1]
m_layout_option_section_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/layout_option_section.mlc [10, 1]
m_layout_option_section_Digit = [0-9] //from test/backend-jflex/in/metalexer/layout_option_section.mlc [11, 1]
m_layout_option_section_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/layout_option_section.mlc [13, 1]
m_layout_option_section_OpenDeclRegion = "%{" //from test/backend-jflex/in/metalexer/layout_option_section.mlc [15, 1]
m_layout_option_section_OpenInitRegion = "%init{" //from test/backend-jflex/in/metalexer/layout_option_section.mlc [16, 1]
m_layout_option_section_DirectiveLookahead = (!(({m_layout_option_section_Letter} | {m_layout_option_section_Digit}) | _)) //from test/backend-jflex/in/metalexer/layout_option_section.mlc [19, 1]
m_layout_option_section_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_layout_option_section_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_layout_rule_section_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [7, 1]
m_layout_rule_section_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [8, 1]
m_layout_rule_section_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [10, 1]
m_layout_rule_section_Digit = [0-9] //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [11, 1]
m_layout_rule_section_DirectiveLookahead = (!(({m_layout_rule_section_Letter} | {m_layout_rule_section_Digit}) | _)) //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [14, 1]
m_layout_rule_section_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_layout_rule_section_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_local_header_SectionSeparator = "%%" //from test/backend-jflex/in/metalexer/local_header.mlc [10, 1]
m_metapattern_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [7, 1]
m_metapattern_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [8, 1]
m_metapattern_directive_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [10, 1]
m_metapattern_directive_Digit = [0-9] //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [11, 1]
m_metapattern_directive_Identifier = {m_metapattern_directive_Letter}(((_ | {m_metapattern_directive_Letter}) | {m_metapattern_directive_Digit}))* //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [12, 1]
m_metapattern_directive_QualifiedIdentifier = {m_metapattern_directive_Identifier}(\.{m_metapattern_directive_Identifier})+ //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [13, 1]
m_metapattern_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_metapattern_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_pair_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/pair_directive.mlc [7, 1]
m_pair_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/pair_directive.mlc [8, 1]
m_pair_directive_Letter = [a-zA-Z] //from test/backend-jflex/in/metalexer/pair_directive.mlc [10, 1]
m_pair_directive_Digit = [0-9] //from test/backend-jflex/in/metalexer/pair_directive.mlc [11, 1]
m_pair_directive_Identifier = {m_pair_directive_Letter}(((_ | {m_pair_directive_Letter}) | {m_pair_directive_Digit}))* //from test/backend-jflex/in/metalexer/pair_directive.mlc [12, 1]
m_pair_directive_QualifiedIdentifier = {m_pair_directive_Identifier}(\.{m_pair_directive_Identifier})+ //from test/backend-jflex/in/metalexer/pair_directive.mlc [13, 1]
m_pair_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_pair_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]
m_string_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/string.mlc [11, 1]
m_string_Quote = \" //from test/backend-jflex/in/metalexer/string.mlc [13, 1]
m_string_Digit = [0-9] //from test/backend-jflex/in/metalexer/string.mlc [15, 1]
m_string_HexDigit = ({m_string_Digit} | [a-fA-F]) //from test/backend-jflex/in/metalexer/string.mlc [16, 1]
m_string_EscapeSequence = \\(((([nrtfb] | x({m_string_HexDigit}{2})) | u({m_string_HexDigit}{1, 4})) | ([0-3])?([0-7])?[0-7]) | [\|\(\)\{\}\[\]\<\>\\\.\*\+\?\^\$\/\.\"\~\!\-]) //from test/backend-jflex/in/metalexer/string.mlc [18, 1]
m_string_directive_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/metalexer/string_directive.mlc [6, 1]
m_string_directive_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/metalexer/string_directive.mlc [7, 1]
m_string_directive_Quote = \" //from test/backend-jflex/in/metalexer/string_directive.mlc [9, 1]
m_string_directive_Comment = "//"([^\r\n])* //from test/backend-jflex/in/metalexer/abstract_comment.mlc [4, 1]
m_string_directive_OpenBracketComment = "/*" //from test/backend-jflex/in/metalexer/abstract_comment.mlc [5, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        yybegin(state_layout.getPrevState());
        return state_layout.getExtraReturn();
    }
    
    <<EOF>> {
        yybegin(state_layout.getPrevState());
        return state_layout.getExtraReturn();
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/base.mlc [9, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_base.base_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/base.mlc [10, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_base.base_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [15, 1]
    {m_bracket_comment_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_1();
        } finally {
            state_layout.processMTok(14); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [16, 1]
    {m_bracket_comment_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_2();
        } finally {
            state_layout.processMTok(15); //END_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [19, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/bracket_comment.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_bracket_comment.bracket_comment_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<decl_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/decl_region.mlc [14, 1]
    %{m_decl_region_CloseDeclRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_decl_region.decl_region_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/decl_region.mlc [15, 1]
    {m_decl_region_CloseDeclRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_decl_region.decl_region_action_2();
        } finally {
            state_layout.processMTok(16); //END_DECL_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<decl_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/decl_region.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_decl_region.decl_region_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/decl_region.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_decl_region.decl_region_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_identifier_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_1();
        } finally {
            state_layout.processMTok(14); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [19, 1]
    {m_identifier_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_2();
        } finally {
            state_layout.processMTok(17); //END_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [20, 1]
    {m_identifier_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [21, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_identifier_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [23, 1]
    {m_identifier_directive_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [24, 1]
    {m_identifier_directive_QualifiedIdentifier} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<identifier_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [26, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/identifier_directive.mlc [27, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_identifier_directive.identifier_directive_action_9();
        } finally {
            state_layout.processMTok(17); //END_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<inherited_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [18, 1]
    {m_inherited_header_SectionSeparator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_inherited_header.inherited_header_action_1();
        } finally {
            state_layout.processMTok(18); //END_INHERITED_HEADER
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<inherited_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_inherited_header.inherited_header_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/inherited_header.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_inherited_header.inherited_header_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<init_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/init_region.mlc [13, 1]
    %{m_init_region_CloseInitRegion} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_init_region.init_region_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/init_region.mlc [14, 1]
    {m_init_region_CloseInitRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_init_region.init_region_action_2();
        } finally {
            state_layout.processMTok(19); //END_INIT_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<init_region_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/init_region.mlc [17, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_init_region.init_region_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/init_region.mlc [18, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_init_region.init_region_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_layout_option_section_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_1();
        } finally {
            state_layout.processMTok(14); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [26, 1]
    {m_layout_option_section_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [27, 1]
    {m_layout_option_section_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [29, 1]
    {m_layout_option_section_OpenDeclRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_4();
        } finally {
            state_layout.processMTok(20); //START_DECL_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [30, 1]
    {m_layout_option_section_OpenInitRegion} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_5();
        } finally {
            state_layout.processMTok(21); //START_INIT_REGION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [33, 1]
    "%helper" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [36, 1]
    "%layout" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_7();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [37, 1]
    "%start" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_8();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [38, 1]
    "%component" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_9();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [41, 1]
    "%declare" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_10();
        } finally {
            state_layout.processMTok(23); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [42, 1]
    "%option" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_11();
        } finally {
            state_layout.processMTok(23); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [43, 1]
    "%initthrow" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_12();
        } finally {
            state_layout.processMTok(23); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [44, 1]
    "%lexthrow" / {m_layout_option_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_13();
        } finally {
            state_layout.processMTok(23); //START_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [47, 1]
    "%" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [50, 1]
    {m_layout_option_section_SectionSeparator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_15();
        } finally {
            state_layout.processMTok(24); //END_OPTION_SECTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_layout_option_section_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_option_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [56, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_option_section.mlc [57, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_option_section.layout_option_section_action_18();
        } finally {
            state_layout.processMTok(24); //END_OPTION_SECTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_layout_rule_section_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_1();
        } finally {
            state_layout.processMTok(14); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [21, 1]
    {m_layout_rule_section_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [22, 1]
    {m_layout_rule_section_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [24, 1]
    "%%embed" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [26, 1]
    "%unembed" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_5();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [27, 1]
    "%replace" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_6();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [28, 1]
    "%unoption" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_7();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [30, 1]
    "%name" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_8();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [31, 1]
    "%host" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_9();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [32, 1]
    "%guest" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_10();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [33, 1]
    "%pair" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_11();
        } finally {
            state_layout.processMTok(25); //START_PAIR_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [35, 1]
    "%start" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_12();
        } finally {
            state_layout.processMTok(26); //START_METAPATTERN_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [36, 1]
    "%end" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_13();
        } finally {
            state_layout.processMTok(26); //START_METAPATTERN_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [38, 1]
    "%%inherit" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_14();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [39, 1]
    "%delete" / {m_layout_rule_section_DirectiveLookahead} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_15();
        } finally {
            state_layout.processMTok(22); //START_IDENTIFIER_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_layout_rule_section_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<layout_rule_section_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [44, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/layout_rule_section.mlc [45, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_layout_rule_section.layout_rule_section_action_18();
        } finally {
            state_layout.processMTok(27); //END_RULE_SECTION
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<local_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/local_header.mlc [13, 1]
    {m_local_header_SectionSeparator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_local_header.local_header_action_1();
        } finally {
            state_layout.processMTok(28); //END_LOCAL_HEADER
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<local_header_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/local_header.mlc [16, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_local_header.local_header_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/local_header.mlc [17, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_local_header.local_header_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metapattern_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_metapattern_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_1();
        } finally {
            state_layout.processMTok(14); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [19, 1]
    {m_metapattern_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_2();
        } finally {
            state_layout.processMTok(29); //END_METAPATTERN_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [20, 1]
    {m_metapattern_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [22, 1]
    "<ANY>" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [23, 1]
    "<BOF>" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [24, 1]
    "<EOF>" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [26, 1]
    "(" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [27, 1]
    ")" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [28, 1]
    "[" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [29, 1]
    "]" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_10();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [30, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_11();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [31, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_12();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [32, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_13();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [33, 1]
    "?" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [34, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metapattern_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_metapattern_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [38, 1]
    "%"{m_metapattern_directive_Identifier}"%" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [39, 1]
    "%"{m_metapattern_directive_QualifiedIdentifier}"%" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [40, 1]
    {m_metapattern_directive_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<metapattern_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [44, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/metapattern_directive.mlc [45, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_metapattern_directive.metapattern_directive_action_21();
        } finally {
            state_layout.processMTok(29); //END_METAPATTERN_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<pair_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_pair_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_pair_directive.pair_directive_action_1();
        } finally {
            state_layout.processMTok(14); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [19, 1]
    {m_pair_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_pair_directive.pair_directive_action_2();
        } finally {
            state_layout.processMTok(30); //END_PAIR_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [20, 1]
    {m_pair_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_pair_directive.pair_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [22, 1]
    "," {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_pair_directive.pair_directive_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<pair_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_pair_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_pair_directive.pair_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [26, 1]
    "%"{m_pair_directive_Identifier}"%" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_pair_directive.pair_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [27, 1]
    "%"{m_pair_directive_QualifiedIdentifier}"%" {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_pair_directive.pair_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [28, 1]
    {m_pair_directive_Identifier} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_pair_directive.pair_directive_action_8();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<pair_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [32, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_pair_directive.pair_directive_action_9();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/pair_directive.mlc [33, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_pair_directive.pair_directive_action_10();
        } finally {
            state_layout.processMTok(30); //END_PAIR_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string.mlc [22, 1]
    {m_string_Quote} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_string.string_action_1();
        } finally {
            state_layout.processMTok(31); //END_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [23, 1]
    {m_string_EscapeSequence} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [24, 1]
    \\[^\r\n] {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [25, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [26, 1]
    {m_string_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string.mlc [29, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string.mlc [30, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string.string_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [8, 1]
    {m_string_directive_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_string_directive.string_directive_action_1();
        } finally {
            state_layout.processMTok(14); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [15, 1]
    {m_string_directive_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_string_directive.string_directive_action_2();
        } finally {
            state_layout.processMTok(32); //END_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [16, 1]
    {m_string_directive_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [17, 1]
    {m_string_directive_Quote} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_string_directive.string_directive_action_4();
        } finally {
            state_layout.processMTok(33); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [18, 1]
    , {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/abstract_comment.mlc [10, 1]
    {m_string_directive_Comment} {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_directive_YYINITIAL_STATE> {
    //from test/backend-jflex/in/metalexer/string_directive.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_layout.inst_string_directive.string_directive_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/metalexer/string_directive.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_layout.inst_string_directive.string_directive_action_8();
        } finally {
            state_layout.processMTok(32); //END_STRING_DIRECTIVE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


