package test.jflex.natlab.attributed;
import static test.jflex.natlab.attributed.AttributeParser.Terminals.*;
import test.jflex.natlab.*;
import static test.jflex.natlab.NatlabParser.Terminals.*;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Scanner; //from null [10, 1]
import beaver.Scanner; //from null [10, 1]
import beaver.Scanner; //from null [10, 1]
%%
//// This file was generated by MetaLexer ////

//from test/backend-jflex/in/natlab/attributed_natlab.mll [8, 1]
%class AttributedNatlabScanner
//from test/backend-jflex/in/natlab/attributed_natlab.mll [9, 1]
%function nextToken
//from test/backend-jflex/in/natlab/helper_beaver.mll [9, 1]
%public
//from test/backend-jflex/in/natlab/helper_beaver.mll [10, 1]
%final
//from test/backend-jflex/in/natlab/helper_beaver.mll [13, 1]
%extends Scanner
//from test/backend-jflex/in/natlab/helper_beaver.mll [14, 1]
%unicode
//from test/backend-jflex/in/natlab/helper_beaver.mll [17, 1]
%line
//from test/backend-jflex/in/natlab/helper_beaver.mll [18, 1]
%column
//from test/backend-jflex/in/natlab/helper_beaver.mll [20, 1]
%type Symbol
//from null [22, 1]
%yylexthrow Scanner.Exception

//from null [12, 1]
%{//// Comment queue ///////////////////////////////////////////////////////////
  
  //put comments in the buffer rather than returning them
  //NB: must be non-null before scanning starts
  private CommentBuffer commentBuffer = null;
  
  public void setCommentBuffer(CommentBuffer commentBuffer) {
      this.commentBuffer = commentBuffer;
  }
  
  public CommentBuffer getCommentBuffer() {
      return commentBuffer;
  }
%}
//from null [29, 1]
%{//// Position info for commas and semicolons /////////////////////////////////
  
  private int storedLine = -1;
  private int storedCol = -1;
%}
//from null [10, 1]
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
//from null [9, 1]
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}


%{
    private final StateClass_attributed_natlab state_attributed_natlab = new StateClass_attributed_natlab();
%}

%{
    private class StateClass_attributed_natlab {
        private StateClass_attributed_natlab() {
            //from test/backend-jflex/in/natlab/natlab.mll [55, 1]
            embeddingRecordArray[0] = new EmbeddingRecord("leading_ws", inst_leading_ws, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [72, 1]
            embeddingRecordArray[1] = new EmbeddingRecord("class_brackets", inst_class_bracketed, new PairFilter.Builder().add(/*START_BRACKETED*/ 18, /*END_BRACKETED*/ 13).build());
            //from test/backend-jflex/in/natlab/natlab.mll [82, 1]
            embeddingRecordArray[2] = new EmbeddingRecord("field_name", inst_field_name, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [91, 1]
            embeddingRecordArray[3] = new EmbeddingRecord("transpose", inst_transpose, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [100, 1]
            embeddingRecordArray[4] = new EmbeddingRecord("string", inst_string, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [109, 1]
            embeddingRecordArray[5] = new EmbeddingRecord("comma_terminator", inst_comma_terminator, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [116, 1]
            embeddingRecordArray[6] = new EmbeddingRecord("semicolon_terminator", inst_semicolon_terminator, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [125, 1]
            embeddingRecordArray[7] = new EmbeddingRecord("bracket_comment", inst_bracket_comment, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/natlab.mll [132, 1]
            embeddingRecordArray[8] = new EmbeddingRecord("bracket_help_comment", inst_bracket_help_comment, PairFilter.EMPTY);
            //from test/backend-jflex/in/natlab/attributed_natlab.mll [22, 1]
            embeddingRecordArray[9] = new EmbeddingRecord("class", inst_attributed_class, new PairFilter.Builder().add(/*OPEN_END*/ 23, /*END*/ 22).add(/*PROPERTIES*/ 26, /*END*/ 22).add(/*METHODS*/ 27, /*END*/ 22).add(/*EVENTS*/ 28, /*END*/ 22).build());
            //from test/backend-jflex/in/natlab/attributed_natlab.mll [33, 1]
            embeddingRecordArray[10] = new EmbeddingRecord("class_attributes", inst_attributes, PairFilter.EMPTY);
            
            //from test/backend-jflex/in/natlab/attributed_natlab.mll [13, 8]
            yybegin(base_YYINITIAL_STATE);
            
            embeddingStack.push(new EmbeddingRecord(null, inst_base, PairFilter.EMPTY));
            
            //Transition through states reachable by pure BOF patterns
            //NB: append actions will not be performed
            startEmbedding(/*leading_ws*/ 0); 
            
            restartAppendBuf();
            restartDelimBuf(false);
            
            //NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.
            sendMTok(/*BOF*/ 0);
        }
        
        private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[11];
        private final CompClass_attributes inst_attributes = new CompClass_attributes();
        private final CompClass_leading_ws inst_leading_ws = new CompClass_leading_ws();
        private final CompClass_base inst_base = new CompClass_base();
        private final CompClass_attributed_class inst_attributed_class = new CompClass_attributed_class();
        private final CompClass_class_bracketed inst_class_bracketed = new CompClass_class_bracketed();
        private final CompClass_field_name inst_field_name = new CompClass_field_name();
        private final CompClass_comma_terminator inst_comma_terminator = new CompClass_comma_terminator();
        private final CompClass_semicolon_terminator inst_semicolon_terminator = new CompClass_semicolon_terminator();
        private final CompClass_string inst_string = new CompClass_string();
        private final CompClass_transpose inst_transpose = new CompClass_transpose();
        private final CompClass_bracket_comment inst_bracket_comment = new CompClass_bracket_comment();
        private final CompClass_bracket_help_comment inst_bracket_help_comment = new CompClass_bracket_help_comment();
        private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();
        
        private void startEmbedding(int newEmbeddingNum) {
            EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];
            newEmbedding.getFilter().reset();
            embeddingStack.push(newEmbedding);
            yybegin(newEmbedding.getComp().getStartState());
        }
        private void endEmbedding() {
            embeddingStack.pop();
            EmbeddingRecord newEmbedding = embeddingStack.peek();
            yybegin(newEmbedding.getComp().getStartState());
        }
        private ComponentInnerClass getCurrComp() {
            return embeddingStack.peek().getComp();
        }
        private PairFilter getCurrFilter() {
            return embeddingStack.peek().getFilter();
        }
        
        private int delimStartLine = -1;
        private int delimStartCol = -1;
        private StringBuffer delimBuf = null;
        
        private void restartDelimBuf(boolean copyToAppendBuf) {
            if(copyToAppendBuf && delimBuf.length() > 0) {
                startLine = delimStartLine;
                startCol = delimStartCol;
                appendBuf.append(delimBuf);
            }
            delimStartLine = -1;
            delimStartCol = -1;
            delimBuf = new StringBuffer();
        }
        private <T> void appendToStartDelim(T t) {
            if(delimStartLine < 0) {
                delimStartLine = yyline + 1;
                delimStartCol = yycolumn + 1;
            }
            delimBuf.append(t);
        }
        
        private int startLine = -1;
        private int startCol = -1;
        private StringBuffer appendBuf = null;
        
        private void restartAppendBuf() {
            startLine = yyline + 1;
            startCol = yycolumn + 1;
            appendBuf = new StringBuffer();
        }
        private int getStartLine() {
            return startLine;
        }
        private int getStartColumn() {
            return startCol;
        }
        private String getAppendText() {
            return appendBuf.toString();
        }
        private <T> void append(T t) {
            appendBuf.append(t);
        }
        
        private Symbol extraReturn = null;
        private int prevState = -1;
        
        public Symbol getExtraReturn() {
            return extraReturn;
        }
        public int getPrevState() {
            return prevState;
        }
        private void returnExtraValue(Symbol value) {
            extraReturn = value;
            prevState = yystate();
            if(yylength() > 0) {
                yypushback(1); //to ensure that at least one char is available
            }
            yybegin(EXTRA_RETURN);
        }
        
        private final MetaLexerClass_attributed_natlab metalexer_attributed_natlab = new MetaLexerClass_attributed_natlab();
        private MetaLexerClass_attributed_natlab.Transition sendMTok(int mtok) {
            return metalexer_attributed_natlab.processSymbol(mtok);
        }
        
        public void processMTok(int mtok)  throws Scanner.Exception{
            if(!getCurrFilter().test(mtok)) {
                return; //don't send symbol if it gets filtered out
            }
            Maybe<? extends Symbol> maybeReturn = Maybe.Nothing();
            ComponentInnerClass currComp = getCurrComp();
            boolean appendActionPerformed = false;
            MetaLexerClass_attributed_natlab.Transition next = sendMTok(mtok);
            while(next != null) {
                boolean endOfEmbedding = next.getEmbeddingNum() < 0;
                if(endOfEmbedding) {
                    endEmbedding();
                } else {
                    //NB: update filter in the OLD embedding and only in start case
                    getCurrFilter().clean(next.getMatch());
                    startEmbedding(next.getEmbeddingNum());
                }
                ComponentInnerClass nextComp = getCurrComp();
                //NB: only one append action can meaningfully be performed since
                //  no input can be consumed while in this loop
                if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {
                    int endLine = yyline + 1;
                    int endCol = yycolumn; //+1 handled by increment below
                    
                    final String yytext = yytext();
                    final int yylength = yylength();
                    boolean prevWasNewline = false;
                    for(int i = 0; i < yylength; i++) {
                        if(prevWasNewline) {
                            endLine++;
                            endCol = 0;
                        }
                        switch(yytext.charAt(i)) {
                        case '\r':
                            if(i + 1 < yylength && yytext.charAt(i+1) == '\n') {
                                i++;
                            }
                            //NB: fall through
                        case '\n':
                            prevWasNewline = true;
                            break;
                        default:
                            prevWasNewline = false;
                            break;
                        }
                        endCol++;
                    }
                    maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());
                    appendActionPerformed = true;
                }
                
                if(currComp.isAppend() != nextComp.isAppend()) {
                    restartAppendBuf();
                }
                
                restartDelimBuf(nextComp.expectsStartDelim());
                
                next = null;
                if(endOfEmbedding) {
                    int regionSym = currComp.getSymbolValue();
                    if(getCurrFilter().test(regionSym)) {
                        next = sendMTok(regionSym);
                    } else {
                    }
                }
            }
            if(maybeReturn.isJust()) {
                returnExtraValue(maybeReturn.fromJust());
            }
        }
    }
%}

%{
    private static abstract class ComponentInnerClass {
        public boolean isAppend() {
            return false;
        }
        public boolean expectsStartDelim() {
            return false;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            throw new UnsupportedOperationException(getClass().getName() + ".performAppendAction has not been implemented.");
        }
        public abstract int getStartState();
        public abstract int getSymbolValue();
    }
%}

%{
    //from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
    private class CompClass_attributes extends ComponentInnerClass {
        
        public CompClass_attributes() {
        }
        
        private static final int YYINITIAL = attributes_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 1;
        }
        
        public Maybe<? extends Symbol> attributes_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [7, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [9, 7]
                return Maybe.Just(symbol(ATTR1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [10, 7]
                return Maybe.Just(symbol(ATTR2));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [12, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [14, 6]
                return Maybe.Just(symbol(VAL1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [15, 6]
                return Maybe.Just(symbol(VAL2));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributes_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributes.attributes_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributes.mlc [17, 5]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
    private class CompClass_leading_ws extends ComponentInnerClass {
        
        public CompClass_leading_ws() {
        }
        
        private static final int YYINITIAL = leading_ws_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 2;
        }
        
        public Maybe<? extends Symbol> leading_ws_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> leading_ws_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> leading_ws_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/leading_ws.mlc [10, 9]
                yypushback(1);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> leading_ws_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_leading_ws.leading_ws_action_4()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/base.mlc [1, 1]
    private class CompClass_base extends ComponentInnerClass {
        //from null [12, 1]
        //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }

        
        public CompClass_base() {
        }
        
        private static final int YYINITIAL = base_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/base.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/base.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 3;
        }
        
        public Maybe<? extends Symbol> base_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_9() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_10() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 4]
                return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_11() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 4]
                return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_12() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_13() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_14() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_15() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_16() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_17() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_18() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_19() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_20() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_21() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_22() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_23() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_24() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_25() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_26() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_27() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_28() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_29() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_30() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_31() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_32() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_33() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_34() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_35() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_36() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_37() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_38() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_39() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [8, 10]
                return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_40() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [9, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_41() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 6]
                return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_42() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 5]
                return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_43() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 10]
                return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_44() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 4]
                return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_45() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 8]
                return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_46() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 8]
                return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_47() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 5]
                return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_48() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 7]
                return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_49() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_50() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_51() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_52() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_53() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_54() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_55() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_56() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_57() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_58() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_59() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_60() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_61() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_62() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 25]
                commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_63() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_64() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_65() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_66() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_67() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_68() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_69() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_70() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_71() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [14, 9]
                error("Illegal character '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> base_action_72() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_base.base_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/base.mlc [15, 9]
                return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
    private class CompClass_attributed_class extends ComponentInnerClass {
        //from null [12, 1]
        //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }

        
        public CompClass_attributed_class() {
        }
        
        private static final int YYINITIAL = attributed_class_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 4;
        }
        
        public Maybe<? extends Symbol> attributed_class_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_9() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_10() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 4]
                return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_11() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 4]
                return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_12() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_13() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_14() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_15() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_16() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_17() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_18() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_19() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_20() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_21() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_22() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_23() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_24() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_25() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_26() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_27() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_28() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_29() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_30() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_31() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_32() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_33() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_34() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_35() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_36() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_37() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_38() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_39() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [11, 10]
                return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_40() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [12, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_41() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 6]
                return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_42() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 5]
                return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_43() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 10]
                return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_44() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 4]
                return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_45() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 8]
                return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_46() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 8]
                return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_47() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 5]
                return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_48() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 7]
                return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_49() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_50() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_51() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_52() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_53() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_54() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_55() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_56() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_57() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_58() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_59() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_60() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributed_class.mlc [9, 12]
                return Maybe.Just(symbol(PROPERTIES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_61() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributed_class.mlc [10, 9]
                return Maybe.Just(symbol(METHODS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_62() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/attributed_class.mlc [11, 8]
                return Maybe.Just(symbol(EVENTS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_63() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_64() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_65() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 25]
                commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_66() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_67() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_68() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_69() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_70() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_71() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_72() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_73() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_73()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_74() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_74()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [21, 9]
                error("Illegal character in classdef '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> attributed_class_action_75() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_attributed_class.attributed_class_action_75()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class.mlc [22, 9]
                return Maybe.Just(symbol(EOF));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
    private class CompClass_class_bracketed extends ComponentInnerClass {
        //from null [12, 1]
        //// Numbers /////////////////////////////////////////////////////////////////
  
  private DecIntNumericLiteralValue parseDecInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new DecIntNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private HexNumericLiteralValue parseHexInt(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new HexNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }
  
  private FPNumericLiteralValue parseFP(String text, boolean imaginary) throws Scanner.Exception {
      try { 
          return new FPNumericLiteralValue(yytext(), imaginary);
      } catch(NumberFormatException e) {
          error("Invalid number: " + yytext() + " (" + e.getMessage() + ")");
          return null; //unreachable - error throws an exception
      }
  }

        
        public CompClass_class_bracketed() {
        }
        
        private static final int YYINITIAL = class_bracketed_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 5;
        }
        
        public Maybe<? extends Symbol> class_bracketed_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 18]
                return Maybe.Just(symbol(LINE_TERMINATOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_4()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_5()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 4]
                return Maybe.Just(symbol(LPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 4]
                return Maybe.Just(symbol(RPAREN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 4]
                return Maybe.Just(symbol(LSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_9() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_9()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 4]
                return Maybe.Just(symbol(RSQUARE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_10() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_10()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 4]
                return Maybe.Just(symbol(LCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_11() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_11()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 4]
                return Maybe.Just(symbol(RCURLY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_12() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_12()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_13() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_13()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 3]
                storedLine = yyline; storedCol = yycolumn;
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_14() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_14()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 3]
                return Maybe.Just(symbol(COLON));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_15() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_15()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 3]
                return Maybe.Just(symbol(AT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_16() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_16()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 5]
                return Maybe.Just(symbol(PLUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_17() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_17()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 5]
                return Maybe.Just(symbol(MINUS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_18() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_18()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 5]
                return Maybe.Just(symbol(MTIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_19() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_19()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 6]
                return Maybe.Just(symbol(ETIMES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_20() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_20()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 5]
                return Maybe.Just(symbol(MDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_21() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_21()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 6]
                return Maybe.Just(symbol(EDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_22() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_22()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 6]
                return Maybe.Just(symbol(MLDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_23() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_23()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 7]
                return Maybe.Just(symbol(ELDIV));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_24() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_24()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 5]
                return Maybe.Just(symbol(MPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_25() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_25()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 6]
                return Maybe.Just(symbol(EPOW));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_26() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_26()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 6]
                return Maybe.Just(symbol(ARRAYTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_27() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_27()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 6]
                return Maybe.Just(symbol(LE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_28() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_28()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 6]
                return Maybe.Just(symbol(GE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_29() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_29()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 5]
                return Maybe.Just(symbol(LT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_30() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_30()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 5]
                return Maybe.Just(symbol(GT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_31() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_31()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 6]
                return Maybe.Just(symbol(EQ));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_32() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_32()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 6]
                return Maybe.Just(symbol(NE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_33() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_33()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 5]
                return Maybe.Just(symbol(AND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_34() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_34()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 5]
                return Maybe.Just(symbol(OR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_35() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_35()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 5]
                return Maybe.Just(symbol(NOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_36() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_36()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 6]
                return Maybe.Just(symbol(SHORTAND));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_37() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_37()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 6]
                return Maybe.Just(symbol(SHORTOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_38() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_38()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 5]
                return Maybe.Just(symbol(ASSIGN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_39() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_39()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [11, 10]
                return Maybe.Just(symbol(CLASSDEF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_40() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_40()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [12, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_41() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_41()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [14, 12]
                return Maybe.Just(symbol(PROPERTIES));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_42() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_42()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [15, 9]
                return Maybe.Just(symbol(METHODS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_43() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_43()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [16, 8]
                return Maybe.Just(symbol(EVENTS));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_44() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_44()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 6]
                return Maybe.Just(symbol(CASE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_45() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_45()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 5]
                return Maybe.Just(symbol(FOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_46() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_46()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 10]
                return Maybe.Just(symbol(FUNCTION));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_47() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_47()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 4]
                return Maybe.Just(symbol(IF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_48() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_48()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 8]
                return Maybe.Just(symbol(PARFOR));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_49() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_49()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 8]
                return Maybe.Just(symbol(SWITCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_50() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_50()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 5]
                return Maybe.Just(symbol(TRY));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_51() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_51()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 7]
                return Maybe.Just(symbol(WHILE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_52() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_52()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 7]
                return Maybe.Just(symbol(BREAK));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_53() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_53()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 7]
                return Maybe.Just(symbol(CATCH));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_54() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_54()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 10]
                return Maybe.Just(symbol(CONTINUE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_55() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_55()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 6]
                return Maybe.Just(symbol(ELSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_56() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_56()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 8]
                return Maybe.Just(symbol(ELSEIF));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_57() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_57()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 5]
                return Maybe.Just(symbol(END));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_58() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_58()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 8]
                return Maybe.Just(symbol(GLOBAL));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_59() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_59()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 11]
                return Maybe.Just(symbol(OTHERWISE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_60() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_60()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 12]
                return Maybe.Just(symbol(PERSISTENT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_61() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_61()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 8]
                return Maybe.Just(symbol(RETURN));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_62() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_62()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 4]
                return Maybe.Just(symbol(DOT));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_63() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_63()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_64() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_64()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_65() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_65()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 25]
                commentBuffer.pushComment(symbol(ELLIPSIS_COMMENT, yytext().substring(yytext().indexOf("..."), yylength() - 1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_66() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_66()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseDecInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_67() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_67()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 12]
                return Maybe.Just(symbol(FP_NUMBER, parseFP(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_68() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_68()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 13]
                return Maybe.Just(symbol(INT_NUMBER, parseHexInt(yytext(), false)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_69() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_69()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseDecInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_70() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_70()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 21]
                return Maybe.Just(symbol(IM_FP_NUMBER, parseFP(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_71() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_71()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 22]
                return Maybe.Just(symbol(IM_INT_NUMBER, parseHexInt(yytext(), true)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_72() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_72()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 16]
                return Maybe.Just(symbol(SHELL_COMMAND, yytext().substring(1)));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_73() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_73()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_74() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_74()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [21, 9]
                error("Illegal character in classdef '" + yytext() + "'");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> class_bracketed_action_75() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_class_bracketed.class_bracketed_action_75()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/class_bracketed.mlc [22, 9]
                error("Unclosed brackets in class");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
    private class CompClass_field_name extends ComponentInnerClass {
        
        public CompClass_field_name() {
        }
        
        private static final int YYINITIAL = field_name_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 6;
        }
        
        public Maybe<? extends Symbol> field_name_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/field_name.mlc [12, 14]
                return Maybe.Just(symbol(IDENTIFIER, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/field_name.mlc [16, 9]
                yypushback(1);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> field_name_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_field_name.field_name_action_7()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
    private class CompClass_comma_terminator extends ComponentInnerClass {
        
        public CompClass_comma_terminator() {
        }
        
        private static final int YYINITIAL = comma_terminator_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 7;
        }
        
        public Maybe<? extends Symbol> comma_terminator_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [12, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [13, 18]
                return Maybe.Just(symbol(COMMA_LINE_TERMINATOR, null, storedLine + 1, storedCol + 1, yyline + 1, yycolumn + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [18, 9]
                yypushback(1); return Maybe.Just(symbol(COMMA, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> comma_terminator_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_comma_terminator.comma_terminator_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comma_terminator.mlc [19, 9]
                return Maybe.Just(symbol(COMMA, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
    private class CompClass_semicolon_terminator extends ComponentInnerClass {
        
        public CompClass_semicolon_terminator() {
        }
        
        private static final int YYINITIAL = semicolon_terminator_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 8;
        }
        
        public Maybe<? extends Symbol> semicolon_terminator_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_1()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_2()");
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [12, 19]
                /* ignore */
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [13, 18]
                return Maybe.Just(symbol(SEMICOLON_LINE_TERMINATOR, null, storedLine + 1, storedCol + 1, yyline + 1, yycolumn + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [16, 15]
                return Maybe.Just(symbol(HELP_COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/comment_start.mlc [17, 11]
                commentBuffer.pushComment(symbol(COMMENT, yytext()));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [18, 9]
                yypushback(1); return Maybe.Just(symbol(SEMICOLON, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> semicolon_terminator_action_8() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_8()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [19, 9]
                return Maybe.Just(symbol(SEMICOLON, null, storedLine + 1, storedCol + 1, storedLine + 1, storedCol + 1));
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/string.mlc [1, 1]
    private class CompClass_string extends ComponentInnerClass {
        
        public CompClass_string() {
        }
        
        private static final int YYINITIAL = string_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/string.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [6, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    return Maybe.Just(symbol(STRING, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_attributed_natlab.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/string.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 9;
        }
        
        public Maybe<? extends Symbol> string_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [13, 6]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [14, 5]
                /*just end string - %append will handle token*/
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [15, 15]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [16, 4]
                error("Invalid escape sequence");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_5() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_5()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [17, 18]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_6() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_6()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [20, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> string_action_7() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_string.string_action_7()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/string.mlc [21, 9]
                error("Unterminated string literal");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
    private class CompClass_transpose extends ComponentInnerClass {
        
        public CompClass_transpose() {
        }
        
        private static final int YYINITIAL = transpose_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 10;
        }
        
        public Maybe<? extends Symbol> transpose_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_transpose.transpose_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/transpose.mlc [7, 5]
                return Maybe.Just(symbol(MTRANSPOSE));
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> transpose_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_transpose.transpose_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/transpose.mlc [10, 9]
                yypushback(1);
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> transpose_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_transpose.transpose_action_3()");
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
    private class CompClass_bracket_comment extends ComponentInnerClass {
        
        public CompClass_bracket_comment() {
        }
        
        private static final int YYINITIAL = bracket_comment_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [7, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    commentBuffer.pushComment(symbol(BRACKET_COMMENT, text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_attributed_natlab.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 11;
        }
        
        public Maybe<? extends Symbol> bracket_comment_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [14, 22]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [15, 23]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [18, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_comment_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_comment.bracket_comment_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_comment.mlc [19, 9]
                error("Unterminated bracket comment");
            }
            return Maybe.Nothing();
        }
    }
%}
%{
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
    private class CompClass_bracket_help_comment extends ComponentInnerClass {
        
        public CompClass_bracket_help_comment() {
        }
        
        private static final int YYINITIAL = bracket_help_comment_YYINITIAL_STATE; //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
        
        public <T> void appendToStartDelim(T t) {
            state_attributed_natlab.appendToStartDelim(t);
        }
        
        public boolean isAppend() {
            return true;
        }
        public Maybe<? extends Symbol> performAppendAction(int startLine, int startCol, int endLine, int endCol, String text) throws Scanner.Exception {
            if(Object.class != null) {
                //from null [7, 1]
                /*(int startLine, int startCol, int endLine, int endCol, String text)*/
    //TODO-AC: inserting delimiters is hackish
    return Maybe.Just(symbol(BRACKET_HELP_COMMENT, "%%{" + text, startLine, startCol, endLine, endCol));
            }
            return Maybe.Nothing();
        }
        public <T> void append(T t) {
            state_attributed_natlab.append(t);
        }
        
        public int getStartState() {
            //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
            return YYINITIAL;
        }
        
        public int getSymbolValue() {
            return 12;
        }
        
        public Maybe<? extends Symbol> bracket_help_comment_action_1() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_1()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [15, 22]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_help_comment_action_2() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_2()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [16, 23]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_help_comment_action_3() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_3()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [19, 9]
                append(yytext());
            }
            return Maybe.Nothing();
        }
        public Maybe<? extends Symbol> bracket_help_comment_action_4() throws Scanner.Exception {
            //System.err.println("state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_4()");
            if(Object.class != null) {
                //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [20, 9]
                error("Unterminated bracket help comment");
            }
            return Maybe.Nothing();
        }
    }
%}

%{
    public static class MetaLexerClass_attributed_natlab {
        
        //// Symbols ////
        // <BOF>
        // %attributes%
        // %leading_ws%
        // %base%
        // %attributed_class%
        // %class_bracketed%
        // %field_name%
        // %comma_terminator%
        // %semicolon_terminator%
        // %string%
        // %transpose%
        // %bracket_comment%
        // %bracket_help_comment%
        // END_BRACKETED
        // END_LEADING_WS
        // START_BRACKET_HELP_COMMENT
        // START_BRACKET_COMMENT
        // START_STRING
        // START_BRACKETED
        // START_COMMA_TERMINATOR
        // START_SEMICOLON_TERMINATOR
        // START_CLASS
        // END
        // OPEN_END
        // START_FIELD_NAME
        // START_TRANSPOSE
        // PROPERTIES
        // METHODS
        // EVENTS
        // END_FIELD_NAME
        // END_COMMA_TERMINATOR
        // END_SEMICOLON_TERMINATOR
        // END_STRING
        // END_TRANSPOSE
        // END_BRACKET_COMMENT
        
        private static final Integer[][] trans_BASE = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,3,4,0,5,6,7,0,0,8,1,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_BASE = new Integer[] {null,1,6,5,2,3,4,7,0,};
        
        private static final Integer[][] trans_bracket_comment = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,},
        };
        private static final Integer[] act_bracket_comment = new Integer[] {null,5,17,};
        
        private static final Integer[][] trans_transpose = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,},
        };
        private static final Integer[] act_transpose = new Integer[] {null,13,};
        
        private static final Integer[][] trans_class_attributes = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_class_attributes = new Integer[] {null,20,};
        
        private static final Integer[][] trans_bracket_help_comment = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,},
        };
        private static final Integer[] act_bracket_help_comment = new Integer[] {null,5,18,};
        
        private static final Integer[][] trans_string = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,},
        };
        private static final Integer[] act_string = new Integer[] {null,14,};
        
        private static final Integer[][] trans_field_name = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,},
        };
        private static final Integer[] act_field_name = new Integer[] {null,6,5,12,};
        
        private static final Integer[][] trans_semicolon_terminator = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,},
        };
        private static final Integer[] act_semicolon_terminator = new Integer[] {null,6,5,16,};
        
        private static final Integer[][] trans_comma_terminator = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,},
        };
        private static final Integer[] act_comma_terminator = new Integer[] {null,6,5,15,};
        
        private static final Integer[][] trans_class_brackets = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_class_brackets = new Integer[] {null,11,6,5,};
        
        private static final Integer[][] trans_class = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,3,4,5,6,7,0,8,0,9,1,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_class = new Integer[] {null,1,6,5,2,8,3,4,19,0,};
        
        private static final Integer[][] trans_leading_ws = new Integer[][] {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
        };
        private static final Integer[] act_leading_ws = new Integer[] {null,10,};
        
        private static final Integer[][][] transitionTables = new Integer[][][] {
            trans_leading_ws,
            trans_class_brackets,
            trans_field_name,
            trans_transpose,
            trans_string,
            trans_comma_terminator,
            trans_semicolon_terminator,
            trans_bracket_comment,
            trans_bracket_help_comment,
            trans_class,
            trans_class_attributes,
        };
        
        private static final Integer[][] actionTables = new Integer[][] {
            act_leading_ws,
            act_class_brackets,
            act_field_name,
            act_transpose,
            act_string,
            act_comma_terminator,
            act_semicolon_terminator,
            act_bracket_comment,
            act_bracket_help_comment,
            act_class,
            act_class_attributes,
        };
        
        private static final Integer[][] rev_trans_class_brackets = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_class_brackets = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_field_name = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_field_name = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_transpose = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_transpose = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_string = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_string = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_comma_terminator = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_comma_terminator = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_semicolon_terminator = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_semicolon_terminator = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_bracket_comment = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_bracket_comment = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_bracket_help_comment = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_bracket_help_comment = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_class = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_class = new Integer[] {null,null,1,};
        
        private static final Integer[][] rev_trans_class_attributes = new Integer[][] {
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,1,1,1,},
        };
        private static final Integer[] rev_act_class_attributes = new Integer[] {null,null,null,1,};
        
        private static final Integer[][][] reverseTransitionTables = new Integer[][][] {
            rev_trans_field_name,
            rev_trans_transpose,
            rev_trans_string,
            rev_trans_comma_terminator,
            rev_trans_semicolon_terminator,
            rev_trans_bracket_comment,
            rev_trans_bracket_help_comment,
            rev_trans_class,
            rev_trans_class_brackets,
            rev_trans_class_attributes,
        };
        
        private static final Integer[][] reverseActionTables = new Integer[][] {
            rev_act_field_name,
            rev_act_transpose,
            rev_act_string,
            rev_act_comma_terminator,
            rev_act_semicolon_terminator,
            rev_act_bracket_comment,
            rev_act_bracket_help_comment,
            rev_act_class,
            rev_act_class_brackets,
            rev_act_class_attributes,
        };
        
        private static final int[] actionMap = new int[] {2,3,4,5,6,7,8,9,1,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,};
        
        private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
        
        private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();
        private int currentState = 0;
        private Integer[][] currentTransitionTable = trans_BASE;
        private Integer[] currentActionTable = act_BASE;
        
        public MetaLexerClass_attributed_natlab() {
            //Transition through states reachable by pure BOF patterns
            switchDFAs(/*leading_ws*/ 0); 
        }
        
        public Transition processSymbol(int sym) {
            currentMatch.add(sym);
            currentState = currentTransitionTable[currentState][sym];
            Integer mpatNum = currentActionTable[currentState];
            if(mpatNum == null) {
                return null;
            }
            int action = actionMap[mpatNum];
            Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));
            switchDFAs(action);
            return transition;
        }
        
        private void switchDFAs(int action) {
            currentState = 0;
            currentMatch.clear();
            
            int nextEmbedding;
            if(action < 0) {
                stateStack.pop();
                nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();
            } else {
                stateStack.push(action);
                nextEmbedding = action;
            }
            
            if(nextEmbedding < 0) {
                currentTransitionTable = trans_BASE;
                currentActionTable = act_BASE;
            } else {
                currentTransitionTable = transitionTables[nextEmbedding];
                currentActionTable = actionTables[nextEmbedding];
            }
        }
        
        private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {
            if(mpatNum >= reverseTransitionTables.length) {
                //don't need to clean end pattern matches - they aren't looked at
                return new java.util.ArrayList<Integer>(rawMatch);
            }
            
            java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();
            Integer[][] transitions = reverseTransitionTables[mpatNum];
            Integer[] actions = reverseActionTables[mpatNum];
            int dfaState = 0;
            for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {
                int sym = rawMatch.get(i);
                cleanMatch.add(sym);
                dfaState = transitions[dfaState][sym];
            }
            java.util.Collections.reverse(cleanMatch);
            return cleanMatch;
        }
        
        public static class Transition {
            private final int embeddingNum;
            private final java.util.List<Integer> match;
            
            public Transition(int embeddingNum, java.util.List<Integer> match) {
                this.embeddingNum = embeddingNum;
                this.match = new java.util.ArrayList<Integer>(match);
            }
            
            public int getEmbeddingNum() { return embeddingNum; }
            
            public java.util.List<Integer> getMatch() { return match; }
        }
        
    }
%}

%{
    private static class PairFilter {
        public static final PairFilter EMPTY = new PairFilter.Builder().build();
        
        private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
        private final java.util.Set<Integer> allOpenSymbols;
        private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards
        
        private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {
            this.pairMap = pairMap;
            this.allOpenSymbols = allOpenSymbols;
            this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();
        }
        
        public static class Builder {
            private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open
            private final java.util.Set<Integer> allOpenSymbols;
            
            public Builder() {
                this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();
                this.allOpenSymbols = new java.util.HashSet<Integer>();
            }
            
            public Builder add(int open, int close) {
                allOpenSymbols.add(open);
                java.util.Set<Integer> list = pairMap.get(close);
                if(list == null) {
                    list = new java.util.HashSet<Integer>();
                    pairMap.put(close, list);
                }
                list.add(open);
                return this;
            }
            
            public PairFilter build() {
                return new PairFilter(pairMap, allOpenSymbols);
            }
        }
        
        public boolean test(int sym) {
            //NB: closing-ness takes precedence over opening-ness
            java.util.Set<Integer> correspondingOpens = pairMap.get(sym);
            if(correspondingOpens != null) { //implies closing
                for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {
                    int open = it.next();
                    if(correspondingOpens.contains(open)) {
                        //if closing and have seen corresponding open, then close open and reject
                        it.remove();
                        return false;
                    }
                }
                //if closing and have not seen corresponding open, then accept
            }
            if(allOpenSymbols.contains(sym)) { //implies opening
                unclosedOpenSymbols.add(0, sym); //insert at beginning
            }
            return true;
        }
        
        public void clean(java.util.List<Integer> match) {
            java.util.Collections.reverse(match);
            for(int sym : match) {
                if(unclosedOpenSymbols.isEmpty()) {
                    return;
                }
                
                if(unclosedOpenSymbols.get(0) == sym) {
                    unclosedOpenSymbols.remove(0);
                }
            }
        }
        
        public void reset() {
            unclosedOpenSymbols.clear();
        }
    }
%}

%{
    public class EmbeddingRecord {
        private final String name;
        private final ComponentInnerClass comp;
        private final PairFilter filter;
        
        public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {
            this.name = name;
            this.comp = comp;
            this.filter = filter;
        }
        
        public String getName() {
            return name;
        }
        
        public ComponentInnerClass getComp() {
            return comp;
        }
        
        public PairFilter getFilter() {
            return filter;
        }
    }
%}

%{
    private static abstract class Maybe<T> {
        @SuppressWarnings("unchecked")
        private final static Maybe NOTHING = new Nothing();
        
        private Maybe() {}
        
        public final boolean isNothing() {
            return !isJust();
        }
        public abstract boolean isJust();
        
        public abstract T fromJust();
        
        public static <S> Maybe<S> Just(S value) {
            return new Just<S>(value);
        }
        
        @SuppressWarnings("unchecked")
        public static <S> Maybe<S> Nothing() {
            return (Nothing<S>) NOTHING;
        }
        
        private static class Just<T> extends Maybe<T> {
            private T value;
            
            private Just(T value) {
                this.value = value;
            }
            
            public boolean isJust() {
                return true;
            }
            
            public T fromJust() {
                return value;
            }
            
            public String toString() { 
                return "Just " + value;
            }
        }
        
        private static class Nothing<T> extends Maybe<T> {
            private Nothing() {}
            
            public boolean isJust() {
                return false;
            }
            
            public T fromJust() {
                throw new UnsupportedOperationException("Cannot extract value from Nothing");
            }
            
            public String toString() {
                return "Nothing";
            }
        }
    }
%}

%xstate EXTRA_RETURN

//from test/backend-jflex/in/natlab/attributes.mlc [1, 1]
%state attributes_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/leading_ws.mlc [1, 1]
%state leading_ws_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/base.mlc [1, 1]
%state base_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/attributed_class.mlc [1, 1]
%state attributed_class_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/class_bracketed.mlc [1, 1]
%state class_bracketed_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/field_name.mlc [1, 1]
%state field_name_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/comma_terminator.mlc [1, 1]
%state comma_terminator_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/semicolon_terminator.mlc [1, 1]
%state semicolon_terminator_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/string.mlc [1, 1]
%state string_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/transpose.mlc [1, 1]
%state transpose_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/bracket_comment.mlc [1, 1]
%state bracket_comment_YYINITIAL_STATE
//from test/backend-jflex/in/natlab/bracket_help_comment.mlc [1, 1]
%state bracket_help_comment_YYINITIAL_STATE

m_leading_ws_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_leading_ws_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_base_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_base_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_base_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_base_EscapedLineTerminator = {m_base_Ellipsis}(.)*{m_base_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_base_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_base_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_base_HexDigit = ({m_base_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_base_Identifier = ([_$] | {m_base_Letter})((([_$] | {m_base_Letter}) | {m_base_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_base_SciExp = [Ee]([+\-])?({m_base_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_base_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_base_IntNumber = ({m_base_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_base_FPNumber = (({m_base_Digit})+(\.)?({m_base_Digit})* | (\.)?({m_base_Digit})+)({m_base_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_base_HexNumber = 0[xX]({m_base_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_base_ImaginaryIntNumber = ({m_base_Digit})+{m_base_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_base_ImaginaryFPNumber = (({m_base_Digit})+(\.)?({m_base_Digit})* | (\.)?({m_base_Digit})+)({m_base_SciExp})?{m_base_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_base_ImaginaryHexNumber = 0[xX]({m_base_HexDigit})+{m_base_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_base_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_base_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_base_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_base_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_base_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_attributed_class_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_attributed_class_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_attributed_class_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_attributed_class_EscapedLineTerminator = {m_attributed_class_Ellipsis}(.)*{m_attributed_class_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_attributed_class_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_attributed_class_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_attributed_class_HexDigit = ({m_attributed_class_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_attributed_class_Identifier = ([_$] | {m_attributed_class_Letter})((([_$] | {m_attributed_class_Letter}) | {m_attributed_class_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_attributed_class_SciExp = [Ee]([+\-])?({m_attributed_class_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_attributed_class_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_attributed_class_IntNumber = ({m_attributed_class_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_attributed_class_FPNumber = (({m_attributed_class_Digit})+(\.)?({m_attributed_class_Digit})* | (\.)?({m_attributed_class_Digit})+)({m_attributed_class_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_attributed_class_HexNumber = 0[xX]({m_attributed_class_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_attributed_class_ImaginaryIntNumber = ({m_attributed_class_Digit})+{m_attributed_class_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_attributed_class_ImaginaryFPNumber = (({m_attributed_class_Digit})+(\.)?({m_attributed_class_Digit})* | (\.)?({m_attributed_class_Digit})+)({m_attributed_class_SciExp})?{m_attributed_class_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_attributed_class_ImaginaryHexNumber = 0[xX]({m_attributed_class_HexDigit})+{m_attributed_class_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_attributed_class_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_attributed_class_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_attributed_class_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_attributed_class_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_attributed_class_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_class_bracketed_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_class_bracketed_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_class_bracketed_Ellipsis = \.\.\. //from test/backend-jflex/in/natlab/macros.mlc [9, 1]
m_class_bracketed_EscapedLineTerminator = {m_class_bracketed_Ellipsis}(.)*{m_class_bracketed_LineTerminator} //from test/backend-jflex/in/natlab/macros.mlc [10, 1]
m_class_bracketed_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_class_bracketed_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_class_bracketed_HexDigit = ({m_class_bracketed_Digit} | [a-fA-F]) //from test/backend-jflex/in/natlab/macros.mlc [14, 1]
m_class_bracketed_Identifier = ([_$] | {m_class_bracketed_Letter})((([_$] | {m_class_bracketed_Letter}) | {m_class_bracketed_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_class_bracketed_SciExp = [Ee]([+\-])?({m_class_bracketed_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [16, 1]
m_class_bracketed_Imaginary = [iIjJ] //from test/backend-jflex/in/natlab/macros.mlc [17, 1]
m_class_bracketed_IntNumber = ({m_class_bracketed_Digit})+ //from test/backend-jflex/in/natlab/macros.mlc [18, 1]
m_class_bracketed_FPNumber = (({m_class_bracketed_Digit})+(\.)?({m_class_bracketed_Digit})* | (\.)?({m_class_bracketed_Digit})+)({m_class_bracketed_SciExp})? //from test/backend-jflex/in/natlab/macros.mlc [19, 1]
m_class_bracketed_HexNumber = 0[xX]({m_class_bracketed_HexDigit})+ //from test/backend-jflex/in/natlab/macros.mlc [20, 1]
m_class_bracketed_ImaginaryIntNumber = ({m_class_bracketed_Digit})+{m_class_bracketed_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [21, 1]
m_class_bracketed_ImaginaryFPNumber = (({m_class_bracketed_Digit})+(\.)?({m_class_bracketed_Digit})* | (\.)?({m_class_bracketed_Digit})+)({m_class_bracketed_SciExp})?{m_class_bracketed_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [22, 1]
m_class_bracketed_ImaginaryHexNumber = 0[xX]({m_class_bracketed_HexDigit})+{m_class_bracketed_Imaginary} //from test/backend-jflex/in/natlab/macros.mlc [23, 1]
m_class_bracketed_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_class_bracketed_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_class_bracketed_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_class_bracketed_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_class_bracketed_ShellCommand = [!](.)* //from test/backend-jflex/in/natlab/macros.mlc [31, 1]
m_field_name_Letter = [a-zA-Z] //from test/backend-jflex/in/natlab/macros.mlc [12, 1]
m_field_name_Digit = [0-9] //from test/backend-jflex/in/natlab/macros.mlc [13, 1]
m_field_name_Identifier = ([_$] | {m_field_name_Letter})((([_$] | {m_field_name_Letter}) | {m_field_name_Digit}))* //from test/backend-jflex/in/natlab/macros.mlc [15, 1]
m_field_name_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_field_name_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_field_name_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_field_name_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_comma_terminator_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_comma_terminator_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_comma_terminator_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_comma_terminator_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_comma_terminator_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_comma_terminator_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_semicolon_terminator_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_semicolon_terminator_OtherWhiteSpace = [ \t\f] //from test/backend-jflex/in/natlab/macros.mlc [6, 1]
m_semicolon_terminator_HelpComment = (%% | %%[^{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [25, 1]
m_semicolon_terminator_OpenBracketHelpComment = %%\{ //from test/backend-jflex/in/natlab/macros.mlc [26, 1]
m_semicolon_terminator_Comment = (% | %[^%{\r\n](.)*) //from test/backend-jflex/in/natlab/macros.mlc [27, 1]
m_semicolon_terminator_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_string_LineTerminator = ((\r | \n) | \r\n) //from test/backend-jflex/in/natlab/macros.mlc [5, 1]
m_string_ValidEscape = \\[bfnrt\\\"] //from test/backend-jflex/in/natlab/macros.mlc [33, 1]
m_bracket_comment_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_bracket_comment_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]
m_bracket_help_comment_OpenBracketComment = %\{ //from test/backend-jflex/in/natlab/macros.mlc [28, 1]
m_bracket_help_comment_CloseBracketComment = %\} //from test/backend-jflex/in/natlab/macros.mlc [29, 1]

%%

<EXTRA_RETURN> {
    (. | \n) {
        yybegin(state_attributed_natlab.getPrevState());
        return state_attributed_natlab.getExtraReturn();
    }
    
    <<EOF>> {
        yybegin(state_attributed_natlab.getPrevState());
        return state_attributed_natlab.getExtraReturn();
    }
}

<attributes_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/attributes.mlc [7, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [9, 1]
    attr1 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [10, 1]
    attr2 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [12, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [14, 1]
    val1 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [15, 1]
    val2 {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributes.attributes_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributes.mlc [17, 1]
    ")" {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributes.attributes_action_7();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<leading_ws_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/leading_ws.mlc [6, 1]
    {m_leading_ws_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/leading_ws.mlc [7, 1]
    {m_leading_ws_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_2();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<leading_ws_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/leading_ws.mlc [10, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_3();
        } finally {
            state_attributed_natlab.processMTok(14); //END_LEADING_WS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/leading_ws.mlc [11, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_leading_ws.leading_ws_action_4();
        } finally {
            state_attributed_natlab.processMTok(14); //END_LEADING_WS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_base_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_1();
        } finally {
            state_attributed_natlab.processMTok(15); //START_BRACKET_HELP_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_base_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_2();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 1]
    {m_base_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [48, 1]
    {m_base_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [51, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_5();
        } finally {
            state_attributed_natlab.processMTok(17); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 1]
    \( {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_6();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 1]
    \) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_7();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_8();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 1]
    \] {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_9();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_10();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 1]
    \} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_11();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 1]
    , {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_12();
        } finally {
            state_attributed_natlab.processMTok(19); //START_COMMA_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 1]
    ; {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_13();
        } finally {
            state_attributed_natlab.processMTok(20); //START_SEMICOLON_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 1]
    : {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 1]
    @ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 1]
    ".*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 1]
    "/" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 1]
    "./" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 1]
    "\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 1]
    ".\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 1]
    ".^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 1]
    ".'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 1]
    "<=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 1]
    ">=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 1]
    "<" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 1]
    ">" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 1]
    "==" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 1]
    "~=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 1]
    "&&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 1]
    "||" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/base.mlc [8, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_39();
        } finally {
            state_attributed_natlab.processMTok(21); //START_CLASS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/base.mlc [9, 1]
    end {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_40();
        } finally {
            state_attributed_natlab.processMTok(22); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 1]
    case {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_41();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 1]
    for {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_42();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 1]
    function {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_43();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 1]
    if {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_44();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 1]
    parfor {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_45();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 1]
    switch {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_46();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 1]
    try {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_47();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 1]
    while {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_48();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 1]
    break {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_49();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 1]
    catch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_50();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 1]
    continue {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_51();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 1]
    else {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 1]
    elseif {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 1]
    global {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 1]
    otherwise {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 1]
    persistent {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 1]
    return {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 1]
    \. {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_59();
        } finally {
            state_attributed_natlab.processMTok(24); //START_FIELD_NAME
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_base_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_60();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_base_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_61();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 1]
    {m_base_EscapedLineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_62();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 1]
    {m_base_IntNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_63();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 1]
    {m_base_FPNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_64();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 1]
    {m_base_HexNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_65();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 1]
    {m_base_ImaginaryIntNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_66();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 1]
    {m_base_ImaginaryFPNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_67();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 1]
    {m_base_ImaginaryHexNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_68();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 1]
    {m_base_ShellCommand} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_69();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 1]
    {m_base_Identifier} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_base.base_action_70();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<base_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/base.mlc [14, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_71();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/base.mlc [15, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_base.base_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<attributed_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_attributed_class_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_1();
        } finally {
            state_attributed_natlab.processMTok(15); //START_BRACKET_HELP_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_attributed_class_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_2();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 1]
    {m_attributed_class_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [48, 1]
    {m_attributed_class_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [51, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_5();
        } finally {
            state_attributed_natlab.processMTok(17); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 1]
    \( {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_6();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 1]
    \) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_7();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_8();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 1]
    \] {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_9();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_10();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 1]
    \} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_11();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 1]
    , {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_12();
        } finally {
            state_attributed_natlab.processMTok(19); //START_COMMA_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 1]
    ; {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_13();
        } finally {
            state_attributed_natlab.processMTok(20); //START_SEMICOLON_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 1]
    : {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 1]
    @ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 1]
    ".*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 1]
    "/" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 1]
    "./" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 1]
    "\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 1]
    ".\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 1]
    ".^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 1]
    ".'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 1]
    "<=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 1]
    ">=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 1]
    "<" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 1]
    ">" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 1]
    "==" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 1]
    "~=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 1]
    "&&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 1]
    "||" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class.mlc [11, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_39();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class.mlc [12, 1]
    end {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_40();
        } finally {
            state_attributed_natlab.processMTok(22); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 1]
    case {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_41();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 1]
    for {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_42();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 1]
    function {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_43();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 1]
    if {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_44();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 1]
    parfor {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_45();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 1]
    switch {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_46();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 1]
    try {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_47();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 1]
    while {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_48();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 1]
    break {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_49();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 1]
    catch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_50();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 1]
    continue {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_51();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 1]
    else {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 1]
    elseif {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 1]
    global {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 1]
    otherwise {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 1]
    persistent {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 1]
    return {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 1]
    \. {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_59();
        } finally {
            state_attributed_natlab.processMTok(24); //START_FIELD_NAME
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributed_class.mlc [9, 1]
    properties {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_60();
        } finally {
            state_attributed_natlab.processMTok(26); //PROPERTIES
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributed_class.mlc [10, 1]
    methods {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_61();
        } finally {
            state_attributed_natlab.processMTok(27); //METHODS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/attributed_class.mlc [11, 1]
    events {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_62();
        } finally {
            state_attributed_natlab.processMTok(28); //EVENTS
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<attributed_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_attributed_class_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_63();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_attributed_class_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_64();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 1]
    {m_attributed_class_EscapedLineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_65();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 1]
    {m_attributed_class_IntNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_66();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 1]
    {m_attributed_class_FPNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_67();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 1]
    {m_attributed_class_HexNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_68();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 1]
    {m_attributed_class_ImaginaryIntNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_69();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 1]
    {m_attributed_class_ImaginaryFPNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_70();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 1]
    {m_attributed_class_ImaginaryHexNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_71();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 1]
    {m_attributed_class_ShellCommand} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 1]
    {m_attributed_class_Identifier} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_73();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<attributed_class_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/class.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_74();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_attributed_class.attributed_class_action_75();
        } finally {
            state_attributed_natlab.processMTok(22); //END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<class_bracketed_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_class_bracketed_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_1();
        } finally {
            state_attributed_natlab.processMTok(15); //START_BRACKET_HELP_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_class_bracketed_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_2();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [47, 1]
    {m_class_bracketed_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [48, 1]
    {m_class_bracketed_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [51, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_5();
        } finally {
            state_attributed_natlab.processMTok(17); //START_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [54, 1]
    \( {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_6();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [55, 1]
    \) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_7();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [56, 1]
    \[ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_8();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [57, 1]
    \] {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_9();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [58, 1]
    \{ {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_10();
        } finally {
            state_attributed_natlab.processMTok(18); //START_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [59, 1]
    \} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_11();
        } finally {
            state_attributed_natlab.processMTok(13); //END_BRACKETED
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [62, 1]
    , {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_12();
        } finally {
            state_attributed_natlab.processMTok(19); //START_COMMA_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [63, 1]
    ; {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_13();
        } finally {
            state_attributed_natlab.processMTok(20); //START_SEMICOLON_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [66, 1]
    : {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_14();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [67, 1]
    @ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_15();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [70, 1]
    "+" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_16();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [71, 1]
    "-" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_17();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [72, 1]
    "*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_18();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [73, 1]
    ".*" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_19();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [74, 1]
    "/" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_20();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [75, 1]
    "./" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_21();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [76, 1]
    "\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_22();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [77, 1]
    ".\\" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_23();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [78, 1]
    "^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_24();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [79, 1]
    ".^" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_25();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [81, 1]
    ".'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_26();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [84, 1]
    "<=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_27();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [85, 1]
    ">=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_28();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [86, 1]
    "<" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_29();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [87, 1]
    ">" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_30();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [88, 1]
    "==" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_31();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [89, 1]
    "~=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_32();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [92, 1]
    "&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_33();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [93, 1]
    "|" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_34();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [94, 1]
    "~" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_35();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [95, 1]
    "&&" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_36();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [96, 1]
    "||" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_37();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [98, 1]
    "=" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_38();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [11, 1]
    classdef {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_39();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [12, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_40();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [14, 1]
    properties {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_41();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [15, 1]
    methods {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_42();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [16, 1]
    events {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_43();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [11, 1]
    case {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_44();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [12, 1]
    for {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_45();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [13, 1]
    function {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_46();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [14, 1]
    if {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_47();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [15, 1]
    parfor {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_48();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [16, 1]
    switch {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_49();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [17, 1]
    try {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_50();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [18, 1]
    while {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_51();
        } finally {
            state_attributed_natlab.processMTok(23); //OPEN_END
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [20, 1]
    break {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_52();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [21, 1]
    catch {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_53();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [22, 1]
    continue {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_54();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [23, 1]
    else {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_55();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [24, 1]
    elseif {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_56();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [25, 1]
    end {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_57();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [26, 1]
    global {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_58();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [27, 1]
    otherwise {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_59();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [28, 1]
    persistent {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_60();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [29, 1]
    return {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_61();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [31, 1]
    \. {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_62();
        } finally {
            state_attributed_natlab.processMTok(24); //START_FIELD_NAME
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<class_bracketed_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_class_bracketed_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_63();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_class_bracketed_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_64();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [103, 1]
    {m_class_bracketed_EscapedLineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_65();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [108, 1]
    {m_class_bracketed_IntNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_66();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [109, 1]
    {m_class_bracketed_FPNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_67();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [110, 1]
    {m_class_bracketed_HexNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_68();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [111, 1]
    {m_class_bracketed_ImaginaryIntNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_69();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [112, 1]
    {m_class_bracketed_ImaginaryFPNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_70();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [113, 1]
    {m_class_bracketed_ImaginaryHexNumber} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_71();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_symbols.mlc [116, 1]
    {m_class_bracketed_ShellCommand} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_72();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/shared_keywords.mlc [36, 1]
    {m_class_bracketed_Identifier} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_73();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<class_bracketed_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [21, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_74();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/class_bracketed.mlc [22, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_class_bracketed.class_bracketed_action_75();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<field_name_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_field_name_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_field_name.field_name_action_1();
        } finally {
            state_attributed_natlab.processMTok(15); //START_BRACKET_HELP_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_field_name_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_field_name.field_name_action_2();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<field_name_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_field_name_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_field_name_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_field_name.field_name_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/field_name.mlc [12, 1]
    {m_field_name_Identifier} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_field_name.field_name_action_5();
        } finally {
            state_attributed_natlab.processMTok(25); //START_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<field_name_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/field_name.mlc [16, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_field_name.field_name_action_6();
        } finally {
            state_attributed_natlab.processMTok(29); //END_FIELD_NAME
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/field_name.mlc [17, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_field_name.field_name_action_7();
        } finally {
            state_attributed_natlab.processMTok(29); //END_FIELD_NAME
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<comma_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_comma_terminator_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_1();
        } finally {
            state_attributed_natlab.processMTok(15); //START_BRACKET_HELP_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_comma_terminator_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_2();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [12, 1]
    {m_comma_terminator_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [13, 1]
    {m_comma_terminator_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_4();
        } finally {
            state_attributed_natlab.processMTok(30); //END_COMMA_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<comma_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_comma_terminator_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_comma_terminator_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<comma_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_7();
        } finally {
            state_attributed_natlab.processMTok(30); //END_COMMA_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comma_terminator.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_comma_terminator.comma_terminator_action_8();
        } finally {
            state_attributed_natlab.processMTok(30); //END_COMMA_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<semicolon_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [12, 1]
    {m_semicolon_terminator_OpenBracketHelpComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_1();
        } finally {
            state_attributed_natlab.processMTok(15); //START_BRACKET_HELP_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [13, 1]
    {m_semicolon_terminator_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_2();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [12, 1]
    {m_semicolon_terminator_OtherWhiteSpace} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [13, 1]
    {m_semicolon_terminator_LineTerminator} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_4();
        } finally {
            state_attributed_natlab.processMTok(31); //END_SEMICOLON_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<semicolon_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/comment_start.mlc [16, 1]
    {m_semicolon_terminator_HelpComment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/comment_start.mlc [17, 1]
    {m_semicolon_terminator_Comment} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<semicolon_terminator_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_7();
        } finally {
            state_attributed_natlab.processMTok(31); //END_SEMICOLON_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/semicolon_terminator.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_semicolon_terminator.semicolon_terminator_action_8();
        } finally {
            state_attributed_natlab.processMTok(31); //END_SEMICOLON_TERMINATOR
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/string.mlc [13, 1]
    "''" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [14, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_string.string_action_2();
        } finally {
            state_attributed_natlab.processMTok(32); //END_STRING
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [15, 1]
    {m_string_ValidEscape} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [16, 1]
    \\ {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [17, 1]
    {m_string_LineTerminator} {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_5();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<string_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/string.mlc [20, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_6();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/string.mlc [21, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_string.string_action_7();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<transpose_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/transpose.mlc [7, 1]
    "'" {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_transpose.transpose_action_1();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<transpose_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/transpose.mlc [10, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_transpose.transpose_action_2();
        } finally {
            state_attributed_natlab.processMTok(33); //END_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/transpose.mlc [11, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_transpose.transpose_action_3();
        } finally {
            state_attributed_natlab.processMTok(33); //END_TRANSPOSE
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [14, 1]
    {m_bracket_comment_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_1();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [15, 1]
    {m_bracket_comment_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_2();
        } finally {
            state_attributed_natlab.processMTok(34); //END_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [18, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_comment.mlc [19, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_comment.bracket_comment_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_help_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [15, 1]
    {m_bracket_help_comment_OpenBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_1();
        } finally {
            state_attributed_natlab.processMTok(16); //START_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [16, 1]
    {m_bracket_help_comment_CloseBracketComment} {
        Maybe<? extends Symbol> maybeResult;
        try {
            maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_2();
        } finally {
            state_attributed_natlab.processMTok(34); //END_BRACKET_COMMENT
        }
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}

<bracket_help_comment_YYINITIAL_STATE> {
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [19, 1]
    (. | \n) {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_3();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
    //from test/backend-jflex/in/natlab/bracket_help_comment.mlc [20, 1]
    <<EOF>> {
        Maybe<? extends Symbol> maybeResult = state_attributed_natlab.inst_bracket_help_comment.bracket_help_comment_action_4();
        if(maybeResult.isJust()) {
            return maybeResult.fromJust();
        }
    }
}


