/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.Parser;
import beaver.comp.Action;
import beaver.comp.Configuration;
import beaver.comp.ParsingTables;
import beaver.comp.State;
import beaver.comp.io.SrcReader;
import beaver.comp.run.Options;
import beaver.comp.util.BitSet;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.GrammarBuilder;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import beaver.spec.ast.GrammarTreeRoot;
import beaver.spec.parser.GrammarParser;
import beaver.spec.parser.GrammarScanner;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.DeflaterOutputStream;

public class ParserGenerator {
    public static final String VERSION = "0.9.6.1";
    public static final String SOURCE_FILE_EXT = ".java";
    public static final String SERIALIZED_PARSER_TABLES_FILE_EXT = ".spec";
    public static final String PARSER_ACTIONS_REPORT_FILE_EXT = ".stat";

    public static void compile(SrcReader src, Options opt, Log log) throws IOException, Parser.Exception, Grammar.Exception {
        Grammar grammar = ParserGenerator.parseGrammar(src, log);
        if (!log.hasErrors()) {
            CompiledParser parser = ParserGenerator.compile(grammar, opt, log);
            if (!log.hasErrors()) {
                File dir = src.file.getParentFile();
                if (opt.dest_dir != null) {
                    dir = opt.dest_dir;
                    if (grammar.package_name != null && !(dir = new File(dir, grammar.package_name.replace('.', File.separatorChar))).exists()) {
                        dir.mkdirs();
                    }
                }
                String output_file_name = ParserGenerator.getOutputFileName(grammar, src.file);
                if (opt.report_actions) {
                    parser.writeActionsReport(dir, output_file_name);
                    log.message("Generated: " + output_file_name + PARSER_ACTIONS_REPORT_FILE_EXT);
                }
                if (!opt.no_output) {
                    parser.writeParserSource(src.file, dir, output_file_name, opt);
                    log.message("Generated: " + output_file_name + SOURCE_FILE_EXT);
                    if (opt.export_terminals) {
                        parser.writeTerminalsSource(src.file, dir, "Terminals", opt);
                        log.message("Generated: Terminals.java");
                    }
                    if (opt.exp_parsing_tables) {
                        parser.writeParsingTables(dir, output_file_name);
                        log.message("Generated: " + output_file_name + SERIALIZED_PARSER_TABLES_FILE_EXT);
                    }
                }
            }
        }
    }

    public static Grammar parseGrammar(SrcReader reader, Log log) throws IOException, Parser.Exception, Grammar.Exception {
        GrammarTreeRoot root = (GrammarTreeRoot)new GrammarParser(log).parse(new GrammarScanner(reader));
        if (log.hasErrors()) {
            throw new Grammar.Exception("cannot parse grammar");
        }
        GrammarBuilder maker = new GrammarBuilder(log);
        root.accept(maker);
        return maker.getGrammar();
    }

    public static CompiledParser compile(Grammar grammar, Options opts, Log log) throws Grammar.Exception {
        grammar.markNullableProductions();
        grammar.buildFirstSets();
        State first = ParserGenerator.makeStates(grammar);
        ParserGenerator.findLookaheads(first);
        ParserGenerator.buildActions(grammar, first);
        ParserGenerator.checkAndResolveConflicts(first, log);
        ParserGenerator.checkUnreducibleProductions(grammar, first, log);
        if (!opts.no_compression) {
            ParserGenerator.compressActions(first);
        }
        ParserGenerator.splitActions(first);
        return new CompiledParser(grammar, new ParsingTables(grammar, first));
    }

    private static State makeStates(Grammar grammar) {
        State first;
        Configuration.Set.Factory conf_set_factory = new Configuration.Set.Factory(grammar);
        Production rule = grammar.goal_symbol.definitions.start();
        while (rule != null) {
            Configuration conf = conf_set_factory.addConfiguration(rule, 0);
            conf.addLookahead(grammar.eof);
            rule = rule.next_definition;
        }
        State state = first = new State.Factory(conf_set_factory).getState(conf_set_factory.getCore());
        while (state != null) {
            state.conf_set.reverseReversePropagation();
            state.conf_set.resetContributionFlags();
            state = state.next;
        }
        return first;
    }

    private static void findLookaheads(State first) {
        boolean more_found;
        do {
            more_found = false;
            State state = first;
            while (state != null) {
                if (state.findLookaheads()) {
                    more_found = true;
                }
                state = state.next;
            }
        } while (more_found);
    }

    private static void buildActions(Grammar grammar, State first) {
        new Action.Reduce.Maker(grammar.terminals, first).buildReduceActions();
        first.actions.add(new Action.Accept(grammar));
    }

    private static void checkAndResolveConflicts(State first, Log log) throws Grammar.Exception {
        int num_conflicts = 0;
        State state = first;
        while (state != null) {
            num_conflicts += state.actions.resolveConflicts(log);
            state = state.next;
        }
        if (num_conflicts > 0) {
            state = first;
            while (state != null) {
                state.actions.reportConflicts(log);
                state = state.next;
            }
            throw new Grammar.Exception("grammar has conflicts");
        }
    }

    private static void checkUnreducibleProductions(Grammar grammar, State first, Log log) throws Grammar.Exception {
        State state = first;
        while (state != null) {
            state.actions.markReducibleProductions();
            state = state.next;
        }
        boolean has_unreducible = false;
        int i = 0;
        while (i < grammar.rules.length) {
            Production rule = grammar.rules[i];
            if (!rule.is_reducible) {
                log.error(rule.start_pos, rule.end_pos, "Production \"" + rule.toString() + "\" can not be reduced");
                has_unreducible = true;
            }
            ++i;
        }
        if (has_unreducible) {
            throw new Grammar.Exception("grammar has unreducible productions");
        }
    }

    private static void compressActions(State first) {
        State state = first;
        while (state != null) {
            state.actions.compress();
            state = state.next;
        }
    }

    private static void splitActions(State first) {
        State state = first;
        while (state != null) {
            state.splitActions();
            state = state.next;
        }
    }

    public static String getOutputFileName(Grammar grammar, File src_file) {
        if (grammar.class_name != null) {
            return grammar.class_name;
        }
        String spec_file_name = src_file.getName();
        int dot_index = spec_file_name.lastIndexOf(46);
        if (dot_index > 0) {
            spec_file_name = spec_file_name.substring(0, dot_index);
        }
        return spec_file_name;
    }

    public static class CompiledParser {
        private static final Comparator TERMINAL_NAME_CMP = new Comparator(){

            public int compare(Object o1, Object o2) {
                Terminal term1 = (Terminal)o1;
                Terminal term2 = (Terminal)o2;
                return term1.id == 0 ? -1 : term1.name.compareTo(term2.name);
            }
        };
        private static final char[] _62_or_63 = new char[]{'#', '$'};
        private Grammar grammar;
        private ParsingTables tables;
        private int[] rule_descr;

        private static int[] makeProductionDescriptors(Grammar grammar) {
            int[] rules = new int[grammar.rules.length];
            int i = 0;
            while (i < grammar.rules.length) {
                Production rule = grammar.rules[i];
                rules[i] = rule.lhs.id << 16 | rule.rhs.items.length;
                ++i;
            }
            return rules;
        }

        private static void writeTerminalsClass(Grammar grammar, Options opts, String indent, Writer out) throws IOException {
            Terminal[] terms;
            out.write(indent);
            if (indent.length() > 0) {
                out.write("static ");
            }
            out.write("public class Terminals {\n");
            if (opts.sort_terminals) {
                terms = new Terminal[grammar.terminals.length];
                System.arraycopy(grammar.terminals, 0, terms, 0, terms.length);
                Arrays.sort(terms, TERMINAL_NAME_CMP);
            } else {
                terms = grammar.terminals;
            }
            int i = 0;
            while (i < terms.length) {
                if (terms[i].name.charAt(0) != '$') {
                    out.write(indent);
                    out.write("\tstatic public final short ");
                    out.write(terms[i].name);
                    out.write(" = ");
                    out.write(String.valueOf(terms[i].id));
                    out.write(";\n");
                }
                ++i;
            }
            if (opts.terminal_names) {
                terms = grammar.terminals;
                out.write(10);
                out.write(indent);
                out.write("\tstatic public final String[] NAMES = {\n");
                i = 0;
                while (i < terms.length - 1) {
                    if (terms[i].name.charAt(0) != '$') {
                        out.write(indent);
                        out.write("\t\t\"");
                        out.write(terms[i].name);
                        out.write("\",\n");
                    }
                    ++i;
                }
                if (terms.length > 0 && terms[terms.length - 1].name.charAt(0) != '$') {
                    out.write(indent);
                    out.write("\t\t\"");
                    out.write(terms[terms.length - 1].name);
                    out.write("\"\n");
                }
                out.write(indent);
                out.write("\t};\n");
            }
            out.write(indent);
            out.write("}\n");
        }

        private static boolean writeMarkersClass(Terminal[] terms, Writer out) throws IOException {
            boolean header_is_out = false;
            int i = 0;
            while (i < terms.length) {
                if (terms[i].name.charAt(0) == '$') {
                    if (!header_is_out) {
                        out.write("\tstatic public class AltGoals {\n");
                        header_is_out = true;
                    }
                    out.write("\t\tstatic public final short ");
                    out.write(terms[i].name.substring(1));
                    out.write(" = ");
                    out.write(String.valueOf(terms[i].id));
                    out.write(";\n");
                }
                ++i;
            }
            if (header_is_out) {
                out.write("\t}\n");
            }
            return header_is_out;
        }

        private static void writeReduceActionClasses(Grammar grammar, Writer out) throws IOException {
            int i = 0;
            while (i < grammar.rules.length) {
                Production rule = grammar.rules[i];
                if (rule.code != null) {
                    out.write("\n\t/**");
                    out.write("\n\t * ");
                    out.write(rule.toString());
                    out.write("\n\t */");
                    out.write("\n\tfinal class Action");
                    out.write(String.valueOf(rule.id));
                    out.write(" extends Action {\n");
                    out.write("\t\t\t\tpublic Symbol reduce(Symbol[] _symbols, int offset) {\n");
                    CompiledParser.writeReduceActionCode(rule, out);
                    out.write("\t\t\t\t}");
                    out.write("\n\t}\n");
                }
                ++i;
            }
        }

        private static void writeStaticReturns(Grammar grammar, Writer out) throws IOException {
            BitSet ret_elems = new BitSet();
            int i = 0;
            while (i < grammar.rules.length) {
                int n;
                Production rule = grammar.rules[i];
                if (rule.code == null && rule.rhs.size() > 1 && (n = CompiledParser.indexOfLastReferencedSymbol(rule.rhs)) != 0) {
                    if (n < 0) {
                        n = rule.rhs.size() - 1;
                    }
                    if (ret_elems.add(n)) {
                        out.write("\n\tstatic final Action RETURN");
                        out.write(String.valueOf(n + 1));
                        out.write(" = new Action() {\n");
                        out.write("\t\tpublic Symbol reduce(Symbol[] _symbols, int offset) {\n");
                        out.write("\t\t\treturn _symbols[offset + ");
                        out.write(String.valueOf(n + 1));
                        out.write("];\n");
                        out.write("\t\t}\n");
                        out.write("\t};\n");
                    }
                }
                ++i;
            }
        }

        private static int countReferencedSymbols(Production.RHS rhs) {
            int c = 0;
            int i = 0;
            while (i < rhs.items.length) {
                if (rhs.items[i].alias != null) {
                    ++c;
                }
                ++i;
            }
            return c;
        }

        private static int indexOfLastReferencedSymbol(Production.RHS rhs) {
            int i = rhs.size();
            while (--i >= 0 && rhs.items[i].alias == null) {
            }
            return i;
        }

        private static void writeParserActionsArray(Grammar grammar, Options opts, Writer out) throws IOException {
            int i = 0;
            int last_i = grammar.rules.length - 1;
            while (i < grammar.rules.length) {
                Production rule = grammar.rules[i];
                out.write("\n\t\t\t");
                if (rule.code == null) {
                    if (rule.rhs.size() == 0) {
                        out.write("Action.NONE");
                        if (i != last_i) {
                            out.write(",  ");
                        }
                        out.write("\t// [");
                        out.write(String.valueOf(rule.id));
                        out.write("] ");
                        out.write(rule.toString());
                    } else if (rule.rhs.size() == 1) {
                        out.write("Action.RETURN");
                        if (i != last_i) {
                            out.write(44);
                        }
                        out.write("\t// [");
                        out.write(String.valueOf(rule.id));
                        out.write("] ");
                        out.write(rule.toString());
                    } else {
                        int n = CompiledParser.indexOfLastReferencedSymbol(rule.rhs);
                        if (n == 0) {
                            out.write("Action.RETURN");
                        } else if (n > 0) {
                            out.write("RETURN");
                            out.write(String.valueOf(n + 1));
                        } else {
                            out.write("RETURN");
                            out.write(String.valueOf(rule.rhs.size()));
                        }
                        if (i != last_i) {
                            out.write(44);
                        }
                        out.write("\t// [");
                        out.write(String.valueOf(rule.id));
                        out.write("] ");
                        out.write(rule.toString());
                        if (n < 0) {
                            out.write("; returns '");
                            out.write(rule.rhs.items[rule.rhs.size() - 1].symbol.name);
                            out.write("' although none is marked");
                        } else if (CompiledParser.countReferencedSymbols(rule.rhs) > 1) {
                            out.write("; returns '");
                            out.write(rule.rhs.items[n].alias);
                            out.write("' although more are marked");
                        }
                    }
                } else {
                    out.write("new Action");
                    if (opts.name_action_classes) {
                        out.write(String.valueOf(rule.id));
                        out.write("()");
                        if (i != last_i) {
                            out.write(44);
                        }
                        out.write("\t// [");
                        out.write(String.valueOf(rule.id));
                        out.write("] ");
                        out.write(rule.toString());
                    } else {
                        out.write("() {\t// [");
                        out.write(String.valueOf(rule.id));
                        out.write("] ");
                        out.write(rule.toString());
                        out.write(10);
                        out.write("\t\t\t\tpublic Symbol reduce(Symbol[] _symbols, int offset) {\n");
                        CompiledParser.writeReduceActionCode(rule, out);
                        out.write("\t\t\t\t}");
                        out.write("\n\t\t\t}");
                        if (i != last_i) {
                            out.write(44);
                        }
                    }
                }
                ++i;
            }
        }

        private static void writeParserActionsSwitch(Grammar grammar, Options opts, Writer out) throws IOException {
            out.write("\t\tswitch(rule_num) {\n");
            int n = grammar.rules.length;
            Production[] rules = new Production[n];
            System.arraycopy(grammar.rules, 0, rules, 0, n);
            int i = 0;
            while (i < rules.length) {
                if (rules[i].code != null) {
                    out.write("\t\t\tcase ");
                    out.write(String.valueOf(rules[i].id));
                    out.write(": // ");
                    out.write(rules[i].toString());
                    out.write("\n\t\t\t{\n");
                    CompiledParser.writeReduceActionCode(rules[i], out);
                    out.write("\t\t\t}\n");
                    rules[i] = null;
                    --n;
                }
                ++i;
            }
            int w = 0;
            while (n > 0) {
                int cnt = 0;
                int i2 = 0;
                while (i2 < rules.length) {
                    if (rules[i2] != null) {
                        int ref_off = CompiledParser.indexOfLastReferencedSymbol(rules[i2].rhs) + 1;
                        if (ref_off == 0) {
                            ref_off = rules[i2].rhs.size();
                        }
                        if (ref_off == w) {
                            out.write("\t\t\tcase ");
                            out.write(String.valueOf(rules[i2].id));
                            out.write(": // ");
                            out.write(rules[i2].toString());
                            out.write("\n");
                            rules[i2] = null;
                            --n;
                            ++cnt;
                        }
                    }
                    ++i2;
                }
                if (cnt > 0) {
                    out.write("\t\t\t{\n");
                    if (w == 0) {
                        out.write("\t\t\t\treturn new Symbol(null);\n");
                    } else {
                        out.write("\t\t\t\treturn _symbols[offset + ");
                        out.write(String.valueOf(w));
                        out.write("];\n");
                    }
                    out.write("\t\t\t}\n");
                }
                ++w;
            }
            out.write("\t\t\tdefault:\n");
            out.write("\t\t\t\tthrow new IllegalArgumentException(\"unknown production #\" + rule_num);\n");
            out.write("\t\t}\n");
        }

        private static void writeReduceActionCode(Production rule, Writer out) throws IOException {
            int i = 0;
            while (i < rule.rhs.items.length) {
                Production.RHS.Item rhs_item = rule.rhs.items[i];
                if (rhs_item.alias != null) {
                    out.write("\t\t\t\t\t");
                    String type = rhs_item.symbol.type;
                    if (type == null) {
                        out.write("final Symbol ");
                        out.write(rhs_item.alias);
                        out.write(" = _symbols[offset + ");
                        out.write(String.valueOf(i + 1));
                        out.write("];\n");
                    } else {
                        out.write("final Symbol _symbol_");
                        out.write(rhs_item.alias);
                        out.write(" = _symbols[offset + ");
                        out.write(String.valueOf(i + 1));
                        out.write("];\n");
                        if (type.charAt(0) == '+') {
                            type = type.substring(1);
                            out.write("\t\t\t\t\tfinal ");
                            out.write(Grammar.EBNF_LIST_TYPE_NAME);
                            out.write(" _list_");
                            out.write(rhs_item.alias);
                            out.write(" = (");
                            out.write(Grammar.EBNF_LIST_TYPE_NAME);
                            out.write(") _symbol_");
                            out.write(rhs_item.alias);
                            out.write(".value;\n");
                            out.write("\t\t\t\t\tfinal ");
                            out.write(type);
                            out.write("[] ");
                            out.write(rhs_item.alias);
                            out.write(" = _list_");
                            out.write(rhs_item.alias);
                            out.write(" == null ? new ");
                            out.write(type);
                            out.write("[0] : (");
                            out.write(type);
                            out.write("[]) _list_");
                            out.write(rhs_item.alias);
                            out.write(".toArray(new ");
                            out.write(type);
                            out.write("[_list_");
                            out.write(rhs_item.alias);
                            out.write(".size()]);\n");
                        } else {
                            out.write("\t\t\t\t\tfinal ");
                            out.write(type);
                            out.write(32);
                            out.write(rhs_item.alias);
                            out.write(" = (");
                            out.write(type);
                            out.write(") _symbol_");
                            out.write(rhs_item.alias);
                            out.write(".value;\n");
                        }
                    }
                }
                ++i;
            }
            out.write("\t\t\t\t\t");
            out.write(rule.code);
            out.write(10);
        }

        private static ByteArrayOutputStream serializeParsingTables(ParsingTables tables, int[] rule_descr, NonTerminal error) throws IOException {
            ByteArrayOutputStream bytes_stream = new ByteArrayOutputStream(16384);
            DataOutputStream data_stream = new DataOutputStream(new DeflaterOutputStream(bytes_stream));
            tables.writeTo(data_stream);
            data_stream.writeInt(rule_descr.length);
            int i = 0;
            while (i < rule_descr.length) {
                data_stream.writeInt(rule_descr[i]);
                ++i;
            }
            data_stream.writeShort(error.id);
            data_stream.close();
            return bytes_stream;
        }

        private static String encode(byte[] bytes) throws IOException {
            int b2;
            int b1;
            StringBuffer text = new StringBuffer((bytes.length * 4 + 2) / 3);
            int i = 0;
            int end = bytes.length - bytes.length % 3;
            while (i < end) {
                b1 = bytes[i++] & 0xFF;
                b2 = bytes[i++] & 0xFF;
                int b3 = bytes[i++] & 0xFF;
                CompiledParser.encode(b1 >> 2, text);
                CompiledParser.encode(b1 << 4 & 0x30 | b2 >> 4, text);
                CompiledParser.encode(b2 << 2 & 0x3C | b3 >> 6, text);
                CompiledParser.encode(b3 & 0x3F, text);
            }
            if (i < bytes.length) {
                b1 = bytes[i++] & 0xFF;
                if (i < bytes.length) {
                    b2 = bytes[i] & 0xFF;
                    CompiledParser.encode(b1 >> 2, text);
                    CompiledParser.encode(b1 << 4 & 0x30 | b2 >> 4, text);
                    CompiledParser.encode(b2 << 2 & 0x3C, text);
                    text.append('=');
                } else {
                    CompiledParser.encode(b1 >> 2, text);
                    CompiledParser.encode(b1 << 4 & 0x30, text);
                    text.append('=');
                    text.append('=');
                }
            }
            return text.toString();
        }

        private static void encode(int c, StringBuffer text) {
            if (c < 10) {
                text.append((char)(48 + c));
            } else if (c < 36) {
                text.append((char)(55 + c));
            } else if (c < 62) {
                text.append((char)(61 + c));
            } else {
                text.append(_62_or_63[c - 62]);
            }
        }

        CompiledParser(Grammar grammar, ParsingTables parsing_tables) {
            this.grammar = grammar;
            this.tables = parsing_tables;
            this.rule_descr = CompiledParser.makeProductionDescriptors(grammar);
        }

        public void writeActionsReport(File dir, String output_file_name) throws IOException {
            FileWriter out = new FileWriter(new File(dir, String.valueOf(output_file_name) + ParserGenerator.PARSER_ACTIONS_REPORT_FILE_EXT));
            try {
                out.write("// This file was generated by Beaver v");
                out.write(ParserGenerator.VERSION);
                out.write("\n\n");
                State state = this.tables.first_state;
                while (state != null) {
                    out.write(String.valueOf(state.id));
                    out.write(58);
                    Action act = state.terminal_lookahead_actions.first;
                    while (act != null) {
                        out.write(9);
                        out.write(act.toString());
                        out.write(10);
                        act = act.next;
                    }
                    act = state.nonterminal_lookahead_actions.first;
                    while (act != null) {
                        out.write(9);
                        out.write(act.toString());
                        out.write(10);
                        act = act.next;
                    }
                    if (state.default_action != null) {
                        out.write(9);
                        out.write(state.default_action.toString());
                        out.write(10);
                    }
                    state = state.next;
                }
            }
            finally {
                out.close();
            }
        }

        public void writeParserSource(File src_file, File dir, String class_name, Options opts) throws IOException {
            FileWriter out = new FileWriter(new File(dir, String.valueOf(class_name) + ParserGenerator.SOURCE_FILE_EXT));
            try {
                if (this.grammar.prolog != null) {
                    out.write(this.grammar.prolog);
                    out.write(10);
                }
                if (this.grammar.package_name != null) {
                    out.write("package ");
                    out.write(this.grammar.package_name);
                    out.write(";\n\n");
                }
                int i = 0;
                while (i < this.grammar.imports.length) {
                    out.write("import ");
                    out.write(this.grammar.imports[i]);
                    out.write(";\n");
                    ++i;
                }
                out.write(10);
                out.write("/**\n");
                out.write(" * This class is a LALR parser generated by\n");
                out.write(" * <a href=\"http://beaver.sourceforge.net\">Beaver</a> v");
                out.write(ParserGenerator.VERSION);
                out.write(10);
                out.write(" * from the grammar specification \"");
                out.write(src_file.getName());
                out.write("\".\n");
                out.write(" */\n");
                this.writeClass(class_name, opts, out);
            }
            finally {
                out.close();
            }
        }

        public void writeTerminalsSource(File src_file, File dir, String output_file_name, Options opts) throws IOException {
            FileWriter out = new FileWriter(new File(dir, String.valueOf(output_file_name) + ParserGenerator.SOURCE_FILE_EXT));
            try {
                if (this.grammar.package_name != null) {
                    out.write("package ");
                    out.write(this.grammar.package_name);
                    out.write(";\n\n");
                }
                out.write("/**\n");
                out.write(" * This class lists terminals used by the\n");
                out.write(" * grammar specified in \"");
                out.write(src_file.getName());
                out.write("\".\n");
                out.write(" */\n");
                CompiledParser.writeTerminalsClass(this.grammar, opts, "", out);
            }
            finally {
                out.close();
            }
        }

        public void writeParsingTables(File dir, String output_file_name) throws IOException {
            FileOutputStream out = new FileOutputStream(new File(dir, String.valueOf(output_file_name) + ParserGenerator.SERIALIZED_PARSER_TABLES_FILE_EXT));
            try {
                CompiledParser.serializeParsingTables(this.tables, this.rule_descr, this.grammar.error).writeTo(out);
            }
            finally {
                out.close();
            }
        }

        private void writeClass(String class_name, Options opts, Writer out) throws IOException {
            out.write("public class ");
            out.write(class_name);
            out.write(" extends ");
            if (class_name.equals("Parser")) {
                out.write("beaver.");
            }
            out.write("Parser {\n");
            if (!opts.export_terminals) {
                CompiledParser.writeTerminalsClass(this.grammar, opts, "\t", out);
            }
            CompiledParser.writeMarkersClass(this.grammar.terminals, out);
            out.write("\n\tstatic final ParsingTables PARSING_TABLES = new ParsingTables(");
            if (opts.exp_parsing_tables) {
                out.write(class_name);
                out.write(".class");
            } else {
                int dlen;
                String enc = this.encodeParsingTables();
                out.write(10);
                int from = 0;
                int to = dlen = enc.length() != 71 ? 71 : 73;
                while (to < enc.length()) {
                    out.write("\t\t\"");
                    out.write(enc.substring(from, to));
                    out.write("\" +\n");
                    from = to;
                    to += dlen;
                }
                out.write("\t\t\"");
                out.write(enc.substring(from));
                out.write(34);
            }
            out.write(");\n");
            if (!opts.use_switch) {
                if (opts.name_action_classes) {
                    CompiledParser.writeReduceActionClasses(this.grammar, out);
                }
                CompiledParser.writeStaticReturns(this.grammar, out);
            }
            if (this.grammar.class_code != null) {
                out.write(this.grammar.class_code);
                out.write(10);
            }
            if (!opts.use_switch) {
                out.write(10);
                out.write("\tprivate final Action[] actions;\n");
            }
            out.write(10);
            out.write("\tpublic ");
            out.write(class_name);
            out.write("() {\n");
            out.write("\t\tsuper(PARSING_TABLES);\n");
            if (!opts.use_switch) {
                out.write("\t\tactions = new Action[] {");
                CompiledParser.writeParserActionsArray(this.grammar, opts, out);
                out.write("\n\t\t};\n");
            }
            if (this.grammar.init_code != null) {
                out.write(10);
                out.write(this.grammar.init_code);
                out.write(10);
            }
            out.write("\t}\n");
            out.write(10);
            out.write("\tprotected Symbol invokeReduceAction(int rule_num, int offset) {\n");
            if (opts.use_switch) {
                CompiledParser.writeParserActionsSwitch(this.grammar, opts, out);
            } else {
                out.write("\t\treturn actions[rule_num].reduce(_symbols, offset);\n");
            }
            out.write("\t}\n");
            out.write("}\n");
        }

        private String encodeParsingTables() throws IOException {
            return CompiledParser.encode(CompiledParser.serializeParsingTables(this.tables, this.rule_descr, this.grammar.error).toByteArray());
        }
    }
}

