/*
 * Decompiled with CFR 0.152.
 */
package beaver.spec;

import beaver.Symbol;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Terminal;
import java.util.Comparator;

public class Production {
    static final Comparator NUM_TERM_CMP = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Production)object2).rhs.n_term - ((Production)object).rhs.n_term;
        }
    };
    static final Comparator NUM_NONTERM_CMP = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Production)object2).rhs.n_nonterm - ((Production)object).rhs.n_nonterm;
        }
    };
    private static final Terminal DEFAULT_PRECEDENCE_SYMBOL = new Terminal("DEFAULT_PRECEDENCE", -1, Terminal.Associativity.NONE);
    public Production next_definition;
    public final int id;
    public final NonTerminal lhs;
    public final RHS rhs;
    public final Terminal prec_sym;
    public String code;
    public int start_pos;
    public int end_pos;
    public boolean is_reducible;

    Production(int n, NonTerminal nonTerminal, RHS rHS, Terminal terminal) {
        this.id = n;
        this.lhs = nonTerminal;
        this.rhs = rHS;
        if (terminal == null) {
            terminal = DEFAULT_PRECEDENCE_SYMBOL;
            for (int i = rHS.items.length - 1; i >= 0; --i) {
                if (!(rHS.items[i].symbol instanceof Terminal)) continue;
                Terminal terminal2 = (Terminal)rHS.items[i].symbol;
                if (terminal2.prec <= 0) continue;
                terminal = terminal2;
                break;
            }
        }
        this.prec_sym = terminal;
        if (rHS.items.length == 0) {
            nonTerminal.is_nullable = true;
        }
        nonTerminal.definitions.add(this);
    }

    Production(int n, NonTerminal nonTerminal, RHS rHS) {
        this(n, nonTerminal, rHS, null);
    }

    boolean isNullable() {
        if (this.rhs.first_term != null) {
            return false;
        }
        for (int i = 0; i < this.rhs.items.length; ++i) {
            if (((NonTerminal)this.rhs.items[i].symbol).is_nullable) continue;
            return false;
        }
        return true;
    }

    void startFirstSet() {
        for (int i = 0; i < this.rhs.items.length; ++i) {
            if (this.rhs.items[i].symbol instanceof Terminal) {
                this.lhs.first_set.add(this.rhs.items[i].symbol.id);
                break;
            }
            NonTerminal nonTerminal = (NonTerminal)this.rhs.items[i].symbol;
            if (nonTerminal != this.lhs && nonTerminal.first_set != null) {
                this.lhs.first_set.add(nonTerminal.first_set);
            }
            if (!nonTerminal.is_nullable) break;
        }
    }

    boolean extendFirstSet() {
        boolean bl = false;
        for (int i = 0; i < this.rhs.items.length && !(this.rhs.items[i].symbol instanceof Terminal); ++i) {
            NonTerminal nonTerminal = (NonTerminal)this.rhs.items[i].symbol;
            if (nonTerminal != this.lhs && nonTerminal.first_set != null && this.lhs.first_set.add(nonTerminal.first_set)) {
                bl = true;
            }
            if (!nonTerminal.is_nullable) break;
        }
        return bl;
    }

    public int getFirstLine() {
        return Symbol.getLine(this.start_pos);
    }

    public String toString() {
        return new StringBuffer(100).append(this.lhs).append(" = ").append(this.rhs).toString();
    }

    public static class RHS {
        public static final Item[] NONE = new Item[0];
        public final Item[] items;
        Item first_term;
        int n_term;
        int n_nonterm;

        RHS() {
            this.items = NONE;
        }

        RHS(Item[] itemArray) {
            this.items = itemArray;
            for (int i = 0; i < itemArray.length; ++i) {
                Item item = itemArray[i];
                if (item.symbol instanceof Terminal) {
                    if (this.first_term == null) {
                        this.first_term = item;
                    }
                    ++this.n_term;
                    continue;
                }
                ++this.n_nonterm;
            }
        }

        RHS(GrammarSymbol grammarSymbol) {
            this(new Item[]{new Item(grammarSymbol)});
        }

        RHS(GrammarSymbol grammarSymbol, GrammarSymbol grammarSymbol2) {
            this(new Item[]{new Item(grammarSymbol), new Item(grammarSymbol2)});
        }

        public Item start() {
            return this.items.length > 0 ? this.items[0] : null;
        }

        public Item end() {
            return this.items.length > 0 ? this.items[this.items.length - 1] : null;
        }

        public int size() {
            return this.items.length;
        }

        public String toString() {
            if (this.items.length == 0) {
                return "";
            }
            if (this.items.length == 1) {
                return this.items[0].toString();
            }
            int n = -1;
            for (int i = 0; i < this.items.length; ++i) {
                n += 1 + this.items[i].symbol.name.length();
                if (this.items[i].alias == null) continue;
                n += 1 + this.items[i].alias.length();
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            this.items[0].appendTo(stringBuffer);
            for (int i = 1; i < this.items.length; ++i) {
                stringBuffer.append(' ');
                this.items[i].appendTo(stringBuffer);
            }
            return stringBuffer.toString();
        }

        public static class Item {
            public final GrammarSymbol symbol;
            public final String alias;

            Item(GrammarSymbol grammarSymbol) {
                this.symbol = grammarSymbol;
                this.alias = null;
            }

            Item(GrammarSymbol grammarSymbol, String string) {
                this.symbol = grammarSymbol;
                this.alias = string;
            }

            public String toString() {
                return this.alias == null ? this.symbol.name : new StringBuffer(this.symbol.name.length() + 1 + this.alias.length()).append(this.symbol.name).append('.').append(this.alias).toString();
            }

            void appendTo(StringBuffer stringBuffer) {
                stringBuffer.append(this.symbol.name);
                if (this.alias != null) {
                    stringBuffer.append('.').append(this.alias);
                }
            }
        }
    }

    public static class List {
        private Production first;
        private Production last;
        private int size;

        public void add(Production production) {
            this.last = this.last == null ? (this.first = production) : (this.last.next_definition = production);
            ++this.size;
        }

        public Production start() {
            return this.first;
        }

        public int size() {
            return this.size;
        }
    }
}

