/* The following code was generated by JFlex 1.4.1 on 5/20/09 1:15 PM */

//TODO-AC: many of the catchall errors are recoverable - either return a bad token which will be discarded or just discard and make a note.
//based on http://jflex.de/manual.html

package metalexer;

import static metalexer.ComponentParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 5/20/09 1:15 PM from the specification file
 * <tt>/Users/amcasey/Research/metalexer/src/frontend/component.flex</tt>
 */
public final class ComponentScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int INSIDE_APPEND_REGION = 14;
  public static final int INSIDE_DELETE_ANGLE_BRACKETS = 32;
  public static final int INSIDE_ANGLE_BRACKETS = 24;
  public static final int INSIDE_APPEND_WITH_START_DELIM_REGION = 16;
  public static final int INSIDE_BRACKET_COMMENT = 6;
  public static final int INSIDE_INIT_REGION = 12;
  public static final int INSIDE_DECL_REGION = 10;
  public static final int INSIDE_ACTION = 22;
  public static final int INSIDE_RULE_SECTION = 4;
  public static final int INSIDE_OPEN_RULE_GROUP = 36;
  public static final int INSIDE_MACRO = 18;
  public static final int INSIDE_STRING = 8;
  public static final int INSIDE_STRING_DIRECTIVE = 28;
  public static final int INSIDE_HEADER_SECTION = 2;
  public static final int INSIDE_META_TOKEN = 34;
  public static final int INSIDE_CHARACTER_CLASS = 38;
  public static final int INSIDE_REPETITION_SPEC = 20;
  public static final int YYINITIAL = 0;
  public static final int INSIDE_IDENTIFIER_DIRECTIVE = 26;
  public static final int INSIDE_DELETE_DIRECTIVE = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  2,  3,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,  9, 
    10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 
    18, 18, 19, 19, 20, 20, 21, 21
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\22\0\1\3\1\63\1\13"+
    "\1\0\1\62\1\11\2\0\1\55\1\56\1\26\1\65\1\50\1\67"+
    "\1\7\1\25\1\10\3\22\4\23\2\5\1\12\1\0\1\46\1\70"+
    "\1\47\1\66\1\0\1\71\2\14\1\43\1\74\1\76\7\4\1\72"+
    "\1\75\3\4\1\42\3\4\1\40\1\4\1\73\1\4\1\57\1\15"+
    "\1\60\1\61\1\6\1\0\1\34\1\17\1\51\1\37\1\36\1\17"+
    "\1\4\1\41\1\31\2\4\1\44\1\45\1\32\1\52\1\35\1\4"+
    "\1\16\1\53\1\33\1\21\1\4\1\54\1\20\2\4\1\27\1\24"+
    "\1\30\1\64\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\26\0\1\1\1\2\2\3\1\4\1\2\1\5\1\6"+
    "\1\7\1\10\1\11\3\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\3\1\27\1\30\1\2\1\12\1\31\1\32\1\3"+
    "\1\2\3\33\1\34\2\35\1\36\1\37\4\34\1\40"+
    "\2\41\1\42\1\43\2\44\1\45\1\46\2\34\2\47"+
    "\1\50\1\51\2\52\1\27\1\51\2\53\2\54\1\55"+
    "\1\56\2\57\2\60\1\61\1\62\1\6\1\63\1\64"+
    "\1\65\2\0\1\66\2\67\2\66\1\67\1\70\1\71"+
    "\6\0\1\30\1\72\10\0\1\73\1\74\3\0\1\75"+
    "\1\76\1\77\1\34\2\77\1\34\1\0\1\100\6\0"+
    "\1\101\1\0\3\102\3\0\1\67\1\0\1\103\1\104"+
    "\17\0\1\34\6\0\1\105\2\0\1\67\17\0\1\34"+
    "\10\0\1\67\16\0\1\34\6\0\1\106\13\0\1\107"+
    "\1\110\2\0\1\111\5\0\1\112\1\113\1\114\1\0"+
    "\1\115\1\116\1\117\2\0\1\107\1\0\1\110\7\0"+
    "\1\120\1\0\1\114\2\0\1\115\1\0\1\116\1\0"+
    "\1\117\5\0\1\121\4\0\1\122\1\0\1\123\1\124"+
    "\3\0\1\125\1\122\1\0\1\126\3\0\1\125\1\0"+
    "\1\126\41\0\1\127\1\130";

  private static int [] zzUnpackAction() {
    int [] result = new int[347];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\u017a\0\u01b9"+
    "\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4\0\u0333\0\u0372\0\u03b1"+
    "\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u052b\0\u056a\0\u056a"+
    "\0\u05a9\0\u056a\0\u056a\0\u05e8\0\u056a\0\u0627\0\u056a\0\u0666"+
    "\0\u056a\0\u06a5\0\u056a\0\u06e4\0\u056a\0\u056a\0\u056a\0\u056a"+
    "\0\u056a\0\u056a\0\u056a\0\u056a\0\u056a\0\u056a\0\u056a\0\u056a"+
    "\0\u0723\0\u0762\0\u07a1\0\u07e0\0\u081f\0\u056a\0\u06e4\0\u085e"+
    "\0\u089d\0\u056a\0\u08dc\0\u091b\0\u056a\0\u095a\0\u056a\0\u056a"+
    "\0\u0999\0\u09d8\0\u0a17\0\u0a56\0\u0a95\0\u056a\0\u0ad4\0\u056a"+
    "\0\u056a\0\u056a\0\u0b13\0\u056a\0\u056a\0\u056a\0\u0b52\0\u0b91"+
    "\0\u056a\0\u0666\0\u056a\0\u056a\0\u0bd0\0\u056a\0\u0c0f\0\u0666"+
    "\0\u056a\0\u0666\0\u0c4e\0\u056a\0\u06e4\0\u056a\0\u056a\0\u0666"+
    "\0\u056a\0\u0666\0\u056a\0\u056a\0\u0c8d\0\u056a\0\u056a\0\u056a"+
    "\0\u0ccc\0\u0d0b\0\u056a\0\u056a\0\u0d4a\0\u0d89\0\u0dc8\0\u0e07"+
    "\0\u0e46\0\u056a\0\u06a5\0\u0e85\0\u0ec4\0\u0f03\0\u0f42\0\u0723"+
    "\0\u0f81\0\u056a\0\u0fc0\0\u0fff\0\u103e\0\u107d\0\u10bc\0\u10fb"+
    "\0\u113a\0\u1179\0\u056a\0\u056a\0\u085e\0\u11b8\0\u11f7\0\u056a"+
    "\0\u056a\0\u056a\0\u1236\0\u1275\0\u12b4\0\u12f3\0\u1332\0\u056a"+
    "\0\u1371\0\u13b0\0\u13ef\0\u142e\0\u146d\0\u14ac\0\u056a\0\u14eb"+
    "\0\u056a\0\u0d89\0\u0dc8\0\u152a\0\u1569\0\u15a8\0\u15e7\0\u1626"+
    "\0\u056a\0\u056a\0\u1665\0\u16a4\0\u16e3\0\u1722\0\u1761\0\u17a0"+
    "\0\u17df\0\u181e\0\u185d\0\u189c\0\u18db\0\u191a\0\u1959\0\u1998"+
    "\0\u19d7\0\u1a16\0\u1a55\0\u1a94\0\u1ad3\0\u1b12\0\u1b51\0\u1b90"+
    "\0\u1bcf\0\u1c0e\0\u1c4d\0\u1c8c\0\u1ccb\0\u1d0a\0\u1d49\0\u1d88"+
    "\0\u1dc7\0\u1e06\0\u1e45\0\u1e84\0\u1ec3\0\u1f02\0\u1f41\0\u1f80"+
    "\0\u1fbf\0\u1ffe\0\u203d\0\u207c\0\u20bb\0\u20fa\0\u2139\0\u2178"+
    "\0\u21b7\0\u21f6\0\u2235\0\u2274\0\u15a8\0\u22b3\0\u22f2\0\u2331"+
    "\0\u2370\0\u23af\0\u23ee\0\u242d\0\u246c\0\u24ab\0\u24ea\0\u2529"+
    "\0\u2568\0\u25a7\0\u25e6\0\u19d7\0\u2625\0\u2664\0\u26a3\0\u26e2"+
    "\0\u2721\0\u2760\0\u056a\0\u279f\0\u27de\0\u281d\0\u285c\0\u289b"+
    "\0\u28da\0\u2919\0\u2958\0\u2997\0\u29d6\0\u2a15\0\u2a54\0\u2a93"+
    "\0\u2ad2\0\u2b11\0\u056a\0\u2b50\0\u2b8f\0\u2bce\0\u2c0d\0\u2c4c"+
    "\0\u056a\0\u056a\0\u2c8b\0\u2cca\0\u2d09\0\u2d48\0\u2d87\0\u2dc6"+
    "\0\u2e05\0\u2e44\0\u2e44\0\u2e83\0\u2e83\0\u2ec2\0\u2f01\0\u2f40"+
    "\0\u2f7f\0\u2fbe\0\u2ffd\0\u056a\0\u303c\0\u307b\0\u307b\0\u30ba"+
    "\0\u30f9\0\u30f9\0\u3138\0\u3138\0\u3177\0\u3177\0\u31b6\0\u31f5"+
    "\0\u3234\0\u3273\0\u056a\0\u32b2\0\u32f1\0\u3330\0\u336f\0\u33ae"+
    "\0\u33ed\0\u056a\0\u056a\0\u342c\0\u346b\0\u34aa\0\u34e9\0\u3528"+
    "\0\u3528\0\u3567\0\u35a6\0\u35e5\0\u3624\0\u3663\0\u3663\0\u36a2"+
    "\0\u36a2\0\u36e1\0\u3720\0\u375f\0\u379e\0\u37dd\0\u381c\0\u385b"+
    "\0\u389a\0\u38d9\0\u3918\0\u3957\0\u3996\0\u39d5\0\u3a14\0\u3a53"+
    "\0\u3a92\0\u3ad1\0\u3b10\0\u3b4f\0\u3b8e\0\u3bcd\0\u3c0c\0\u3c4b"+
    "\0\u3c8a\0\u3cc9\0\u3d08\0\u3d47\0\u3d86\0\u3dc5\0\u3e04\0\u3e43"+
    "\0\u3e82\0\u056a\0\u056a";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[347];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\77\27\1\30\1\31\2\32\3\30\1\33\1\30\1\34"+
    "\1\30\1\35\1\30\1\36\6\30\1\37\1\40\1\41"+
    "\1\42\1\43\15\30\1\44\1\43\5\30\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\1\60\7\30\1\31\1\32\1\61\1\62\2\30"+
    "\1\33\1\30\1\63\1\30\1\35\1\62\1\36\4\62"+
    "\2\30\1\37\1\40\1\41\1\42\1\43\15\62\1\44"+
    "\1\43\1\30\4\62\1\45\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\6\62"+
    "\1\30\1\31\2\32\3\30\1\33\1\30\1\64\1\30"+
    "\1\35\1\30\1\36\6\30\1\37\1\40\1\41\1\65"+
    "\1\66\15\30\1\67\1\43\5\30\1\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\57"+
    "\1\60\7\30\1\31\1\32\1\70\3\30\1\33\1\30"+
    "\1\71\1\30\1\35\1\30\1\36\6\30\1\37\1\40"+
    "\1\41\1\65\1\66\15\30\1\67\1\43\5\30\1\45"+
    "\1\46\1\47\1\50\1\51\1\52\1\53\1\54\1\55"+
    "\1\56\1\57\1\60\6\30\25\72\1\73\1\74\50\72"+
    "\1\75\1\76\1\77\10\75\1\100\1\75\1\101\72\75"+
    "\1\102\76\75\1\103\76\75\1\104\76\75\1\105\65\75"+
    "\1\106\1\107\2\110\1\62\7\106\1\62\1\106\4\62"+
    "\6\106\1\111\15\62\3\106\4\62\14\106\6\62\1\112"+
    "\1\107\2\110\1\112\1\113\2\112\1\114\11\112\2\113"+
    "\4\112\1\115\17\112\1\116\26\112\11\75\1\117\1\120"+
    "\64\75\1\121\1\31\2\32\1\62\7\121\1\62\1\121"+
    "\4\62\3\121\1\122\3\121\15\62\1\121\1\123\1\116"+
    "\4\62\14\121\6\62\1\124\1\125\1\126\1\32\1\127"+
    "\7\124\1\127\1\124\4\127\3\124\1\130\3\124\15\127"+
    "\2\124\1\116\4\127\14\124\6\127\1\131\1\125\1\126"+
    "\1\32\7\131\1\35\11\131\1\132\22\131\1\116\26\131"+
    "\1\30\1\133\1\134\1\32\3\30\1\33\3\30\1\35"+
    "\1\30\1\36\6\30\1\37\1\40\1\41\1\42\1\43"+
    "\15\30\1\135\1\43\5\30\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\1\55\1\56\1\57\1\60"+
    "\6\30\1\121\1\31\2\32\1\62\7\121\1\62\1\121"+
    "\4\62\3\121\1\122\3\121\15\62\1\121\1\136\1\116"+
    "\4\62\14\121\6\62\1\137\1\125\1\126\1\32\1\62"+
    "\7\137\1\62\1\137\4\62\3\137\1\140\3\137\15\62"+
    "\3\137\4\62\14\137\6\62\1\141\1\31\2\32\21\141"+
    "\1\142\1\141\1\143\47\141\15\144\1\145\42\144\1\146"+
    "\1\147\5\144\1\57\7\144\101\0\1\32\123\0\1\150"+
    "\1\0\1\151\2\0\1\152\42\0\7\153\1\154\1\155"+
    "\2\153\1\154\1\153\3\154\1\156\1\157\1\155\1\160"+
    "\5\154\1\153\2\154\12\153\2\154\5\153\13\154\7\153"+
    "\25\0\1\161\1\162\53\0\1\163\1\164\1\165\2\0"+
    "\1\166\3\0\1\164\1\0\4\164\2\165\5\0\15\164"+
    "\3\0\4\164\14\0\6\164\46\0\1\167\33\0\1\170"+
    "\1\62\4\0\1\171\2\0\1\62\1\0\4\62\7\0"+
    "\15\62\3\0\4\62\14\0\6\62\4\0\3\62\1\0"+
    "\1\62\3\0\1\62\1\0\6\62\5\0\15\62\3\0"+
    "\4\62\14\0\6\62\11\0\1\172\6\0\1\173\6\0"+
    "\1\150\1\0\1\174\2\0\1\152\1\0\1\175\2\0"+
    "\1\176\2\0\1\177\4\0\1\200\1\0\1\201\34\0"+
    "\1\202\1\203\67\0\1\163\1\164\1\165\2\0\1\166"+
    "\1\0\1\204\1\0\1\164\1\0\4\164\2\165\5\0"+
    "\15\164\3\0\4\164\14\0\6\164\3\0\1\205\5\0"+
    "\1\206\76\0\1\202\1\203\24\0\1\207\65\0\1\210"+
    "\75\0\1\211\53\0\1\77\74\0\7\212\1\75\1\213"+
    "\2\212\1\75\1\212\3\75\1\214\1\215\1\213\1\216"+
    "\5\75\1\212\2\75\12\212\2\75\5\212\13\75\7\212"+
    "\11\0\1\217\16\0\1\220\57\0\1\221\17\0\1\222"+
    "\56\0\1\223\22\0\1\224\53\0\1\225\22\0\1\226"+
    "\44\0\1\110\101\0\1\113\2\0\1\113\11\0\2\113"+
    "\65\0\1\217\114\0\1\227\50\0\1\126\100\0\3\127"+
    "\1\230\1\127\3\0\1\127\1\0\6\127\5\0\15\127"+
    "\3\0\4\127\14\0\6\127\2\0\1\134\74\0\7\231"+
    "\1\154\1\155\2\231\1\154\1\231\3\154\1\232\1\233"+
    "\1\155\1\160\5\154\1\231\2\154\12\231\2\154\5\231"+
    "\13\154\7\231\32\0\1\234\101\0\1\235\51\0\1\160"+
    "\11\0\2\160\60\0\1\236\2\0\1\236\3\0\1\236"+
    "\2\0\1\236\2\0\2\236\10\0\1\236\1\0\2\236"+
    "\3\0\1\236\5\0\1\236\17\0\1\236\2\0\1\236"+
    "\1\0\1\236\5\0\1\237\2\0\1\237\3\0\1\237"+
    "\2\0\1\237\2\0\2\237\10\0\1\237\1\0\2\237"+
    "\3\0\1\237\5\0\1\237\17\0\1\237\2\0\1\237"+
    "\1\0\1\237\10\0\1\154\11\0\2\154\53\0\1\161"+
    "\2\0\74\161\3\0\1\240\3\164\1\0\1\164\3\0"+
    "\1\164\1\0\6\164\4\0\1\241\15\164\3\0\4\164"+
    "\14\0\6\164\3\0\1\166\1\0\1\165\2\0\1\165"+
    "\11\0\2\165\4\0\1\242\17\0\1\243\31\0\1\166"+
    "\24\0\1\242\17\0\1\243\117\0\1\244\2\0\1\245"+
    "\13\0\1\172\6\0\1\173\10\0\1\246\4\0\1\175"+
    "\2\0\1\176\2\0\1\177\4\0\1\200\1\0\1\201"+
    "\76\0\1\247\55\0\1\250\12\0\1\251\51\0\1\252"+
    "\114\0\1\253\76\0\1\254\112\0\1\255\57\0\1\256"+
    "\74\0\1\257\104\0\1\207\75\0\1\260\50\0\1\216"+
    "\11\0\2\216\60\0\1\261\2\0\1\261\3\0\1\261"+
    "\2\0\1\261\2\0\2\261\10\0\1\261\1\0\2\261"+
    "\3\0\1\261\5\0\1\261\17\0\1\261\2\0\1\261"+
    "\1\0\1\261\5\0\1\262\2\0\1\262\3\0\1\262"+
    "\2\0\1\262\2\0\2\262\10\0\1\262\1\0\2\262"+
    "\3\0\1\262\5\0\1\262\17\0\1\262\2\0\1\262"+
    "\1\0\1\262\10\0\1\75\11\0\2\75\103\0\1\212"+
    "\77\0\1\263\77\0\1\264\100\0\1\265\77\0\1\266"+
    "\75\0\1\267\77\0\1\270\45\0\1\271\7\0\1\271"+
    "\1\0\4\271\7\0\15\271\3\0\4\271\14\0\6\271"+
    "\31\0\1\272\102\0\1\273\46\0\1\154\2\0\1\154"+
    "\3\0\1\154\2\0\1\154\2\0\2\154\10\0\1\154"+
    "\1\0\2\154\3\0\1\154\5\0\1\154\17\0\1\154"+
    "\2\0\1\154\1\0\1\154\5\0\1\274\2\0\1\274"+
    "\3\0\1\274\2\0\1\274\2\0\2\274\10\0\1\274"+
    "\1\0\2\274\3\0\1\274\5\0\1\274\17\0\1\274"+
    "\2\0\1\274\1\0\1\274\3\0\1\240\24\0\1\241"+
    "\51\0\1\243\1\0\1\275\2\0\1\276\11\0\2\275"+
    "\145\0\1\277\101\0\1\300\33\0\1\301\12\0\1\251"+
    "\64\0\1\302\74\0\1\303\102\0\1\304\74\0\1\305"+
    "\107\0\1\306\52\0\1\307\123\0\1\310\65\0\1\311"+
    "\74\0\1\312\110\0\1\313\37\0\1\75\2\0\1\75"+
    "\3\0\1\75\2\0\1\75\2\0\2\75\10\0\1\75"+
    "\1\0\2\75\3\0\1\75\5\0\1\75\17\0\1\75"+
    "\2\0\1\75\1\0\1\75\5\0\1\314\2\0\1\314"+
    "\3\0\1\314\2\0\1\314\2\0\2\314\10\0\1\314"+
    "\1\0\2\314\3\0\1\314\5\0\1\314\17\0\1\314"+
    "\2\0\1\314\1\0\1\314\32\0\1\315\75\0\1\316"+
    "\102\0\1\317\76\0\1\320\76\0\1\321\76\0\1\322"+
    "\45\0\3\271\1\230\1\271\3\0\1\271\1\0\6\271"+
    "\5\0\15\271\3\0\4\271\14\0\6\271\33\0\1\323"+
    "\101\0\1\324\45\0\1\325\2\0\1\325\3\0\1\325"+
    "\2\0\1\325\2\0\2\325\10\0\1\325\1\0\2\325"+
    "\3\0\1\325\5\0\1\325\17\0\1\325\2\0\1\325"+
    "\1\0\1\325\3\0\1\276\1\0\1\275\2\0\1\275"+
    "\11\0\2\275\4\0\1\242\51\0\1\276\24\0\1\242"+
    "\141\0\1\326\101\0\1\327\31\0\1\330\101\0\1\331"+
    "\75\0\1\332\115\0\1\333\62\0\1\334\75\0\1\335"+
    "\74\0\1\336\100\0\1\337\57\0\1\340\14\0\1\341"+
    "\104\0\1\342\73\0\1\343\45\0\1\344\2\0\1\344"+
    "\3\0\1\344\2\0\1\344\2\0\2\344\10\0\1\344"+
    "\1\0\2\344\3\0\1\344\5\0\1\344\17\0\1\344"+
    "\2\0\1\344\1\0\1\344\31\0\1\345\100\0\1\346"+
    "\100\0\1\347\77\0\1\350\75\0\1\351\77\0\1\352"+
    "\67\0\1\353\101\0\1\354\113\0\1\355\76\0\1\356"+
    "\62\0\1\357\76\0\1\360\72\0\1\353\3\0\1\361"+
    "\61\0\1\362\76\0\1\363\116\0\1\364\101\0\1\365"+
    "\107\0\1\366\57\0\1\367\101\0\1\370\76\0\1\371"+
    "\73\0\1\372\76\0\1\217\73\0\1\373\104\0\1\374"+
    "\72\0\1\375\102\0\1\376\72\0\1\377\103\0\1\u0100"+
    "\106\0\1\u0101\76\0\1\u0102\62\0\1\361\101\0\1\u0103"+
    "\101\0\1\u0104\70\0\1\u0105\75\0\1\u0106\62\0\1\u0107"+
    "\76\0\1\u0108\112\0\1\u0109\44\0\4\u010a\3\u010b\1\u010a"+
    "\1\u010b\3\u010a\1\u010b\1\u010a\6\u010b\5\u010a\15\u010b\3\u010a"+
    "\4\u010b\14\u010a\6\u010b\4\u010c\3\u010d\1\u010c\1\u010d\3\u010c"+
    "\1\u010d\1\u010c\6\u010d\5\u010c\15\u010d\3\u010c\4\u010d\14\u010c"+
    "\6\u010d\16\0\1\u010e\116\0\1\u010f\72\0\1\u0110\103\0"+
    "\1\u0111\71\0\1\u0112\103\0\1\u0113\66\0\1\u0114\10\0"+
    "\1\u0115\36\0\4\u0116\3\u0117\1\u0116\1\u0117\3\u0116\1\u0117"+
    "\1\u0116\6\u0117\5\u0116\15\u0117\3\u0116\4\u0117\14\u0116\6\u0117"+
    "\16\0\1\u0118\60\0\4\u0119\3\u011a\1\u0119\1\u011a\3\u0119"+
    "\1\u011a\1\u0119\6\u011a\5\u0119\15\u011a\3\u0119\4\u011a\14\u0119"+
    "\6\u011a\4\u011b\3\u011c\1\u011b\1\u011c\3\u011b\1\u011c\1\u011b"+
    "\6\u011c\5\u011b\15\u011c\3\u011b\4\u011c\14\u011b\6\u011c\4\u011d"+
    "\3\u011e\1\u011d\1\u011e\3\u011d\1\u011e\1\u011d\6\u011e\5\u011d"+
    "\15\u011e\3\u011d\4\u011e\14\u011d\6\u011e\52\0\1\u011f\62\0"+
    "\1\u0120\40\0\77\u010a\77\u010c\31\0\1\u0121\46\0\3\u0122"+
    "\132\0\1\217\67\0\1\u0123\105\0\1\u0124\77\0\1\u0125"+
    "\67\0\1\u0126\45\0\77\u0116\52\0\1\u0127\24\0\77\u0119"+
    "\77\u011b\77\u011d\54\0\1\u0128\54\0\1\u0129\77\0\1\u012a"+
    "\44\0\3\u0122\42\0\1\u012b\70\0\1\u012c\67\0\1\u012d"+
    "\100\0\1\u012e\117\0\1\u012f\22\0\4\u0130\3\u0131\1\u0130"+
    "\1\u0131\3\u0130\1\u0131\1\u0130\6\u0131\5\u0130\15\u0131\3\u0130"+
    "\4\u0131\14\u0130\6\u0131\33\0\1\u0132\74\0\1\u0133\100\0"+
    "\1\u0134\104\0\1\u0135\35\0\4\u0136\3\u0137\1\u0136\1\u0137"+
    "\3\u0136\1\u0137\1\u0136\6\u0137\5\u0136\15\u0137\3\u0136\4\u0137"+
    "\14\u0136\6\u0137\77\u0130\4\u0138\3\u0139\1\u0138\1\u0139\3\u0138"+
    "\1\u0139\1\u0138\6\u0139\5\u0138\15\u0139\3\u0138\4\u0139\14\u0138"+
    "\6\u0139\33\0\1\u013a\104\0\1\u013b\77\0\1\u013c\34\0"+
    "\77\u0136\77\u0138\41\0\1\u013d\77\0\1\u013e\67\0\1\u013f"+
    "\105\0\1\u0140\67\0\1\u0141\77\0\1\u0142\75\0\1\u0143"+
    "\77\0\1\u0144\60\0\1\u0145\114\0\1\u0146\60\0\1\u0147"+
    "\113\0\1\u0148\61\0\1\u0149\113\0\1\u014a\106\0\1\u014b"+
    "\66\0\1\u014c\106\0\1\u014d\71\0\1\u014e\103\0\1\u014f"+
    "\71\0\1\u0150\104\0\1\u0151\70\0\1\u0152\104\0\1\u0153"+
    "\63\0\1\u0154\111\0\1\u0155\63\0\1\u0156\112\0\1\u0157"+
    "\62\0\1\u0158\112\0\1\u0159\60\0\1\u015a\114\0\1\217"+
    "\61\0\1\u015b\46\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[16065];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\26\0\2\11\1\1\2\11\1\1\1\11\1\1\1\11"+
    "\1\1\1\11\1\3\1\11\1\1\14\11\4\1\1\3"+
    "\1\11\3\1\1\11\2\1\1\11\1\1\2\11\5\1"+
    "\1\11\1\1\3\11\1\1\3\11\2\1\1\11\1\1"+
    "\2\11\1\1\1\11\2\1\1\11\2\1\1\11\1\1"+
    "\2\11\1\1\1\11\1\1\2\11\1\1\3\11\2\0"+
    "\2\11\5\1\1\11\6\0\1\1\1\11\10\0\2\11"+
    "\3\0\3\11\4\1\1\0\1\11\6\0\1\11\1\0"+
    "\1\11\2\1\3\0\1\1\1\0\2\15\17\0\1\1"+
    "\6\0\1\1\2\0\1\1\17\0\1\1\10\0\1\1"+
    "\16\0\1\1\6\0\1\11\13\0\2\7\2\0\1\11"+
    "\5\0\2\11\1\7\1\0\3\7\2\0\1\5\1\0"+
    "\1\5\2\0\1\2\4\0\1\11\1\0\1\5\2\0"+
    "\1\5\1\0\1\5\1\0\1\5\5\0\1\11\4\0"+
    "\1\7\1\0\1\11\1\15\3\0\1\7\1\5\1\0"+
    "\1\7\3\0\1\5\1\0\1\5\41\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[347];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  //// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
  
  //// Position ////////////////////////////////////////////////////////////////
  
  //records the position of a symbol
  private static class PositionRecord {
      int startLine = -1;
      int startCol = -1;
      int endLine = -1;
      int endCol = -1;
  }
  
  //the position of the current symbol
  private PositionRecord pos = new PositionRecord();
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markStartPosition() {
    //correct to one-indexed
    pos.startLine = yyline + 1;
    pos.startCol = yycolumn + 1;
  }
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markEndPosition() {
    //correct to one-indexed
    pos.endLine = yyline + 1;
    pos.endCol = (yycolumn + 1) + yylength() - 1;
  }
  
  //like symbol(type), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type) {
    return symbolFromMarkedPositions(type, null);
  }
  
  //like symbol(type, value), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type, Object value) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.endLine, pos.endCol);
  }
  
  //like symbol(type), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, int length) {
    return symbolFromMarkedStart(type, null, length);
  }
  
  //like symbol(type, value), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, Object value, int length) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.startLine, pos.startCol + length - 1);
  }
  
  //// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
  
  //// State transitions ///////////////////////////////////////////////////////
  
  //stack entry: stack identifier + symbol position
  private static class StateRecord {
    int stateNum;
    PositionRecord pos;
    
    StateRecord(int stateNum, PositionRecord pos) {
        this.stateNum = stateNum;
        this.pos = pos;
    }
  }
  
  //most of our states are used for bracketing
  //this gives us a way to nest bracketing states
  private java.util.Stack<StateRecord> stateStack = new java.util.Stack<StateRecord>();
  
  void saveStateAndTransition(int newState) {
    stateStack.push(new StateRecord(yystate(), pos));
    pos = new PositionRecord();
    yybegin(newState);
  }
  
  void restoreState() {
    StateRecord rec = stateStack.pop();
    yybegin(rec.stateNum);
    pos = rec.pos;
  }
  
  //// Comment nesting /////////////////////////////////////////////////////////
  
  //number of '*/'s
  private int nestingDepth = 0;
  
  //// Blob accumulation ///////////////////////////////////////////////////////
  
  //for accumulating the contents of a string literal, comment, action, etc
  private StringBuffer blobBuf = new StringBuffer();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ComponentScanner(java.io.Reader in) {
    saveStateAndTransition(INSIDE_HEADER_SECTION);
  blobBuf = new StringBuffer();
  markStartPosition();
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ComponentScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 166) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol nextToken() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;
    int zzPushbackPosL = zzPushbackPos = -1;
    boolean zzWasPushback;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      zzWasPushback = false;

      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            zzPushbackPos = zzPushbackPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            zzPushbackPosL = zzPushbackPos;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 2) == 2 )
            zzPushbackPosL = zzCurrentPosL;

          if ( (zzAttributes & 1) == 1 ) {
            zzWasPushback = (zzAttributes & 4) == 4;
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;
      if (zzWasPushback)
        zzMarkedPos = zzPushbackPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 69: 
          { return symbol(QUALIFIED_IDENTIFIER, yytext());
          }
        case 89: break;
        case 43: 
          { error("Unexpected character in string list: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 90: break;
        case 66: 
          { return symbol(CHAR_CLASS_CHAR, yytext().substring(1));
          }
        case 91: break;
        case 10: 
          { error("Unexpected character: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 92: break;
        case 34: 
          { restoreState();
        return symbol(CLOSE_MACRO);
          }
        case 93: break;
        case 35: 
          { error("Unexpected character in repetition specification: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 94: break;
        case 15: 
          { return symbol(BEGINNING_OF_LINE);
          }
        case 95: break;
        case 50: 
          { return symbol(CHAR_CLASS_CHAR, yytext());
          }
        case 96: break;
        case 65: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(ACTION, blobBuf.toString());
        restoreState(); //NB: restore before transitioning
        saveStateAndTransition(INSIDE_META_TOKEN);
        return sym;
          }
        case 97: break;
        case 5: 
          { saveStateAndTransition(INSIDE_STRING);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 98: break;
        case 83: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_SECTION_SEPARATOR);
          }
        case 99: break;
        case 33: 
          { /*ignore*/
          }
        case 100: break;
        case 14: 
          { return symbol(RSQUARE);
          }
        case 101: break;
        case 7: 
          { return symbol(ALT);
          }
        case 102: break;
        case 59: 
          { return symbol(GROUP_SEPARATOR);
          }
        case 103: break;
        case 56: 
          { /* ignore */
        //return symbol(COMMENT, yytext());
          }
        case 104: break;
        case 32: 
          { error("Unexpected character in macro invocation: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 105: break;
        case 61: 
          { //blobBuf.append(yytext());
        nestingDepth++;
          }
        case 106: break;
        case 57: 
          { saveStateAndTransition(INSIDE_BRACKET_COMMENT);
        //blobBuf = new StringBuffer(yytext());
        //markStartPosition();
        nestingDepth++;
          }
        case 107: break;
        case 19: 
          { return symbol(PLUS);
          }
        case 108: break;
        case 70: 
          { saveStateAndTransition(INSIDE_INIT_REGION);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 109: break;
        case 44: 
          { restoreState(); return symbol(DELETE_TERMINATOR);
          }
        case 110: break;
        case 45: 
          { saveStateAndTransition(INSIDE_DELETE_ANGLE_BRACKETS);
        return symbol(LANGLE);
          }
        case 111: break;
        case 74: 
          { return symbol(ANY_PATTERN);
          }
        case 112: break;
        case 48: 
          { error("Expecting '{', found: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 113: break;
        case 12: 
          { return symbol(RPAREN);
          }
        case 114: break;
        case 77: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(IMPORT_DIRECTIVE);
          }
        case 115: break;
        case 51: 
          { restoreState(); return symbol(RSQUARE);
          }
        case 116: break;
        case 53: 
          { saveStateAndTransition(INSIDE_DECL_REGION);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 117: break;
        case 73: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(INIT_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 118: break;
        case 22: 
          { return symbol(ASSIGN);
          }
        case 119: break;
        case 79: 
          { return symbol(HELPER_DIRECTIVE);
          }
        case 120: break;
        case 71: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(START_DIRECTIVE);
          }
        case 121: break;
        case 18: 
          { return symbol(UPTO);
          }
        case 122: break;
        case 81: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(APPEND_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 123: break;
        case 28: 
          { blobBuf.append(yytext());
          }
        case 124: break;
        case 29: 
          { yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
          }
        case 125: break;
        case 63: 
          { blobBuf.append(yytext().substring(1));
          }
        case 126: break;
        case 23: 
          { return symbol(IDENTIFIER, yytext());
          }
        case 127: break;
        case 64: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(DECL_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 128: break;
        case 55: 
          { return symbol(ESCAPE_SEQUENCE, yytext());
          }
        case 129: break;
        case 30: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(STRING, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 130: break;
        case 80: 
          { saveStateAndTransition(INSIDE_APPEND_REGION);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 131: break;
        case 11: 
          { return symbol(LPAREN);
          }
        case 132: break;
        case 58: 
          { restoreState();
        saveStateAndTransition(INSIDE_RULE_SECTION);
        return symbol(SECTION_SEPARATOR);
          }
        case 133: break;
        case 25: 
          { return symbol(CLOSE_RULE_GROUP);
          }
        case 134: break;
        case 52: 
          { return symbol(CHAR_CLASS_NEGATE);
          }
        case 135: break;
        case 13: 
          { saveStateAndTransition(INSIDE_CHARACTER_CLASS); return symbol(LSQUARE);
          }
        case 136: break;
        case 20: 
          { return symbol(OPT);
          }
        case 137: break;
        case 39: 
          { error("Unexpected character between angle brackets: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 138: break;
        case 60: 
          { saveStateAndTransition(INSIDE_ACTION);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 139: break;
        case 82: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(LEXTHROW_DIRECTIVE);
          }
        case 140: break;
        case 87: 
          { saveStateAndTransition(INSIDE_APPEND_WITH_START_DELIM_REGION);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 141: break;
        case 26: 
          { saveStateAndTransition(INSIDE_ANGLE_BRACKETS);
        return symbol(LANGLE);
          }
        case 142: break;
        case 78: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(EXTERN_DIRECTIVE);
          }
        case 143: break;
        case 27: 
          { //blobBuf.append(yytext());
          }
        case 144: break;
        case 40: 
          { restoreState();
        saveStateAndTransition(INSIDE_OPEN_RULE_GROUP);
        return symbol(RANGLE);
          }
        case 145: break;
        case 4: 
          { return symbol(DOT);
          }
        case 146: break;
        case 88: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(APPEND_WITH_START_DELIM_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 147: break;
        case 36: 
          { return symbol(NUMBER, yytext());
          }
        case 148: break;
        case 86: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(COMPONENT_DIRECTIVE);
          }
        case 149: break;
        case 75: 
          { return symbol(EOF_PATTERN);
          }
        case 150: break;
        case 9: 
          { return symbol(STAR);
          }
        case 151: break;
        case 72: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(STATE_DIRECTIVE);
          }
        case 152: break;
        case 21: 
          { return symbol(DASH);
          }
        case 153: break;
        case 6: 
          { error("Incomplete escape sequence");
          }
        case 154: break;
        case 1: 
          { error("Unexpected character: " + yytext());
          }
        case 155: break;
        case 68: 
          { saveStateAndTransition(INSIDE_REPETITION_SPEC);
        return symbol(OPEN_REPETITION_SPEC);
          }
        case 156: break;
        case 16: 
          { return symbol(END_OF_LINE);
          }
        case 157: break;
        case 84: 
          { saveStateAndTransition(INSIDE_DELETE_DIRECTIVE);
        return symbol(DELETE_DIRECTIVE);
          }
        case 158: break;
        case 17: 
          { return symbol(NOT);
          }
        case 159: break;
        case 24: 
          { error("Invalid directive");
          }
        case 160: break;
        case 37: 
          { restoreState();
        return symbol(CLOSE_REPETITION_SPEC);
          }
        case 161: break;
        case 47: 
          { error("Unexpected character in meta token specification: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 162: break;
        case 3: 
          { /* ignore */
          }
        case 163: break;
        case 67: 
          { saveStateAndTransition(INSIDE_MACRO);
        return symbol(OPEN_MACRO);
          }
        case 164: break;
        case 85: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(INITTHROW_DIRECTIVE);
          }
        case 165: break;
        case 41: 
          { error("Unexpected character in identifier list: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 166: break;
        case 8: 
          { return symbol(SLASH);
          }
        case 167: break;
        case 49: 
          { restoreState();
        return symbol(OPEN_RULE_GROUP);
          }
        case 168: break;
        case 42: 
          { restoreState(); /* ignore */
          }
        case 169: break;
        case 54: 
          { return symbol(NON_META, yytext().substring(1));
          }
        case 170: break;
        case 2: 
          { return symbol(NON_META, yytext());
          }
        case 171: break;
        case 62: 
          { //blobBuf.append(yytext());
        nestingDepth--;
        if(nestingDepth == 0) {
            //markEndPosition();
            //Symbol sym = symbolFromMarkedPositions(BRACKET_COMMENT, blobBuf.toString());
            restoreState();
            //return sym;
        }
          }
        case 172: break;
        case 38: 
          { return symbol(COMMA);
          }
        case 173: break;
        case 31: 
          { yybegin(YYINITIAL);
        error("Incomplete escape sequence");
          }
        case 174: break;
        case 76: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(XSTATE_DIRECTIVE);
          }
        case 175: break;
        case 46: 
          { restoreState();
        return symbol(RANGLE);
          }
        case 176: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case INSIDE_APPEND_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated append region: '" + blobBuf + "'");
            }
            case 348: break;
            case INSIDE_DELETE_ANGLE_BRACKETS: {
              error("Unterminated angle brackets"); //TODO-AC: could attach position
        yybegin(YYINITIAL); //central handling of EOF
            }
            case 349: break;
            case INSIDE_ANGLE_BRACKETS: {
              error("Unterminated angle brackets"); //TODO-AC: could attach position
        yybegin(YYINITIAL); //central handling of EOF
            }
            case 350: break;
            case INSIDE_APPEND_WITH_START_DELIM_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated append region: '" + blobBuf + "'");
            }
            case 351: break;
            case INSIDE_BRACKET_COMMENT: {
              yybegin(YYINITIAL);
        //don't finish scanning if there's an unclosed comment
        if(nestingDepth != 0) {
            error(nestingDepth + " levels of comments not closed");
        }
            }
            case 352: break;
            case INSIDE_INIT_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated init region: '" + blobBuf + "'");
            }
            case 353: break;
            case INSIDE_DECL_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated declaration region: '" + blobBuf + "'");
            }
            case 354: break;
            case INSIDE_ACTION: {
              yybegin(YYINITIAL);
            }
            case 355: break;
            case INSIDE_RULE_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 356: break;
            case INSIDE_OPEN_RULE_GROUP: {
              error("No group associated with state list");
        yybegin(YYINITIAL); //central handling of EOF
            }
            case 357: break;
            case INSIDE_STRING: {
              yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
            }
            case 358: break;
            case INSIDE_STRING_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 359: break;
            case INSIDE_HEADER_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 360: break;
            case INSIDE_META_TOKEN: {
              yybegin(YYINITIAL);
            }
            case 361: break;
            case YYINITIAL: {
              return symbol(EOF);
            }
            case 362: break;
            case INSIDE_IDENTIFIER_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 363: break;
            case INSIDE_DELETE_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
        return symbol(DELETE_TERMINATOR);
            }
            case 364: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
