/* The following code was generated by JFlex 1.4.1 on 5/20/09 1:15 PM */

//TODO-AC: many of the catchall errors are recoverable - either return a bad token which will be discarded or just discard and make a note.
//TODO-AC: meta-pattern macros?
//based on http://jflex.de/manual.html

package metalexer;

import static metalexer.LayoutParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 5/20/09 1:15 PM from the specification file
 * <tt>/Users/amcasey/Research/metalexer/src/frontend/layout.flex</tt>
 */
public final class LayoutScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int INSIDE_INHERITED_HEADER_SECTION = 2;
  public static final int INSIDE_BRACKET_COMMENT = 5;
  public static final int INSIDE_STRING_IDENTIFIER_DIRECTIVE = 9;
  public static final int INSIDE_PAIR_DIRECTIVE = 11;
  public static final int INSIDE_DECL_REGION = 7;
  public static final int INSIDE_STRING = 6;
  public static final int INSIDE_OPTION_SECTION = 3;
  public static final int INSIDE_LOCAL_HEADER_SECTION = 1;
  public static final int YYINITIAL = 0;
  public static final int INSIDE_META_PATTERN_DIRECTIVE = 10;
  public static final int INSIDE_INIT_REGION = 8;
  public static final int INSIDE_RULE_SECTION = 4;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\22\0\1\3\1\22\1\11"+
    "\1\0\1\22\1\10\2\0\1\61\1\62\1\24\1\66\1\50\1\0"+
    "\1\7\1\23\4\20\4\21\2\5\2\0\1\51\1\0\1\55\1\67"+
    "\1\0\1\52\1\56\3\12\1\60\7\4\1\53\1\57\11\4\1\54"+
    "\1\4\1\63\1\13\1\64\1\65\1\6\1\0\1\36\1\46\1\42"+
    "\1\44\1\33\1\15\1\47\1\32\1\27\2\4\1\34\1\43\1\30"+
    "\1\40\1\35\1\4\1\14\1\41\1\31\1\17\1\4\1\45\1\16"+
    "\1\37\1\4\1\25\1\70\1\26\1\22\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\14\0\1\1\3\2\1\3\2\4\1\5\1\3\3\6"+
    "\3\7\2\10\1\11\1\12\2\2\1\13\2\14\1\15"+
    "\1\16\1\13\1\17\1\20\1\21\2\20\1\22\1\20"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\3\33\1\34\1\35\1\36\1\37\7\0\1\40\1\41"+
    "\11\0\1\42\1\43\3\44\2\2\1\0\1\45\31\0"+
    "\1\2\2\0\1\46\1\0\1\47\21\0\1\50\3\0"+
    "\1\2\21\0\1\51\1\52\1\50\1\0\1\53\2\0"+
    "\1\2\2\0\1\54\1\55\1\56\5\0\1\57\7\0"+
    "\1\51\1\0\1\52\1\0\1\53\1\0\1\60\1\61"+
    "\1\62\1\0\1\63\1\0\1\64\1\65\1\57\4\0"+
    "\1\66\3\0\1\60\1\0\1\61\2\0\1\63\2\0"+
    "\1\64\1\0\1\65\2\0\1\67\1\0\1\66\1\0"+
    "\1\70\1\71\2\0\1\72\1\0\1\67\1\0\1\73"+
    "\1\70\1\0\1\71\1\0\1\74\1\75\1\72\1\0"+
    "\1\76\1\73\1\0\1\74\1\0\1\75\1\0\1\76"+
    "\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[250];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\71\0\162\0\253\0\344\0\u011d\0\u0156\0\u018f"+
    "\0\u01c8\0\u0201\0\u023a\0\u0273\0\u02ac\0\u02ac\0\u02e5\0\u031e"+
    "\0\u02ac\0\u0357\0\u02ac\0\u0390\0\u03c9\0\u02ac\0\u0402\0\u03c9"+
    "\0\u02ac\0\u043b\0\u0474\0\u04ad\0\u02ac\0\u02ac\0\u04e6\0\u051f"+
    "\0\u0558\0\u02ac\0\u0591\0\u02ac\0\u05ca\0\u02ac\0\u03c9\0\u02ac"+
    "\0\u02ac\0\u0603\0\u063c\0\u03c9\0\u02ac\0\u0675\0\u02ac\0\u02ac"+
    "\0\u02ac\0\u02ac\0\u02ac\0\u02ac\0\u02ac\0\u02ac\0\u02ac\0\u063c"+
    "\0\u03c9\0\u02ac\0\u02ac\0\u02ac\0\u02ac\0\u06ae\0\u06e7\0\u0720"+
    "\0\u0759\0\u0792\0\u07cb\0\u0804\0\u083d\0\u02ac\0\u0876\0\u08af"+
    "\0\u08e8\0\u0921\0\u095a\0\u0993\0\u09cc\0\u0a05\0\u0a3e\0\u02ac"+
    "\0\u02ac\0\u02ac\0\u0a77\0\u0ab0\0\u0ae9\0\u0b22\0\u0b5b\0\u02ac"+
    "\0\u0b94\0\u0bcd\0\u0c06\0\u0c3f\0\u0c78\0\u0cb1\0\u0cea\0\u0d23"+
    "\0\u0d5c\0\u0d95\0\u0dce\0\u0e07\0\u0e40\0\u0e79\0\u0eb2\0\u0eeb"+
    "\0\u0f24\0\u0f5d\0\u0f96\0\u0fcf\0\u1008\0\u1041\0\u107a\0\u10b3"+
    "\0\u10ec\0\u1125\0\u115e\0\u1197\0\u11d0\0\u063c\0\u02ac\0\u1209"+
    "\0\u1242\0\u127b\0\u12b4\0\u12ed\0\u1326\0\u135f\0\u1398\0\u13d1"+
    "\0\u140a\0\u1443\0\u147c\0\u14b5\0\u14ee\0\u1527\0\u1560\0\u1599"+
    "\0\u15d2\0\u160b\0\u1644\0\u167d\0\u16b6\0\u16ef\0\u1728\0\u1761"+
    "\0\u179a\0\u17d3\0\u180c\0\u1845\0\u187e\0\u18b7\0\u18f0\0\u1929"+
    "\0\u1962\0\u199b\0\u19d4\0\u1a0d\0\u1a46\0\u1a7f\0\u1ab8\0\u1af1"+
    "\0\u1b2a\0\u1b2a\0\u1b63\0\u1b9c\0\u1bd5\0\u10ec\0\u1c0e\0\u1c47"+
    "\0\u02ac\0\u02ac\0\u02ac\0\u1c80\0\u1cb9\0\u1cf2\0\u1d2b\0\u1d64"+
    "\0\u1d9d\0\u1dd6\0\u1e0f\0\u1e48\0\u1e81\0\u1eba\0\u1ef3\0\u1f2c"+
    "\0\u1f65\0\u1f65\0\u1f9e\0\u1f9e\0\u1fd7\0\u1fd7\0\u2010\0\u2049"+
    "\0\u02ac\0\u2082\0\u20bb\0\u20f4\0\u212d\0\u2166\0\u219f\0\u219f"+
    "\0\u21d8\0\u2211\0\u224a\0\u2283\0\u22bc\0\u22f5\0\u232e\0\u2367"+
    "\0\u2367\0\u23a0\0\u23a0\0\u23d9\0\u2412\0\u2412\0\u244b\0\u2484"+
    "\0\u2484\0\u24bd\0\u24bd\0\u24f6\0\u252f\0\u2568\0\u25a1\0\u25a1"+
    "\0\u25da\0\u2613\0\u264c\0\u2685\0\u26be\0\u26f7\0\u2730\0\u2730"+
    "\0\u2769\0\u27a2\0\u27a2\0\u27db\0\u27db\0\u2814\0\u284d\0\u2886"+
    "\0\u2886\0\u28bf\0\u28f8\0\u28f8\0\u2931\0\u2931\0\u296a\0\u296a"+
    "\0\u29a3\0\u29a3";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[250];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\71\15\10\16\1\17\70\16\1\20\60\16\1\21\1\22"+
    "\2\23\4\21\1\24\12\21\1\25\45\21\1\26\1\22"+
    "\2\23\4\26\1\27\12\26\1\30\45\26\23\31\1\32"+
    "\1\33\44\31\1\16\1\34\1\35\6\16\1\36\1\16"+
    "\1\37\65\16\1\40\70\16\1\41\60\16\1\42\1\43"+
    "\1\44\1\23\1\45\4\42\1\46\1\45\1\42\4\45"+
    "\3\42\1\47\3\42\21\45\1\50\1\42\3\45\1\42"+
    "\3\45\10\42\1\51\1\43\1\44\1\23\1\52\3\51"+
    "\1\53\1\51\1\52\1\51\4\52\3\51\1\54\1\55"+
    "\2\51\21\52\1\51\1\56\3\52\1\51\3\52\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\1\66\1\67"+
    "\1\43\1\44\1\23\1\52\3\67\1\70\1\67\1\52"+
    "\1\67\4\52\3\67\1\71\3\67\21\52\1\50\1\67"+
    "\3\52\1\67\3\52\10\67\101\0\1\72\70\0\1\73"+
    "\62\0\1\23\76\0\1\74\14\0\1\75\1\0\1\76"+
    "\2\0\1\77\1\0\1\100\3\0\1\101\1\102\1\103"+
    "\1\0\1\104\47\0\1\105\1\106\54\0\1\107\3\0"+
    "\1\110\2\0\1\111\10\0\1\112\1\0\1\113\1\114"+
    "\1\0\1\115\3\0\1\116\5\0\1\117\45\0\1\120"+
    "\67\0\1\121\47\0\1\35\66\0\7\122\1\16\1\122"+
    "\1\16\1\122\3\16\1\123\1\124\1\125\1\126\5\16"+
    "\1\122\2\16\14\122\1\16\2\122\1\16\3\122\1\16"+
    "\3\122\10\16\10\0\1\127\15\0\1\130\52\0\1\131"+
    "\16\0\1\132\43\0\1\44\72\0\3\45\1\133\2\0"+
    "\1\45\1\0\6\45\5\0\21\45\2\0\3\45\1\0"+
    "\3\45\14\0\3\52\3\0\1\52\1\0\6\52\5\0"+
    "\21\52\2\0\3\52\1\0\3\52\14\0\1\134\5\0"+
    "\1\134\1\0\4\134\7\0\21\134\2\0\3\134\1\0"+
    "\3\134\62\0\1\135\3\0\1\136\42\0\1\137\73\0"+
    "\1\140\70\0\1\141\2\0\1\142\67\0\1\143\64\0"+
    "\1\144\77\0\1\145\63\0\1\146\35\0\1\105\2\0"+
    "\66\105\27\0\1\147\3\0\1\150\70\0\1\151\65\0"+
    "\1\152\76\0\1\153\72\0\1\154\60\0\1\155\76\0"+
    "\1\156\63\0\1\157\56\0\1\160\56\0\1\161\4\0"+
    "\1\161\2\0\1\161\2\0\2\161\11\0\1\161\2\0"+
    "\1\161\3\0\1\161\1\0\1\161\1\0\1\161\3\0"+
    "\1\161\3\0\1\161\1\0\1\161\15\0\1\162\4\0"+
    "\1\162\2\0\1\162\2\0\2\162\11\0\1\162\2\0"+
    "\1\162\3\0\1\162\1\0\1\162\1\0\1\162\3\0"+
    "\1\162\3\0\1\162\1\0\1\162\30\0\2\126\67\0"+
    "\2\16\75\0\1\122\71\0\1\163\71\0\1\164\44\0"+
    "\1\165\5\0\1\165\1\0\4\165\7\0\21\165\2\0"+
    "\3\165\1\0\3\165\14\0\3\134\1\166\1\167\1\0"+
    "\1\134\1\0\6\134\5\0\21\134\2\0\3\134\1\0"+
    "\3\134\63\0\1\170\74\0\1\171\40\0\1\172\75\0"+
    "\1\173\52\0\1\174\111\0\1\175\62\0\1\176\75\0"+
    "\1\177\75\0\1\200\67\0\1\201\56\0\1\202\103\0"+
    "\1\203\62\0\1\204\66\0\1\205\4\0\1\206\73\0"+
    "\1\207\66\0\1\210\73\0\1\211\53\0\1\212\77\0"+
    "\1\213\65\0\1\214\42\0\1\16\4\0\1\16\2\0"+
    "\1\16\2\0\2\16\11\0\1\16\2\0\1\16\3\0"+
    "\1\16\1\0\1\16\1\0\1\16\3\0\1\16\3\0"+
    "\1\16\1\0\1\16\15\0\1\215\4\0\1\215\2\0"+
    "\1\215\2\0\2\215\11\0\1\215\2\0\1\215\3\0"+
    "\1\215\1\0\1\215\1\0\1\215\3\0\1\215\3\0"+
    "\1\215\1\0\1\215\40\0\1\216\67\0\1\217\45\0"+
    "\3\165\1\133\2\0\1\165\1\0\6\165\5\0\21\165"+
    "\2\0\3\165\1\0\3\165\64\0\1\220\74\0\1\221"+
    "\41\0\1\222\74\0\1\223\64\0\1\224\77\0\1\225"+
    "\57\0\1\226\55\0\1\227\111\0\1\230\67\0\1\231"+
    "\66\0\1\232\104\0\1\233\56\0\1\234\77\0\1\235"+
    "\62\0\1\236\66\0\1\237\66\0\1\240\37\0\4\241"+
    "\3\242\3\241\1\242\1\241\6\242\5\241\21\242\2\241"+
    "\3\242\1\241\3\242\10\241\14\0\1\243\70\0\1\244"+
    "\115\0\1\245\34\0\1\246\4\0\1\246\2\0\1\246"+
    "\2\0\2\246\11\0\1\246\2\0\1\246\3\0\1\246"+
    "\1\0\1\246\1\0\1\246\3\0\1\246\3\0\1\246"+
    "\1\0\1\246\37\0\1\247\72\0\1\250\114\0\1\251"+
    "\70\0\1\252\40\0\1\253\3\0\1\254\72\0\1\255"+
    "\67\0\1\256\55\0\1\257\111\0\1\260\61\0\1\261"+
    "\77\0\1\262\66\0\1\263\65\0\1\264\70\0\1\265"+
    "\73\0\1\266\100\0\1\267\53\0\1\270\37\0\4\271"+
    "\3\272\3\271\1\272\1\271\6\272\5\271\21\272\2\271"+
    "\3\272\1\271\3\272\10\271\4\273\3\274\3\273\1\274"+
    "\1\273\6\274\5\273\21\274\2\273\3\274\1\273\3\274"+
    "\10\273\71\241\4\275\3\276\3\275\1\276\1\275\6\276"+
    "\5\275\21\276\2\275\3\276\1\275\3\276\10\275\31\0"+
    "\1\277\70\0\1\300\70\0\1\127\65\0\1\301\74\0"+
    "\1\302\52\0\1\303\70\0\1\304\105\0\1\305\67\0"+
    "\1\306\40\0\4\307\3\310\3\307\1\310\1\307\6\310"+
    "\5\307\21\310\2\307\3\310\1\307\3\310\10\307\30\0"+
    "\1\311\54\0\1\312\70\0\1\313\120\0\1\314\66\0"+
    "\1\315\61\0\1\316\64\0\1\317\41\0\71\271\71\273"+
    "\71\275\4\320\3\321\3\320\1\321\1\320\6\321\5\320"+
    "\21\321\2\320\3\321\1\320\3\321\10\320\4\322\3\323"+
    "\3\322\1\323\1\322\6\323\5\322\21\323\2\322\3\323"+
    "\1\322\3\323\10\322\14\0\1\324\54\0\4\325\3\326"+
    "\3\325\1\326\1\325\6\326\5\325\21\326\2\325\3\326"+
    "\1\325\3\326\10\325\40\0\1\327\30\0\4\330\3\331"+
    "\3\330\1\331\1\330\6\331\5\330\21\331\2\330\3\331"+
    "\1\330\3\331\10\330\4\332\3\333\3\332\1\333\1\332"+
    "\6\333\5\332\21\333\2\332\3\333\1\332\3\333\10\332"+
    "\71\307\33\0\1\334\70\0\1\335\64\0\1\336\41\0"+
    "\4\337\3\340\3\337\1\340\1\337\6\340\5\337\21\340"+
    "\2\337\3\340\1\337\3\340\10\337\33\0\1\341\101\0"+
    "\1\342\64\0\1\343\30\0\71\320\71\322\40\0\1\344"+
    "\30\0\71\325\45\0\1\345\23\0\71\330\71\332\30\0"+
    "\1\346\40\0\4\347\3\350\3\347\1\350\1\347\6\350"+
    "\5\347\21\350\2\347\3\350\1\347\3\350\10\347\31\0"+
    "\1\351\37\0\71\337\4\352\3\353\3\352\1\353\1\352"+
    "\6\353\5\352\21\353\2\352\3\353\1\352\3\353\10\352"+
    "\4\354\3\355\3\354\1\355\1\354\6\355\5\354\21\355"+
    "\2\354\3\355\1\354\3\355\10\354\30\0\1\356\105\0"+
    "\1\357\23\0\4\360\3\361\3\360\1\361\1\360\6\361"+
    "\5\360\21\361\2\360\3\361\1\360\3\361\10\360\31\0"+
    "\1\362\37\0\71\347\4\363\3\364\3\363\1\364\1\363"+
    "\6\364\5\363\21\364\2\363\3\364\1\363\3\364\10\363"+
    "\71\352\71\354\4\365\3\366\3\365\1\366\1\365\6\366"+
    "\5\365\21\366\2\365\3\366\1\365\3\366\10\365\4\367"+
    "\3\370\3\367\1\370\1\367\6\370\5\367\21\370\2\367"+
    "\3\370\1\367\3\370\10\367\71\360\4\371\3\372\3\371"+
    "\1\372\1\371\6\372\5\371\21\372\2\371\3\372\1\371"+
    "\3\372\10\371\71\363\71\365\71\367\71\371";

  private static int [] zzUnpackTrans() {
    int [] result = new int[10716];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\14\0\2\11\2\1\1\11\1\1\1\11\2\1\1\11"+
    "\2\1\1\11\3\1\2\11\3\1\1\11\1\1\1\11"+
    "\1\1\1\11\1\1\2\11\3\1\1\11\1\1\11\11"+
    "\2\1\4\11\7\0\1\1\1\11\11\0\3\11\4\1"+
    "\1\0\1\11\31\0\1\1\2\0\1\1\1\0\1\11"+
    "\21\0\1\7\3\0\1\1\21\0\2\7\1\5\1\0"+
    "\1\7\2\0\1\1\2\0\3\11\5\0\1\7\7\0"+
    "\1\5\1\0\1\5\1\0\1\5\1\0\2\7\1\11"+
    "\1\0\1\7\1\0\2\7\1\5\4\0\1\7\3\0"+
    "\1\5\1\0\1\5\2\0\1\5\2\0\1\5\1\0"+
    "\1\5\2\0\1\7\1\0\1\5\1\0\2\7\2\0"+
    "\1\7\1\0\1\5\1\0\1\7\1\5\1\0\1\5"+
    "\1\0\2\7\1\5\1\0\1\7\1\5\1\0\1\5"+
    "\1\0\1\5\1\0\1\5\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[250];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  //// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
  
  //// Position ////////////////////////////////////////////////////////////////
  
  //records the position of a symbol
  private static class PositionRecord {
      int startLine = -1;
      int startCol = -1;
      int endLine = -1;
      int endCol = -1;
  }
  
  //the position of the current symbol
  private PositionRecord pos = new PositionRecord();
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markStartPosition() {
    //correct to one-indexed
    pos.startLine = yyline + 1;
    pos.startCol = yycolumn + 1;
  }
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markEndPosition() {
    //correct to one-indexed
    pos.endLine = yyline + 1;
    pos.endCol = (yycolumn + 1) + yylength() - 1;
  }
  
  //like symbol(type), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type) {
    return symbolFromMarkedPositions(type, null);
  }
  
  //like symbol(type, value), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type, Object value) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.endLine, pos.endCol);
  }
  
  //like symbol(type), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, int length) {
    return symbolFromMarkedStart(type, null, length);
  }
  
  //like symbol(type, value), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, Object value, int length) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.startLine, pos.startCol + length - 1);
  }
  
  //// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
  
  //// State transitions ///////////////////////////////////////////////////////
  
  //stack entry: stack identifier + symbol position
  private static class StateRecord {
    int stateNum;
    PositionRecord pos;
    
    StateRecord(int stateNum, PositionRecord pos) {
        this.stateNum = stateNum;
        this.pos = pos;
    }
  }
  
  //most of our states are used for bracketing
  //this gives us a way to nest bracketing states
  private java.util.Stack<StateRecord> stateStack = new java.util.Stack<StateRecord>();
  
  void saveStateAndTransition(int newState) {
    stateStack.push(new StateRecord(yystate(), pos));
    pos = new PositionRecord();
    yybegin(newState);
  }
  
  void restoreState() {
    StateRecord rec = stateStack.pop();
    yybegin(rec.stateNum);
    pos = rec.pos;
  }
  
  //// Comment nesting /////////////////////////////////////////////////////////
  
  //number of '*/'s or '}'s expected
  private int nestingDepth = 0;
  
  //// Blob accumulation ///////////////////////////////////////////////////////
  
  //for accumulating the contents of a string literal, comment, action, etc
  private StringBuffer blobBuf = new StringBuffer();
  
  //// Other ///////////////////////////////////////////////////////////////////
  
  //for deleting terminal line breaks
  private static String frontChomp(String oldString) {
    if(oldString.startsWith("\r\n")) {
        return oldString.substring(2);
    } else if(oldString.startsWith("\n") || oldString.startsWith("\r")) {
        return oldString.substring(1);
    } else {
        return oldString;
    }
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public LayoutScanner(java.io.Reader in) {
    saveStateAndTransition(INSIDE_LOCAL_HEADER_SECTION);
  blobBuf = new StringBuffer();
  markStartPosition();
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public LayoutScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 154) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol nextToken() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;
    int zzPushbackPosL = zzPushbackPos = -1;
    boolean zzWasPushback;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;

      zzWasPushback = false;

      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            zzPushbackPos = zzPushbackPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            zzPushbackPosL = zzPushbackPos;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 2) == 2 )
            zzPushbackPosL = zzCurrentPosL;

          if ( (zzAttributes & 1) == 1 ) {
            zzWasPushback = (zzAttributes & 4) == 4;
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;
      if (zzWasPushback)
        zzMarkedPos = zzPushbackPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 4: 
          { /* ignore */
          }
        case 63: break;
        case 59: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(START_INHERIT_GROUP);
          }
        case 64: break;
        case 5: 
          { error("Invalid directive");
          }
        case 65: break;
        case 52: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(LAYOUT_DIRECTIVE);
          }
        case 66: break;
        case 9: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(STRING, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 67: break;
        case 54: 
          { return symbol(START_EMBED_GROUP);
          }
        case 68: break;
        case 41: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(EMBEDDING_NAME);
          }
        case 69: break;
        case 48: 
          { saveStateAndTransition(INSIDE_META_PATTERN_DIRECTIVE);
        return symbol(EMBEDDING_START);
          }
        case 70: break;
        case 30: 
          { restoreState();
        saveStateAndTransition(INSIDE_RULE_SECTION);
        //TODO-AC: return symbol(SECTION_SEPARATOR);?
          }
        case 71: break;
        case 53: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(OPTION_DIRECTIVE);
          }
        case 72: break;
        case 15: 
          { return symbol(COMMA);
          }
        case 73: break;
        case 11: 
          { error("Unexpected character in directive option list: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 74: break;
        case 60: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_UNOPTION);
          }
        case 75: break;
        case 14: 
          { saveStateAndTransition(INSIDE_STRING);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 76: break;
        case 6: 
          { error("Unexpected character in rule section: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 77: break;
        case 34: 
          { //blobBuf.append(yytext());
        nestingDepth++;
          }
        case 78: break;
        case 45: 
          { return symbol(MP_BOF);
          }
        case 79: break;
        case 20: 
          { return symbol(MP_RPAREN);
          }
        case 80: break;
        case 28: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(LOCAL_HEADER, blobBuf.toString());
        restoreState();
        
        saveStateAndTransition(INSIDE_INHERITED_HEADER_SECTION);
        blobBuf = new StringBuffer();
        markStartPosition();
        
        return sym;
        //TODO-AC: pushback separator and return it later?
          }
        case 81: break;
        case 17: 
          { return symbol(MP_SYM, yytext());
          }
        case 82: break;
        case 13: 
          { return symbol(IDENTIFIER, yytext());
          }
        case 83: break;
        case 50: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(INIT_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 84: break;
        case 16: 
          { error("Unexpected character in meta-pattern: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 85: break;
        case 43: 
          { saveStateAndTransition(INSIDE_PAIR_DIRECTIVE);
        return symbol(EMBEDDING_PAIR);
          }
        case 86: break;
        case 29: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(INHERITED_HEADER, frontChomp(blobBuf.toString()));
        restoreState();
        saveStateAndTransition(INSIDE_OPTION_SECTION);
        return sym;
        //TODO-AC: pushback separator and return it later?
          }
        case 87: break;
        case 25: 
          { return symbol(MP_OPT);
          }
        case 88: break;
        case 32: 
          { /* ignore */
        //return symbol(COMMENT, yytext());
          }
        case 89: break;
        case 24: 
          { return symbol(MP_PLUS);
          }
        case 90: break;
        case 36: 
          { blobBuf.append(yytext().substring(1));
          }
        case 91: break;
        case 46: 
          { saveStateAndTransition(INSIDE_INIT_REGION);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 92: break;
        case 22: 
          { return symbol(MP_RSQUARE);
          }
        case 93: break;
        case 33: 
          { saveStateAndTransition(INSIDE_BRACKET_COMMENT);
        //blobBuf = new StringBuffer(yytext());
        //markStartPosition();
        nestingDepth++;
          }
        case 94: break;
        case 56: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_REPLACE);
          }
        case 95: break;
        case 35: 
          { //blobBuf.append(yytext());
        nestingDepth--;
        if(nestingDepth == 0) {
            //markEndPosition();
            //Symbol sym = symbolFromMarkedPositions(BRACKET_COMMENT, blobBuf.toString());
            restoreState();
            //return sym;
        }
          }
        case 96: break;
        case 1: 
          { error("Unexpected character: " + yytext());
          }
        case 97: break;
        case 3: 
          { error("Unexpected character in option section: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 98: break;
        case 26: 
          { return symbol(MP_OR);
          }
        case 99: break;
        case 2: 
          { blobBuf.append(yytext());
          }
        case 100: break;
        case 49: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(EMBEDDING_GUEST);
          }
        case 101: break;
        case 39: 
          { return symbol(MP_REGION, yytext().substring(1, yylength() - 1));
          }
        case 102: break;
        case 61: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INITTHROW_DIRECTIVE);
          }
        case 103: break;
        case 40: 
          { saveStateAndTransition(INSIDE_META_PATTERN_DIRECTIVE);
        return symbol(EMBEDDING_END);
          }
        case 104: break;
        case 57: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_UNEMBED);
          }
        case 105: break;
        case 31: 
          { saveStateAndTransition(INSIDE_DECL_REGION);
        blobBuf = new StringBuffer();
        markStartPosition();
          }
        case 106: break;
        case 18: 
          { return symbol(MP_STAR);
          }
        case 107: break;
        case 55: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(DECLARE_DIRECTIVE);
          }
        case 108: break;
        case 27: 
          { error("Unexpected character in pair element: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 109: break;
        case 19: 
          { return symbol(MP_LPAREN);
          }
        case 110: break;
        case 38: 
          { return symbol(QUALIFIED_IDENTIFIER, yytext());
          }
        case 111: break;
        case 37: 
          { markEndPosition();
        Symbol sym = symbolFromMarkedPositions(DECL_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 112: break;
        case 58: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(LEXTHROW_DIRECTIVE);
          }
        case 113: break;
        case 47: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(START_DIRECTIVE);
          }
        case 114: break;
        case 23: 
          { return symbol(MP_CARET);
          }
        case 115: break;
        case 62: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(COMPONENT_DIRECTIVE);
          }
        case 116: break;
        case 44: 
          { return symbol(MP_ANY);
          }
        case 117: break;
        case 42: 
          { saveStateAndTransition(INSIDE_STRING_IDENTIFIER_DIRECTIVE);
        return symbol(EMBEDDING_HOST);
          }
        case 118: break;
        case 7: 
          { //blobBuf.append(yytext());
          }
        case 119: break;
        case 51: 
          { return symbol(HELPER_DIRECTIVE);
          }
        case 120: break;
        case 10: 
          { yybegin(YYINITIAL);
        error("Incomplete escape sequence");
          }
        case 121: break;
        case 8: 
          { yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
          }
        case 122: break;
        case 12: 
          { restoreState(); /* ignore */
          }
        case 123: break;
        case 21: 
          { return symbol(MP_LSQUARE);
          }
        case 124: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case INSIDE_INHERITED_HEADER_SECTION: {
              yybegin(YYINITIAL); 
        error("Unterminated inherited header section.");
            }
            case 251: break;
            case INSIDE_BRACKET_COMMENT: {
              yybegin(YYINITIAL);
        //don't finish scanning if there's an unclosed comment
        if(nestingDepth != 0) {
            error(nestingDepth + " levels of comments not closed");
        }
            }
            case 252: break;
            case INSIDE_STRING_IDENTIFIER_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 253: break;
            case INSIDE_PAIR_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 254: break;
            case INSIDE_DECL_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated declaration region: '" + blobBuf + "'");
            }
            case 255: break;
            case INSIDE_STRING: {
              yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
            }
            case 256: break;
            case INSIDE_OPTION_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 257: break;
            case INSIDE_LOCAL_HEADER_SECTION: {
              yybegin(YYINITIAL); 
        error("Unterminated local header section.");
            }
            case 258: break;
            case YYINITIAL: {
              return symbol(EOF);
            }
            case 259: break;
            case INSIDE_META_PATTERN_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 260: break;
            case INSIDE_INIT_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated init region: '" + blobBuf + "'");
            }
            case 261: break;
            case INSIDE_RULE_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 262: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
