public class Unescape {
    // [nrtfb] | x {HexDigit}{2} | u {HexDigit}{1,4} | [0-3]? [0-7]? [0-7]
    private static char unescape(String escape) {
        char ch = escape.charAt(1);
        switch (ch) {
        case 'n':
            return '\n';
        case 'r':
            return '\r';
        case 't':
            return '\t';
        case 'f':
            return '\f';
        case 'b':
            return '\b';
        default:
            if (escape.length() == 2) {
                return ch;
            }
            switch (ch) {
            case 'x':
            case 'u':
                //NB: assuming substring(1) satisfies
                //  {HexDigit}{2} for x
                //  {HexDigit}{1,4} for u
                String hex = escape.substring(2);
                return (char) Integer.parseInt(hex, 16);
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
                //NB: assuming substring(1) satisfies [0-3]? [0-7]? [0-7]
                String octal = escape.substring(1);
                return (char) Integer.parseInt(octal, 8);
            default:
                throw new RuntimeException("Invalid escape sequence: " + escape);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(unescape("\\n"));
        System.out.println(unescape("\\r"));
        System.out.println(unescape("\\t"));
        System.out.println(unescape("\\f"));
        System.out.println(unescape("\\b"));
        System.out.println(unescape("\\x31"));
        System.out.println(unescape("\\ua"));
        System.out.println(unescape("\\u31"));
        System.out.println(unescape("\\u031"));
        System.out.println(unescape("\\u0031"));
        System.out.println(unescape("\\7"));
        System.out.println(unescape("\\71"));
        System.out.println(unescape("\\071"));
        System.out.println(unescape("\\a"));
        System.out.println(unescape("\\u"));
        System.out.println(unescape("\\x"));
    }
}