package metalexer;

import java.io.PrintWriter;

/** Generates metalexer.*ParserPassTests from the provided list file. */
public abstract class ParserPassTestGenerator extends AbstractTestGenerator {
    private final String prefix;

    protected ParserPassTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "ParserPassTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import metalexer.ast." + prefix + ";");
        testFileWriter.println("import metalexer.ast." + prefix + "Wrapper;");
        testFileWriter.println();
        testFileWriter.println("import beaver.Scanner;");
        testFileWriter.println();
        testFileWriter.println("public class " + prefix + "ParserPassTests extends " + prefix + "ParserPassTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String inFileName = "test/frontend/" + testName + ".in";
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("	public void " + methodName + "() throws Exception {");
        testFileWriter.println("		Scanner scanner = getScanner(\"" + inFileName + "\");");
        testFileWriter.println("		" + prefix + "Parser parser = new " + prefix + "Parser();");
        testFileWriter.println("        parser.setFilename(\"" + inFileName + "\");");
        testFileWriter.println("		" + prefix + " actual = ((" + prefix + "Wrapper) parser.parse(scanner)).get" + prefix + "();");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("		Structure expected = parseStructure(\"" + outFileName + "\");");
        testFileWriter.println("		assertEquiv(actual, expected);");
        testFileWriter.println("	}");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}
