/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.util.BitSet;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class Configuration
implements Comparable {
    Configuration next;
    Production rule;
    int dot;
    BitSet lookaheads;
    PropagationLink fwd_propagation;
    PropagationLink bck_propagation;
    PropagationLink last_bck_propagation;
    boolean has_contributed;

    private Configuration() {
    }

    Configuration(Configuration configuration, Grammar grammar) {
        this.rule = configuration.rule;
        this.dot = configuration.dot;
        this.lookaheads = new BitSet(grammar.terminals.length);
    }

    GrammarSymbol getSymbolAfterDot() {
        return this.rule.rhs.items[this.dot].symbol;
    }

    boolean isDotAfterLastSymbol() {
        return this.dot == this.rule.rhs.items.length;
    }

    void addLookahead(Terminal terminal) {
        this.lookaheads.add(terminal.id);
    }

    boolean addLookaheads(Configuration configuration) {
        for (int i = configuration.dot + 1; i < configuration.rule.rhs.items.length; ++i) {
            GrammarSymbol grammarSymbol = configuration.rule.rhs.items[i].symbol;
            if (grammarSymbol instanceof Terminal) {
                this.lookaheads.add(grammarSymbol.id);
                return false;
            }
            NonTerminal nonTerminal = (NonTerminal)grammarSymbol;
            this.lookaheads.add(nonTerminal.first_set);
            if (nonTerminal.is_nullable) continue;
            return false;
        }
        return true;
    }

    void addForwardPropagation(Configuration configuration) {
        PropagationLink propagationLink = new PropagationLink(configuration);
        propagationLink.next = this.fwd_propagation;
        this.fwd_propagation = propagationLink;
    }

    void addReversePropagation(Configuration configuration) {
        PropagationLink propagationLink = new PropagationLink(configuration);
        this.last_bck_propagation = this.last_bck_propagation == null ? (this.bck_propagation = propagationLink) : (this.last_bck_propagation.next = propagationLink);
    }

    void appendReversePropagation(Configuration configuration) {
        if (this.last_bck_propagation == null) {
            this.bck_propagation = configuration.bck_propagation;
        } else {
            this.last_bck_propagation.next = configuration.bck_propagation;
        }
        this.last_bck_propagation = configuration.last_bck_propagation;
    }

    void reverseReversePropagation() {
        PropagationLink propagationLink = this.bck_propagation;
        while (propagationLink != null) {
            PropagationLink propagationLink2 = propagationLink.next;
            Configuration configuration = propagationLink.conf;
            propagationLink.conf = this;
            propagationLink.next = configuration.fwd_propagation;
            configuration.fwd_propagation = propagationLink;
            propagationLink = propagationLink2;
        }
        this.bck_propagation = null;
    }

    boolean findLookaheads() {
        boolean bl = false;
        PropagationLink propagationLink = this.fwd_propagation;
        while (propagationLink != null) {
            if (propagationLink.conf.lookaheads.add(this.lookaheads)) {
                bl = true;
                propagationLink.conf.has_contributed = false;
            }
            propagationLink = propagationLink.next;
        }
        return bl;
    }

    boolean equals(Configuration configuration) {
        return this.rule == configuration.rule && this.dot == configuration.dot;
    }

    public boolean equals(Object object) {
        return object instanceof Configuration && this.equals((Configuration)object);
    }

    public int hashCode() {
        return this.rule.id * 37 + this.dot;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        Configuration configuration = (Configuration)object;
        int n = this.rule.id - configuration.rule.id;
        if (n == 0) {
            n = this.dot - configuration.dot;
        }
        return n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.rule.lhs).append(" =");
        for (n = 0; n < this.rule.rhs.items.length; ++n) {
            Production.RHS.Item item = this.rule.rhs.items[n];
            stringBuffer.append(' ');
            if (n == this.dot) {
                stringBuffer.append('*');
            }
            stringBuffer.append(item);
        }
        if (this.dot == this.rule.rhs.items.length) {
            stringBuffer.append(" *");
        }
        if ((n = this.rule.getFirstLine()) > 0) {
            stringBuffer.append(" @ ").append(n);
        }
        return stringBuffer.toString();
    }

    static class PropagationLink {
        PropagationLink next;
        Configuration conf;

        PropagationLink(Configuration configuration) {
            this.conf = configuration;
        }
    }

    static class Set {
        Factory conf_set_factory;
        Configuration first_conf;
        Configuration last_core_conf;
        int core_size;
        int core_hash_code;

        private Set(Factory factory, int n) {
            this.conf_set_factory = factory;
            this.first_conf = factory.first_conf;
            this.last_core_conf = factory.last_conf;
            this.core_hash_code = n;
            this.core_size = factory.num_conf;
        }

        void appendReversePropagation(Set set) {
            Configuration configuration = this.last_core_conf.next;
            Configuration configuration2 = this.first_conf;
            Configuration configuration3 = set.first_conf;
            while (configuration2 != configuration) {
                configuration2.appendReversePropagation(configuration3);
                configuration2 = configuration2.next;
                configuration3 = configuration3.next;
            }
        }

        void buildClosure() {
            Configuration configuration = this.first_conf;
            while (configuration != null) {
                GrammarSymbol grammarSymbol;
                if (!configuration.isDotAfterLastSymbol() && (grammarSymbol = configuration.getSymbolAfterDot()) instanceof NonTerminal) {
                    NonTerminal nonTerminal = (NonTerminal)grammarSymbol;
                    Production production = nonTerminal.definitions.start();
                    while (production != null) {
                        Configuration configuration2 = this.conf_set_factory.addConfiguration(production, 0);
                        if (configuration2.addLookaheads(configuration)) {
                            configuration.addForwardPropagation(configuration2);
                        }
                        production = production.next_definition;
                    }
                }
                configuration = configuration.next;
            }
        }

        void reverseReversePropagation() {
            Configuration configuration = this.first_conf;
            while (configuration != null) {
                configuration.reverseReversePropagation();
                configuration = configuration.next;
            }
        }

        void resetContributionFlags() {
            Configuration configuration = this.first_conf;
            while (configuration != null) {
                configuration.has_contributed = false;
                configuration = configuration.next;
            }
        }

        private boolean equals(Set set) {
            if (set == this) {
                return true;
            }
            if (set.core_size != this.core_size) {
                return false;
            }
            Configuration configuration = this.first_conf;
            Configuration configuration2 = set.first_conf;
            Configuration configuration3 = this.last_core_conf.next;
            while (configuration != configuration3 && configuration.equals(configuration2)) {
                configuration = configuration.next;
                configuration2 = configuration2.next;
            }
            return configuration == configuration3;
        }

        public boolean equals(Object object) {
            return object instanceof Set && this.equals((Set)object);
        }

        public int hashCode() {
            return this.core_hash_code;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(1000);
            Configuration configuration = this.first_conf;
            while (configuration != this.last_core_conf.next) {
                stringBuffer.append('+').append(configuration).append('\n');
                configuration = configuration.next;
            }
            while (configuration != null) {
                stringBuffer.append(' ').append(configuration).append('\n');
                configuration = configuration.next;
            }
            return stringBuffer.toString();
        }

        static class Factory {
            private Map configurations = new HashMap(89);
            private Configuration probe = new Configuration();
            private Grammar grammar;
            Configuration first_conf;
            Configuration last_conf;
            int num_conf;

            Factory(Grammar grammar) {
                this.grammar = grammar;
            }

            void reset() {
                this.last_conf = null;
                this.first_conf = null;
                this.num_conf = 0;
                this.configurations = new HashMap(89);
            }

            Configuration addConfiguration(Production production, int n) {
                this.probe.rule = production;
                this.probe.dot = n;
                Configuration configuration = (Configuration)this.configurations.get(this.probe);
                if (configuration == null) {
                    configuration = new Configuration(this.probe, this.grammar);
                    this.configurations.put(configuration, configuration);
                    this.last_conf = this.last_conf == null ? (this.first_conf = configuration) : (this.last_conf.next = configuration);
                    ++this.num_conf;
                }
                return configuration;
            }

            Set getCore() {
                Object[] objectArray = new Configuration[this.num_conf];
                int n = 0;
                Object object = this.first_conf;
                while (object != null) {
                    objectArray[n++] = object;
                    object = ((Configuration)object).next;
                }
                Arrays.sort(objectArray);
                object = this.first_conf = objectArray[0];
                int n2 = ((Configuration)object).hashCode();
                for (n = 1; n < this.num_conf; ++n) {
                    object = ((Configuration)object).next = objectArray[n];
                    n2 = n2 * 571 + ((Configuration)object).hashCode();
                }
                this.last_conf = object;
                ((Configuration)object).next = null;
                return new Set(this, n2);
            }
        }
    }
}

