/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.run;

import beaver.Parser;
import beaver.comp.ParserGenerator;
import beaver.comp.io.SrcReader;
import beaver.comp.run.Options;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import java.io.File;
import java.io.IOException;

public class Make {
    static void printVersion() {
        System.err.print("Beaver parser generator v");
        System.err.println("0.9.6.1");
        System.err.println("Copyright (C) 2003,2004 Alexander Demenchuk <alder@softanvil.com>.");
        System.err.println("All rights reserved.");
    }

    static void printUsage() {
        System.err.println("Usage: java -jar beaver.jar [options] <grammar file>");
        System.err.println("where possible options are:");
        System.err.println("  -a        Generate parsing states report (.stat)");
        System.err.println("  -c        Do not compress parsing tables");
        System.err.println("  -d <dir>  Specify where to place generated files");
        System.err.println("  -D        Do not generate anything - dry-run");
        System.err.println("  -e        Export parsing tables into a file (.spec)");
        System.err.println("  -n        Generate non-anonymous delegates for action routines");
        System.err.println("  -s        Sort terminals (by name)");
        System.err.println("  -t        Generate terminal names");
        System.err.println("  -T        Export Terminals \"enum\" class into a file");
        System.err.println("  -s        Sort terminals (by name)");
        System.err.println("  -w        Use \"switch\" to invoke action routines");
        System.err.println("  -v        Print version information and exit");
        System.err.println("  -h        Print this help text and exit");
    }

    static Options parseOptions(String[] stringArray) {
        Options options = new Options();
        int n = stringArray.length - 1;
        block14: for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].length();
            if (n2 < 2 || stringArray[i].charAt(0) != '-') {
                throw new IllegalArgumentException("Error: \"" + stringArray[i] + "\" is an invalid option.");
            }
            block15: for (int j = 1; j < n2; ++j) {
                switch (stringArray[i].charAt(j)) {
                    case 'a': {
                        options.report_actions = true;
                        continue block15;
                    }
                    case 'c': {
                        options.no_compression = true;
                        continue block15;
                    }
                    case 'd': {
                        if (++i == n) {
                            throw new IllegalArgumentException("-d option specified without a destination directory.");
                        }
                        options.dest_dir = new File(stringArray[i]);
                        continue block14;
                    }
                    case 'D': {
                        options.no_output = true;
                        continue block15;
                    }
                    case 'e': {
                        options.exp_parsing_tables = true;
                        continue block15;
                    }
                    case 'n': {
                        options.name_action_classes = true;
                        continue block15;
                    }
                    case 's': {
                        options.sort_terminals = true;
                        continue block15;
                    }
                    case 't': {
                        options.terminal_names = true;
                        continue block15;
                    }
                    case 'T': {
                        options.export_terminals = true;
                        continue block15;
                    }
                    case 'w': {
                        options.use_switch = true;
                        continue block15;
                    }
                    case 'v': {
                        Make.printVersion();
                        System.exit(0);
                        continue block15;
                    }
                    case 'h': {
                        Make.printUsage();
                        System.exit(0);
                        continue block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Error: \"-" + stringArray[i].charAt(j) + "\" is an invalid option.");
                    }
                }
            }
        }
        return options;
    }

    static File getSrcFile(String string) {
        File file = new File(string);
        if (!file.canRead()) {
            throw new IllegalArgumentException("Error: cannot read \"" + string + "\"");
        }
        return file;
    }

    static void compile(SrcReader srcReader, Options options, Log log) {
        try {
            ParserGenerator.compile(srcReader, options, log);
        }
        catch (Parser.Exception exception) {
            System.err.print("Error: ");
            System.err.println(exception.getMessage());
        }
        catch (Grammar.Exception exception) {
            System.err.print("Error: ");
            System.err.println(exception.getMessage());
        }
        catch (IOException iOException) {
            System.err.print("System Error: ");
            System.err.println(iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            Make.printUsage();
        } else {
            try {
                Log log = new Log();
                Options options = Make.parseOptions(stringArray);
                File file = Make.getSrcFile(stringArray[stringArray.length - 1]);
                SrcReader srcReader = new SrcReader(file);
                Make.compile(srcReader, options, log);
                log.report(file.getName(), srcReader);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.getMessage());
                Make.printUsage();
            }
        }
    }
}

