/*
 * Decompiled with CFR 0.152.
 */
package beaver.spec;

import beaver.Symbol;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import beaver.spec.ast.Declaration;
import beaver.spec.ast.GrammarTreeRoot;
import beaver.spec.ast.Rule;
import beaver.spec.ast.TreeWalker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class GrammarBuilder
extends TreeWalker {
    private Log log;
    private Grammar grammar;
    private HashMap symbols;
    private int n_nonterms;
    private int n_terms;
    private int n_rules;

    private static boolean checkBraces(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                ++n;
            } else if (c == '}') {
                --n;
            }
            if (n >= 0) continue;
            bl = true;
        }
        return !bl && n == 0;
    }

    private static String trimCode(String string) {
        if (string != null) {
            int n = string.length();
            while (Character.isWhitespace(string.charAt(--n))) {
            }
            if (string.charAt(n) == '\n' && string.charAt(--n) == '\r') {
                --n;
            }
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public GrammarBuilder(Log log) {
        this.log = log;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void visit(GrammarTreeRoot grammarTreeRoot) {
        NonTerminal[] nonTerminalArray;
        this.grammar = new Grammar();
        this.symbols = new HashMap(89);
        this.symbols.put(this.grammar.error.name, this.grammar.error);
        this.n_nonterms = 1;
        this.n_terms = 1;
        this.n_rules = 0;
        final HashMap hashMap = new HashMap(89);
        final ArrayList arrayList = new ArrayList();
        grammarTreeRoot.accept(new TreeWalker(){

            public void visit(Declaration.Terminals terminals) {
                for (int i = 0; i < terminals.symbols.length; ++i) {
                    String string = (String)terminals.symbols[i].value;
                    if (GrammarBuilder.this.symbols.containsKey(string)) continue;
                    GrammarBuilder.this.symbols.put(string, new Terminal(string));
                    GrammarBuilder.this.n_terms++;
                    hashMap.put(string, terminals.symbols[i]);
                }
            }

            public void visit(Rule rule) {
                String string = rule.getLHSSymbolName();
                if (!GrammarBuilder.this.symbols.containsKey(string)) {
                    GrammarBuilder.this.symbols.put(string, new NonTerminal(string));
                    GrammarBuilder.this.n_nonterms++;
                } else if (hashMap.containsKey(string)) {
                    GrammarBuilder.this.log.error(rule.lhs_sym, "nonterminal was declared as a terminal");
                    GrammarBuilder.this.symbols.put(string, new NonTerminal(string));
                    GrammarBuilder.this.n_nonterms++;
                    hashMap.remove(string);
                    GrammarBuilder.this.n_terms--;
                }
                super.visit(rule);
            }

            public void visit(Rule.Definition definition) {
                String string = definition.getPrecedenceSymbolName();
                if (string != null && !GrammarBuilder.this.symbols.containsKey(string)) {
                    Terminal terminal = new Terminal(string);
                    terminal.id = (short)-1;
                    GrammarBuilder.this.symbols.put(string, terminal);
                }
                GrammarBuilder.this.n_rules++;
            }
        });
        grammarTreeRoot.accept(new RuleWalker(){

            public void visit(Rule.Definition.Element element) {
                String string = element.getName();
                GrammarSymbol grammarSymbol = (GrammarSymbol)GrammarBuilder.this.symbols.get(string);
                if (grammarSymbol == null) {
                    GrammarBuilder.this.log.error(element.sym_name, "symbol is neither a terminal nor a nonterminal of the grammar");
                    grammarSymbol = new Terminal(string);
                    GrammarBuilder.this.symbols.put(string, grammarSymbol);
                    grammarSymbol.id = (short)-1;
                } else if (grammarSymbol instanceof Terminal) {
                    if (grammarSymbol.id < 0) {
                        GrammarBuilder.this.log.error(element.sym_name, "symbol is not declared as a grammar terminal");
                    } else {
                        hashMap.remove(string);
                    }
                }
            }
        });
        Object object = hashMap.values().iterator();
        while (object.hasNext()) {
            nonTerminalArray = (NonTerminal[])object.next();
            this.log.warning((Symbol)nonTerminalArray, "declared terminal is not used by the grammar");
            this.symbols.remove(nonTerminalArray.value);
            --this.n_terms;
        }
        grammarTreeRoot.accept(new DeclarationWalker(){
            private int precedence = Integer.MAX_VALUE;
            private HashSet imports = new HashSet(23);

            public void visit(GrammarTreeRoot grammarTreeRoot) {
                this.imports.add("java.util.ArrayList");
                this.imports.add("beaver.*");
                super.visit(grammarTreeRoot);
                ((GrammarBuilder)GrammarBuilder.this).grammar.imports = this.imports.toArray(new String[this.imports.size()]);
            }

            public void visit(Declaration.Header header) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.prolog == null) {
                    char c;
                    String string = (String)header.code.value;
                    int n = 0;
                    while (Character.isWhitespace(c = string.charAt(n)) || c == '\n') {
                        ++n;
                    }
                    ((GrammarBuilder)GrammarBuilder.this).grammar.prolog = n > 0 ? string.substring(n) : string;
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.prolog = ((GrammarBuilder)GrammarBuilder.this).grammar.prolog + (String)header.code.value;
                }
            }

            public void visit(Declaration.PackageName packageName) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.package_name != null) {
                    GrammarBuilder.this.log.warning(packageName.name, "Parser package has been already defined as \"" + ((GrammarBuilder)GrammarBuilder.this).grammar.package_name + "\", new name ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.package_name = packageName.getName();
                }
            }

            public void visit(Declaration.Imports imports) {
                for (int i = 0; i < imports.symbols.length; ++i) {
                    this.imports.add(imports.symbols[i].value);
                }
            }

            public void visit(Declaration.ClassName className) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.class_name != null) {
                    GrammarBuilder.this.log.warning(className.name, "Parser class name has been already defined as \"" + ((GrammarBuilder)GrammarBuilder.this).grammar.class_name + "\", new name ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.class_name = className.getName();
                }
            }

            public void visit(Declaration.ClassCode classCode) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.class_code != null) {
                    GrammarBuilder.this.log.warning(classCode.code, "Embedded parser class code has been already defined, new code ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.class_code = GrammarBuilder.trimCode(this.getCode(classCode));
                }
            }

            public void visit(Declaration.ConstructorCode constructorCode) {
                if (((GrammarBuilder)GrammarBuilder.this).grammar.init_code != null) {
                    GrammarBuilder.this.log.warning(constructorCode.code, "Parser initialization code has been already defined, new code ignored.");
                } else {
                    ((GrammarBuilder)GrammarBuilder.this).grammar.init_code = GrammarBuilder.trimCode(this.getCode(constructorCode));
                }
            }

            public void visit(Declaration.Goal goal) {
                String string = goal.getName();
                GrammarSymbol grammarSymbol = (GrammarSymbol)GrammarBuilder.this.symbols.get(string);
                if (grammarSymbol == null) {
                    GrammarBuilder.this.log.error(goal.name, "Symbol is undefined");
                } else if (grammarSymbol instanceof Terminal) {
                    GrammarBuilder.this.log.error(goal.name, "Symbol is a terminal");
                } else {
                    arrayList.add(grammarSymbol);
                }
            }

            public void visit(Declaration.TypeOf typeOf) {
                String string = typeOf.getTypeName();
                for (int i = 0; i < typeOf.symbols.length; ++i) {
                    GrammarSymbol grammarSymbol = (GrammarSymbol)GrammarBuilder.this.symbols.get(typeOf.symbols[i].value);
                    if (grammarSymbol == null) {
                        GrammarBuilder.this.log.error(typeOf.symbols[i], "Symbol is undefined");
                        continue;
                    }
                    if (grammarSymbol.type != null) {
                        GrammarBuilder.this.log.error(typeOf.symbols[i], "Symbol's Java type is already set to \"" + grammarSymbol.type + "\"");
                        continue;
                    }
                    grammarSymbol.type = string;
                }
            }

            public void visit(Declaration.LeftAssoc leftAssoc) {
                this.setPrecedence(leftAssoc, Terminal.Associativity.LEFT);
            }

            public void visit(Declaration.RightAssoc rightAssoc) {
                this.setPrecedence(rightAssoc, Terminal.Associativity.RIGHT);
            }

            public void visit(Declaration.NonAssoc nonAssoc) {
                this.setPrecedence(nonAssoc, Terminal.Associativity.NONE);
            }

            private void setPrecedence(Declaration.SymbolsContainer symbolsContainer, Terminal.Associativity associativity) {
                for (int i = 0; i < symbolsContainer.symbols.length; ++i) {
                    String string = (String)symbolsContainer.symbols[i].value;
                    GrammarSymbol grammarSymbol = (GrammarSymbol)GrammarBuilder.this.symbols.get(string);
                    if (grammarSymbol == null) {
                        GrammarBuilder.this.log.warning(symbolsContainer.symbols[i], "Symbol is not used by the grammar");
                        continue;
                    }
                    if (grammarSymbol instanceof NonTerminal) {
                        GrammarBuilder.this.log.error(symbolsContainer.symbols[i], "Symbol is a non-terminal.");
                        continue;
                    }
                    ((Terminal)grammarSymbol).setPrecedence(this.precedence, associativity);
                }
                --this.precedence;
            }

            private String getCode(Declaration.CodeContainer codeContainer) {
                String string = codeContainer.getCode();
                if (!GrammarBuilder.checkBraces(string)) {
                    GrammarBuilder.this.log.warning(codeContainer, "Java code has unbalanced braces");
                }
                return string;
            }
        });
        object = new ArrayList(this.n_rules * 2);
        if (arrayList.isEmpty()) {
            this.log.warning(grammarTreeRoot.rules[0].lhs_sym, "Grammar has not declared any goals, will use first declared nonterminal");
            this.grammar.goal_symbol = (NonTerminal)this.symbols.get(grammarTreeRoot.rules[0].getLHSSymbolName());
        } else if (arrayList.size() == 1) {
            this.grammar.goal_symbol = (NonTerminal)arrayList.get(0);
        } else {
            nonTerminalArray = arrayList.toArray(new NonTerminal[arrayList.size()]);
            this.grammar.goal_symbol = new NonTerminal("$goal");
            this.symbols.put(this.grammar.goal_symbol.name, this.grammar.goal_symbol);
            ++this.n_nonterms;
            ((ArrayList)object).add(new Production(((ArrayList)object).size(), this.grammar.goal_symbol, new Production.RHS(nonTerminalArray[0])));
            for (int i = 1; i < nonTerminalArray.length; ++i) {
                Terminal terminal = new Terminal("$" + nonTerminalArray[i].name);
                this.symbols.put(terminal.name, terminal);
                ++this.n_terms;
                ((ArrayList)object).add(new Production(((ArrayList)object).size(), this.grammar.goal_symbol, new Production.RHS(terminal, nonTerminalArray[i])));
            }
        }
        grammarTreeRoot.accept(new RuleWalker((ArrayList)object){
            boolean found = false;
            private final /* synthetic */ ArrayList val$rules;
            {
                this.val$rules = arrayList;
            }

            public void visit(GrammarTreeRoot grammarTreeRoot) {
                super.visit(grammarTreeRoot);
                if (this.found) {
                    NonTerminal nonTerminal = new NonTerminal("$goal");
                    nonTerminal.type = ((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol.type;
                    GrammarBuilder.this.symbols.put(nonTerminal.name, nonTerminal);
                    GrammarBuilder.this.n_nonterms++;
                    this.val$rules.add(new Production(this.val$rules.size(), nonTerminal, new Production.RHS(((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol)));
                    ((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol = nonTerminal;
                }
            }

            public void visit(Rule.Definition.Element element) {
                if (!this.found) {
                    this.found = ((GrammarBuilder)GrammarBuilder.this).grammar.goal_symbol.name.equals(element.getName());
                }
            }
        });
        grammarTreeRoot.accept(new RuleWalker((ArrayList)object){
            private NonTerminal lhs_sym;
            private ArrayList rhs_elements = new ArrayList();
            private final /* synthetic */ ArrayList val$rules;
            {
                this.val$rules = arrayList;
            }

            public void visit(Rule rule) {
                this.lhs_sym = (NonTerminal)GrammarBuilder.this.symbols.get(rule.getLHSSymbolName());
                super.visit(rule);
            }

            public void visit(Rule.Definition definition) {
                this.rhs_elements.clear();
                super.visit(definition);
                Production production = new Production(this.val$rules.size(), this.lhs_sym, new Production.RHS(this.rhs_elements.toArray(new Production.RHS.Item[this.rhs_elements.size()])), definition.getPrecedenceSymbolName() == null ? null : (Terminal)GrammarBuilder.this.symbols.get(definition.getPrecedenceSymbolName()));
                String string = definition.getReduceActionCode();
                if (string != null) {
                    if (!GrammarBuilder.checkBraces(string)) {
                        GrammarBuilder.this.log.warning(definition.code, "Java code has unbalanced braces");
                    }
                    production.code = GrammarBuilder.trimCode(string);
                }
                if (definition.elements.length > 0) {
                    production.start_pos = definition.elements[0].getStart();
                    production.end_pos = definition.elements[definition.elements.length - 1].getEnd();
                }
                this.val$rules.add(production);
            }

            public void visit(Rule.Definition.Element element) {
                GrammarSymbol grammarSymbol = element.ebnf_sym.value == null ? (GrammarSymbol)GrammarBuilder.this.symbols.get(element.getName()) : this.getExtendedSymbol(element);
                this.rhs_elements.add(new Production.RHS.Item(grammarSymbol, element.getAlias()));
            }

            private GrammarSymbol getExtendedSymbol(Rule.Definition.Element element) {
                switch (element.getExtUseMark()) {
                    case '?': {
                        return this.getOpt(element.getName());
                    }
                    case '+': {
                        return this.getLst(element.getName());
                    }
                    case '*': {
                        return this.getOpt(this.getLst((String)element.getName()).name);
                    }
                }
                throw new IllegalArgumentException("unrecognized extended symbol notation");
            }

            private NonTerminal getOpt(String string) {
                String string2 = "opt$" + string;
                NonTerminal nonTerminal = (NonTerminal)GrammarBuilder.this.symbols.get(string2);
                if (nonTerminal == null) {
                    GrammarSymbol grammarSymbol = (GrammarSymbol)GrammarBuilder.this.symbols.get(string);
                    nonTerminal = new NonTerminal(string2, grammarSymbol.type);
                    GrammarBuilder.this.symbols.put(string2, nonTerminal);
                    GrammarBuilder.this.n_nonterms++;
                    this.val$rules.add(new Production(this.val$rules.size(), nonTerminal, new Production.RHS()));
                    this.val$rules.add(new Production(this.val$rules.size(), nonTerminal, new Production.RHS(grammarSymbol)));
                }
                return nonTerminal;
            }

            private NonTerminal getLst(String string) {
                String string2 = "lst$" + string;
                NonTerminal nonTerminal = (NonTerminal)GrammarBuilder.this.symbols.get(string2);
                if (nonTerminal == null) {
                    GrammarSymbol grammarSymbol = (GrammarSymbol)GrammarBuilder.this.symbols.get(string);
                    nonTerminal = new NonTerminal(string2, grammarSymbol.type != null ? "+" + grammarSymbol.type : null);
                    GrammarBuilder.this.symbols.put(string2, nonTerminal);
                    GrammarBuilder.this.n_nonterms++;
                    this.val$rules.add(new Production(this.val$rules.size(), nonTerminal, new Production.RHS(grammarSymbol)));
                    this.val$rules.add(new Production(this.val$rules.size(), nonTerminal, new Production.RHS(nonTerminal, grammarSymbol)));
                }
                return nonTerminal;
            }
        });
        this.grammar.rules = ((ArrayList)object).toArray(new Production[((ArrayList)object).size()]);
        this.grammar.nonterminals = this.getNonTerminals();
        this.grammar.terminals = this.getTerminals();
        this.propagateTypes(this.grammar.nonterminals);
        this.writeListsCode(this.grammar.nonterminals);
    }

    private Terminal[] getTerminals() {
        Production[] productionArray = new Production[this.grammar.rules.length];
        System.arraycopy(this.grammar.rules, 0, productionArray, 0, productionArray.length);
        Arrays.sort(productionArray, Production.NUM_TERM_CMP);
        Terminal[] terminalArray = new Terminal[this.n_terms];
        terminalArray[0] = this.grammar.eof;
        int n = 1;
        for (int i = 0; i < productionArray.length; ++i) {
            Production.RHS rHS = productionArray[i].rhs;
            if (rHS.n_term <= 0) continue;
            for (int j = 0; j < rHS.items.length; ++j) {
                GrammarSymbol grammarSymbol = rHS.items[j].symbol;
                if (!(grammarSymbol instanceof Terminal) || grammarSymbol.id != 0) continue;
                Terminal terminal = (Terminal)grammarSymbol;
                terminal.id = (short)n;
                terminalArray[n++] = terminal;
            }
        }
        if (n < this.n_terms) {
            throw new IllegalStateException("found less terminals than previously counted");
        }
        return terminalArray;
    }

    private NonTerminal[] getNonTerminals() {
        Production[] productionArray = new Production[this.grammar.rules.length];
        System.arraycopy(this.grammar.rules, 0, productionArray, 0, productionArray.length);
        Arrays.sort(productionArray, Production.NUM_NONTERM_CMP);
        NonTerminal[] nonTerminalArray = new NonTerminal[this.n_nonterms];
        int n = 0;
        for (int i = 0; i < productionArray.length; ++i) {
            Production.RHS rHS = productionArray[i].rhs;
            if (rHS.n_nonterm <= 0) continue;
            for (int j = 0; j < rHS.items.length; ++j) {
                GrammarSymbol grammarSymbol = rHS.items[j].symbol;
                if (!(grammarSymbol instanceof NonTerminal) || grammarSymbol.id != 0) continue;
                NonTerminal nonTerminal = (NonTerminal)grammarSymbol;
                nonTerminal.id = (short)(n + this.n_terms);
                nonTerminalArray[n++] = nonTerminal;
            }
        }
        this.grammar.goal_symbol.id = (short)(n + this.n_terms);
        nonTerminalArray[n++] = this.grammar.goal_symbol;
        if (this.grammar.error.id == 0) {
            this.grammar.error.id = (short)(n + this.n_terms);
            nonTerminalArray[n++] = this.grammar.error;
        }
        if (n < this.n_nonterms) {
            throw new IllegalStateException("found less nonterminals than previously counted");
        }
        return nonTerminalArray;
    }

    private void propagateTypes(NonTerminal[] nonTerminalArray) {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < nonTerminalArray.length; ++i) {
                Production production;
                GrammarSymbol grammarSymbol;
                Production production2;
                if (nonTerminalArray[i].type != null) continue;
                if (nonTerminalArray[i].definitions.size() != 2) {
                    if (nonTerminalArray[i].definitions.size() != 1) continue;
                    production2 = nonTerminalArray[i].definitions.start();
                    if (production2.code != null || production2.rhs.size() != 1) continue;
                    grammarSymbol = production2.rhs.start().symbol;
                    if (grammarSymbol.type == null) continue;
                    nonTerminalArray[i].type = grammarSymbol.type;
                    bl = true;
                    continue;
                }
                production2 = nonTerminalArray[i].definitions.start();
                if (production2.rhs.size() != 1) {
                    production2 = production2.next_definition;
                    if (production2.rhs.size() != 1) continue;
                }
                if (production2.code != null) continue;
                grammarSymbol = production2.rhs.start().symbol;
                if (grammarSymbol.type == null) continue;
                Production production3 = production = production2.next_definition != null ? production2.next_definition : nonTerminalArray[i].definitions.start();
                if (production.code != null) continue;
                if (production.rhs.size() == 0) {
                    nonTerminalArray[i].type = grammarSymbol.type;
                    bl = true;
                    continue;
                }
                if (production.rhs.size() < 2 || production.rhs.start().symbol != nonTerminalArray[i] || production.rhs.end().symbol != grammarSymbol) continue;
                nonTerminalArray[i].type = "+" + grammarSymbol.type;
                bl = true;
            }
        } while (bl);
    }

    private void writeListsCode(NonTerminal[] nonTerminalArray) {
        for (int i = 0; i < nonTerminalArray.length; ++i) {
            if (nonTerminalArray[i].definitions.size() != 2) continue;
            Production production = nonTerminalArray[i].definitions.start();
            if (production.rhs.size() != 1) {
                production = production.next_definition;
                if (production.rhs.size() != 1) continue;
            }
            if (production.code != null) continue;
            GrammarSymbol grammarSymbol = production.rhs.start().symbol;
            Production production2 = nonTerminalArray[i].definitions.start();
            if (production2.rhs.size() < 2) {
                production2 = production2.next_definition;
                if (production2.rhs.size() < 2) continue;
            }
            if (production2.code != null || production2.rhs.start().symbol != nonTerminalArray[i] || production2.rhs.end().symbol != grammarSymbol) continue;
            if (nonTerminalArray[i].type == null) {
                nonTerminalArray[i].type = "+" + (grammarSymbol.type != null ? grammarSymbol.type : "beaver.Symbol");
            }
            production.code = new StringBuffer(Grammar.EBNF_LIST_TYPE_NAME.length() * 2 + 77).append(Grammar.EBNF_LIST_TYPE_NAME).append(" lst = new ").append(Grammar.EBNF_LIST_TYPE_NAME).append("(); ").append("lst.add(_symbols[offset + 1]").append(grammarSymbol.type != null ? ".value" : "").append("); ").append("return new Symbol(lst);").toString();
            production2.code = new StringBuffer(Grammar.EBNF_LIST_TYPE_NAME.length() + 88).append("((").append(Grammar.EBNF_LIST_TYPE_NAME).append(") _symbols[offset + 1].value).add(_symbols[offset + ").append(production2.rhs.size()).append("]").append(grammarSymbol.type != null ? ".value" : "").append("); ").append("return _symbols[offset + 1];").toString();
        }
    }

    static class DeclarationWalker
    extends TreeWalker {
        DeclarationWalker() {
        }

        public void visit(GrammarTreeRoot grammarTreeRoot) {
            for (int i = 0; i < grammarTreeRoot.declarations.length; ++i) {
                grammarTreeRoot.declarations[i].accept(this);
            }
        }
    }

    static class RuleWalker
    extends TreeWalker {
        RuleWalker() {
        }

        public void visit(GrammarTreeRoot grammarTreeRoot) {
            for (int i = 0; i < grammarTreeRoot.rules.length; ++i) {
                grammarTreeRoot.rules[i].accept(this);
            }
        }
    }
}

