/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.AttrDecl;
import ast.AST.AttrEq;
import ast.AST.Components;
import ast.AST.List;
import ast.AST.ListComponents;
import ast.AST.Node;
import ast.AST.Opt;
import ast.AST.Parameter;
import ast.AST.TypeDecl;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class InhEq
extends AttrEq
implements Cloneable {
    private String tokenString_Name;
    private String tokenString_FileName;
    private int tokenint_StartLine;
    private int tokenint_EndLine;
    private String tokenString_Comment;
    private String tokenString_AspectName;
    private String tokenString_SonName;
    protected boolean error_visited = false;
    protected boolean getComponents_visited = false;
    protected boolean sonName_visited = false;
    protected boolean getSonAttrDecl_visited = false;
    protected boolean decl_visited = false;
    protected boolean decl_computed = false;
    protected AttrDecl decl_value;

    public void flushCache() {
        super.flushCache();
        this.error_visited = false;
        this.getComponents_visited = false;
        this.sonName_visited = false;
        this.getSonAttrDecl_visited = false;
        this.decl_visited = false;
        this.decl_computed = false;
        this.decl_value = null;
    }

    public Object clone() throws CloneNotSupportedException {
        InhEq node = (InhEq)super.clone();
        node.error_visited = false;
        node.getComponents_visited = false;
        node.sonName_visited = false;
        node.getSonAttrDecl_visited = false;
        node.decl_visited = false;
        node.decl_computed = false;
        node.decl_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            InhEq node = (InhEq)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        InhEq res = (InhEq)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public InhEq(int i) {
        super(i);
    }

    public InhEq(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public InhEq() {
        this(0);
        this.setChild(new List(), 0);
        this.setChild(new Opt(), 1);
    }

    public InhEq(List p0, String p1, String p2, int p3, int p4, String p5, String p6, String p7, Opt p8) {
        this.setChild(p0, 0);
        this.setName(p1);
        this.setFileName(p2);
        this.setStartLine(p3);
        this.setEndLine(p4);
        this.setComment(p5);
        this.setAspectName(p6);
        this.setSonName(p7);
        this.setChild(p8, 1);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "InhEq" + "\"" + this.getName() + "\"" + "\"" + this.getFileName() + "\"" + "\"" + this.getStartLine() + "\"" + "\"" + this.getEndLine() + "\"" + "\"" + this.getComment() + "\"" + "\"" + this.getAspectName() + "\"" + "\"" + this.getSonName() + "\"");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0) {
            if (!(n instanceof List)) {
                throw new Error("Child number 0 of InhEq has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            int k = 0;
            while (k < ((List)n).getNumChild()) {
                if (!(((List)n).getChildNoTransform(k) instanceof Parameter)) {
                    throw new Error("Child number " + k + " in ParameterList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Parameter");
                }
                ++k;
            }
        }
        if (i == 1) {
            if (!(n instanceof Opt)) {
                throw new Error("Child number 1 of InhEq has the type " + n.getClass().getName() + " which is not an instance of Opt");
            }
            if (((Opt)n).getNumChild() != 0 && !(((Opt)n).getChildNoTransform(0) instanceof Parameter)) {
                throw new Error("Optional Index has the type " + ((Opt)n).getChildNoTransform(0).getClass().getName() + " which is not an instance of Parameter");
            }
        }
    }

    public int getNumChild() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setParameterList(List list) {
        this.setChild(list, 0);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public Parameter getParameter(int i) {
        return (Parameter)this.getParameterList().getChild(i);
    }

    public void addParameter(Parameter node) {
        List list = this.getParameterList();
        list.setChild(node, list.getNumChild());
    }

    public void setParameter(Parameter node, int i) {
        List list = this.getParameterList();
        list.setChild(node, i);
    }

    public List getParameterList() {
        return (List)this.getChild(0);
    }

    public List getParameterListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public String getName() {
        return this.tokenString_Name;
    }

    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    public String getFileName() {
        return this.tokenString_FileName;
    }

    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    public String getComment() {
        return this.tokenString_Comment;
    }

    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    public String getAspectName() {
        return this.tokenString_AspectName;
    }

    public void setSonName(String value) {
        this.tokenString_SonName = value;
    }

    public String getSonName() {
        return this.tokenString_SonName;
    }

    public void setIndexOpt(Opt opt) {
        this.setChild(opt, 1);
    }

    public boolean hasIndex() {
        return this.getIndexOpt().getNumChild() != 0;
    }

    public Parameter getIndex() {
        return (Parameter)this.getIndexOpt().getChild(0);
    }

    public void setIndex(Parameter node) {
        this.getIndexOpt().setChild(node, 0);
    }

    public Opt getIndexOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt getIndexOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    public String error() {
        boolean interruptedCircle = false;
        if (this.error_visited) {
            throw new RuntimeException("Circular definition of attr: error in class: ");
        }
        this.error_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String error_value = this.error_compute();
        this.error_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return error_value;
    }

    private String error_compute() {
        StringBuffer result = new StringBuffer();
        if (this.getComponents() == null && this.getSonName().startsWith("get") && !this.getSonName().equals("getChild")) {
            result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
            result.append("Inherited equation for unknown son " + this.sonName() + " in class " + this.hostClass().name() + "\n");
            Iterator iter = this.hostClass().getComponents();
            while (iter.hasNext()) {
                Components c = (Components)iter.next();
                result.append(String.valueOf(c.type()) + " " + c.name() + "\n");
            }
        } else if (this.getComponents() == null && !this.getSonName().equals("getChild")) {
            AttrDecl decl = this.getSonAttrDecl();
            if (decl == null) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Inherited equation for unknown NTA " + this.sonName() + " in class " + this.hostClass().name() + "\n");
            } else if (!decl.getNTA()) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Inherited equation for attribute " + this.sonName() + " which is not a NTA");
            }
        } else {
            InhEq equation = this.hostClass().lookupInhEq(this.signature(), this.sonName());
            if (equation != null && equation != this) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("Multiple equation for inherited attribute " + this.sonName() + "." + this.name() + " in class " + this.hostClass().name());
                result.append(" and " + equation.name() + " in class " + equation.hostClass().name() + " in " + equation.getFileName() + ":" + equation.getStartLine() + "\n");
            } else if (this.hasIndex() && !(this.getComponents() instanceof ListComponents) && !this.getSonName().equals("getChild")) {
                result.append(String.valueOf(this.getFileName()) + ":" + this.getStartLine() + " ");
                result.append("May not supply index for non list child " + this.sonName() + " in class " + this.hostClass().name() + "\n");
            }
        }
        return result.toString();
    }

    public Components getComponents() {
        boolean interruptedCircle = false;
        if (this.getComponents_visited) {
            throw new RuntimeException("Circular definition of attr: getComponents in class: ");
        }
        this.getComponents_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        Components getComponents_value = this.getComponents_compute();
        this.getComponents_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return getComponents_value;
    }

    private Components getComponents_compute() {
        TypeDecl c = this.hostClass();
        if (c != null) {
            return c.components(this.sonName());
        }
        return null;
    }

    public String sonName() {
        boolean interruptedCircle = false;
        if (this.sonName_visited) {
            throw new RuntimeException("Circular definition of attr: sonName in class: ");
        }
        this.sonName_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String sonName_value = this.sonName_compute();
        this.sonName_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return sonName_value;
    }

    private String sonName_compute() {
        return this.getSonName().startsWith("get") ? this.getSonName().substring(3) : this.getSonName();
    }

    public AttrDecl getSonAttrDecl() {
        boolean interruptedCircle = false;
        if (this.getSonAttrDecl_visited) {
            throw new RuntimeException("Circular definition of attr: getSonAttrDecl in class: ");
        }
        this.getSonAttrDecl_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        AttrDecl getSonAttrDecl_value = this.getSonAttrDecl_compute();
        this.getSonAttrDecl_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return getSonAttrDecl_value;
    }

    private AttrDecl getSonAttrDecl_compute() {
        AttrDecl decl = this.hostClass().lookupSynDeclPrefix(this.sonName());
        if (decl == null) {
            decl = this.hostClass().lookupInhDeclPrefix(this.sonName());
        }
        return decl;
    }

    public AttrDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        boolean interruptedCircle = false;
        if (this.decl_visited) {
            throw new RuntimeException("Circular definition of attr: decl in class: ");
        }
        this.decl_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        int num = ASTNode.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == ASTNode.boundariesCrossed) {
            this.decl_computed = true;
        }
        this.decl_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return this.decl_value;
    }

    private AttrDecl decl_compute() {
        return this.hostClass().getInhDeclFor(this.signature(), new LinkedHashSet());
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

