/*
 * Decompiled with CFR 0.152.
 */
package jastadd;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.Components;
import ast.AST.Grammar;
import ast.AST.ParseException;
import ast.AST.TokenComponent;
import ast.AST.TokenMgrError;
import jastadd.CommandLineArguments;
import jastadd.JastAddCodeGen;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import jrag.AST.JragParser;
import jrag.Doc;

public class JastAdd {
    public static final String VERSION = "JastAdd II (http://jastadd.cs.lth.se) version R20081114";
    public static final String VERSIONINFO = "\n// Generated with JastAdd II (http://jastadd.cs.lth.se) version R20081114\n\n";
    protected List files;
    protected Grammar root;
    protected String pack;
    protected File outputDir;
    protected String grammar;
    protected boolean publicModifier;

    public static void main(String[] args) {
        new JastAdd().compile(args);
        Runtime.getRuntime().gc();
    }

    /*
     * Unable to fully structure code
     */
    public void compile(String[] args) {
        try {
            this.files = new ArrayList<E>();
            if (this.readArgs(args)) {
                System.exit(1);
            }
            time = System.currentTimeMillis();
            this.root = new Grammar();
            this.root.abstractAncestors();
            errors = new ArrayList<String>();
            iter = this.files.iterator();
            while (iter.hasNext()) {
                fileName = (String)iter.next();
                if (!fileName.endsWith(".ast")) continue;
                try {
                    parser = new Ast(new FileInputStream(fileName));
                    parser.fileName = new File(fileName).getName();
                    g = parser.Grammar();
                    i = 0;
                    while (i < g.getNumTypeDecl()) {
                        this.root.addTypeDecl(g.getTypeDecl(i));
                        ++i;
                    }
                    errorIter = parser.getErrors();
                    while (errorIter.hasNext()) {
                        s = ((String)errorIter.next()).split(";");
                        errors.add("Syntax error in " + fileName + " at line " + s[0] + ", column " + s[1]);
                    }
                }
                catch (TokenMgrError e) {
                    System.out.println("Lexical error in " + fileName + ": " + e.getMessage());
                    System.exit(1);
                }
                catch (ParseException v0) {
                }
                catch (FileNotFoundException v1) {
                    System.out.println("File error: Abstract syntax grammar file " + fileName + " not found");
                    System.exit(1);
                }
            }
            if (!errors.isEmpty()) {
                iter = errors.iterator();
                while (iter.hasNext()) {
                    System.out.println(iter.next());
                }
                System.exit(1);
            }
            astParseTime = System.currentTimeMillis() - time;
            astErrors = this.root.astErrors();
            astErrorTime = System.currentTimeMillis() - time - astParseTime;
            if (!astErrors.equals("")) {
                System.out.println("Semantic error:");
                System.out.println(astErrors);
                System.exit(1);
            }
            ASTNode.resetGlobalErrors();
            writer = new StringWriter();
            this.root.jjtGenASTNode$State(new PrintWriter(writer), this.grammar, ASTNode.jjtree, ASTNode.rewriteEnabled);
            jp = new JragParser(new StringReader(writer.toString()));
            jp.root = this.root;
            jp.setFileName("ASTNode");
            jp.className = "ASTNode";
            jp.pushTopLevelOrAspect(true);
            try {
                while (true) {
                    jp.AspectBodyDeclaration();
                }
            }
            catch (Exception e) {
                e.getMessage();
                jp.popTopLevelOrAspect();
                iter = this.files.iterator();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                fileName = (String)iter.next();
                if (!fileName.endsWith(".jrag") && !fileName.endsWith(".jadd")) continue;
                try {
                    inputStream = new FileInputStream(fileName);
                    jp = new JragParser(inputStream);
                    jp.inputStream = inputStream;
                    jp.root = this.root;
                    jp.setFileName(new File(fileName).getName());
                    var19_27 = jp;
                    if (Doc.ajc$if_0(var19_27)) {
                        Doc.aspectOf().ajc$before$jrag_Doc$1$bb37984f(var19_27);
                    }
                    au = var19_27.CompilationUnit();
                    this.root.addCompUnit(au);
                }
                catch (jrag.AST.ParseException e) {
                    msg = new StringBuffer();
                    msg.append("Syntax error in " + fileName + " at line " + e.currentToken.next.beginLine + ", column " + e.currentToken.next.beginColumn);
                    System.out.println(msg.toString());
                    System.exit(1);
                }
                catch (FileNotFoundException v2) {
                    System.out.println("File error: Aspect file " + fileName + " not found");
                    System.exit(1);
                }
                continue;
            }
lbl95:
            // 1 sources

            jragParseTime = System.currentTimeMillis() - time - astErrorTime;
            i = 0;
            while (i < this.root.getNumTypeDecl()) {
                if (this.root.getTypeDecl(i) instanceof ASTDecl) {
                    decl = (ASTDecl)this.root.getTypeDecl(i);
                    writer = new StringWriter();
                    decl.jjtGen(new PrintWriter(writer), this.grammar, ASTNode.jjtree, ASTNode.rewriteEnabled);
                    jp = new JragParser(new StringReader(writer.toString()));
                    jp.root = this.root;
                    jp.setFileName(decl.getFileName());
                    jp.className = "ASTNode";
                    jp.pushTopLevelOrAspect(true);
                    try {
                        while (true) {
                            jp.AspectBodyDeclaration();
                        }
                    }
                    catch (Exception e) {
                        e.getMessage();
                        jp.popTopLevelOrAspect();
                        j = 0;
                        iter = decl.getComponents();
                        ** while (iter.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        c = (Components)iter.next();
                        if (c instanceof TokenComponent) {
                            c.jaddGen(null, j, this.publicModifier, decl);
                            continue;
                        }
                        c.jaddGen(null, j, this.publicModifier, decl);
                        ++j;
                        continue;
                    }
                }
lbl125:
                // 3 sources

                ++i;
            }
            if (Doc.ajc$if_2()) {
                Doc.aspectOf().ajc$before$jrag_Doc$3$68df8c27();
            }
            this.root.processRefinements();
            JastAddCodeGen.ajc$interMethodDispatch1$jastadd_JastAddCodeGen$ast_AST_Grammar$weaveInterfaceIntroductions(this.root);
            this.root.weaveCollectionAttributes();
            err = this.root.errors();
            if (!err.equals("") || !ASTNode.globalErrors.equals("")) {
                System.out.println("Semantic errors: \n" + err + ASTNode.globalErrors);
                System.exit(1);
            }
            jragErrorTime = System.currentTimeMillis() - time - jragParseTime;
            JastAddCodeGen.ajc$interMethodDispatch1$jastadd_JastAddCodeGen$ast_AST_Grammar$jastAddGen(this.root, this.outputDir, this.grammar, this.pack, this.publicModifier);
            try {
                this.root.createInterfaces(this.outputDir, this.pack);
            }
            catch (FileNotFoundException v3) {
                System.out.println("File error: Output directory " + this.outputDir + " does not exist or is write protected");
                System.exit(1);
            }
            System.currentTimeMillis() - time - jragErrorTime;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public boolean readArgs(String[] args) {
        CommandLineArguments cla = new CommandLineArguments(args);
        if (cla.hasLongOption("jjtree") && !cla.hasLongOption("grammar")) {
            System.out.println("Missing grammar option that is required in jjtree-mode");
            return true;
        }
        ASTNode.jjtree = cla.hasLongOption("jjtree");
        this.grammar = cla.getLongOptionValue("grammar", "Unknown");
        ASTNode.createDefaultMap = cla.getLongOptionValue("defaultMap", "new java.util.HashMap(4)");
        ASTNode.createDefaultSet = cla.getLongOptionValue("defaultSet", "new java.util.HashSet(4)");
        ASTNode.lazyMaps = cla.hasLongOption("lazyMaps");
        this.publicModifier = !cla.hasLongOption("private");
        ASTNode.rewriteEnabled = cla.hasLongOption("rewrite");
        ASTNode.beaver = cla.hasLongOption("beaver");
        ASTNode.visitCheckEnabled = !cla.hasLongOption("novisitcheck");
        ASTNode.cacheCycle = !cla.hasLongOption("noCacheCycle");
        ASTNode.componentCheck = !cla.hasLongOption("noComponentCheck");
        ASTNode.noInhEqCheck = cla.hasLongOption("noInhEqCheck");
        ASTNode.suppressWarnings = cla.hasLongOption("suppressWarnings");
        ASTNode.parentInterface = cla.hasLongOption("parentInterface");
        ASTNode.refineLegacy = cla.hasLongOption("refineLegacy");
        ASTNode.stagedRewrites = cla.hasLongOption("stagedRewrites");
        ASTNode.doc = cla.hasLongOption("doc");
        ASTNode.license = "";
        if (cla.hasLongOption("license")) {
            String fileName = cla.getLongOptionValue("license", null);
            try {
                if (fileName != null) {
                    ASTNode.license = this.readFile(fileName);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error loading license file " + fileName);
                System.exit(1);
            }
        }
        boolean bl = ASTNode.java5 = !cla.hasLongOption("java1.4");
        if (cla.hasLongOption("debug")) {
            ASTNode.debugMode = true;
            ASTNode.cycleLimit = 100;
            ASTNode.rewriteLimit = 100;
            ASTNode.visitCheckEnabled = true;
        }
        ASTNode.block = cla.hasLongOption("synch");
        ASTNode.noStatic = cla.hasLongOption("noStatic");
        if (cla.hasLongOption("deterministic")) {
            ASTNode.createDefaultMap = "new java.util.LinkedHashMap(4)";
            ASTNode.createDefaultSet = "new java.util.LinkedHashSet(4)";
        }
        String outputDirName = cla.getLongOptionValue("o", System.getProperty("user.dir"));
        this.outputDir = new File(outputDirName);
        if (!this.outputDir.exists()) {
            System.out.println("Output directory does not exist");
            System.exit(1);
        }
        if (!this.outputDir.isDirectory()) {
            System.out.println("Output directory is not a directory");
            System.exit(1);
        }
        if (!this.outputDir.canWrite()) {
            System.out.println("Output directory is write protected");
            System.exit(1);
        }
        this.pack = cla.getLongOptionValue("package", "").replace('/', '.');
        int n = cla.getNumOperands();
        int k = 0;
        while (k < n) {
            String fileName = cla.getOperand(k);
            if (!(fileName.endsWith(".ast") || fileName.endsWith(".jrag") || fileName.endsWith(".jadd"))) {
                System.out.println("FileError: " + fileName + " is of unknown file type");
                return true;
            }
            this.files.add(fileName);
            ++k;
        }
        if (cla.hasLongOption("version")) {
            System.out.println(VERSION);
            return true;
        }
        if (cla.hasLongOption("help") || this.files.isEmpty()) {
            System.out.println("JastAdd II (http://jastadd.cs.lth.se) version R20081114\n");
            this.printHelp();
            return true;
        }
        return false;
    }

    private String readFile(String name) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(name));
        char[] cbuf = new char[1024];
        int i = 0;
        while ((i = reader.read(cbuf)) != -1) {
            buf.append(String.valueOf(cbuf, 0, i));
        }
        ((Reader)reader).close();
        return buf.toString();
    }

    private void checkMem() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long use = total - free;
        System.out.println("Before GC: Total " + total + ", use " + use);
        runtime.gc();
        total = runtime.totalMemory();
        free = runtime.freeMemory();
        use = total - free;
        System.out.println("After GC: Total " + total + ", use " + use);
    }

    public void printHelp() {
        System.out.println("This program reads a number of .jrag, .jadd, and .ast files");
        System.out.println("and creates the nodes in the abstract syntax tree");
        System.out.println();
        System.out.println("The .jrag source files may contain declarations of synthesized ");
        System.out.println("and inherited attributes and their corresponding equations.");
        System.out.println("It may also contain ordinary Java methods and fields.");
        System.out.println();
        System.out.println("Source file syntax can be found at http://jastadd.cs.lth.se");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  --help (prints this text and stops)");
        System.out.println("  --version (prints version information and stops)");
        System.out.println("  --package=PPP (optional package for generated files, default is none)");
        System.out.println("  --o=DDD (optional base output directory, default is current directory");
        System.out.println("  --beaver (use beaver base node)");
        System.out.println("  --jjtree (use jjtree base node, this requires --grammar to be set)");
        System.out.println("  --grammar=GGG (the parser for the grammar is called GGG, required when using jjtree)");
        System.out.println("  --rewrite (enable ReRAGs support)");
        System.out.println("  --novisitcheck (disable circularity check for attributes)");
        System.out.println("  --noCacheCycle (disable cache cyle optimization for circular attributes)");
        System.out.println("  --license=LICENSE (include the file LICENSE in each generated file)");
        System.out.println();
        System.out.println("Arguments:");
        System.out.println("Names of .ast, .jrag and .jadd source files");
        System.out.println();
        System.out.println("Example: The following command reads and translates files NameAnalysis.jrag");
        System.out.println("and TypeAnalysis.jrag, weaves PrettyPrint.jadd into the abstract syntax tree");
        System.out.println("defined in the grammar Toy.ast.");
        System.out.println("The result is the generated classes for the nodes in the AST that are placed");
        System.out.println("in the package ast.");
        System.out.println();
        System.out.println("JastAdd --package=ast Toy.ast NameAnalysis.jrag TypeAnalysis.jrag PrettyPrinter.jadd");
        System.out.println();
        System.out.println("Stopping program");
    }
}

