/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.util.BitSet;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class Configuration
implements Comparable {
    Configuration next;
    Production rule;
    int dot;
    BitSet lookaheads;
    PropagationLink fwd_propagation;
    PropagationLink bck_propagation;
    PropagationLink last_bck_propagation;
    boolean has_contributed;

    private Configuration() {
    }

    Configuration(Configuration factory_probe, Grammar grammar) {
        this.rule = factory_probe.rule;
        this.dot = factory_probe.dot;
        this.lookaheads = new BitSet(grammar.terminals.length);
    }

    GrammarSymbol getSymbolAfterDot() {
        return this.rule.rhs.items[this.dot].symbol;
    }

    boolean isDotAfterLastSymbol() {
        return this.dot == this.rule.rhs.items.length;
    }

    void addLookahead(Terminal term) {
        this.lookaheads.add(term.id);
    }

    boolean addLookaheads(Configuration conf) {
        int i = conf.dot + 1;
        while (i < conf.rule.rhs.items.length) {
            GrammarSymbol sym = conf.rule.rhs.items[i].symbol;
            if (sym instanceof Terminal) {
                this.lookaheads.add(sym.id);
                return false;
            }
            NonTerminal nt = (NonTerminal)sym;
            this.lookaheads.add(nt.first_set);
            if (!nt.is_nullable) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void addForwardPropagation(Configuration conf) {
        PropagationLink link = new PropagationLink(conf);
        link.next = this.fwd_propagation;
        this.fwd_propagation = link;
    }

    void addReversePropagation(Configuration conf) {
        PropagationLink link = new PropagationLink(conf);
        this.last_bck_propagation = this.last_bck_propagation == null ? (this.bck_propagation = link) : (this.last_bck_propagation.next = link);
    }

    void appendReversePropagation(Configuration conf) {
        if (this.last_bck_propagation == null) {
            this.bck_propagation = conf.bck_propagation;
        } else {
            this.last_bck_propagation.next = conf.bck_propagation;
        }
        this.last_bck_propagation = conf.last_bck_propagation;
    }

    void reverseReversePropagation() {
        PropagationLink link = this.bck_propagation;
        while (link != null) {
            PropagationLink next_link = link.next;
            Configuration conf = link.conf;
            link.conf = this;
            link.next = conf.fwd_propagation;
            conf.fwd_propagation = link;
            link = next_link;
        }
        this.bck_propagation = null;
    }

    boolean findLookaheads() {
        boolean more_found = false;
        PropagationLink link = this.fwd_propagation;
        while (link != null) {
            if (link.conf.lookaheads.add(this.lookaheads)) {
                more_found = true;
                link.conf.has_contributed = false;
            }
            link = link.next;
        }
        return more_found;
    }

    boolean equals(Configuration conf) {
        return this.rule == conf.rule && this.dot == conf.dot;
    }

    public boolean equals(Object obj) {
        return obj instanceof Configuration && this.equals((Configuration)obj);
    }

    public int hashCode() {
        return this.rule.id * 37 + this.dot;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        Configuration conf = (Configuration)o;
        int cmp = this.rule.id - conf.rule.id;
        if (cmp == 0) {
            cmp = this.dot - conf.dot;
        }
        return cmp;
    }

    public String toString() {
        int line;
        StringBuffer str = new StringBuffer(100);
        str.append(this.rule.lhs).append(" =");
        int i = 0;
        while (i < this.rule.rhs.items.length) {
            Production.RHS.Item rhs_item = this.rule.rhs.items[i];
            str.append(' ');
            if (i == this.dot) {
                str.append('*');
            }
            str.append(rhs_item);
            ++i;
        }
        if (this.dot == this.rule.rhs.items.length) {
            str.append(" *");
        }
        if ((line = this.rule.getFirstLine()) > 0) {
            str.append(" @ ").append(line);
        }
        return str.toString();
    }

    /* synthetic */ Configuration(Configuration configuration) {
        this();
    }

    static class Set {
        Factory conf_set_factory;
        Configuration first_conf;
        Configuration last_core_conf;
        int core_size;
        int core_hash_code;

        private Set(Factory conf_set_factory, int hash_code) {
            this.conf_set_factory = conf_set_factory;
            this.first_conf = conf_set_factory.first_conf;
            this.last_core_conf = conf_set_factory.last_conf;
            this.core_hash_code = hash_code;
            this.core_size = conf_set_factory.num_conf;
        }

        void appendReversePropagation(Set conf_set) {
            Configuration stop = this.last_core_conf.next;
            Configuration my_conf = this.first_conf;
            Configuration cp_conf = conf_set.first_conf;
            while (my_conf != stop) {
                my_conf.appendReversePropagation(cp_conf);
                my_conf = my_conf.next;
                cp_conf = cp_conf.next;
            }
        }

        void buildClosure() {
            Configuration conf = this.first_conf;
            while (conf != null) {
                GrammarSymbol sym;
                if (!conf.isDotAfterLastSymbol() && (sym = conf.getSymbolAfterDot()) instanceof NonTerminal) {
                    NonTerminal nt = (NonTerminal)sym;
                    Production rule = nt.definitions.start();
                    while (rule != null) {
                        Configuration new_conf = this.conf_set_factory.addConfiguration(rule, 0);
                        if (new_conf.addLookaheads(conf)) {
                            conf.addForwardPropagation(new_conf);
                        }
                        rule = rule.next_definition;
                    }
                }
                conf = conf.next;
            }
        }

        void reverseReversePropagation() {
            Configuration conf = this.first_conf;
            while (conf != null) {
                conf.reverseReversePropagation();
                conf = conf.next;
            }
        }

        void resetContributionFlags() {
            Configuration conf = this.first_conf;
            while (conf != null) {
                conf.has_contributed = false;
                conf = conf.next;
            }
        }

        private boolean equals(Set conf_set) {
            if (conf_set == this) {
                return true;
            }
            if (conf_set.core_size != this.core_size) {
                return false;
            }
            Configuration my_conf = this.first_conf;
            Configuration cmp_conf = conf_set.first_conf;
            Configuration stop = this.last_core_conf.next;
            while (my_conf != stop && my_conf.equals(cmp_conf)) {
                my_conf = my_conf.next;
                cmp_conf = cmp_conf.next;
            }
            return my_conf == stop;
        }

        public boolean equals(Object obj) {
            return obj instanceof Set && this.equals((Set)obj);
        }

        public int hashCode() {
            return this.core_hash_code;
        }

        public String toString() {
            StringBuffer str = new StringBuffer(1000);
            Configuration conf = this.first_conf;
            while (conf != this.last_core_conf.next) {
                str.append('+').append(conf).append('\n');
                conf = conf.next;
            }
            while (conf != null) {
                str.append(' ').append(conf).append('\n');
                conf = conf.next;
            }
            return str.toString();
        }

        static class Factory {
            private Map configurations = new HashMap(89);
            private Configuration probe = new Configuration(null);
            private Grammar grammar;
            Configuration first_conf;
            Configuration last_conf;
            int num_conf;

            Factory(Grammar grammar) {
                this.grammar = grammar;
            }

            void reset() {
                this.last_conf = null;
                this.first_conf = null;
                this.num_conf = 0;
                this.configurations = new HashMap(89);
            }

            Configuration addConfiguration(Production rule, int mark) {
                this.probe.rule = rule;
                this.probe.dot = mark;
                Configuration conf = (Configuration)this.configurations.get(this.probe);
                if (conf == null) {
                    conf = new Configuration(this.probe, this.grammar);
                    this.configurations.put(conf, conf);
                    this.last_conf = this.last_conf == null ? (this.first_conf = conf) : (this.last_conf.next = conf);
                    ++this.num_conf;
                }
                return conf;
            }

            Set getCore() {
                Object[] core = new Configuration[this.num_conf];
                int j = 0;
                Object conf = this.first_conf;
                while (conf != null) {
                    core[j++] = conf;
                    conf = ((Configuration)conf).next;
                }
                Arrays.sort(core);
                conf = this.first_conf = core[0];
                int core_hash_code = ((Configuration)conf).hashCode();
                j = 1;
                while (j < this.num_conf) {
                    conf = ((Configuration)conf).next = core[j];
                    core_hash_code = core_hash_code * 571 + ((Configuration)conf).hashCode();
                    ++j;
                }
                this.last_conf = conf;
                ((Configuration)conf).next = null;
                return new Set(this, core_hash_code);
            }
        }
    }

    static class PropagationLink {
        PropagationLink next;
        Configuration conf;

        PropagationLink(Configuration conf) {
            this.conf = conf;
        }
    }
}

